/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.components.es.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.oc.components.es.IUocEsSync;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryRspBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.insporder.sub.UocShipInspRel;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderRelQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderAgreement;
import com.tydic.dyc.oc.model.order.sub.UocOrderRel;
import com.tydic.dyc.oc.model.payorder.IUocPayOrderModel;
import com.tydic.dyc.oc.model.payorder.sub.UocOrderShouldPay;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocOrderAgreementQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderPayConfQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleStakeholder;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class UocEsSyncInsp
implements IUocEsSync {
    private static final Logger log = LoggerFactory.getLogger(UocEsSyncInsp.class);
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocPayOrderModel iUocPayOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;
    private static final String ES_INSP_ORDER_ITEM_KEY = "uocInspOrderItemList";
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public String indexName() {
        return this.uocIndexConfig.getInspOrderIndex();
    }

    @Override
    public IUocEsSyncQryRspBo qryData(IUocEsSyncQryReqBo reqBo) {
        UocInspOrderDo inspOderItem;
        IUocEsSyncQryRspBo iUocEsSyncQryRspBo = new IUocEsSyncQryRspBo();
        iUocEsSyncQryRspBo.setObjId(reqBo.getObjId());
        UocInspOrderDo inspOrderMain = this.getInspOrderMain(reqBo);
        if (null == inspOrderMain) {
            return iUocEsSyncQryRspBo;
        }
        JSONObject inspOrderJson = JSON.parseObject((String)JSON.toJSONString((Object)inspOrderMain));
        if (!CollectionUtils.isEmpty(inspOrderMain.getExtParallelBoList())) {
            inspOrderMain.getExtParallelBoList().forEach(uocInspOrderMap -> inspOrderJson.put(uocInspOrderMap.getFieldCode(), (Object)uocInspOrderMap.getFieldValue()));
        }
        if (!CollectionUtils.isEmpty((inspOderItem = this.getInspOderItem(inspOrderMain)).getUocInspOrderItemList())) {
            Map<Long, UocSaleOrderItem> saleItemMap = this.getSaleItem(inspOrderMain);
            Map<Long, UocShipOrderItem> shipOrderItemMap = this.getListShipOrderItem(inspOderItem);
            JSONArray inspOrdeItemArray = new JSONArray();
            inspOderItem.getUocInspOrderItemList().forEach(uocInspOrderItem -> {
                JSONObject inspOrderItemJson = JSON.parseObject((String)JSON.toJSONString((Object)uocInspOrderItem));
                if (!CollectionUtils.isEmpty(uocInspOrderItem.getItemExtParallelBoList())) {
                    uocInspOrderItem.getItemExtParallelBoList().forEach(uocInspItemMap -> inspOrderItemJson.put(uocInspItemMap.getFieldCode(), (Object)uocInspItemMap.getFieldValue()));
                }
                this.putSaleItem(inspOrderItemJson, (UocSaleOrderItem)saleItemMap.get(uocInspOrderItem.getSaleOrderItemId()));
                this.putShipItem(inspOrderItemJson, (UocShipOrderItem)shipOrderItemMap.get(uocInspOrderItem.getShipOrderItemId()));
                inspOrdeItemArray.add((Object)inspOrderItemJson);
            });
            inspOrderJson.put(ES_INSP_ORDER_ITEM_KEY, (Object)inspOrdeItemArray);
        }
        this.putSaleOrder(inspOrderMain, inspOrderJson);
        this.putShipOrder(inspOrderMain, inspOrderJson);
        this.putOrderRel(reqBo, inspOrderJson);
        this.putOrderShouldPay(reqBo, inspOrderJson);
        this.putStr(inspOrderJson, inspOrderMain);
        iUocEsSyncQryRspBo.setJsonObj(inspOrderJson);
        return iUocEsSyncQryRspBo;
    }

    private void putOrderShouldPay(IUocEsSyncQryReqBo reqBo, JSONObject inspOrderJson) {
        List<UocOrderShouldPay> orderShouldPayList = this.getOrderShouldPayList(reqBo);
        if (ObjectUtil.isNotEmpty(orderShouldPayList)) {
            UocOrderShouldPay shouldPay = orderShouldPayList.get(0);
            inspOrderJson.put("payeeId", (Object)shouldPay.getPayeeId());
            inspOrderJson.put("payeeName", (Object)shouldPay.getPayeeName());
        }
    }

    private void putSaleOrder(UocInspOrderDo inspOrderMain, JSONObject inspOrderJson) {
        UocSaleOrderDo saleOrder = this.getSaleOrder(inspOrderMain);
        inspOrderJson.put("inspOrderId", (Object)inspOrderMain.getInspOrderId().toString());
        if (null != saleOrder) {
            inspOrderJson.put("payState", (Object)saleOrder.getPayState());
            inspOrderJson.put("orderSource", (Object)saleOrder.getOrderSource().toString());
            inspOrderJson.put("orderCreateOperId", (Object)saleOrder.getCreateOperId());
            inspOrderJson.put("orderCreateOperName", (Object)saleOrder.getCreateOperName());
            inspOrderJson.put("orderCreateTime", (Object)saleOrder.getCreateTime());
            inspOrderJson.put("saleOrderNo", (Object)saleOrder.getSaleOrderNo());
            inspOrderJson.put("saleOrderNoExt", (Object)saleOrder.getSaleOrderNoExt());
            if (null != saleOrder.getOrderSource()) {
                inspOrderJson.put("orderSourceStr", (Object)this.getDic().get("UOC_SALE_ORDER_SOURCE").get(saleOrder.getOrderSource().toString()));
            }
            if (null != saleOrder.getModelSettle()) {
                inspOrderJson.put("modelSettleStr", (Object)this.getDic().get("UOC_COMMON_MODEL_SETTLE").get(saleOrder.getModelSettle().toString()));
            }
            this.putSaleStakeholder(saleOrder, inspOrderJson);
            this.putOrderAgreement(inspOrderJson, saleOrder);
            this.putSalePayConf(inspOrderJson, saleOrder);
        }
    }

    private void putOrderAgreement(JSONObject inspOrderJson, UocSaleOrderDo saleOrder) {
        List<UocOrderAgreement> agreementList = this.getOrderAgreement(saleOrder);
        if (ObjectUtil.isNotEmpty(agreementList)) {
            inspOrderJson.put("tradeMode", (Object)agreementList.get(0).getTradeMode());
            if (null != agreementList.get(0).getTradeMode()) {
                inspOrderJson.put("tradeModeStr", (Object)this.getDic().get("TRADE_MODE").get(agreementList.get(0).getTradeMode().toString()));
            }
        }
    }

    private List<UocOrderAgreement> getOrderAgreement(UocSaleOrderDo saleOrder) {
        UocOrderAgreementQryBo agreementQryBo = new UocOrderAgreementQryBo();
        agreementQryBo.setOrderId(saleOrder.getOrderId());
        agreementQryBo.setId(saleOrder.getAgrDataId());
        return this.iUocSaleOrderModel.getAgreementOrderList(agreementQryBo);
    }

    private void putSalePayConf(JSONObject inspOrderJson, UocSaleOrderDo saleOrder) {
        List<UocSaleOrderPayConf> payConfList = this.getPayConfList(saleOrder);
        if (ObjectUtil.isNotEmpty(payConfList)) {
            UocSaleOrderPayConf payConf = payConfList.get(0);
            inspOrderJson.put("payType", (Object)payConf.getPayType());
            inspOrderJson.put("payBreakScale", (Object)payConf.getPayBreakScale());
            inspOrderJson.put("paymentDays", (Object)payConf.getPaymentDays());
            inspOrderJson.put("payRule", (Object)payConf.getPayRule());
            inspOrderJson.put("payAccountDayRule", (Object)payConf.getPayAccountDayRule());
            inspOrderJson.put("payNodeRule", (Object)payConf.getPayNodeRule());
            if (null != payConf.getPayRule()) {
                inspOrderJson.put("payRuleStr", (Object)this.getDic().get("PAY_RULE").get(payConf.getPayRule().toString()));
            }
            if (null != payConf.getPayAccountDayRule()) {
                inspOrderJson.put("payAccountDayRuleStr", (Object)this.getDic().get("PAY_ACCOUNT_DAY_RULE").get(payConf.getPayAccountDayRule().toString()));
            }
            if (null != payConf.getPayNodeRule()) {
                inspOrderJson.put("payNodeRuleStr", (Object)this.getDic().get("PAY_NODE_RULE").get(payConf.getPayNodeRule().toString()));
            }
        }
    }

    private List<UocSaleOrderPayConf> getPayConfList(UocSaleOrderDo saleOrder) {
        UocSaleOrderPayConfQryBo payConfQryBo = new UocSaleOrderPayConfQryBo();
        payConfQryBo.setSaleOrderId(saleOrder.getSaleOrderId());
        payConfQryBo.setOrderId(saleOrder.getOrderId());
        return this.iUocSaleOrderModel.getSaleOrderPayConfList(payConfQryBo);
    }

    private List<UocOrderShouldPay> getOrderShouldPayList(IUocEsSyncQryReqBo reqBo) {
        UocOrderShouldPay uocOrderShouldPay = new UocOrderShouldPay();
        uocOrderShouldPay.setOrderId(reqBo.getOrderId());
        uocOrderShouldPay.setObjectId(reqBo.getObjId());
        uocOrderShouldPay.setObjectType(UocDicConstant.OBJ_TYPE.INSPECTION);
        return this.iUocPayOrderModel.getListOrderShouldPay(uocOrderShouldPay);
    }

    private void putOrderRel(IUocEsSyncQryReqBo reqBo, JSONObject inspOrderJson) {
        UocOrderRel relInfo = this.getUocRelInfo(reqBo);
        if (null != relInfo) {
            inspOrderJson.put("relId", (Object)relInfo.getRelId());
            inspOrderJson.put("objId", (Object)relInfo.getObjId());
            inspOrderJson.put("objType", (Object)relInfo.getObjType());
            inspOrderJson.put("relType", (Object)relInfo.getRelType());
            inspOrderJson.put("relStatus", (Object)relInfo.getRelStatus());
            if (null != relInfo.getObjType()) {
                inspOrderJson.put("objTypeStr", (Object)this.getDic().get("UOC_ORDER_OBJ_TYPE").get(relInfo.getObjType().toString()));
            }
            if (null != relInfo.getRelType()) {
                inspOrderJson.put("relTypeStr", (Object)this.getDic().get("UOC_ORDER_REL_TYPE").get(relInfo.getRelType().toString()));
            }
            if (null != relInfo.getRelStatus()) {
                inspOrderJson.put("relStatusStr", (Object)this.getDic().get("UOC_ORDER_REL_STATUS").get(relInfo.getRelStatus().toString()));
            }
        }
    }

    private UocOrderRel getUocRelInfo(IUocEsSyncQryReqBo reqBo) {
        UocOrderRelQryBo qryBo = new UocOrderRelQryBo();
        qryBo.setOrderId(reqBo.getOrderId());
        qryBo.setObjId(reqBo.getObjId());
        qryBo.setObjType(UocDicConstant.OBJ_TYPE.INSPECTION);
        return this.iUocOrderModel.qryRelInfo(qryBo);
    }

    private void putStr(JSONObject inspOrderJson, UocInspOrderDo inspOrderMain) {
        Map<String, Map<String, String>> dicMap = this.getDic();
        Map<String, String> stateMap = dicMap.get("INSP_ORDER_STATE");
        Map<String, String> checkStateMap = dicMap.get("UOC_ORD_CHECK_STATE");
        Map<String, String> invoiceTagMap = dicMap.get("UOC_ORD_INVOICE_TAG");
        inspOrderJson.put("inspOrderStateStr", (Object)(ObjectUtil.isNotEmpty(stateMap) ? stateMap.get(inspOrderMain.getInspOrderState()) : ""));
        inspOrderJson.put("checkStateStr", (Object)(ObjectUtil.isNotEmpty(checkStateMap) ? checkStateMap.get(inspOrderMain.getCheckState()) : ""));
        inspOrderJson.put("invoiceTagStr", (Object)(ObjectUtil.isNotEmpty(invoiceTagMap) ? invoiceTagMap.get(inspOrderMain.getInvoiceTag()) : ""));
        inspOrderJson.put("saleOrderId", (Object)(ObjectUtil.isNotEmpty((Object)inspOrderJson.get((Object)"saleOrderId")) ? inspOrderMain.getSaleOrderId().toString() : ""));
    }

    private void putShipItem(JSONObject inspOrderItemJson, UocShipOrderItem uocShipOrderItem) {
        if (null != uocShipOrderItem) {
            inspOrderItemJson.put("sendCount", (Object)uocShipOrderItem.getSendCount());
        }
    }

    private void putSaleStakeholder(UocSaleOrderDo saleOrder, JSONObject inspOrderJson) {
        UocSaleStakeholder uocSaleStakeholder = saleOrder.getStakeholder();
        if (null != uocSaleStakeholder) {
            inspOrderJson.put("supNo", (Object)uocSaleStakeholder.getSupNo());
            inspOrderJson.put("supId", (Object)uocSaleStakeholder.getSupId());
            inspOrderJson.put("supName", (Object)uocSaleStakeholder.getSupName());
            inspOrderJson.put("purOrgId", (Object)uocSaleStakeholder.getPurOrgId());
            inspOrderJson.put("purOrgName", (Object)uocSaleStakeholder.getPurOrgName());
            inspOrderJson.put("proId", (Object)uocSaleStakeholder.getProId());
            inspOrderJson.put("proName", (Object)uocSaleStakeholder.getProName());
            inspOrderJson.put("purAccount", (Object)uocSaleStakeholder.getPurAccount());
            inspOrderJson.put("purAccountName", (Object)uocSaleStakeholder.getPurAccountName());
        }
    }

    private void putShipOrder(UocInspOrderDo inspOrderMain, JSONObject inspOrderJson) {
        List<UocShipOrderDo> uocShipOrderDoList = this.getListShipOrder(inspOrderMain);
        if (!CollectionUtils.isEmpty(uocShipOrderDoList)) {
            ArrayList shipOrderNoList = new ArrayList();
            ArrayList shipOrderIdList = new ArrayList();
            uocShipOrderDoList.forEach(uocShipOrderDo -> {
                shipOrderNoList.add(uocShipOrderDo.getShipOrderNo());
                if (null != uocShipOrderDo.getShipOrderId()) {
                    shipOrderIdList.add(uocShipOrderDo.getShipOrderId().toString());
                }
            });
            inspOrderJson.put("shipOrderNo", shipOrderNoList.get(0));
            inspOrderJson.put("shipOrderId", shipOrderIdList.get(0));
        }
    }

    private List<UocShipOrderDo> getListShipOrder(UocInspOrderDo uocInspOrderDo) {
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setShipOrderIdList(uocInspOrderDo.getUocShipInspRelList().stream().map(UocShipInspRel::getShipOrderId).collect(Collectors.toList()));
        return this.iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
    }

    private Map<Long, UocShipOrderItem> getListShipOrderItem(UocInspOrderDo uocInspOrderDo) {
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setShipOrderItemIdList(uocInspOrderDo.getUocInspOrderItemList().stream().map(UocInspOrderItem::getShipOrderItemId).collect(Collectors.toList()));
        UocShipOrderDo uocShipOrderDo = this.iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
        if (!CollectionUtils.isEmpty(uocShipOrderDo.getShipOrderItemBoList())) {
            return uocShipOrderDo.getShipOrderItemBoList().stream().collect(Collectors.toMap(UocShipOrderItem::getShipOrderItemId, o -> o));
        }
        return new HashMap<Long, UocShipOrderItem>();
    }

    private Map<Long, UocSaleOrderItem> getSaleItem(UocInspOrderDo uocInspOrderDo) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderId(uocInspOrderDo.getSaleOrderId());
        uocSaleOrderItemQryBo.setOrderId(uocInspOrderDo.getOrderId());
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        if (!CollectionUtils.isEmpty(saleOrderItemList)) {
            return saleOrderItemList.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));
        }
        return new HashMap<Long, UocSaleOrderItem>();
    }

    private void putSaleItem(JSONObject inspOrderItemJson, UocSaleOrderItem uocSaleOrderItem) {
        if (null != uocSaleOrderItem) {
            inspOrderItemJson.put("skuExtSkuId", (Object)uocSaleOrderItem.getSkuExtSkuId());
            inspOrderItemJson.put("commodityId", (Object)uocSaleOrderItem.getSkuName());
            inspOrderItemJson.put("commodityName", (Object)uocSaleOrderItem.getSkuName());
            inspOrderItemJson.put("skuName", (Object)uocSaleOrderItem.getSkuName());
            inspOrderItemJson.put("skuMaterialId", (Object)uocSaleOrderItem.getSkuName());
            inspOrderItemJson.put("skuMainPicUrl", (Object)uocSaleOrderItem.getSkuName());
            inspOrderItemJson.put("skuMaterialName", (Object)uocSaleOrderItem.getSkuMaterialName());
            inspOrderItemJson.put("skuMaterialTypeId", (Object)uocSaleOrderItem.getSkuMaterialTypeId());
            inspOrderItemJson.put("skuMaterialTypeName", (Object)uocSaleOrderItem.getSkuMaterialTypeName());
            inspOrderItemJson.put("model", (Object)uocSaleOrderItem.getModel());
            inspOrderItemJson.put("spec", (Object)uocSaleOrderItem.getSpec());
            inspOrderItemJson.put("tax", (Object)uocSaleOrderItem.getTax());
            inspOrderItemJson.put("taxId", (Object)uocSaleOrderItem.getTaxId());
            inspOrderItemJson.put("taxPrice", (Object)uocSaleOrderItem.getTaxPrice());
            inspOrderItemJson.put("l1Catalog", (Object)uocSaleOrderItem.getL1Catalog());
            inspOrderItemJson.put("l1CatalogName", (Object)uocSaleOrderItem.getL1CatalogName());
            inspOrderItemJson.put("l2Catalog", (Object)uocSaleOrderItem.getL2Catalog());
            inspOrderItemJson.put("l2CatalogName", (Object)uocSaleOrderItem.getL2CatalogName());
            inspOrderItemJson.put("l3Catalog", (Object)uocSaleOrderItem.getL3Catalog());
            inspOrderItemJson.put("l3CatalogName", (Object)uocSaleOrderItem.getL3CatalogName());
            inspOrderItemJson.put("salePrice", (Object)uocSaleOrderItem.getSalePrice());
            inspOrderItemJson.put("purPrice", (Object)uocSaleOrderItem.getPurchasePrice());
            inspOrderItemJson.put("purchaseCount", (Object)uocSaleOrderItem.getPurchaseCount());
            if (null != uocSaleOrderItem.getSalePrice() && null != uocSaleOrderItem.getPurchaseCount()) {
                inspOrderItemJson.put("inspSaleMoney", (Object)uocSaleOrderItem.getSalePrice().multiply(uocSaleOrderItem.getPurchaseCount()));
            }
            if (null != uocSaleOrderItem.getPurchasePrice() && null != uocSaleOrderItem.getPurchaseCount()) {
                inspOrderItemJson.put("inspPurchaseMoney", (Object)uocSaleOrderItem.getPurchasePrice().multiply(uocSaleOrderItem.getPurchaseCount()));
            }
            inspOrderItemJson.put("settleUnit", (Object)uocSaleOrderItem.getSettleUnit());
        }
    }

    private UocInspOrderDo getInspOderItem(UocInspOrderDo inspOrderMain) {
        UocInspOrderItemQryBo uocInspOrderItemQryBo = new UocInspOrderItemQryBo();
        uocInspOrderItemQryBo.setInspOrderId(inspOrderMain.getInspOrderId());
        uocInspOrderItemQryBo.setOrderId(inspOrderMain.getOrderId());
        return this.iUocInspOrderModel.getListInspOrderItem(uocInspOrderItemQryBo);
    }

    private UocInspOrderDo getInspOrderMain(IUocEsSyncQryReqBo reqBo) {
        UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
        uocInspOrderQryBo.setInspOrderId(reqBo.getObjId());
        uocInspOrderQryBo.setOrderId(reqBo.getOrderId());
        return this.iUocInspOrderModel.getInspOrderMain(uocInspOrderQryBo);
    }

    private UocSaleOrderDo getSaleOrder(UocInspOrderDo uocInspOrderDo) {
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setSaleOrderId(uocInspOrderDo.getSaleOrderId());
        uocSaleOrderQryBo.setOrderId(uocInspOrderDo.getOrderId());
        return this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
    }

    private Map<String, Map<String, String>> getDic() {
        ArrayList<String> pCodes = new ArrayList<String>();
        pCodes.add("INSP_ORDER_STATE");
        pCodes.add("UOC_ORD_CHECK_STATE");
        pCodes.add("UOC_COMMON_MODEL_SETTLE");
        pCodes.add("UOC_ORDER_OBJ_TYPE");
        pCodes.add("UOC_ORDER_REL_TYPE");
        pCodes.add("UOC_ORDER_REL_STATUS");
        pCodes.add("UOC_SALE_ORDER_SOURCE");
        pCodes.add("PAY_RULE");
        pCodes.add("PAY_ACCOUNT_DAY_RULE");
        pCodes.add("PAY_NODE_RULE");
        pCodes.add("TRADE_MODE");
        return this.iUocSysDictionaryModel.getDictionaryMap(pCodes);
    }
}

