/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.components.event.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.event.EventConsumer;
import com.tydic.dyc.oc.components.event.IUocEsSyncQryEventReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class EventConsumerSyncTodo
implements EventConsumer {
    private static final Logger log = LoggerFactory.getLogger(EventConsumerSyncTodo.class);
    @Autowired
    private UocIndexConfig uocIndexConfig;
    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Override
    public List<IUocEsSyncQryEventReqBo> parseMap(Map<String, Object> map) {
        List<UocOrderTaskInst> deleteList;
        ArrayList<IUocEsSyncQryEventReqBo> retList = new ArrayList<IUocEsSyncQryEventReqBo>();
        Long orderId = UocRu.parseLong(map.get("orderId"));
        Long objId = UocRu.parseLong(map.get("objId"));
        Integer objType = UocRu.parseInteger(map.get("objType"));
        String oldTaskInstId = UocRu.parseStr(map.get("oldTaskInstId"));
        UocOrderTaskInstQryBo uocOrderTaskInstQryBo = new UocOrderTaskInstQryBo();
        uocOrderTaskInstQryBo.setOrderId(orderId);
        uocOrderTaskInstQryBo.setObjId(objId);
        uocOrderTaskInstQryBo.setObjType(objType);
        uocOrderTaskInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocOrderModel.qryOrderTaskInstList(uocOrderTaskInstQryBo);
        ArrayList<IUocEsSyncQryReqBo> todoList = new ArrayList<IUocEsSyncQryReqBo>();
        if (!CollectionUtils.isEmpty(uocOrderTaskInsts)) {
            uocOrderTaskInsts.forEach(uocOrderTaskInst -> {
                IUocEsSyncQryReqBo syncQryReqBo = new IUocEsSyncQryReqBo();
                syncQryReqBo.setOrderId(orderId);
                syncQryReqBo.setObjId(uocOrderTaskInst.getId());
                todoList.add(syncQryReqBo);
            });
        }
        if (!StringUtils.isBlank((CharSequence)oldTaskInstId) && !CollectionUtils.isEmpty(deleteList = this.getDeleteList(oldTaskInstId))) {
            deleteList.forEach(uocOrderTaskInst -> {
                IUocEsSyncQryReqBo deleteReq = new IUocEsSyncQryReqBo();
                deleteReq.setObjId(uocOrderTaskInst.getId());
                deleteReq.setOrderId(uocOrderTaskInst.getOrderId());
                deleteReq.setDelFlag(true);
                todoList.add(deleteReq);
            });
        }
        IUocEsSyncQryEventReqBo eventReqBo = new IUocEsSyncQryEventReqBo();
        eventReqBo.setIndexName(this.uocIndexConfig.getTodoIndex());
        eventReqBo.setDataList(todoList);
        retList.add(eventReqBo);
        log.info("\u4ee3\u529e\u51fa\u53c2:{}", (Object)JSON.toJSONString(retList));
        return retList;
    }

    @Override
    public String getEvent() {
        return "UOCE_ES_SYNC_TODO";
    }

    private List<UocOrderTaskInst> getDeleteList(String oldTaskInstId) {
        UocOrderTaskInstQryBo uocOrderTaskInstQryBo = new UocOrderTaskInstQryBo();
        uocOrderTaskInstQryBo.setTaskInstId(oldTaskInstId);
        return this.iUocOrderModel.qryOrderTaskInstList(uocOrderTaskInstQryBo);
    }
}

