/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderMap;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.domainservice.UocAdjustPriceOrderCreateService;
import com.tydic.dyc.oc.service.domainservice.bo.UocAdjustPriceOrderCreateReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAdjustPriceOrderCreateRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.domainservice.UocAdjustPriceOrderCreateService"})
public class UocAdjustPriceOrderCreateServiceImpl
implements UocAdjustPriceOrderCreateService {
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @PostMapping(value={"createAdjustPriceOrder"})
    public UocAdjustPriceOrderCreateRspBo createAdjustPriceOrder(@RequestBody UocAdjustPriceOrderCreateReqBo reqBo) {
        this.validateArg(reqBo);
        UocChngOrderDo uocChngOrderDo = this.convertChngOrderDo(reqBo, new Date());
        this.iUocChngOrderModel.createChngOrder(uocChngOrderDo);
        UocAdjustPriceOrderCreateRspBo uocAdjustPriceOrderCreateRspBo = UocRu.success(UocAdjustPriceOrderCreateRspBo.class);
        uocAdjustPriceOrderCreateRspBo.setChngOrderId(uocChngOrderDo.getChngOrderId());
        return uocAdjustPriceOrderCreateRspBo;
    }

    private UocChngOrderDo convertChngOrderDo(UocAdjustPriceOrderCreateReqBo reqBo, Date newDate) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo = this.iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException("103001", "\u67e5\u8be2\u9500\u552e\u5355\u4e3a\u7a7a");
        }
        UocChngOrderDo uocChngOrderDo = new UocChngOrderDo();
        uocChngOrderDo.setOrderId(reqBo.getOrderId());
        uocChngOrderDo.setChngOrderId(IdUtil.nextId());
        uocChngOrderDo.setChngOrderNo(this.getChngOrderNo(uocSaleOrderDo));
        uocChngOrderDo.setCreateOperId(reqBo.getUserId().toString());
        uocChngOrderDo.setCreateOperName(reqBo.getName());
        uocChngOrderDo.setCreateOperMobile(reqBo.getCellphone());
        uocChngOrderDo.setCreateTime(newDate);
        uocChngOrderDo.setBusiType(UocConstant.BUSI_TYPE.ADJUST_PRICE);
        uocChngOrderDo.setTenantId(reqBo.getTenantId());
        ArrayList<UocChngOrderObj> uocChngOrderObjList = new ArrayList<UocChngOrderObj>();
        UocChngOrderObj uocChngOrderObj = new UocChngOrderObj();
        uocChngOrderObj.setOrderId(reqBo.getOrderId());
        uocChngOrderObj.setChngOrderObjId(IdUtil.nextId());
        uocChngOrderObj.setChngOrderId(uocChngOrderDo.getChngOrderId());
        uocChngOrderObj.setChngType(UocConstant.BUSI_TYPE.ADJUST_PRICE);
        uocChngOrderObj.setSaleOrderId(reqBo.getSaleOrderId());
        uocChngOrderObj.setCreateTime(newDate);
        uocChngOrderObj.setCreateOperId(reqBo.getUserId().toString());
        uocChngOrderObjList.add(uocChngOrderObj);
        ArrayList<UocChngOrderItemObj> uocChngOrderItemObjList = new ArrayList<UocChngOrderItemObj>();
        reqBo.getSaleItemList().forEach(itemBo -> {
            UocChngOrderItemObj uocChngOrderItemObj = new UocChngOrderItemObj();
            uocChngOrderItemObj.setOrderId(reqBo.getOrderId());
            uocChngOrderItemObj.setChngOrderId(uocChngOrderDo.getChngOrderId());
            uocChngOrderItemObj.setChngOrderObjId(uocChngOrderObj.getChngOrderObjId());
            uocChngOrderItemObj.setId(IdUtil.nextId());
            uocChngOrderItemObj.setOrderItemId(itemBo.getOrderItemId());
            uocChngOrderItemObj.setSaleOrderItemId(itemBo.getSaleOrderItemId());
            uocChngOrderItemObj.setChngType(UocConstant.BUSI_TYPE.ADJUST_PRICE);
            uocChngOrderItemObj.setChngFee(itemBo.getAdjustPrice());
            uocChngOrderItemObj.setCreateOperId(reqBo.getUserId().toString());
            uocChngOrderItemObj.setCreateTime(newDate);
            uocChngOrderItemObjList.add(uocChngOrderItemObj);
        });
        uocChngOrderObj.setUocChngOrderItemObjList(uocChngOrderItemObjList);
        uocChngOrderDo.setUocChngOrderObjList(uocChngOrderObjList);
        if (!CollectionUtils.isEmpty((Collection)reqBo.getOrderAccessoryBoList())) {
            List<UocOrderAccessory> orderAccessoryBoList = UocRu.jsl(reqBo.getOrderAccessoryBoList(), UocOrderAccessory.class);
            orderAccessoryBoList.forEach(uocOrderAccessory -> {
                uocOrderAccessory.setOrderId(reqBo.getOrderId());
                uocOrderAccessory.setId(IdUtil.nextId());
                uocOrderAccessory.setCreateOperId(reqBo.getUserId().toString());
                uocOrderAccessory.setCreateTime(newDate);
                uocOrderAccessory.setObjId(uocChngOrderDo.getChngOrderId());
                uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.CHNG);
            });
            uocChngOrderDo.setOrderAccessoryBoList(orderAccessoryBoList);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getExtParallelBoList())) {
            List<UocChngOrderMap> uocChngOrderMapList = UocRu.jsl(reqBo.getExtParallelBoList(), UocChngOrderMap.class);
            uocChngOrderMapList.forEach(uocChngOrderMap -> {
                uocChngOrderMap.setOrderId(reqBo.getOrderId());
                uocChngOrderMap.setChngOrderId(uocChngOrderDo.getChngOrderId());
                uocChngOrderMap.setId(IdUtil.nextId());
                uocChngOrderMap.setCreateOperId(reqBo.getUserId().toString());
                uocChngOrderMap.setCreateTime(newDate);
            });
            uocChngOrderDo.setUocChngOrderMapList(uocChngOrderMapList);
        }
        return uocChngOrderDo;
    }

    private String getChngOrderNo(UocSaleOrderDo uocSaleOrderDo) {
        UocChngOrderQryBo uocChngOrderQryBo = new UocChngOrderQryBo();
        uocChngOrderQryBo.setBusiType(UocConstant.BUSI_TYPE.ADJUST_PRICE);
        uocChngOrderQryBo.setOrderSource(uocSaleOrderDo.getOrderSource());
        UocChngOrderDo uocChngOrderDo = this.iUocChngOrderModel.getChngOrderNo(uocChngOrderQryBo);
        return uocChngOrderDo.getChngOrderNo();
    }

    private void validateArg(UocAdjustPriceOrderCreateReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e3a\u7a7a");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u9500\u552e\u5355ID\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getSaleItemList())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8c03\u4ef7\u4fe1\u606f\u4e3a\u7a7a");
        }
        reqBo.getSaleItemList().forEach(uocAdjustPriceOrderCreateReqItemBo -> {
            if (uocAdjustPriceOrderCreateReqItemBo.getOrderItemId() == null) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355\u660e\u7ec6ID\u4e3a\u7a7a");
            }
            if (uocAdjustPriceOrderCreateReqItemBo.getSaleOrderItemId() == null) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u9500\u552e\u660e\u7ec6ID\u4e3a\u7a7a");
            }
            if (uocAdjustPriceOrderCreateReqItemBo.getAdjustPrice() == null) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u8c03\u4ef7\u540e\u91d1\u989d\u4e3a\u7a7a");
            }
        });
    }
}

