/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspItemMap;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderMap;
import com.tydic.dyc.oc.model.insporder.sub.UocShipInspRel;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.domainservice.UocArrvalAcceptanceService;
import com.tydic.dyc.oc.service.domainservice.bo.UocArrvalAcceptanceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocArrvalAcceptanceRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateInspOrderReqShipBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateInspOrderReqShipItemBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.domainservice.UocArrvalAcceptanceService"})
public class UocArrvalAcceptanceServiceImpl
implements UocArrvalAcceptanceService {
    private static final Logger log = LoggerFactory.getLogger(UocArrvalAcceptanceServiceImpl.class);
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    private static final String OP_FLAG_YES = "1";
    private static final String OP_FLAG_NO = "0";

    @PostMapping(value={"dealArrvalAcceptance"})
    public UocArrvalAcceptanceRspBo dealArrvalAcceptance(@RequestBody UocArrvalAcceptanceReqBo reqBo) {
        this.validateArg(reqBo);
        UocShipOrderDo uocShipOrderDo = this.getShipOrderItemList(reqBo);
        Map<Long, UocShipOrderItem> uocShipOrderItemMap = uocShipOrderDo.getShipOrderItemBoList().stream().collect(Collectors.toMap(UocShipOrderItem::getShipOrderItemId, o -> o));
        Date now = new Date();
        String operId = reqBo.getUserId().toString();
        List<UocSaleOrderItem> uocSaleOrderItemList = this.getUocSaleOrderItem(reqBo, uocShipOrderDo.getShipOrderItemBoList().stream().map(UocShipOrderItem::getSaleOrderItemId).distinct().collect(Collectors.toList()));
        Map<Long, UocSaleOrderItem> uocSaleOrderItemMap = uocSaleOrderItemList.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));
        Map<Long, Boolean> shipOrderInspStateMap = this.checkShipOrderInspState(reqBo, uocShipOrderItemMap, uocSaleOrderItemMap);
        this.modifyShipOrder(reqBo, now, operId, shipOrderInspStateMap);
        this.iUocSaleOrderModel.modifyBatchItemInspCount(this.convertSaleOrderDo(reqBo, now, uocShipOrderItemMap, operId));
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        this.iUocSaleOrderModel.modifyInspSuper(uocSaleOrderDo);
        UocInspOrderDo uocInspOrderDo = this.convertInspOrderDo(reqBo, now, uocShipOrderItemMap, operId);
        this.iUocInspOrderModel.createInspOrder(uocInspOrderDo);
        UocArrvalAcceptanceRspBo uocArrvalAcceptanceRspBo = UocRu.success(UocArrvalAcceptanceRspBo.class);
        boolean inspFinish = this.calculateSaleOrderState(reqBo, uocSaleOrderItemMap);
        uocArrvalAcceptanceRspBo.setFinish(Boolean.valueOf(inspFinish));
        uocArrvalAcceptanceRspBo.setOpFlag(inspFinish ? OP_FLAG_YES : OP_FLAG_NO);
        uocArrvalAcceptanceRspBo.setInspOrderId(uocInspOrderDo.getInspOrderId());
        return uocArrvalAcceptanceRspBo;
    }

    private Map<Long, Boolean> checkShipOrderInspState(UocArrvalAcceptanceReqBo reqBo, Map<Long, UocShipOrderItem> uocShipOrderItemMap, Map<Long, UocSaleOrderItem> uocSaleOrderItemMap) {
        HashMap<Long, Boolean> shipOrderInspStateMap = new HashMap<Long, Boolean>();
        reqBo.getShipOrderList().forEach(uocCreateInspOrderReqShipBo -> {
            boolean finish = this.isFinish(uocShipOrderItemMap, uocSaleOrderItemMap, (UocCreateInspOrderReqShipBo)uocCreateInspOrderReqShipBo);
            shipOrderInspStateMap.put(uocCreateInspOrderReqShipBo.getShipOrderId(), finish);
        });
        return shipOrderInspStateMap;
    }

    private boolean isFinish(Map<Long, UocShipOrderItem> uocShipOrderItemMap, Map<Long, UocSaleOrderItem> uocSaleOrderItemMap, UocCreateInspOrderReqShipBo uocCreateInspOrderReqShipBo) {
        for (UocCreateInspOrderReqShipItemBo uocCreateInspOrderReqShipItemBo : uocCreateInspOrderReqShipBo.getShipItemList()) {
            UocShipOrderItem uocShipOrderItem = uocShipOrderItemMap.get(uocCreateInspOrderReqShipItemBo.getShipItemId());
            UocSaleOrderItem uocSaleOrderItem = uocSaleOrderItemMap.get(uocShipOrderItem.getSaleOrderItemId());
            BigDecimal inspectionExcessPercent = this.getInspectionExcessPercent(uocSaleOrderItem.getInspectionExcessPercent());
            BigDecimal inspTotalCount = uocCreateInspOrderReqShipItemBo.getInspCount().add(uocShipOrderItem.getInspCount());
            BigDecimal canInspCount = uocShipOrderItem.getSendCount().add(uocSaleOrderItem.getPurchaseCount().multiply(inspectionExcessPercent));
            log.info("\u53ef\u9a8c\u6536\u6570\u91cf:{}", (Object)canInspCount);
            log.info("\u5168\u90e8\u9a8c\u6536\u6570\u91cf:{}", (Object)inspTotalCount);
            if (inspTotalCount.compareTo(canInspCount) > 0) {
                throw new BaseBusinessException("101004", "\u5269\u4f59\u53ef\u9a8c\u6536\u6570\u91cf\u4e0d\u8db3\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u65b0\u586b\u5199\u9a8c\u6536\u6570\u91cf");
            }
            if (inspTotalCount.compareTo(canInspCount) >= 0) continue;
            return false;
        }
        return true;
    }

    private BigDecimal getInspectionExcessPercent(Integer supInspScale) {
        BigDecimal inspectionExcessPercent = BigDecimal.ZERO;
        if (null != supInspScale) {
            inspectionExcessPercent = new BigDecimal(supInspScale).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP);
        }
        return inspectionExcessPercent;
    }

    private UocInspOrderDo convertInspOrderDo(UocArrvalAcceptanceReqBo reqBo, Date now, Map<Long, UocShipOrderItem> uocShipOrderItemMap, String operId) {
        UocInspOrderDo uocInspOrderDo = new UocInspOrderDo();
        uocInspOrderDo.setOrderId(reqBo.getOrderId());
        uocInspOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocInspOrderDo.setInspOrderId(IdUtil.nextId());
        uocInspOrderDo.setRemark(reqBo.getRemark());
        uocInspOrderDo.setOtherRemark(reqBo.getOtherRemark());
        uocInspOrderDo.setInspOrderNo(this.getInspOrderNo(reqBo));
        uocInspOrderDo.setInspOrderState("YS_YS_YS");
        uocInspOrderDo.setInspOper(reqBo.getName());
        uocInspOrderDo.setCreateOperId(operId);
        uocInspOrderDo.setCreateTime(now);
        uocInspOrderDo.setInspOper(reqBo.getName());
        uocInspOrderDo.setInvoiceTag(UocConstant.INVOICE_TAG.NO);
        uocInspOrderDo.setInspOperPhone(reqBo.getCellphone());
        uocInspOrderDo.setTenantId(reqBo.getTenantId());
        uocInspOrderDo.setTotalPurchaseFee(BigDecimal.ZERO);
        uocInspOrderDo.setTotalSaleFee(BigDecimal.ZERO);
        ArrayList<UocShipInspRel> uocShipInspRelList = new ArrayList<UocShipInspRel>();
        ArrayList<UocInspOrderItem> uocInspOrderItemList = new ArrayList<UocInspOrderItem>();
        reqBo.getShipOrderList().forEach(uocCreateInspOrderReqShipBo -> {
            UocShipInspRel uocShipInspRel = UocRu.js(uocInspOrderDo, UocShipInspRel.class);
            uocShipInspRel.setId(IdUtil.nextId());
            uocShipInspRel.setShipOrderId(uocCreateInspOrderReqShipBo.getShipOrderId());
            uocShipInspRel.setRemark(null);
            uocShipInspRelList.add(uocShipInspRel);
            uocCreateInspOrderReqShipBo.getShipItemList().forEach(uocCreateInspOrderReqShipItemBo -> {
                UocShipOrderItem uocShipOrderItem = (UocShipOrderItem)uocShipOrderItemMap.get(uocCreateInspOrderReqShipItemBo.getShipItemId());
                UocInspOrderItem uocInspOrderItem = UocRu.js(uocInspOrderDo, UocInspOrderItem.class);
                uocInspOrderItem.setInspOrderItemId(IdUtil.nextId());
                uocInspOrderItem.setInspCount(uocCreateInspOrderReqShipItemBo.getInspCount());
                uocInspOrderItem.setShipOrderItemId(uocCreateInspOrderReqShipItemBo.getShipItemId());
                uocInspOrderItem.setUnitName(uocShipOrderItem.getUnitName());
                uocInspOrderItem.setRemark(null);
                if (!CollectionUtils.isEmpty((Collection)uocCreateInspOrderReqShipItemBo.getItemExtParallelBoList())) {
                    List<UocInspItemMap> uocInspItemMapList = UocRu.jsl(uocCreateInspOrderReqShipItemBo.getItemExtParallelBoList(), UocInspItemMap.class);
                    uocInspItemMapList.forEach(uocInspItemMap -> {
                        uocInspItemMap.setInspOrderId(uocInspOrderDo.getInspOrderId());
                        uocInspItemMap.setOrderId(uocInspOrderDo.getOrderId());
                        uocInspItemMap.setSaleOrderId(uocInspOrderDo.getSaleOrderId());
                        uocInspItemMap.setInspOrderItemId(uocInspOrderItem.getInspOrderItemId());
                        uocInspItemMap.setCreateOperId(operId);
                        uocInspItemMap.setCreateTime(now);
                        uocInspItemMap.setId(IdUtil.nextId());
                    });
                    uocInspOrderItem.setItemExtParallelBoList(uocInspItemMapList);
                }
                uocInspOrderItemList.add(uocInspOrderItem);
            });
        });
        uocInspOrderDo.setUocShipInspRelList(uocShipInspRelList);
        uocInspOrderDo.setUocInspOrderItemList(uocInspOrderItemList);
        if (!CollectionUtils.isEmpty((Collection)reqBo.getExtParallelBoList())) {
            List<UocInspOrderMap> uocInspOrderMapList = UocRu.jsl(reqBo.getExtParallelBoList(), UocInspOrderMap.class);
            uocInspOrderMapList.forEach(uocInspOrderMap -> {
                uocInspOrderMap.setInspOrderId(uocInspOrderDo.getInspOrderId());
                uocInspOrderMap.setSaleOrderId(reqBo.getSaleOrderId());
                uocInspOrderMap.setOrderId(reqBo.getOrderId());
                uocInspOrderMap.setCreateOperId(operId);
                uocInspOrderMap.setCreateTime(now);
                uocInspOrderMap.setId(IdUtil.nextId());
            });
            uocInspOrderDo.setExtParallelBoList(uocInspOrderMapList);
        }
        return uocInspOrderDo;
    }

    private List<UocSaleOrderItem> getUocSaleOrderItem(UocArrvalAcceptanceReqBo reqBo, List<Long> saleOrderItemIdList) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderItemIdList(saleOrderItemIdList);
        uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
        UocSaleOrderDo uocSaleOrderDo = this.iUocSaleOrderModel.qryListSaleOrderItem(uocSaleOrderItemQryBo);
        if (CollectionUtils.isEmpty(uocSaleOrderDo.getSaleOrderItems())) {
            throw new BaseBusinessException("101004", "\u83b7\u53d6\u9500\u552e\u660e\u7ec6\u4e3a\u7a7a");
        }
        return uocSaleOrderDo.getSaleOrderItems();
    }

    private void modifyShipOrder(UocArrvalAcceptanceReqBo reqBo, Date now, String operId, Map<Long, Boolean> shipOrderInspStateMap) {
        UocShipOrderDo uocShipOrderDo = this.convertShipOrderDo(reqBo, now, operId, shipOrderInspStateMap);
        if (!CollectionUtils.isEmpty(uocShipOrderDo.getShipOrderIdList())) {
            this.iUocShipOrderModel.modifyShipOrderMain(uocShipOrderDo);
        }
        this.iUocShipOrderModel.modifyShipOrderItemInspCount(uocShipOrderDo);
    }

    private UocShipOrderDo convertShipOrderDo(UocArrvalAcceptanceReqBo reqBo, Date now, String operId, Map<Long, Boolean> shipOrderInspStateMap) {
        ArrayList<Long> shipOrderIdList = new ArrayList<Long>();
        ArrayList<UocShipOrderItem> shipOrderItemList = new ArrayList<UocShipOrderItem>();
        reqBo.getShipOrderList().forEach(uocCreateInspOrderReqShipBo -> {
            if (reqBo.getInspFinish().booleanValue() || ((Boolean)shipOrderInspStateMap.get(uocCreateInspOrderReqShipBo.getShipOrderId())).booleanValue()) {
                shipOrderIdList.add(uocCreateInspOrderReqShipBo.getShipOrderId());
            }
            uocCreateInspOrderReqShipBo.getShipItemList().forEach(uocCreateInspOrderReqShipItemBo -> {
                UocShipOrderItem uocShipOrderItem = new UocShipOrderItem();
                uocShipOrderItem.setShipOrderItemId(uocCreateInspOrderReqShipItemBo.getShipItemId());
                uocShipOrderItem.setInspCount(uocCreateInspOrderReqShipItemBo.getInspCount());
                uocShipOrderItem.setOrderId(reqBo.getOrderId());
                uocShipOrderItem.setSaleOrderId(reqBo.getSaleOrderId());
                shipOrderItemList.add(uocShipOrderItem);
            });
        });
        UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
        uocShipOrderDo.setOrderId(reqBo.getOrderId());
        uocShipOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocShipOrderDo.setUpdateTime(now);
        uocShipOrderDo.setUpdateOperId(operId);
        if (!CollectionUtils.isEmpty(shipOrderIdList)) {
            uocShipOrderDo.setShipOrderIdList(shipOrderIdList);
            uocShipOrderDo.setInspTime(now);
            uocShipOrderDo.setShipOrderState("FH_FH_YS");
            uocShipOrderDo.setInspOperId(operId);
            uocShipOrderDo.setInspOperPhone(reqBo.getCellphone());
            uocShipOrderDo.setInspOperName(reqBo.getName());
        }
        uocShipOrderDo.setShipOrderItemBoList(shipOrderItemList);
        return uocShipOrderDo;
    }

    private UocShipOrderDo getShipOrderItemList(UocArrvalAcceptanceReqBo reqBo) {
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        ArrayList<Long> shipOrderItemIdList = new ArrayList<Long>();
        ArrayList<Long> shipOrderIdList = new ArrayList<Long>();
        reqBo.getShipOrderList().forEach(uocCreateInspOrderReqShipBo -> {
            shipOrderIdList.add(uocCreateInspOrderReqShipBo.getShipOrderId());
            uocCreateInspOrderReqShipBo.getShipItemList().forEach(uocCreateInspOrderReqShipItemBo -> shipOrderItemIdList.add(uocCreateInspOrderReqShipItemBo.getShipItemId()));
        });
        uocShipOrderItemQryBo.setShipOrderItemIdList(shipOrderItemIdList);
        uocShipOrderItemQryBo.setShipOrderIdList(shipOrderIdList);
        UocShipOrderDo uocShipOrderDo = this.iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
        Integer idSize = shipOrderItemIdList.size();
        if (CollectionUtils.isEmpty(uocShipOrderDo.getShipOrderItemBoList()) || !idSize.equals(uocShipOrderDo.getShipOrderItemBoList().size())) {
            throw new BaseBusinessException("101004", "\u52fe\u9009\u7684\u53d1\u8d27\u660e\u7ec6\u4e0e\u67e5\u8be2\u7ed3\u679c\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u9a8c\u6536\u7684\u5546\u54c1\u4fe1\u606f");
        }
        return uocShipOrderDo;
    }

    private UocSaleOrderDo convertSaleOrderDo(UocArrvalAcceptanceReqBo reqBo, Date now, Map<Long, UocShipOrderItem> uocShipOrderItemMap, String operId) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo.setUpdateOperId(operId);
        uocSaleOrderDo.setUpdateTime(now);
        HashMap saleItemIdMap = new HashMap();
        reqBo.getShipOrderList().forEach(uocCreateInspOrderReqShipBo -> uocCreateInspOrderReqShipBo.getShipItemList().forEach(uocCreateInspOrderReqShipItemBo -> {
            UocShipOrderItem uocShipOrderItem = (UocShipOrderItem)uocShipOrderItemMap.get(uocCreateInspOrderReqShipItemBo.getShipItemId());
            UocSaleOrderItem uocSaleOrderItem = (UocSaleOrderItem)saleItemIdMap.get(uocShipOrderItem.getSaleOrderItemId());
            if (null != uocSaleOrderItem) {
                uocSaleOrderItem.setAcceptanceCount(uocSaleOrderItem.getAcceptanceCount().add(uocCreateInspOrderReqShipItemBo.getInspCount()));
            } else {
                uocSaleOrderItem = new UocSaleOrderItem();
                uocSaleOrderItem.setSaleOrderItemId(uocShipOrderItem.getSaleOrderItemId());
                uocSaleOrderItem.setAcceptanceCount(uocCreateInspOrderReqShipItemBo.getInspCount());
            }
            saleItemIdMap.put(uocSaleOrderItem.getSaleOrderItemId(), uocSaleOrderItem);
        }));
        uocSaleOrderDo.setSaleOrderItems(new ArrayList<UocSaleOrderItem>(saleItemIdMap.values()));
        return uocSaleOrderDo;
    }

    private boolean calculateSaleOrderState(UocArrvalAcceptanceReqBo reqBo, Map<Long, UocSaleOrderItem> uocSaleOrderItemMap) {
        this.modifySaleOrderState(reqBo);
        return true;
    }

    private void modifySaleOrderState(UocArrvalAcceptanceReqBo reqBo) {
        List<UocShipOrderDo> uocShipOrderDoList = this.getUocShipOrderDoList(reqBo, "FH_FH_JS");
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo.setUpdateOperId(reqBo.getUserId().toString());
        if (reqBo.getClosePennyDiff() == null || !reqBo.getClosePennyDiff().booleanValue()) {
            uocSaleOrderDo.setClosePennyDiff(UocConstant.CLOSE_PENNY_DIFF.NO);
        } else {
            uocSaleOrderDo.setClosePennyDiff(UocConstant.CLOSE_PENNY_DIFF.YES);
        }
        if (!CollectionUtils.isEmpty(uocShipOrderDoList)) {
            uocSaleOrderDo.setSaleOrderState("XS_YS_BFYS");
        } else {
            uocSaleOrderDo.setSaleOrderState("XS_YS_YS");
        }
        this.iUocSaleOrderModel.updateSaleStatusAndProCode(uocSaleOrderDo);
    }

    private List<UocInspOrderDo> getUocInspOrderDoList(UocArrvalAcceptanceReqBo reqBo, String state) {
        UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
        uocInspOrderQryBo.setOrderId(reqBo.getOrderId());
        uocInspOrderQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        uocInspOrderQryBo.setInspOrderState(state);
        return this.iUocInspOrderModel.getListInspOrder(uocInspOrderQryBo);
    }

    private List<UocShipOrderDo> getUocShipOrderDoList(UocArrvalAcceptanceReqBo reqBo, String state) {
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        uocShipOrderQryBo.setShipOrderState(state);
        return this.iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
    }

    private String getInspOrderNo(UocArrvalAcceptanceReqBo reqBo) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo = this.iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException("101002", "\u67e5\u8be2\u9a8c\u6536\u5355\u4e3a\u7a7a");
        }
        UocInspOrderDo uocInspOrderDo = new UocInspOrderDo();
        uocInspOrderDo.setOrderSource(uocSaleOrderDo.getOrderSource());
        return this.iUocInspOrderModel.getInspOrderNo(uocInspOrderDo).getInspOrderNo();
    }

    private void validateArg(UocArrvalAcceptanceReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getInspFinish()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u9a8c\u6536\u5b8c\u7ed3\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getClosePennyDiff()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5173\u95ed\u5c3e\u5dee\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getUserId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u7528\u6237ID\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getShipOrderList())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u53d1\u8d27\u5355\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqBo.getShipOrderList().forEach(uocCreateInspOrderReqShipBo -> {
            if (null == uocCreateInspOrderReqShipBo.getShipOrderId()) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u53d1\u8d27\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (CollectionUtils.isEmpty((Collection)uocCreateInspOrderReqShipBo.getShipItemList())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u53d1\u8d27\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
            }
            uocCreateInspOrderReqShipBo.getShipItemList().forEach(uocCreateInspOrderReqShipItemBo -> {
                if (null == uocCreateInspOrderReqShipItemBo.getInspCount()) {
                    throw new BaseBusinessException("100001", "\u5165\u53c2\u9a8c\u6536\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (null == uocCreateInspOrderReqShipItemBo.getShipItemId()) {
                    throw new BaseBusinessException("100001", "\u5165\u53c2\u53d1\u8d27\u660e\u7ec6ID\u4e0d\u80fd\u4e3a\u7a7a");
                }
            });
        });
    }
}

