/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.payorder.IUocPayOrderModel;
import com.tydic.dyc.oc.model.payorder.sub.UocOrderShouldPay;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.service.domainservice.UocPaymentCallbackService;
import com.tydic.dyc.oc.service.domainservice.bo.UocPaymentCallbackBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocPaymentCallbackReqBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocPaymentCallbackRspBO;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.domainservice.UocPaymentCallbackService"})
public class UocPaymentCallbackServiceImpl
implements UocPaymentCallbackService {
    private static final Logger log = LoggerFactory.getLogger(UocPaymentCallbackServiceImpl.class);
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocPayOrderModel iUocPayOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;

    @PostMapping(value={"dealCallback"})
    public UocPaymentCallbackRspBO dealCallback(@RequestBody UocPaymentCallbackReqBO reqBO) {
        this.val(reqBO);
        for (UocPaymentCallbackBO uocPaymentCallbackBO : reqBO.getUocPaymentCallbackBOS()) {
            if (!uocPaymentCallbackBO.getPayResult().booleanValue()) {
                log.info("\u7ed3\u7b97\u56de\u8c03\u652f\u4ed8\u72b6\u6001\u4e3afalse\uff0c\u8ba2\u5355\u4fa7\u4e0d\u505a\u4efb\u4f55\u64cd\u4f5c");
                return UocRu.success(UocPaymentCallbackRspBO.class);
            }
            UocOrderShouldPay uocOrderShouldPay = new UocOrderShouldPay();
            uocOrderShouldPay.setFscShouldPayId(uocPaymentCallbackBO.getFscShouldPayId());
            UocOrderShouldPay orderShouldPay = this.iUocPayOrderModel.getOrderShouldPay(uocOrderShouldPay);
            if (orderShouldPay == null) {
                throw new BaseBusinessException("100001", "\u7ed3\u7b97\u5e94\u4ed8id\u67e5\u8be2\u5e94\u4ed8\u5355\u4e3a\u7a7a");
            }
            UocOrderShouldPay set = new UocOrderShouldPay();
            set.setIsPayCompleted(UocDicConstant.SHOULD_PAY_ORDER_PAY_STATE.PAY_COMPLETED);
            UocOrderShouldPay where = new UocOrderShouldPay();
            where.setFscShouldPayId(uocPaymentCallbackBO.getFscShouldPayId());
            where.setPaidAmount(uocPaymentCallbackBO.getShouldPayMoney());
            this.iUocPayOrderModel.modifyOrderShouldPayMain(set, where);
            Long objectId = orderShouldPay.getObjectId();
            Integer objectType = orderShouldPay.getObjectType();
            Long saleOrderID = this.qrySaleOrderID(uocPaymentCallbackBO, objectId, objectType);
            if (saleOrderID == null) {
                throw new BaseBusinessException("100001", "\u67e5\u8be2\u9500\u552e\u5355ID\u4e3a\u7a7a");
            }
            UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
            uocSaleOrderDo.setOrderId(uocPaymentCallbackBO.getOrderId());
            uocSaleOrderDo.setSaleOrderId(saleOrderID);
            uocSaleOrderDo.setUsedFee(uocPaymentCallbackBO.getShouldPayMoney());
            this.iUocSaleOrderModel.modifySaleOrderMain(uocSaleOrderDo);
        }
        return UocRu.success(UocPaymentCallbackRspBO.class);
    }

    private Long qrySaleOrderID(UocPaymentCallbackBO uocPaymentCallbackBO, Long objectId, Integer objectType) {
        Long saleOrderId = null;
        if (UocDicConstant.OBJ_TYPE.SALE.equals(objectType)) {
            saleOrderId = objectId;
        } else if (UocDicConstant.OBJ_TYPE.SHIP.equals(objectType)) {
            UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
            uocShipOrderQryBo.setOrderId(uocPaymentCallbackBO.getOrderId());
            uocShipOrderQryBo.setShipOrderId(objectId);
            UocShipOrderDo uocShipOrderDo = this.iUocShipOrderModel.getShipOrderById(uocShipOrderQryBo);
            if (uocShipOrderDo == null) {
                throw new BaseBusinessException("100001", "\u67e5\u8be2\u53d1\u8d27\u5355\u4e3a\u7a7a");
            }
            saleOrderId = uocShipOrderDo.getSaleOrderId();
        } else if (UocDicConstant.OBJ_TYPE.INSPECTION.equals(objectType)) {
            UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
            uocInspOrderQryBo.setOrderId(uocPaymentCallbackBO.getOrderId());
            uocInspOrderQryBo.setInspOrderId(objectId);
            UocInspOrderDo inspOrderMain = this.iUocInspOrderModel.getInspOrderMain(uocInspOrderQryBo);
            if (inspOrderMain == null) {
                throw new BaseBusinessException("100001", "\u67e5\u8be2\u9a8c\u6536\u5355\u4e3a\u7a7a");
            }
            saleOrderId = inspOrderMain.getSaleOrderId();
        } else {
            throw new BaseBusinessException("100001", "\u6682\u4ec5\u652f\u6301\u9500\u552e\u5355\u3001\u53d1\u8d27\u5355\u3001\u9a8c\u6536\u5355\u5355\u636e\u7c7b\u578b");
        }
        return saleOrderId;
    }

    private void val(UocPaymentCallbackReqBO reqBO) {
        if (reqBO == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getUocPaymentCallbackBOS())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2[\u56de\u8c03\u4fe1\u606f\u96c6\u5408]\u4e3a\u7a7a");
        }
        for (UocPaymentCallbackBO uocPaymentCallbackBO : reqBO.getUocPaymentCallbackBOS()) {
            if (uocPaymentCallbackBO == null) {
                throw new BaseBusinessException("100001", "\u5165\u53c2[\u652f\u4ed8\u662f\u5426\u6210\u529f]\u4e3a\u7a7a");
            }
            if (!uocPaymentCallbackBO.getPayResult().booleanValue()) continue;
            if (uocPaymentCallbackBO.getFscShouldPayId() == null) {
                throw new BaseBusinessException("100001", "\u5165\u53c2[\u7ed3\u7b97\u5e94\u4ed8ID]\u4e3a\u7a7a");
            }
            if (uocPaymentCallbackBO.getOrderId() == null) {
                throw new BaseBusinessException("100001", "\u5165\u53c2[\u8ba2\u5355ID]\u4e3a\u7a7a");
            }
            if (uocPaymentCallbackBO.getShouldPayMoney() != null) continue;
            throw new BaseBusinessException("100001", "\u5165\u53c2[\u5e94\u4ed8\u91d1\u989d]\u4e3a\u7a7a");
        }
    }
}

