package com.tydic.dyc.oc.components.notice;

import java.util.List;
import java.util.Map;

/**
 * 标题:UocNoticeProcessor
 * 说明:订单中心通知处理类，主要是返回接受用户查询条件和通知内容
 * 时间:2022/4/15 11:33
 * 作者:田桂银
 */
public interface UocNoticeProcessor {

    /**
     * 描述:返回通知中心编码
     * @return java.lang.String
     * @author tgy
     * @date 2022/4/15 11:36
     */
    String noticeCode();


    /**
     * 描述:返回接受用户查询条件（通知中心传递给会员查询接受用户）
     * @return com.tydic.dyc.oc.components.notice.UocNoticeReceiverQryConditionBo
     * @author tgy
     * @date 2022/4/15 11:39
     */
    UocNoticeReceiverQryConditionBo qryCondition();


    /**
     * 描述:返回通知中心替换内容
     * @return java.util.List<com.tydic.dyc.oc.components.notice.UocNoticeContentReplaceBo>
     * @author tgy
     * @date 2022/4/15 11:42
     */
    List<UocNoticeContentReplaceBo> replaceContent(Map<String,Object> dataMap);


}
