package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.UocAfOrderDo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderItem;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderMap;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryAddBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderCreateReqAddressBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderCreateReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderCreateReqItemBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderCreateRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 标题：类名称:UocAfterOrderCreateServiceImpl
 * 说明：描述一下类的作用TODO
 * 时间：2022/4/1 14:36
 * 作者 @author 尹栋梁
 */
@HTServiceImpl
public class UocAfterOrderCreateServiceImpl implements UocAfterOrderCreateService{
    @Autowired
    private IUocAfOrderModel afOrderModel;

    @Autowired
    private IUocShipOrderModel shipOrderModel;

    @Autowired
    private IUocSaleOrderModel saleOrderModel;

    @Override
    public UocAfterOrderCreateRspBo createAfterOrder(UocAfterOrderCreateReqBo reqBo) {
        //参数校验
        validateArg(reqBo);
        UocAfterOrderCreateRspBo rspBo = UocRu.success(UocAfterOrderCreateRspBo.class);
        if (!StringUtils.isEmpty(reqBo.getName())) {
            reqBo.setUsername(reqBo.getName());
        }
        checkAfterCount(reqBo);
        //bo转售后订单do
        UocAfOrderDo createDo = convertOrderDo(reqBo);
        buildShipItem(reqBo, createDo);
        //售后服务单入库
        UocAfOrderDo uocAfOrderDo1 = afOrderModel.dealPebTheZoneAfterApplication(createDo);

        rspBo.setAfOrderId(uocAfOrderDo1.getAfOrderId());
        return rspBo;
    }

    private void checkAfterCount(UocAfterOrderCreateReqBo reqBo) {
        UocShipOrderItemQryBo uocShipOrderQryBo = new UocShipOrderItemQryBo();
        uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderQryBo.setShipOrderId(reqBo.getShipOrderId());
        UocShipOrderDo shipOrderById = shipOrderModel.getListShipOrderItem(uocShipOrderQryBo);
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        List<UocSaleOrderItem> saleOrderItemList = saleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        Map<Long, UocSaleOrderItem> saleOrderItemMap = saleOrderItemList.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));
        Map<Long, UocShipOrderItem> shipOrderItemMap = shipOrderById.getShipOrderItemBoList().stream().collect(Collectors.toMap(UocShipOrderItem::getShipOrderItemId, o -> o));
        List<UocAfterOrderCreateReqItemBo> shipItemList = reqBo.getShipItemList();
        for (UocAfterOrderCreateReqItemBo uocAfterOrderCreateReqItemBo : shipItemList) {
            UocShipOrderItem uocShipOrderItem = shipOrderItemMap.get(uocAfterOrderCreateReqItemBo.getShipOrderItemId());
            UocSaleOrderItem uocSaleOrderItem = saleOrderItemMap.get(uocShipOrderItem.getSaleOrderItemId());

            //若发货单状态为已到货时，可售后数量=本次发货数量-已退货数量-售后中数量
            if (UocStateConstants.ShipOrder.FH_FH_YSH.equals(shipOrderById.getShipOrderState())) {
                BigDecimal afterCountEnable = uocShipOrderItem.getSendCount().subtract(uocSaleOrderItem.getReturnCount()).subtract(uocSaleOrderItem.getAfterServingCount());
                if (uocAfterOrderCreateReqItemBo.getReturnCount().compareTo(afterCountEnable) > 0) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性售后数量不能超过可售后数量");
                }
            }

            //若发货单状态为已验收时，可售后数量=实际验收数量-已退货数量-售后中数量
            if (UocStateConstants.ShipOrder.FH_FH_YS.equals(shipOrderById.getShipOrderState())) {
                BigDecimal afterCountEnable = uocSaleOrderItem.getAcceptanceCount().subtract(uocSaleOrderItem.getReturnCount()).subtract(uocSaleOrderItem.getAfterServingCount());
                if (uocAfterOrderCreateReqItemBo.getReturnCount().compareTo(afterCountEnable) > 0) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性售后数量不能超过可售后数量");
                }
            }
        }
    }

    private void buildShipItem(UocAfterOrderCreateReqBo reqBo, UocAfOrderDo createDo) {
        List<UocAfOrderItem> uocAfOrderItems = new ArrayList<>();
        List<UocAfterOrderCreateReqItemBo> shipItemList = reqBo.getShipItemList();
        if (CollectionUtil.isNotEmpty(shipItemList)) {
            for (UocAfterOrderCreateReqItemBo uocAfterOrderCreateReqItemBo : shipItemList) {
                Long shipOrderItemId = uocAfterOrderCreateReqItemBo.getShipOrderItemId();
                UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
                uocShipOrderItemQryBo.setShipOrderItemId(shipOrderItemId);
                UocShipOrderDo shipOrderItem = shipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
                if (ObjectUtil.isNotEmpty(shipOrderItem) && ObjectUtil.isNotEmpty(shipOrderItem.getShipOrderItemBoList())) {
                    UocAfOrderItem uocAfOrderItem = new UocAfOrderItem();
                    List<UocShipOrderItem> shipOrderItemBoList = shipOrderItem.getShipOrderItemBoList();
                    UocShipOrderItem uocShipOrderItem = shipOrderItemBoList.get(0);
                    BeanUtil.copyProperties(uocShipOrderItem, uocAfOrderItem);
                    Long saleOrderItemId = uocShipOrderItem.getSaleOrderItemId();
                    UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
                    uocSaleOrderItemQryBo.setOrderItemId(saleOrderItemId);
                    List<UocSaleOrderItem> saleOrderItemList = saleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
                    UocSaleOrderItem uocSaleOrderItem = saleOrderItemList.get(0);
                    BeanUtil.copyProperties(uocSaleOrderItem, uocAfOrderItem);
                    uocAfOrderItems.add(uocAfOrderItem);
                }
            }
        }
        createDo.setAfOrderItemBoList(uocAfOrderItems);
    }


    private UocAfOrderDo convertOrderDo(UocAfterOrderCreateReqBo reqBo) {
        UocAfOrderDo uocAfOrderDo = UocRu.js(reqBo, UocAfOrderDo.class);
        uocAfOrderDo.setExtAfId(reqBo.getServiceId());
        List<UocBaseExtParallelBo> extParallelBoList = reqBo.getExtParallelBoList();
        if (CollectionUtil.isNotEmpty(extParallelBoList)) {
            uocAfOrderDo.setExtParallelBoList(UocRu.jsl(extParallelBoList, UocAfOrderMap.class));
            BeanUtils.copyProperties(reqBo, uocAfOrderDo);
            uocAfOrderDo.setCreateTime(new Date());
            uocAfOrderDo.setCreateOperId(String.valueOf(reqBo.getUserId()));
        }
        List<UocAfterOrderCreateReqItemBo> shipItemList = reqBo.getShipItemList();
        if (CollectionUtil.isNotEmpty(shipItemList)) {
            uocAfOrderDo.setAfOrderItemBoList(UocRu.jsl(shipItemList, UocAfOrderItem.class));
            for (UocAfOrderItem uocAfOrderItem : uocAfOrderDo.getAfOrderItemBoList()) {
                BeanUtils.copyProperties(reqBo, uocAfOrderItem);
                uocAfOrderItem.setCreateTime(new Date());
                uocAfOrderItem.setCreateOperId(String.valueOf(reqBo.getUserId()));
            }
        }
        List<UocBaseOrderAccessoryAddBo> orderAccessoryBoList = reqBo.getOrderAccessoryBoList();
        if (CollectionUtil.isNotEmpty(orderAccessoryBoList)) {
            uocAfOrderDo.setOrderAccessoryBoList(UocRu.jsl(shipItemList, UocOrderAccessory.class));
            for (UocOrderAccessory uocOrderAccessory : uocAfOrderDo.getOrderAccessoryBoList()) {
                BeanUtils.copyProperties(reqBo, uocOrderAccessory);
                uocOrderAccessory.setCreateTime(new Date());
                uocOrderAccessory.setCreateOperId(String.valueOf(reqBo.getUserId()));
            }
        }
        UocAfterOrderCreateReqAddressBo takeAddress = reqBo.getTakeAddress();
        UocAfterOrderCreateReqAddressBo returnAddress = reqBo.getReturnAddress();
        if (ObjectUtil.isNotEmpty(takeAddress)) {
            uocAfOrderDo.setTakeAddress(UocRu.js(takeAddress, UocOrdLogisticsRela.class));
            uocAfOrderDo.getTakeAddress().setCreateOperId(String.valueOf(reqBo.getUserId()));
        }
        if (ObjectUtil.isNotEmpty(returnAddress)) {
            uocAfOrderDo.setReturnAddress(UocRu.js(returnAddress, UocOrdLogisticsRela.class));
            uocAfOrderDo.getReturnAddress().setCreateOperId(String.valueOf(reqBo.getUserId()));
        }
        uocAfOrderDo.setSubContactName(reqBo.getName());
        uocAfOrderDo.setSubContactMobile(reqBo.getCellphone());
        uocAfOrderDo.setCreateTime(new Date());
        uocAfOrderDo.setCreateOperId(String.valueOf(reqBo.getUserId()));
        uocAfOrderDo.setSubmiteTime(new Date());
        uocAfOrderDo.setSubmitterOperId(String.valueOf(reqBo.getUserId()));
        uocAfOrderDo.setSubmitterOperName(reqBo.getUsername());
        uocAfOrderDo.setSubDeptId(String.valueOf(reqBo.getOrgId()));
        uocAfOrderDo.setSubDeptName(reqBo.getOrgName());
        uocAfOrderDo.setSubCompId(String.valueOf(reqBo.getCompanyId()));
        uocAfOrderDo.setSubCompName(reqBo.getCompanyName());
        return uocAfOrderDo;
    }

    private void validateArg(UocAfterOrderCreateReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocAfterOrderCreateReqBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getShipOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[发货单ID]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[订单ID]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getSaleOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[销售单ID]不能为空");
        }

        if (ObjectUtil.isEmpty(reqBo.getServType())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[服务类型]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getAfsReason())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[售后原因]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getPickwareType())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[取货服务类型]不能为空");
        }

        if (UocConstant.AFTERORDER_PICKWARETYPE.UPDOORPICK.equals(reqBo.getPickwareType())) {
            if (ObjectUtil.isEmpty(reqBo.getTakeAddress())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[取件地址]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getTakeAddress().getContactProvinceId())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人省份编号]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getTakeAddress().getContactProvinceName())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人省份名称]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getTakeAddress().getContactCityId())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人地市编号]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getTakeAddress().getContactCityName())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人地市名称]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getTakeAddress().getContactCountyId())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人区县编号]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getTakeAddress().getContactCountyName())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人区县名称]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getTakeAddress().getContactAddress())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[收货人地址]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getTakeAddress().getContactName())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人名称]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getTakeAddress().getContactEmail())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人邮件]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getTakeAddress().getContactMobile())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人手机]不能为空");
            }
        }

        if (UocConstant.AFTERORDER_SERVTYPE.CHANGE.equals(reqBo.getServType()) || UocConstant.AFTERORDER_SERVTYPE.FIX.equals(reqBo.getServType())) {
            if (ObjectUtil.isEmpty(reqBo.getReturnAddress())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[返件地址]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getReturnAddress().getContactProvinceId())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人省份编号]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getReturnAddress().getContactProvinceName())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人省份名称]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getReturnAddress().getContactCityId())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人地市编号]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getReturnAddress().getContactCityName())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人地市名称]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getReturnAddress().getContactCountyId())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人区县编号]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getReturnAddress().getContactCountyName())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人区县名称]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getReturnAddress().getContactAddress())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[收货人地址]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getReturnAddress().getContactName())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人名称]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getReturnAddress().getContactEmail())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人邮件]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getReturnAddress().getContactMobile())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人手机]不能为空");
            }
        }
        if (ObjectUtil.isEmpty(reqBo.getQuestionDesc())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[问题描述]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getShipItemList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[售后明细]不能为空");
        }
        for (UocAfterOrderCreateReqItemBo uocAfterOrderCreateReqItemBo : reqBo.getShipItemList()) {
            if (ObjectUtil.isEmpty(uocAfterOrderCreateReqItemBo.getShipOrderItemId())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[发货明细ID]不能为空");
            }
            if (ObjectUtil.isEmpty(uocAfterOrderCreateReqItemBo.getReturnCount())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[售后数量]不能为空");
            }
        }
        if (ObjectUtil.isEmpty(reqBo.getOrderAccessoryBoList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[附件]不能为空");
        }
    }
}
