package com.tydic.dyc.oc.model.audit.impl;

import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.UocAuditOrderDo;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalLogQryBo;
import com.tydic.dyc.oc.model.audit.qrybo.UocAuditOrderQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.audit.sub.UocAuditOrder;
import com.tydic.dyc.oc.model.order.sub.UocOrderBusiOperRecord;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.repository.UocAuditOrderRepository;
import com.tydic.dyc.oc.repository.UocCommonRepository;
import com.tydic.dyc.oc.utils.UocRu;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * 标题:IUocAuditOrderModelImpl
 * 说明:
 * 时间:2022/3/10 17:26
 * 作者:田桂银
 */
@Service
public class IUocAuditOrderModelImpl implements IUocAuditOrderModel {


    @Autowired
    private UocAuditOrderRepository uocAuditOrderRepository;

    @Autowired
    private UocCommonRepository uocCommonRepository;


    @Override
    public UocAuditOrderDo saveAudit(UocAuditOrderDo orderDo) {
        orderDo.setCreateTime(new Date());
        return uocAuditOrderRepository.saveAudit(orderDo);
    }

    @Override
    public UocOrderProcInst updateProInst(UocOrderProcInst inst) {
        UocOrderProcInst updateInst = UocRu.js(inst, UocOrderProcInst.class);
        uocCommonRepository.updateProInst(updateInst);
        return inst;
    }

    @Override
    public UocAuditOrderDo updateApprove(UocAuditOrderDo updateDo) {
        uocAuditOrderRepository.updateApprove(updateDo);
        return updateDo;
    }

    @Override
    public void saveOperRecord(List<UocOrderBusiOperRecord> recordList) {
        uocCommonRepository.saveOperRecord(recordList);
    }

    @Override
    public List<UocApprovalObj> qryApprovealObj(UocApprovalObj obj) {
        return uocAuditOrderRepository.qryApprovealObj(obj);
    }

    @Override
    public List<UocAuditOrder> qryAuditOrderList(UocAuditOrderQryBo qryBo) {
        return uocAuditOrderRepository.qryAuditOrderList(qryBo);
    }

    @Override
    public void saveAuditLog(UocAuditOrderDo orderDo) {
        uocAuditOrderRepository.saveAuditLog(orderDo);
    }

    @Override
    public UocAuditOrderDo qryApprovalLog(UocApprovalLogQryBo uocApprovalLogQryBo) {
        return uocAuditOrderRepository.qryApprovalLog(uocApprovalLogQryBo);
    }
}


