/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.UocAfOrderDo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderItem;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderMap;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderObj;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.domainservice.UocAfterOrderCreateService;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderCreateReqAddressBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderCreateReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderCreateReqItemBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderCreateRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.domainservice.UocAfterOrderCreateService"})
public class UocAfterOrderCreateServiceImpl
implements UocAfterOrderCreateService {
    @Autowired
    private IUocAfOrderModel afOrderModel;
    @Autowired
    private IUocShipOrderModel shipOrderModel;
    @Autowired
    private IUocSaleOrderModel saleOrderModel;

    @PostMapping(value={"createAfterOrder"})
    public UocAfterOrderCreateRspBo createAfterOrder(@RequestBody UocAfterOrderCreateReqBo reqBo) {
        this.validateArg(reqBo);
        UocAfterOrderCreateRspBo rspBo = UocRu.success(UocAfterOrderCreateRspBo.class);
        if (!StringUtils.isEmpty((Object)reqBo.getName())) {
            reqBo.setUsername(reqBo.getName());
        }
        this.checkAfterCount(reqBo);
        UocAfOrderDo createDo = this.convertOrderDo(reqBo);
        this.buildShipItem(reqBo, createDo);
        UocAfOrderDo uocAfOrderDo1 = this.afOrderModel.dealPebTheZoneAfterApplication(createDo, reqBo.getOrderSource());
        rspBo.setAfOrderId(uocAfOrderDo1.getAfOrderId());
        return rspBo;
    }

    private void checkAfterCount(UocAfterOrderCreateReqBo reqBo) {
        UocShipOrderItemQryBo uocShipOrderQryBo = new UocShipOrderItemQryBo();
        uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderQryBo.setShipOrderId(reqBo.getShipOrderId());
        UocShipOrderDo shipOrderById = this.shipOrderModel.getListShipOrderItem(uocShipOrderQryBo);
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        List<UocSaleOrderItem> saleOrderItemList = this.saleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        Map<Long, UocSaleOrderItem> saleOrderItemMap = saleOrderItemList.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));
        Map<Long, UocShipOrderItem> shipOrderItemMap = shipOrderById.getShipOrderItemBoList().stream().collect(Collectors.toMap(UocShipOrderItem::getShipOrderItemId, o -> o));
        List shipItemList = reqBo.getShipItemList();
        for (UocAfterOrderCreateReqItemBo uocAfterOrderCreateReqItemBo : shipItemList) {
            BigDecimal afterCountEnable;
            UocShipOrderItem uocShipOrderItem = shipOrderItemMap.get(uocAfterOrderCreateReqItemBo.getShipOrderItemId());
            UocSaleOrderItem uocSaleOrderItem = saleOrderItemMap.get(uocShipOrderItem.getSaleOrderItemId());
            if ("FH_FH_YDH".equals(shipOrderById.getShipOrderState())) {
                afterCountEnable = uocShipOrderItem.getSendCount().subtract(uocSaleOrderItem.getReturnCount()).subtract(uocSaleOrderItem.getAfterServingCount());
                if (uocAfterOrderCreateReqItemBo.getReturnCount().compareTo(afterCountEnable) > 0) {
                    throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u552e\u540e\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\u53ef\u552e\u540e\u6570\u91cf");
                }
            }
            if (!"FH_FH_YS".equals(shipOrderById.getShipOrderState())) continue;
            afterCountEnable = uocSaleOrderItem.getAcceptanceCount().subtract(uocSaleOrderItem.getReturnCount()).subtract(uocSaleOrderItem.getAfterServingCount());
            if (uocAfterOrderCreateReqItemBo.getReturnCount().compareTo(afterCountEnable) <= 0) continue;
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u552e\u540e\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\u53ef\u552e\u540e\u6570\u91cf");
        }
    }

    private void buildShipItem(UocAfterOrderCreateReqBo reqBo, UocAfOrderDo createDo) {
        ArrayList<UocAfOrderItem> uocAfOrderItems = new ArrayList<UocAfOrderItem>();
        List shipItemList = reqBo.getShipItemList();
        if (CollectionUtil.isNotEmpty((Collection)shipItemList)) {
            for (UocAfterOrderCreateReqItemBo uocAfterOrderCreateReqItemBo : shipItemList) {
                Long shipOrderItemId = uocAfterOrderCreateReqItemBo.getShipOrderItemId();
                UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
                uocShipOrderItemQryBo.setShipOrderItemId(shipOrderItemId);
                uocShipOrderItemQryBo.setShipOrderId(reqBo.getShipOrderId());
                UocShipOrderDo shipOrderItem = this.shipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
                if (!ObjectUtil.isNotEmpty((Object)shipOrderItem) || !ObjectUtil.isNotEmpty(shipOrderItem.getShipOrderItemBoList())) continue;
                UocAfOrderItem uocAfOrderItem = new UocAfOrderItem();
                List<UocShipOrderItem> shipOrderItemBoList = shipOrderItem.getShipOrderItemBoList();
                UocShipOrderItem uocShipOrderItem = shipOrderItemBoList.get(0);
                BeanUtil.copyProperties((Object)uocShipOrderItem, (Object)uocAfOrderItem);
                Long saleOrderItemId = uocShipOrderItem.getSaleOrderItemId();
                UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
                uocSaleOrderItemQryBo.setSaleOrderItemId(saleOrderItemId);
                List<UocSaleOrderItem> saleOrderItemList = this.saleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
                UocSaleOrderItem uocSaleOrderItem = saleOrderItemList.get(0);
                BeanUtil.copyProperties((Object)uocSaleOrderItem, (Object)uocAfOrderItem);
                uocAfOrderItem.setSaleItemId(uocShipOrderItem.getSaleOrderItemId());
                uocAfOrderItem.setShipItemId(uocShipOrderItem.getShipOrderItemId());
                uocAfOrderItems.add(uocAfOrderItem);
            }
        }
        createDo.setAfOrderItemBoList(uocAfOrderItems);
    }

    private UocAfOrderDo convertOrderDo(UocAfterOrderCreateReqBo reqBo) {
        List orderAccessoryBoList;
        List shipItemList;
        UocAfOrderDo uocAfOrderDo = UocRu.js(reqBo, UocAfOrderDo.class);
        UocAfOrderObj uocAfOrderObj = UocRu.js(reqBo, UocAfOrderObj.class);
        ArrayList<UocAfOrderObj> uocAfOrderObjs = new ArrayList<UocAfOrderObj>();
        uocAfOrderObjs.add(uocAfOrderObj);
        uocAfOrderDo.setAfOrderObjList(uocAfOrderObjs);
        uocAfOrderDo.setExtAfId(reqBo.getServiceId());
        List extParallelBoList = reqBo.getExtParallelBoList();
        if (CollectionUtil.isNotEmpty((Collection)extParallelBoList)) {
            uocAfOrderDo.setExtParallelBoList(UocRu.jsl(extParallelBoList, UocAfOrderMap.class));
            BeanUtils.copyProperties((Object)reqBo, (Object)uocAfOrderDo);
            uocAfOrderDo.setCreateTime(new Date());
            uocAfOrderDo.setCreateOperId(String.valueOf(reqBo.getUserId()));
        }
        if (CollectionUtil.isNotEmpty((Collection)(shipItemList = reqBo.getShipItemList()))) {
            uocAfOrderDo.setAfOrderItemBoList(UocRu.jsl(shipItemList, UocAfOrderItem.class));
            for (UocAfOrderItem uocAfOrderItem : uocAfOrderDo.getAfOrderItemBoList()) {
                BeanUtils.copyProperties((Object)reqBo, (Object)uocAfOrderItem);
                uocAfOrderItem.setCreateTime(new Date());
                uocAfOrderItem.setCreateOperId(String.valueOf(reqBo.getUserId()));
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)(orderAccessoryBoList = reqBo.getOrderAccessoryBoList()))) {
            uocAfOrderDo.setOrderAccessoryBoList(UocRu.jsl(orderAccessoryBoList, UocOrderAccessory.class));
            for (UocOrderAccessory uocOrderAccessory : uocAfOrderDo.getOrderAccessoryBoList()) {
                BeanUtils.copyProperties((Object)reqBo, (Object)uocOrderAccessory);
                uocOrderAccessory.setCreateTime(new Date());
                uocOrderAccessory.setAttachmentType(1);
                uocOrderAccessory.setCreateOperId(String.valueOf(reqBo.getUserId()));
            }
        }
        UocAfterOrderCreateReqAddressBo uocAfterOrderCreateReqAddressBo = reqBo.getTakeAddress();
        UocAfterOrderCreateReqAddressBo returnAddress = reqBo.getReturnAddress();
        if (ObjectUtil.isNotEmpty((Object)uocAfterOrderCreateReqAddressBo)) {
            uocAfOrderDo.setTakeAddress(UocRu.js(uocAfterOrderCreateReqAddressBo, UocOrdLogisticsRela.class));
            uocAfOrderDo.getTakeAddress().setCreateOperId(String.valueOf(reqBo.getUserId()));
        }
        if (ObjectUtil.isNotEmpty((Object)returnAddress)) {
            uocAfOrderDo.setReturnAddress(UocRu.js(returnAddress, UocOrdLogisticsRela.class));
            uocAfOrderDo.getReturnAddress().setCreateOperId(String.valueOf(reqBo.getUserId()));
        }
        uocAfOrderDo.setSubContactName(reqBo.getName());
        uocAfOrderDo.setSubContactMobile(reqBo.getCellphone());
        uocAfOrderDo.setCreateTime(new Date());
        uocAfOrderDo.setCreateOperId(String.valueOf(reqBo.getUserId()));
        uocAfOrderDo.setSubmiteTime(new Date());
        uocAfOrderDo.setSubmitterOperId(String.valueOf(reqBo.getUserId()));
        uocAfOrderDo.setSubmitterOperName(reqBo.getUsername());
        uocAfOrderDo.setSubDeptId(String.valueOf(reqBo.getOrgId()));
        uocAfOrderDo.setSubDeptName(reqBo.getOrgName());
        uocAfOrderDo.setSubCompId(String.valueOf(reqBo.getCompanyId()));
        uocAfOrderDo.setSubCompName(reqBo.getCompanyName());
        return uocAfOrderDo;
    }

    private void validateArg(UocAfterOrderCreateReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocAfterOrderCreateReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getShipOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u53d1\u8d27\u5355ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8ba2\u5355ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSaleOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u9500\u552e\u5355ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getServType())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u670d\u52a1\u7c7b\u578b]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getAfsReason())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u552e\u540e\u539f\u56e0]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getPickwareType())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u53d6\u8d27\u670d\u52a1\u7c7b\u578b]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (UocConstant.AFTERORDER_PICKWARETYPE.UPDOORPICK.equals(reqBo.getPickwareType())) {
            if (ObjectUtil.isEmpty((Object)reqBo.getTakeAddress())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u53d6\u4ef6\u5730\u5740]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getTakeAddress().getContactProvinceId())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u7701\u4efd\u7f16\u53f7]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getTakeAddress().getContactProvinceName())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u7701\u4efd\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getTakeAddress().getContactCityId())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u5730\u5e02\u7f16\u53f7]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getTakeAddress().getContactCityName())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u5730\u5e02\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getTakeAddress().getContactCountyId())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u533a\u53bf\u7f16\u53f7]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getTakeAddress().getContactCountyName())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u533a\u53bf\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getTakeAddress().getContactAddress())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u6536\u8d27\u4eba\u5730\u5740]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getTakeAddress().getContactName())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getTakeAddress().getContactEmail())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u90ae\u4ef6]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getTakeAddress().getContactMobile())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u624b\u673a]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (UocConstant.AFTERORDER_SERVTYPE.CHANGE.equals(reqBo.getServType()) || UocConstant.AFTERORDER_SERVTYPE.FIX.equals(reqBo.getServType())) {
            if (ObjectUtil.isEmpty((Object)reqBo.getReturnAddress())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8fd4\u4ef6\u5730\u5740]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getReturnAddress().getContactProvinceId())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u7701\u4efd\u7f16\u53f7]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getReturnAddress().getContactProvinceName())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u7701\u4efd\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getReturnAddress().getContactCityId())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u5730\u5e02\u7f16\u53f7]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getReturnAddress().getContactCityName())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u5730\u5e02\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getReturnAddress().getContactCountyId())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u533a\u53bf\u7f16\u53f7]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getReturnAddress().getContactCountyName())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u533a\u53bf\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getReturnAddress().getContactAddress())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u6536\u8d27\u4eba\u5730\u5740]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getReturnAddress().getContactName())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getReturnAddress().getContactEmail())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u90ae\u4ef6]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getReturnAddress().getContactMobile())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u624b\u673a]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getQuestionDesc())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u95ee\u9898\u63cf\u8ff0]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getShipItemList())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u552e\u540e\u660e\u7ec6]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UocAfterOrderCreateReqItemBo uocAfterOrderCreateReqItemBo : reqBo.getShipItemList()) {
            if (ObjectUtil.isEmpty((Object)uocAfterOrderCreateReqItemBo.getShipOrderItemId())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u53d1\u8d27\u660e\u7ec6ID]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!ObjectUtil.isEmpty((Object)uocAfterOrderCreateReqItemBo.getReturnCount())) continue;
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u552e\u540e\u6570\u91cf]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderAccessoryBoList())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u9644\u4ef6]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

