/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.UocAuditOrderDo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalLog;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.order.sub.UocOrderBusiOperRecord;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.service.domainservice.UocApproveMoveService;
import com.tydic.dyc.oc.service.domainservice.bo.UocApproveMoveServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocApproveMoveServiceReqTaskBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocApproveMoveServiceRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.domainservice.UocApproveMoveService"})
public class UocApproveMoveServiceImpl
implements UocApproveMoveService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;

    @PostMapping(value={"moveApprove"})
    public UocApproveMoveServiceRspBo moveApprove(@RequestBody UocApproveMoveServiceReqBo reqBo) {
        UocApproveMoveServiceRspBo rspBo = UocRu.success(UocApproveMoveServiceRspBo.class);
        this.validateArg(reqBo);
        Date now = new Date();
        UocApprovalObj qryObj = new UocApprovalObj();
        qryObj.setObjId(reqBo.getObjId().toString());
        qryObj.setOrderId(reqBo.getOrderId());
        qryObj.setObjBusiType(reqBo.getObjBusiType());
        List<UocApprovalObj> uocApprovalObjs = this.iUocAuditOrderModel.qryApprovealObj(qryObj);
        if (ObjectUtil.isEmpty(uocApprovalObjs)) {
            throw new BaseBusinessException("101005", "\u67e5\u8be2\u5ba1\u6279\u5bf9\u8c61\u4e3a\u7a7a");
        }
        Long auditOrderId = uocApprovalObjs.get(0).getAuditOrderId();
        Boolean finished = reqBo.getFinished();
        Integer finalResult = reqBo.getFinalResult();
        if (finished.booleanValue()) {
            UocOrderProcInst updateInst = new UocOrderProcInst();
            updateInst.setOrderId(reqBo.getOrderId());
            updateInst.setObjId(reqBo.getObjId());
            updateInst.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
            updateInst.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.FINISHED);
            updateInst.setFinishTime(now);
            updateInst.setProcInstId(reqBo.getProcInstId());
            this.iUocAuditOrderModel.updateProInst(updateInst);
            UocAuditOrderDo updateApprove = new UocAuditOrderDo();
            updateApprove.setOrderId(reqBo.getOrderId());
            updateApprove.setAuditOrderId(auditOrderId);
            updateApprove.setFinishTime(now);
            updateApprove.setUpdateTime(now);
            updateApprove.setUpdateOperId(reqBo.getUserId().toString());
            updateApprove.setFinalResult(finalResult);
            this.iUocAuditOrderModel.updateApprove(updateApprove);
        }
        this.saveLog(reqBo, now, auditOrderId, finished, finalResult);
        String oldTaskInstId = reqBo.getOldTaskInstId();
        UocOrderTaskInst qryInst = new UocOrderTaskInst();
        qryInst.setOrderId(reqBo.getOrderId());
        qryInst.setTaskInstId(oldTaskInstId);
        List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocSaleOrderModel.qryTaskInstList(qryInst);
        if (ObjectUtil.isEmpty(uocOrderTaskInsts)) {
            throw new BaseBusinessException("101005", "\u4efb\u52a1\u5b9e\u4f8bid(" + oldTaskInstId + ")\u4e0d\u5b58\u5728");
        }
        if (UocDicConstant.PROC_TASK_FINISHED.FINISHED.equals(uocOrderTaskInsts.get(0).getFinishTag())) {
            throw new BaseBusinessException("101005", "\u4efb\u52a1\u5b9e\u4f8bid(" + oldTaskInstId + ")\u5df2\u5b8c\u7ed3");
        }
        ArrayList<UocOrderTaskInst> updateList = new ArrayList<UocOrderTaskInst>();
        UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
        updateList.add(uocOrderTaskInst);
        uocOrderTaskInst.setOrderId(reqBo.getOrderId());
        uocOrderTaskInst.setTaskInstId(oldTaskInstId);
        this.iUocSaleOrderModel.updateProcTaskInstToFinished(updateList);
        List taskBoList = reqBo.getTaskBoList();
        if (ObjectUtil.isNotEmpty((Object)taskBoList)) {
            ArrayList<UocOrderTaskDeal> saveDealList = new ArrayList<UocOrderTaskDeal>();
            ArrayList<UocOrderTaskInst> saveList = new ArrayList<UocOrderTaskInst>();
            for (UocApproveMoveServiceReqTaskBo reqTaskBo : taskBoList) {
                UocOrderTaskInst taskBo = new UocOrderTaskInst();
                taskBo.setId(IdUtil.nextId());
                taskBo.setOrderId(reqBo.getOrderId());
                taskBo.setTaskInstId(reqTaskBo.getTaskInstId());
                taskBo.setObjId(reqBo.getObjId());
                taskBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
                taskBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
                saveList.add(taskBo);
                String assignee = reqTaskBo.getAssignee();
                List candidates = reqTaskBo.getCandidates();
                if (ObjectUtil.isNotEmpty((Object)assignee)) {
                    UocOrderTaskDeal deal = this.assembleTaskDealObj(reqBo, reqTaskBo);
                    deal.setDealId(assignee);
                    deal.setDealClass("1");
                    saveDealList.add(deal);
                } else if (ObjectUtil.isNotEmpty((Object)candidates)) {
                    for (String candidate : candidates) {
                        UocOrderTaskDeal deal = this.assembleTaskDealObj(reqBo, reqTaskBo);
                        deal.setDealId(candidate);
                        deal.setDealClass("2");
                        saveDealList.add(deal);
                    }
                }
                if (ObjectUtil.isNotEmpty(saveDealList)) {
                    this.iUocSaleOrderModel.saveOrderTaskDealList(saveDealList);
                }
                this.iUocSaleOrderModel.saveProcTaskInst(saveList);
            }
        }
        ArrayList<UocOrderBusiOperRecord> recordList = new ArrayList<UocOrderBusiOperRecord>();
        UocOrderBusiOperRecord saveRecord = UocRu.js(reqBo, UocOrderBusiOperRecord.class);
        recordList.add(saveRecord);
        saveRecord.setId(IdUtil.nextId());
        saveRecord.setObjId(reqBo.getObjId());
        saveRecord.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
        saveRecord.setOrderId(reqBo.getOrderId());
        saveRecord.setCreateTime(now);
        saveRecord.setDealTime(now);
        saveRecord.setDealOperId(reqBo.getUserId().toString());
        saveRecord.setDealOperName(reqBo.getName());
        this.iUocAuditOrderModel.saveOperRecord(recordList);
        return rspBo;
    }

    private void saveLog(UocApproveMoveServiceReqBo reqBo, Date now, Long auditOrderId, Boolean finished, Integer finalResult) {
        UocApprovalLog approvalLog = new UocApprovalLog();
        approvalLog.setFinish(finished != false ? UocConstant.AUDIT_LOG_FINISH.YES : UocConstant.AUDIT_LOG_FINISH.NO);
        approvalLog.setId(IdUtil.nextId());
        approvalLog.setOperid(reqBo.getUserId().toString());
        approvalLog.setOperName(reqBo.getName());
        approvalLog.setOperDept(reqBo.getOrgId().toString());
        approvalLog.setCreateTime(now);
        approvalLog.setDealTime(now);
        approvalLog.setAuditAdvice(reqBo.getDealReason());
        approvalLog.setAuditResult(finalResult);
        approvalLog.setObjType(reqBo.getObjBusiType());
        approvalLog.setAuditOrderId(auditOrderId);
        UocAuditOrderDo logDo = new UocAuditOrderDo();
        logDo.setApprovalLog(approvalLog);
        this.iUocAuditOrderModel.saveAuditLog(logDo);
    }

    private UocOrderTaskDeal assembleTaskDealObj(UocApproveMoveServiceReqBo reqBo, UocApproveMoveServiceReqTaskBo nextTaskInfo) {
        UocOrderTaskDeal deal = new UocOrderTaskDeal();
        deal.setId(IdUtil.nextId());
        deal.setTaskInstId(nextTaskInfo.getTaskInstId());
        deal.setOrderId(reqBo.getOrderId());
        deal.setObjId(reqBo.getObjId());
        deal.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
        return deal;
    }

    private void validateArg(UocApproveMoveServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocApproveMoveServiceReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getUserId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u7528\u6237id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8ba2\u5355id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getObjId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[objid]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getProcInstId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u6d41\u7a0b\u5b9e\u4f8bid]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getFinalResult())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u5ba1\u6279\u7ed3\u679c 0\u901a\u8fc7 1\u9a73\u56de]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getFinished())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u5ba1\u6279\u662f\u5426\u7ed3\u675f]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOldTaskInstId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u65e7\u4efb\u52a1\u5b9e\u4f8bid]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isNotEmpty((Object)reqBo.getTaskBoList())) {
            for (UocApproveMoveServiceReqTaskBo uocApproveMoveServiceReqTaskBo : reqBo.getTaskBoList()) {
                this.validateTask(uocApproveMoveServiceReqTaskBo);
            }
        }
    }

    private void validateTask(UocApproveMoveServiceReqTaskBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocApproveMoveServiceReqTaskBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getTaskInstId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u65b0\u4efb\u52a1\u5b9e\u4f8bid]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

