/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.collection.CollectionUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderItemObjQryBo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderMap;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.domainservice.UocNumChngOrderCreateService;
import com.tydic.dyc.oc.service.domainservice.bo.UocNumChngOrderCreateReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocNumChngOrderCreateReqShipBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocNumChngOrderCreateReqShipItemBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocNumChngOrderCreateRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.domainservice.UocNumChngOrderCreateService"})
public class UocNumChngOrderCreateServiceImpl
implements UocNumChngOrderCreateService {
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @PostMapping(value={"createNumChng"})
    public UocNumChngOrderCreateRspBo createNumChng(@RequestBody UocNumChngOrderCreateReqBo reqBo) {
        this.validateArg(reqBo);
        String operId = reqBo.getUserId().toString();
        Date now = new Date();
        List<UocShipOrderItem> shipOrderItemList = this.getShipOrderItemList(reqBo);
        this.checkChngingCount(reqBo, shipOrderItemList);
        List<UocSaleOrderItem> saleOrderItems = this.getImplOrderItemList(shipOrderItemList);
        UocChngOrderDo uocChngOrderDo = this.convertChngOrderDo(reqBo, operId, now, shipOrderItemList, saleOrderItems);
        this.iUocChngOrderModel.createChngOrder(uocChngOrderDo);
        for (UocNumChngOrderCreateReqShipBo uocNumChngOrderCreateReqShipBo : reqBo.getChngItemList()) {
            this.iUocShipOrderModel.modifyShipOrderItemChngingCount(this.convertShipOrderDo(reqBo, uocNumChngOrderCreateReqShipBo, operId, now));
            this.iUocSaleOrderModel.modifyBatchItemChngingCount(this.convertImplOrderDo(reqBo, uocNumChngOrderCreateReqShipBo, shipOrderItemList, operId, now));
        }
        UocNumChngOrderCreateRspBo uocNumChngOrderCreateRspBo = UocRu.success(UocNumChngOrderCreateRspBo.class);
        uocNumChngOrderCreateRspBo.setChngOrderId(uocChngOrderDo.getChngOrderId());
        uocNumChngOrderCreateRspBo.setShipOrderIdList(reqBo.getChngItemList().stream().map(UocNumChngOrderCreateReqShipBo::getShipOrderId).collect(Collectors.toList()));
        return uocNumChngOrderCreateRspBo;
    }

    private void checkChngingCount(UocNumChngOrderCreateReqBo reqBo, List<UocShipOrderItem> shipOrderItemList) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        Map<Long, UocSaleOrderItem> uocSaleOrderItemMap = saleOrderItemList.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));
        Map<Long, UocShipOrderItem> uocShipOrderItemMap = shipOrderItemList.stream().collect(Collectors.toMap(UocShipOrderItem::getShipOrderItemId, o -> o));
        reqBo.getChngItemList().forEach(x -> x.getShipOrderItemList().forEach(y -> {
            UocShipOrderItem uocShipOrderItem;
            UocSaleOrderItem uocSaleOrderItem;
            UocChngOrderItemObjQryBo uocChngOrderItemObjQryBo = new UocChngOrderItemObjQryBo();
            uocChngOrderItemObjQryBo.setShipOrderItemId(y.getShipOrderItemId());
            uocChngOrderItemObjQryBo.setChngType(UocConstant.BUSI_TYPE.NUM);
            List<UocChngOrderItemObj> listChngOrderItemObj = this.iUocChngOrderModel.getListChngOrderItemObj(uocChngOrderItemObjQryBo);
            BigDecimal chngCount = BigDecimal.ZERO;
            if (CollectionUtil.isNotEmpty(listChngOrderItemObj)) {
                chngCount = listChngOrderItemObj.stream().map(UocChngOrderItemObj::getChngNum).reduce((x1, x2) -> x1.add((BigDecimal)x2)).get();
            }
            if ((uocSaleOrderItem = (UocSaleOrderItem)uocSaleOrderItemMap.get((uocShipOrderItem = (UocShipOrderItem)uocShipOrderItemMap.get(y.getShipOrderItemId())).getSaleOrderItemId())).getChngingCount().compareTo(BigDecimal.ZERO) > 0) {
                throw new BaseBusinessException("101006", "\u5b58\u5728\u5f02\u5e38\u53d8\u66f4\u5728\u9014\u6570\u91cf\uff0c\u8bf7\u5f85\u53d8\u66f4\u5b8c\u7ed3\u540e\u518d\u53d1\u8d77");
            }
            if (uocSaleOrderItem.getReturnCount().compareTo(BigDecimal.ZERO) == 0) {
                if (y.getChngCount().compareTo(BigDecimal.ZERO) < 0 || y.getChngCount().compareTo(uocSaleOrderItem.getAcceptanceCount()) > 0) {
                    throw new BaseBusinessException("101008", "\u53d8\u66f4\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\u9a8c\u6536\u6570\u91cf\uff0c\u8bf7\u91cd\u65b0\u586b\u5199");
                }
            } else if (y.getChngCount().compareTo(uocSaleOrderItem.getReturnCount().negate()) <= 0 || y.getChngCount().compareTo(uocSaleOrderItem.getAcceptanceCount().subtract(chngCount)) >= 0) {
                throw new BaseBusinessException("101008", "\u53d8\u66f4\u6570\u91cf\u4e0d\u80fd\u5c11\u4e8e\u9000\u8d27\u6570\u91cf\u5e76\u4e14\u4e0d\u80fd\u8d85\u8fc7\u9a8c\u6536\u6570\u91cf\uff0c\u8bf7\u91cd\u65b0\u586b\u5199");
            }
        }));
    }

    private UocSaleOrderDo convertImplOrderDo(UocNumChngOrderCreateReqBo reqBo, UocNumChngOrderCreateReqShipBo uocNumChngOrderCreateReqShipBo, List<UocShipOrderItem> shipOrderItemList, String operId, Date now) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo.setUpdateTime(now);
        uocSaleOrderDo.setUpdateOperId(operId);
        Map<Long, UocShipOrderItem> uocShipOrderItemMap = shipOrderItemList.stream().collect(Collectors.toMap(UocShipOrderItem::getShipOrderItemId, o -> o));
        HashMap uocImplOrderItemMap = new HashMap();
        uocNumChngOrderCreateReqShipBo.getShipOrderItemList().forEach(x -> {
            UocShipOrderItem uocShipOrderItem = (UocShipOrderItem)uocShipOrderItemMap.get(x.getShipOrderItemId());
            UocSaleOrderItem uocSaleOrderItem = (UocSaleOrderItem)uocImplOrderItemMap.get(uocShipOrderItem.getSaleOrderItemId());
            if (null == uocSaleOrderItem) {
                uocSaleOrderItem = new UocSaleOrderItem();
                uocSaleOrderItem.setSaleOrderItemId(uocShipOrderItem.getSaleOrderItemId());
                uocSaleOrderItem.setChngingCount(x.getChngCount());
            } else {
                uocSaleOrderItem.setChngingCount(uocSaleOrderItem.getChngingCount().add(x.getChngCount()));
            }
            uocImplOrderItemMap.put(uocShipOrderItem.getSaleOrderItemId(), uocSaleOrderItem);
        });
        uocSaleOrderDo.setSaleOrderItems(new ArrayList<UocSaleOrderItem>(uocImplOrderItemMap.values()));
        return uocSaleOrderDo;
    }

    private UocShipOrderDo convertShipOrderDo(UocNumChngOrderCreateReqBo reqBo, UocNumChngOrderCreateReqShipBo uocNumChngOrderCreateReqShipBo, String operId, Date now) {
        UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
        uocShipOrderDo.setOrderId(reqBo.getOrderId());
        uocShipOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocShipOrderDo.setShipOrderId(uocNumChngOrderCreateReqShipBo.getShipOrderId());
        uocShipOrderDo.setUpdateOperId(operId);
        uocShipOrderDo.setUpdateTime(now);
        ArrayList<UocShipOrderItem> uocShipOrderItemList = new ArrayList<UocShipOrderItem>();
        uocNumChngOrderCreateReqShipBo.getShipOrderItemList().forEach(x -> {
            UocShipOrderItem uocShipOrderItem = new UocShipOrderItem();
            uocShipOrderItem.setShipOrderItemId(x.getShipOrderItemId());
            uocShipOrderItem.setChngingCount(x.getChngCount());
            uocShipOrderItemList.add(uocShipOrderItem);
        });
        uocShipOrderDo.setShipOrderItemBoList(uocShipOrderItemList);
        return uocShipOrderDo;
    }

    private UocChngOrderDo convertChngOrderDo(UocNumChngOrderCreateReqBo reqBo, String operId, Date now, List<UocShipOrderItem> shipOrderItemList, List<UocSaleOrderItem> saleOrderItems) {
        Map<Long, UocShipOrderItem> shipOrderItemMap = shipOrderItemList.stream().collect(Collectors.toMap(UocShipOrderItem::getShipOrderItemId, o -> o));
        Map<Long, UocSaleOrderItem> implOrderItemMap = saleOrderItems.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));
        UocChngOrderDo uocChngOrderDo = new UocChngOrderDo();
        uocChngOrderDo.setChngOrderId(IdUtil.nextId());
        uocChngOrderDo.setChngOrderState("CHNG_CHNG_QRZ");
        uocChngOrderDo.setCreateOperId(operId);
        uocChngOrderDo.setTenantId(reqBo.getTenantId());
        uocChngOrderDo.setCreateTime(now);
        uocChngOrderDo.setCreateOperName(reqBo.getName());
        uocChngOrderDo.setCreateOperMobile(reqBo.getCellphone());
        uocChngOrderDo.setOrderId(reqBo.getOrderId());
        uocChngOrderDo.setBusiType(UocConstant.BUSI_TYPE.NUM);
        uocChngOrderDo.setRemark(reqBo.getRemark());
        uocChngOrderDo.setChngOrderNo(this.getChngOrderNo(reqBo));
        ArrayList<UocChngOrderObj> uocChngOrderObjList = new ArrayList<UocChngOrderObj>();
        for (UocNumChngOrderCreateReqShipBo uocNumChngOrderCreateReqShipBo : reqBo.getChngItemList()) {
            UocChngOrderObj uocChngOrderObj = new UocChngOrderObj();
            uocChngOrderObj.setChngOrderId(uocChngOrderDo.getChngOrderId());
            uocChngOrderObj.setOrderId(reqBo.getOrderId());
            uocChngOrderObj.setSaleOrderId(reqBo.getSaleOrderId());
            uocChngOrderObj.setShipOrderId(uocNumChngOrderCreateReqShipBo.getShipOrderId());
            uocChngOrderObj.setChngOrderObjId(IdUtil.nextId());
            uocChngOrderObj.setChngType(UocConstant.BUSI_TYPE.NUM);
            uocChngOrderObj.setCreateOperId(operId);
            uocChngOrderObj.setCreateTime(now);
            ArrayList<UocChngOrderItemObj> uocChngOrderItemObjList = new ArrayList<UocChngOrderItemObj>();
            uocChngOrderObj.setChngNum(BigDecimal.ZERO);
            uocChngOrderObj.setChngFee(BigDecimal.ZERO);
            uocNumChngOrderCreateReqShipBo.getShipOrderItemList().forEach(x -> {
                UocShipOrderItem uocShipOrderItem = (UocShipOrderItem)shipOrderItemMap.get(x.getShipOrderItemId());
                UocSaleOrderItem saleOrderItem = (UocSaleOrderItem)implOrderItemMap.get(uocShipOrderItem.getSaleOrderItemId());
                UocChngOrderItemObj uocChngOrderItemObj = new UocChngOrderItemObj();
                uocChngOrderItemObj.setChngNum(x.getChngCount());
                uocChngOrderItemObj.setChngFee(x.getChngCount().multiply(saleOrderItem.getSalePrice()));
                uocChngOrderItemObj.setChngOrderId(uocChngOrderObj.getChngOrderId());
                uocChngOrderItemObj.setChngOrderObjId(uocChngOrderObj.getChngOrderObjId());
                uocChngOrderItemObj.setShipOrderItemId(x.getShipOrderItemId());
                uocChngOrderItemObj.setImplOrderItemId(uocShipOrderItem.getImplOrderItemId());
                uocChngOrderItemObj.setSaleOrderItemId(uocShipOrderItem.getSaleOrderItemId());
                uocChngOrderItemObj.setChngType(UocConstant.BUSI_TYPE.NUM);
                uocChngOrderItemObj.setOrderId(reqBo.getOrderId());
                uocChngOrderItemObj.setId(IdUtil.nextId());
                uocChngOrderItemObj.setCreateOperId(operId);
                uocChngOrderItemObj.setCreateTime(now);
                uocChngOrderItemObjList.add(uocChngOrderItemObj);
                uocChngOrderObj.setChngNum(uocChngOrderObj.getChngNum().add(x.getChngCount()));
                uocChngOrderObj.setChngFee(uocChngOrderObj.getChngNum().multiply(saleOrderItem.getSalePrice()));
            });
            uocChngOrderObj.setUocChngOrderItemObjList(uocChngOrderItemObjList);
            uocChngOrderObjList.add(uocChngOrderObj);
        }
        uocChngOrderDo.setUocChngOrderObjList(uocChngOrderObjList);
        if (!CollectionUtils.isEmpty((Collection)reqBo.getExtParallelBoList())) {
            List<UocChngOrderMap> uocChngOrderMapList = UocRu.jsl(reqBo.getExtParallelBoList(), UocChngOrderMap.class);
            uocChngOrderMapList.forEach(uocChngOrderMap -> {
                uocChngOrderMap.setChngOrderId(uocChngOrderDo.getChngOrderId());
                uocChngOrderMap.setOrderId(uocChngOrderDo.getOrderId());
                uocChngOrderMap.setCreateOperId(operId);
                uocChngOrderMap.setCreateTime(now);
                uocChngOrderMap.setId(IdUtil.nextId());
            });
            uocChngOrderDo.setUocChngOrderMapList(uocChngOrderMapList);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getOrderAccessoryBoList())) {
            List<UocOrderAccessory> uocOrderAccessoryList = UocRu.jsl(reqBo.getOrderAccessoryBoList(), UocOrderAccessory.class);
            uocOrderAccessoryList.forEach(uocOrderAccessory -> {
                uocOrderAccessory.setOrderId(reqBo.getOrderId());
                uocOrderAccessory.setCreateTime(now);
                uocOrderAccessory.setCreateOperId(reqBo.getUserId().toString());
                uocOrderAccessory.setId(IdUtil.nextId());
                uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.CHNG);
                uocOrderAccessory.setObjId(uocChngOrderDo.getChngOrderId());
            });
            uocChngOrderDo.setOrderAccessoryBoList(uocOrderAccessoryList);
        }
        return uocChngOrderDo;
    }

    private String getChngOrderNo(UocNumChngOrderCreateReqBo reqBo) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo = this.iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException("101002", "\u67e5\u8be2\u9a8c\u6536\u5355\u4e3a\u7a7a");
        }
        UocChngOrderQryBo uocChngOrderQryBo = new UocChngOrderQryBo();
        uocChngOrderQryBo.setBusiType(UocConstant.BUSI_TYPE.NUM);
        uocChngOrderQryBo.setOrderSource(uocSaleOrderDo.getOrderSource());
        UocChngOrderDo uocChngOrderDo = this.iUocChngOrderModel.getChngOrderNo(uocChngOrderQryBo);
        return uocChngOrderDo.getChngOrderNo();
    }

    private List<UocShipOrderItem> getShipOrderItemList(UocNumChngOrderCreateReqBo reqBo) {
        ArrayList<UocShipOrderItem> shipOrderItems = new ArrayList<UocShipOrderItem>();
        for (UocNumChngOrderCreateReqShipBo uocNumChngOrderCreateReqShipBo : reqBo.getChngItemList()) {
            UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
            uocShipOrderItemQryBo.setShipOrderItemIdList(uocNumChngOrderCreateReqShipBo.getShipOrderItemList().stream().map(UocNumChngOrderCreateReqShipItemBo::getShipOrderItemId).collect(Collectors.toList()));
            uocShipOrderItemQryBo.setOrderId(reqBo.getOrderId());
            uocShipOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
            uocShipOrderItemQryBo.setShipOrderId(uocNumChngOrderCreateReqShipBo.getShipOrderId());
            UocShipOrderDo uocShipOrderDo = this.iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
            if (CollectionUtils.isEmpty(uocShipOrderDo.getShipOrderItemBoList())) {
                throw new BaseBusinessException("101006", "\u67e5\u8be2\u53d1\u8d27\u5355\u660e\u7ec6\u5217\u8868\u4e3a\u7a7a");
            }
            shipOrderItems.addAll(uocShipOrderDo.getShipOrderItemBoList());
        }
        return shipOrderItems;
    }

    private List<UocSaleOrderItem> getImplOrderItemList(List<UocShipOrderItem> uocShipOrderItemList) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(uocShipOrderItemList.get(0).getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderItemIdList(uocShipOrderItemList.stream().map(UocShipOrderItem::getSaleOrderItemId).distinct().collect(Collectors.toList()));
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        if (CollectionUtils.isEmpty(saleOrderItemList)) {
            throw new BaseBusinessException("101006", "\u67e5\u8be2\u9500\u552e\u5355\u660e\u7ec6\u5217\u8868\u4e3a\u7a7a");
        }
        return saleOrderItemList;
    }

    private void validateArg(UocNumChngOrderCreateReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e3a\u7a7a");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u9500\u552e\u5355ID\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getChngItemList())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u53d8\u66f4\u4fe1\u606f\u5217\u8868\u4e3a\u7a7a");
        }
        reqBo.getChngItemList().forEach(uocNumChngOrderCreateReqItemBo -> {
            if (null == uocNumChngOrderCreateReqItemBo.getShipOrderId()) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u53d1\u8d27\u5355ID\u4e3a\u7a7a");
            }
            if (null == uocNumChngOrderCreateReqItemBo.getShipOrderItemList()) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u53d1\u8d27\u5bf9\u8c61\u4e3a\u7a7a");
            }
            uocNumChngOrderCreateReqItemBo.getShipOrderItemList().forEach(x -> {
                if (null == x.getShipOrderItemId()) {
                    throw new BaseBusinessException("100001", "\u5165\u53c2\u53d1\u8d27\u5355\u660e\u7ec6ID\u4e3a\u7a7a");
                }
                if (null == x.getChngCount()) {
                    throw new BaseBusinessException("100001", "\u5165\u53c2\u53d8\u66f4\u6570\u91cf\u4e3a\u7a7a");
                }
            });
        });
    }
}

