package com.tydic.dyc.oc.components.event.impl;

import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.event.EventConsumer;
import com.tydic.dyc.oc.components.event.IUocEsSyncQryEventReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocEventConstant;
import com.tydic.dyc.oc.utils.UocRu;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;


/**
 * 标题:EventConsumerCommonSyncSale
 * 说明:解释销售单通用
 * 时间:2022/3/10 20:10
 * 作者:罗有
 */
@Component
public class EventConsumerCommonSyncSale implements EventConsumer {
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public List<IUocEsSyncQryEventReqBo> parseMap(Map<String, Object> map) {
        List<IUocEsSyncQryEventReqBo> retList = new ArrayList<>();
        Long orderId = UocRu.parseLong(map.get("orderId"));
        Long saleOrderId = UocRu.parseLong(map.get("saleOrderId"));
        IUocEsSyncQryReqBo syncQryReqBo = new IUocEsSyncQryReqBo();
        syncQryReqBo.setOrderId(orderId);
        syncQryReqBo.setObjId(saleOrderId);
        List<IUocEsSyncQryReqBo> saleList = new ArrayList<>();
        saleList.add(syncQryReqBo);
        IUocEsSyncQryEventReqBo eventReqBo = new IUocEsSyncQryEventReqBo();
        eventReqBo.setIndexName(uocIndexConfig.getSaleOrderIndex());
        eventReqBo.setDataList(saleList);
        retList.add(eventReqBo);
        return retList;
    }

    @Override
    public String getEvent() {
        return UocEventConstant.UOCE_ES_SYNC_SALE_ORDER;
    }
}


