package com.tydic.dyc.oc.service.order;

import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocConfEffectiveQryBo;
import com.tydic.dyc.oc.model.order.sub.UocConfEffective;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.model.sysdictionary.UocSysDictionaryDo;
import com.tydic.dyc.oc.service.order.bo.UocProOrderEffectiveInfoBo;
import com.tydic.dyc.oc.service.order.bo.UocProOrderEffectiveListPageQueryReqBo;
import com.tydic.dyc.oc.service.order.bo.UocProOrderEffectiveListPageQueryRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.*;

/**
 * 标题：UocProOrderEffectiveListPageQueryAbilityServiceImpl
 * 说明：订单时效类配置列表分页查询API 实现类
 * 时间：2021/4/2 14:44
 * 作者 何秀全
 */
@HTServiceImpl
public class UocProOrderEffectivePageQueryServiceImpl implements UocProOrderEffectivePageQueryService {

    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

    @Override
    public UocProOrderEffectiveListPageQueryRspBo queryOrderEffectiveListPage(UocProOrderEffectiveListPageQueryReqBo reqBo) {
        UocProOrderEffectiveListPageQueryRspBo rspBo = UocRu.success(UocProOrderEffectiveListPageQueryRspBo.class);
        rspBo.setPageNo(reqBo.getPageNo());
        UocConfEffectiveQryBo effectivePOWhere = new UocConfEffectiveQryBo();
        Map<String, String> effectiveNameMap = null;
        if (null != reqBo.getEffectiveId() && 0L != reqBo.getEffectiveId()) {
            effectivePOWhere.setEffectiveId(reqBo.getEffectiveId());
        } else {
            if (StringUtils.hasText(reqBo.getEffectiveName())) {
                List<UocSysDictionaryDo> effectiveCodes = getEffectiveCodeListByEffectiveName();
                if (CollectionUtils.isEmpty(effectiveCodes)) {
                    rspBo.setTotal(0);
                    rspBo.setRecordsTotal(0);
                    rspBo.setRows(new ArrayList<>(0));
                    return rspBo;
                }
                effectiveNameMap = new HashMap<>(effectiveCodes.size());
                List<String> effectiveCodeList = new ArrayList<>();
                for (UocSysDictionaryDo dicDictionaryBO : effectiveCodes) {
                    if (null != dicDictionaryBO.getDescrip() && dicDictionaryBO.getDescrip().contains(reqBo.getEffectiveName())) {
                        effectiveCodeList.add(dicDictionaryBO.getCode());
                        effectiveNameMap.put(dicDictionaryBO.getCode(), dicDictionaryBO.getDescrip());
                    }
                }
                if (CollectionUtils.isEmpty(effectiveCodeList)) {
                    rspBo.setTotal(0);
                    rspBo.setRecordsTotal(0);
                    rspBo.setRows(new ArrayList<>(0));
                    return rspBo;
                }
                effectivePOWhere.setEffectiveCodeList(effectiveCodeList);
            }
            effectivePOWhere.setBusinessTypeCode(reqBo.getBusinessTypeCode());
            effectivePOWhere.setSupplierNo(reqBo.getSupplierNo());
            effectivePOWhere.setSourceCode(reqBo.getSourceCode());
            effectivePOWhere.setOperatingTimeStart(DateUtils.strToDateLong(reqBo.getOperatingTimeStart()));
            effectivePOWhere.setOperatingTimeEnd(DateUtils.strToDateLong(reqBo.getOperatingTimeEnd()));
            effectivePOWhere.setOperatorName(reqBo.getOperatorName());
        }
        effectivePOWhere.setOrderBy("effective_code, source_code,case business_type_code when '2' then 1 when '1' then 2 else 3 end");
        effectivePOWhere.setPageNo(reqBo.getPageNo());
        effectivePOWhere.setPageSize(reqBo.getPageSize());

//        Page<ConfEffectivePO> confEffectivePOPage = new Page<>();
//        confEffectivePOPage.setPageNo(reqBo.getPageNo());
//        confEffectivePOPage.setPageSize(reqBo.getPageSize());
//        List<ConfEffectivePO> effectivePOList = confEffectiveMapper.getListPage(effectivePOWhere, confEffectivePOPage);
        BasePageRspBo<UocConfEffective> uocConfEffectiveBasePageRspBo = iUocOrderModel.qryListPageConfEffective(effectivePOWhere);
        if (CollectionUtils.isEmpty(uocConfEffectiveBasePageRspBo.getRows())) {
            rspBo.setTotal(0);
            rspBo.setRecordsTotal(0);
            rspBo.setRows(new ArrayList<>(0));
        } else {
            rspBo.setTotal(uocConfEffectiveBasePageRspBo.getTotal());
            rspBo.setRecordsTotal(uocConfEffectiveBasePageRspBo.getRecordsTotal());
            List<UocProOrderEffectiveInfoBo> rows = new ArrayList<>(uocConfEffectiveBasePageRspBo.getRows().size());
            UocProOrderEffectiveInfoBo orderEffectiveInfoBo;
            Map<String, Map<String, String>> dicValName = getDicValName(effectiveNameMap);
            effectiveNameMap = dicValName.get(UocConstant.EFFECTIVE_CODE);
            Map<String, String> businessTypeMap = dicValName.get(UocDicConstant.ORDER_SOURCE.P_CODE);
            Map<String, String> sourceNameMap = dicValName.get(UocConstant.SOURCE_CODE);
            for (UocConfEffective effectivePO : uocConfEffectiveBasePageRspBo.getRows()) {
                orderEffectiveInfoBo = new UocProOrderEffectiveInfoBo();
                orderEffectiveInfoBo.setEffectiveId(effectivePO.getEffectiveId());
                orderEffectiveInfoBo.setEffectiveCode(effectivePO.getEffectiveCode());
                orderEffectiveInfoBo.setBusinessTypeCode(effectivePO.getBusinessTypeCode());
                orderEffectiveInfoBo.setSupplierNo(effectivePO.getSupplierNo());
                orderEffectiveInfoBo.setSupplierName(effectivePO.getSupplierName());
                orderEffectiveInfoBo.setAging(effectivePO.getAging());
                orderEffectiveInfoBo.setSourceCode(effectivePO.getSourceCode());
                orderEffectiveInfoBo.setOperatingTime(effectivePO.getOperatingTime());
                orderEffectiveInfoBo.setOperatorId(effectivePO.getOperatorId());
                orderEffectiveInfoBo.setOperatorName(effectivePO.getOperatorName());
                if (null != effectiveNameMap) {
                    orderEffectiveInfoBo.setEffectiveName(effectiveNameMap.get(effectivePO.getEffectiveCode()));
                }
                if (null != businessTypeMap) {
                    orderEffectiveInfoBo.setBusinessTypeName(businessTypeMap.get(effectivePO.getBusinessTypeCode()));
                }
                if (null != sourceNameMap) {
                    orderEffectiveInfoBo.setSourceName(sourceNameMap.get(effectivePO.getSourceCode()));
                }
                rows.add(orderEffectiveInfoBo);
            }
            rspBo.setRows(rows);
        }
        return rspBo;
    }
    /**
     * 根据配置名称获取 配置编码
     *
     * @return 配置编码
     */
    private List<UocSysDictionaryDo>  getEffectiveCodeListByEffectiveName() {
        return iUocSysDictionaryModel.qryDicListByPCodes(Collections.singletonList(UocConstant.EFFECTIVE_CODE));
    }

    /**
     * 获取字典名称
     *
     * @param effectiveNameMap 配置名称map
     * @return 所有字典名称信息
     */
    private Map<String, Map<String, String>> getDicValName(Map<String, String> effectiveNameMap) {
        List<String> pCodes = new ArrayList<>();
        if (null == effectiveNameMap) {
            pCodes.add(UocConstant.EFFECTIVE_CODE);
        }
        pCodes.add(UocDicConstant.ORDER_SOURCE.P_CODE);
        pCodes.add(UocConstant.SOURCE_CODE);
        return iUocSysDictionaryModel.getDictionaryMap(pCodes);
    }
}
