package com.tydic.dyc.oc.service.order;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderQueryIndexQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderStakeholderQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex;
import com.tydic.dyc.oc.service.order.bo.UocQryOutOrderIndexBo;
import com.tydic.dyc.oc.service.order.bo.UocQryOutOrderIndexServiceReqBo;
import com.tydic.dyc.oc.service.order.bo.UocQryOutOrderIndexServiceRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/*
 * @Author lsl
 * @Description //TODO 查询外部与内部订单关联信息接口实现
 * @Date 17:10 2022/4/8
 * @Param
 * @return
 */
@Slf4j
@HTServiceImpl
public class UocQryOutOrderIndexServiceImpl implements UocQryOutOrderIndexService {
    
    @Autowired
    private IUocOrderModel iUocOrderModel;
    
    @Override
    public UocQryOutOrderIndexServiceRspBo qryOutOrderIndex(UocQryOutOrderIndexServiceReqBo reqBo) {
        UocQryOutOrderIndexServiceRspBo rspBo = new UocQryOutOrderIndexServiceRspBo();
        List<UocQryOutOrderIndexBo> uocQryOutOrderIndexBoList = new ArrayList<>();
        UocOrderQueryIndexQryBo uocOrderQueryIndexQryBo = new UocOrderQueryIndexQryBo();
        uocOrderQueryIndexQryBo.setOutObjId(reqBo.getOutOrderNo());//外部订单号
        uocOrderQueryIndexQryBo.setOrderId(reqBo.getOrderId());
        List<UocOrderQueryIndex> uocOrderQueryIndexList = iUocOrderModel.qryOrderQueryIndexList(uocOrderQueryIndexQryBo);
        if (ObjectUtil.isNotEmpty(uocOrderQueryIndexList)) {
            for (UocOrderQueryIndex item : uocOrderQueryIndexList) {
                uocQryOutOrderIndexBoList.add(UocRu.js(item, UocQryOutOrderIndexBo.class));
            }
        }
        UocOrderStakeholderQryBo qryBo = new UocOrderStakeholderQryBo();
        qryBo.setOrderId(reqBo.getOrderId());
        List<UocOrderStakeholderQryBo> qryBoList = iUocOrderModel.qryStakeholderList(qryBo);
        if(ObjectUtil.isNotEmpty(qryBoList)){
            rspBo.setSupplierNo(qryBoList.get(0).getSupId());
        }
        rspBo.setQryOutOrderIndexBoList(uocQryOutOrderIndexBoList);
        return rspBo;
    }
}
