package com.tydic.dyc.oc.components.event.impl;

import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.event.EventConsumer;
import com.tydic.dyc.oc.components.event.IUocEsSyncQryEventReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocEventConstant;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 标题：类名称:EventConsumerSyncAfterOrder
 * 说明：描述一下类的作用TODO
 * 时间：2022/4/18 16:20
 * 作者 @author 尹栋梁
 */
@Slf4j
@Component
public class EventConsumerSyncAfterOrder implements EventConsumer {
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public List<IUocEsSyncQryEventReqBo> parseMap(Map<String, Object> map) {
        List<IUocEsSyncQryEventReqBo> retList = new ArrayList<>();
        Long afOrderId = UocRu.parseLong(map.get("afOrderId"));
        Long orderId = UocRu.parseLong(map.get("orderId"));
        List<IUocEsSyncQryReqBo> afOrderList = new ArrayList<>();
        IUocEsSyncQryReqBo afOrder = new IUocEsSyncQryReqBo();
        afOrder.setOrderId(orderId);
        afOrder.setObjId(afOrderId);
        afOrderList.add(afOrder);
        IUocEsSyncQryEventReqBo saleEventReqBo = new IUocEsSyncQryEventReqBo();
        saleEventReqBo.setIndexName(uocIndexConfig.getAfOrderIndex());
        saleEventReqBo.setDataList(afOrderList);
        retList.add(saleEventReqBo);
        return retList;
    }

    @Override
    public String getEvent() {
        return UocEventConstant.UOCE_ORDER_AFTER_SYNC;
    }
}
