package com.tydic.dyc.oc.components.event.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.event.EventConsumer;
import com.tydic.dyc.oc.components.event.IUocEsSyncQryEventReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocEventConstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 标题：EventConsumerSyncTransaction
 * 说明：成交服务费同步
 * 时间：2022/4/6 19:30
 *
 * @author 文乐
 */
@Component
public class EventConsumerSyncSaleTransaction implements EventConsumer {
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public List<IUocEsSyncQryEventReqBo> parseMap(Map<String, Object> map) {
        List<IUocEsSyncQryEventReqBo> retList = new ArrayList<>();
        Long orderId = Long.valueOf((String) map.get("orderId"));
        JSONObject supSignInfo = (JSONObject) map.get("jsonObj");
        if (ObjectUtil.isNotEmpty(orderId)) {
            Object saleOrderListObj = map.get("saleOrderList");
            if (ObjectUtil.isNotEmpty(saleOrderListObj)) {
                JSONArray saleOrderList = JSON.parseArray(JSON.toJSONString(saleOrderListObj));
                List<IUocEsSyncQryReqBo> saleList = new ArrayList<>();
                if(ObjectUtil.isNotEmpty(saleOrderList)){
                    for (int i = 0; i < saleOrderList.size(); i++) {
                        JSONObject arrayJson = saleOrderList.getJSONObject(i);
                        Long saleOrderId = arrayJson.getLong("saleOrderId");
                        Long supId = arrayJson.getLong("supId");
                        if (saleOrderId != null) {
                            IUocEsSyncQryReqBo syncQryReqBo = new IUocEsSyncQryReqBo();
                            syncQryReqBo.setOrderId(orderId);
                            syncQryReqBo.setObjId(saleOrderId);
                            syncQryReqBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
                            syncQryReqBo.setJsonObj(supSignInfo.getJSONObject(supId.toString()));
                            saleList.add(syncQryReqBo);
                        }
                    }
                }
                if (ObjectUtil.isNotEmpty(saleList)) {
                    IUocEsSyncQryEventReqBo eventReqBo = new IUocEsSyncQryEventReqBo();
                    eventReqBo.setIndexName(uocIndexConfig.getTransactionIndex());
                    eventReqBo.setDataList(saleList);
                    retList.add(eventReqBo);
                }

            }
        }
        return retList;
    }

    @Override
    public String getEvent() {
        return UocEventConstant.UOC_SALE_TRANSACTION_SYNC;
    }
}
