package com.tydic.dyc.oc.repository;

import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;

import java.util.List;

/**
 * 标题:UocShipOrderRepository
 * 说明:发货单
 * 时间:2022-02-21 14:31
 * 作者:罗有
 **/
public interface UocShipOrderRepository {
	/**
	 * 创建发货单
	 * @param uocShipOrderDo
	 */
	void createShipOrder(UocShipOrderDo uocShipOrderDo);

	/**
	 * 记录到货/拒收信息
	 * @param uocShipOrderDo
	 */
	void modifyBatchShipOrderArrivaRefuse(UocShipOrderDo uocShipOrderDo);

	/**
	 * 记录到货明细
	 * @param uocShipOrderDo
	 */
	void modifyArrivaShipOrderItem(UocShipOrderDo uocShipOrderDo);

	/**
	 * 记录拒收明细
	 * @param uocShipOrderDo
	 */
	void modifyRefuseShipOrderItem(UocShipOrderDo uocShipOrderDo);

	/**
	 * 查询发货明细
	 * @param uocShipOrderItemQryBo
	 * @return
	 */
	UocShipOrderDo getListShipOrderItem(UocShipOrderItemQryBo uocShipOrderItemQryBo);

	/**
	 * 变更发货单主体信息
	 * @param uocShipOrderDo
	 */
	void modifyShipOrderMain(UocShipOrderDo uocShipOrderDo);

	/**
	 * 更新发货明细的验收信息
	 *
	 * @param uocShipOrderDo
	 */
	void modifyBatchShipOrderItemInspCount(UocShipOrderDo uocShipOrderDo);

	/**
	 * 根据ID查询发货单信息
	 *
	 * @return
	 */
	UocShipOrderDo getShipOrderById(UocShipOrderQryBo uocShipOrderQryBo);

	/**
	 * 查询发货单列表
	 */
	List<UocShipOrderDo> getListShipOrder(UocShipOrderQryBo uocShipOrderQryBo);

	/**
	 * 获取发货单编码
	 *
	 * @param uocShipOrderDo
	 * @return
	 */
	UocShipOrderDo getShipOrderNo(UocShipOrderDo uocShipOrderDo);

	/**
	 * 更新异常变更在途数量
	 *
	 * @param uocShipOrderDo
	 */
	void modifyShipOrderItemChngingCount(UocShipOrderDo uocShipOrderDo);

	/**
	 * 更新发货明细退货数量 变更确认
	 */
	void modifyItemReturnCountConfirm(UocShipOrderDo uocShipOrderDo);

	/**
	 * 更新异常变更在途数量为空 变更拒绝
	 *
	 * @param uocShipOrderDo
	 */
	void modifyItemChngCountRefuse(UocShipOrderDo uocShipOrderDo);

	/**
	 * 更新发货单状态 和环节编码
	 *
	 * @param uocShipOrderDo
	 */
	void updateShipStatusAndProCode(UocShipOrderDo uocShipOrderDo);

	/**
	 * 增加扩展字段
	 *
	 * @param uocShipOrderDo
	 */
	void addShipOrderMap(UocShipOrderDo uocShipOrderDo);

	/**
	 * 更新扩展字段
	 *
	 * @param uocShipOrderDo
	 */
	void updateBatchValue(UocShipOrderDo uocShipOrderDo);

	/**
	 * 更新扩展字段
	 *
	 * @param uocShipOrderDo
	 */
	void updateInvalid(UocShipOrderDo uocShipOrderDo);

	/**
	 * 更新发货单明细的验收数量=到货数量
	 *
	 * @param uocShipOrderDo
	 */
	void modifyShipOrderItemInspCountEqualArrivalCount(UocShipOrderDo uocShipOrderDo);

	void modifyItemArriveCountConfirm(UocShipOrderDo uocShipOrderDo);

	void modifyItemRefuseCountConfirm(UocShipOrderDo uocShipOrderDo);
	
	void modifyShipArrivtime(UocShipOrderDo uocShipOrderDo);
	
	void modifyItemArriveCount(UocShipOrderDo uocShipOrderDo);
}
