package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderDeleteServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderDeleteServiceRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题:UocSaleOrderDeleteServiceImpl
 * 说明:销售单删除
 * 时间:2022/4/2 10:01
 *
 * @author 童垣杰
 */
@HTServiceImpl
public class UocSaleOrderDeleteServiceImpl implements UocSaleOrderDeleteService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Override
    public UocSaleOrderDeleteServiceRspBo deleteSaleOrder(UocSaleOrderDeleteServiceReqBo reqBo) {
        validateArg(reqBo);
        //查询销售单判断是否为空
        UocSaleOrderQryBo uocSaleOrderQryBo = UocRu.js(reqBo, UocSaleOrderQryBo.class);
        UocSaleOrderDo uocSaleOrderDo = iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_SALE_ORDER_RESP_GET_OBJ_NO_ERROR, "该销售单不存在");
        }

        //更新销售单状态
        UocSaleOrderDo modelReq = UocRu.js(reqBo, UocSaleOrderDo.class);
        iUocSaleOrderModel.deleteSaleOrder(modelReq);

        return UocRu.success(UocSaleOrderDeleteServiceRspBo.class);
    }

    private void validateArg(UocSaleOrderDeleteServiceReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (reqBo.getSaleOrderId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "销售单ID不能为空");
        }
        if (reqBo.getOrderId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "订单ID不能为空");
        }
    }
}
