/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocEvaluateQryBo;
import com.tydic.dyc.oc.model.order.sub.UocEvaluate;
import com.tydic.dyc.oc.service.domainservice.UocEvaluateDealService;
import com.tydic.dyc.oc.service.domainservice.bo.UocEvaluateDealServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocEvaluateDealServiceRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.domainservice.UocEvaluateDealService"})
public class UocEvaluateDealServiceImpl
implements UocEvaluateDealService {
    private static final Logger log = LoggerFactory.getLogger(UocEvaluateDealServiceImpl.class);
    @Autowired
    private IUocOrderModel iUocOrderModel;

    @PostMapping(value={"dealEvaluate"})
    public UocEvaluateDealServiceRspBo dealEvaluate(@RequestBody UocEvaluateDealServiceReqBo reqBo) {
        this.val(reqBo);
        UocEvaluateQryBo uocEvaluateQryBo = new UocEvaluateQryBo();
        uocEvaluateQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        uocEvaluateQryBo.setObjId(reqBo.getSaleOrderId());
        uocEvaluateQryBo.setOrderId(reqBo.getOrderId());
        List<UocEvaluate> uocEvaluates = this.iUocOrderModel.qryOrderEvaluateList(uocEvaluateQryBo);
        if (uocEvaluates.size() > 1) {
            for (UocEvaluate uocEvaluate : uocEvaluates) {
                UocEvaluate uocEva = new UocEvaluate();
                uocEva.setId(uocEvaluate.getId());
                uocEva.setEvaluateState(uocEvaluate.getEvaluateState());
                this.iUocOrderModel.updateOrderEvaluate(uocEva);
            }
            return UocRu.success(UocEvaluateDealServiceRspBo.class);
        }
        UocEvaluate uocEvaluate = new UocEvaluate();
        uocEvaluate.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        uocEvaluate.setId(IdUtil.nextId());
        uocEvaluate.setOrderId(reqBo.getOrderId());
        uocEvaluate.setCreateOperId(reqBo.getUserId().toString());
        uocEvaluate.setEvaluateState(reqBo.getEvaluateState());
        uocEvaluate.setObjId(reqBo.getSaleOrderId());
        this.iUocOrderModel.insertOrderEvaluate(uocEvaluate);
        return UocRu.success(UocEvaluateDealServiceRspBo.class);
    }

    private void val(UocEvaluateDealServiceReqBo reqBo) {
        if (ObjectUtil.isNull((Object)reqBo)) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOrderId() == null) {
            throw new BaseBusinessException("100001", "\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getSaleOrderId() == null) {
            throw new BaseBusinessException("100001", "\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getEvaluateState() == null) {
            throw new BaseBusinessException("100001", "\u8bc4\u4ef7\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

