/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderItemQryBo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderWaybillQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderItem;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderWaybill;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrdLogisticsRelaQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderAccessoryQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderItemQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderItem;
import com.tydic.dyc.oc.model.payorder.IUocPayOrderModel;
import com.tydic.dyc.oc.model.payorder.qrybo.UocPayOrderQryBo;
import com.tydic.dyc.oc.model.payorder.sub.UocPayOrder;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleStakeholderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleStakeholder;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryDetailBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryTypeDetailBo;
import com.tydic.dyc.oc.service.domainservice.UocGetAfOrderDetailService;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfOrderCommodityItemBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfOrderReceiverAddressBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfOrderRefundDetailBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfOrderServiceInfoBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfOrderShipInfoBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocGetAfOrderDetailServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocGetAfOrderDetailServiceRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.domainservice.UocGetAfOrderDetailService"})
public class UocGetAfOrderDetailServiceImpl
implements UocGetAfOrderDetailService {
    private static final Logger log = LoggerFactory.getLogger(UocGetAfOrderDetailServiceImpl.class);
    @Autowired
    private IUocAfOrderModel iUocAfOrderModel;
    @Autowired
    private IUocPayOrderModel iUocPayOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

    @PostMapping(value={"qryAfOrderDetails"})
    public UocGetAfOrderDetailServiceRspBo qryAfOrderDetails(@RequestBody UocGetAfOrderDetailServiceReqBo reqBo) {
        UocGetAfOrderDetailServiceRspBo rspBo = UocRu.success(UocGetAfOrderDetailServiceRspBo.class);
        this.validateParam(reqBo);
        UocAfOrder uocAfOrder = this.getAfOrderMain(reqBo);
        if (ObjectUtil.isNull((Object)uocAfOrder)) {
            return rspBo;
        }
        List<UocSaleStakeholder> stakeHolderList = this.getStakeHolderList(new UocSaleOrderItem(), reqBo, false);
        List<UocAfOrderItem> afOrderItemList = this.getAfOrderItemList(reqBo);
        List<UocAfOrderWaybill> afOrderWayBillList = this.getAfOrderWayBillList(reqBo);
        this.encapServInfo(stakeHolderList, uocAfOrder, rspBo, reqBo);
        this.encapCommodityInfo(afOrderItemList, rspBo, reqBo);
        this.encapRefundInfo(stakeHolderList, uocAfOrder, reqBo, rspBo);
        this.encapShipInfo(rspBo, afOrderWayBillList);
        return rspBo;
    }

    private void encapShipInfo(UocGetAfOrderDetailServiceRspBo rspBo, List<UocAfOrderWaybill> afOrderWayBillList) {
        if (ObjectUtil.isNotEmpty(afOrderWayBillList)) {
            UocAfOrderWaybill waybill = afOrderWayBillList.get(0);
            UocAfOrderShipInfoBo shipInfo = UocRu.js(waybill, UocAfOrderShipInfoBo.class);
            if (null != waybill.getFreight()) {
                try {
                    shipInfo.setFreightMoney(MoneyUtils.Long2BigDecimal((Long)waybill.getFreight()));
                }
                catch (Exception e) {
                    log.error("\u91d1\u989d\u8f6c\u6362\u5f02\u5e38:{}", (Object)e.getMessage());
                }
            }
            rspBo.setShipInfo(shipInfo);
        }
    }

    private List<UocAfOrderWaybill> getAfOrderWayBillList(UocGetAfOrderDetailServiceReqBo reqBo) {
        UocAfOrderWaybillQryBo uocAfOrderWaybillQryBo = new UocAfOrderWaybillQryBo();
        uocAfOrderWaybillQryBo.setAfOrderId(reqBo.getAfOrderId());
        return this.iUocAfOrderModel.getAfOrderWayBillList(uocAfOrderWaybillQryBo);
    }

    private void encapRefundInfo(List<UocSaleStakeholder> stakeHolderList, UocAfOrder uocAfOrder, UocGetAfOrderDetailServiceReqBo reqBo, UocGetAfOrderDetailServiceRspBo rspBo) {
        UocAfOrderRefundDetailBo refundDetailBo = new UocAfOrderRefundDetailBo();
        List<UocPayOrder> listPayOrder = this.getUocPayOrderDoList(reqBo);
        if (ObjectUtil.isNotEmpty(listPayOrder)) {
            refundDetailBo = UocRu.js(listPayOrder.get(0), UocAfOrderRefundDetailBo.class);
        }
        if (ObjectUtil.isNotEmpty(stakeHolderList)) {
            refundDetailBo.setPurAccount(stakeHolderList.get(0).getPurAccount());
            refundDetailBo.setPurAccountName(stakeHolderList.get(0).getPurAccountName());
        }
        refundDetailBo.setRealReturnFee(uocAfOrder.getRealReturnFee());
        refundDetailBo.setPayFee(uocAfOrder.getRetTotalSaleFee());
        this.translateRefundInfo(refundDetailBo);
        rspBo.setRefundInfo(refundDetailBo);
    }

    private void translateRefundInfo(UocAfOrderRefundDetailBo refundDetailBo) {
        if (null != refundDetailBo.getInterType()) {
            refundDetailBo.setInterTypeStr(this.getDic().get("UOC_SALE_ORDER_SOURCE").get(refundDetailBo.getInterType().toString()));
        }
        Optional.ofNullable(refundDetailBo.getPayState()).ifPresent(x -> refundDetailBo.setPayStateStr(this.getDic().get("UOC_SALE_ORDER_PAY_STATE").get(x)));
        if (null != refundDetailBo.getPayType()) {
            refundDetailBo.setPayTypeStr(this.getDic().get("UOC_SALE_ORDER_PAY_TYPE").get(refundDetailBo.getPayType().toString()));
        }
    }

    private List<UocPayOrder> getUocPayOrderDoList(UocGetAfOrderDetailServiceReqBo reqBo) {
        UocPayOrderQryBo uocPayOrderQryBo = new UocPayOrderQryBo();
        uocPayOrderQryBo.setOrderId(reqBo.getOrderId());
        List<UocPayOrder> listPayOrder = this.iUocPayOrderModel.getListPayOrder(uocPayOrderQryBo);
        return listPayOrder;
    }

    private void encapServInfo(List<UocSaleStakeholder> stakeHolderList, UocAfOrder uocAfOrder, UocGetAfOrderDetailServiceRspBo rspBo, UocGetAfOrderDetailServiceReqBo reqBo) {
        UocAfOrderServiceInfoBo servInfoBo = UocRu.js(uocAfOrder, UocAfOrderServiceInfoBo.class);
        if (ObjectUtil.isNotEmpty(stakeHolderList)) {
            UocSaleStakeholder stakeholder = stakeHolderList.get(0);
            servInfoBo.setSupplierId(stakeholder.getSupId());
            servInfoBo.setSupplierName(stakeholder.getSupName());
        }
        this.encapReceiverAddressInfo(uocAfOrder, servInfoBo);
        this.encapAccessoryInfo(reqBo, servInfoBo);
        this.translateServInfo(servInfoBo);
        rspBo.setServInfo(servInfoBo);
    }

    private void translateServInfo(UocAfOrderServiceInfoBo servInfoBo) {
        if (null != servInfoBo.getServType()) {
            servInfoBo.setServTypeStr(this.getDic().get("UOC_ORD_SERVICE_TYPE").get(servInfoBo.getServType().toString()));
        }
        if (null != servInfoBo.getServState()) {
            servInfoBo.setServStateStr(this.getDic().get("UOC_ORD_SERVICE_STATE").get(servInfoBo.getServState().toString()));
        }
        servInfoBo.setPayTypeStr(this.getDic().get("UOC_SALE_ORDER_PAY_TYPE").get(servInfoBo.getPayType()));
        if (null != servInfoBo.getAfsReason()) {
            servInfoBo.setAfsReasonStr(this.getDic().get("AFS_REASON").get(servInfoBo.getAfsReason().toString()));
        }
    }

    private void encapAccessoryInfo(UocGetAfOrderDetailServiceReqBo reqBo, UocAfOrderServiceInfoBo servInfoBo) {
        ArrayList<UocBaseOrderAccessoryTypeDetailBo> accessoryInfo = new ArrayList<UocBaseOrderAccessoryTypeDetailBo>();
        UocOrderAccessoryQryBo qryBo = new UocOrderAccessoryQryBo();
        qryBo.setObjId(reqBo.getAfOrderId());
        qryBo.setObjType(UocDicConstant.OBJ_TYPE.AFTER);
        qryBo.setOrderId(reqBo.getOrderId());
        List<UocOrderAccessory> orderAccessoryList = this.iUocOrderModel.getOrderAccessoryList(qryBo);
        if (ObjectUtil.isNotEmpty(orderAccessoryList)) {
            ConcurrentMap<Integer, List<UocOrderAccessory>> uocOrderAccessoryMap = orderAccessoryList.stream().collect(Collectors.groupingByConcurrent(UocOrderAccessory::getAttachmentType));
            Iterator iterator = uocOrderAccessoryMap.keySet().iterator();
            while (iterator.hasNext()) {
                UocBaseOrderAccessoryTypeDetailBo accessoryTypeDetailBo = new UocBaseOrderAccessoryTypeDetailBo();
                Integer key = (Integer)iterator.next();
                accessoryTypeDetailBo.setAttachmentType(key);
                accessoryTypeDetailBo.setAttchList(UocRu.jsl((List)uocOrderAccessoryMap.get(key), UocBaseOrderAccessoryDetailBo.class));
                accessoryInfo.add(accessoryTypeDetailBo);
            }
        }
        servInfoBo.setAccessoryInfo(accessoryInfo);
    }

    private void encapReceiverAddressInfo(UocAfOrder uocAfOrder, UocAfOrderServiceInfoBo servInfoBo) {
        UocOrdLogisticsRelaQryBo qryBo = new UocOrdLogisticsRelaQryBo();
        qryBo.setOrderId(uocAfOrder.getOrderId());
        qryBo.setContactId(uocAfOrder.getTpContactId());
        UocOrdLogisticsRela uocOrdLogisticsRela = this.iUocOrderModel.qryOrderLogisticsRela(qryBo);
        if (ObjectUtil.isNotNull((Object)uocOrdLogisticsRela)) {
            servInfoBo.setOrderTakeDeliveryInfo(UocRu.js(uocOrdLogisticsRela, UocAfOrderReceiverAddressBo.class));
        }
        UocOrdLogisticsRelaQryBo qryBo1 = new UocOrdLogisticsRelaQryBo();
        qryBo1.setOrderId(uocAfOrder.getOrderId());
        qryBo1.setContactId(uocAfOrder.getContactId());
        UocOrdLogisticsRela getAddress = this.iUocOrderModel.qryOrderLogisticsRela(qryBo1);
        if (ObjectUtil.isNotNull((Object)getAddress)) {
            servInfoBo.setOrderTakeReceiveInfo(UocRu.js(getAddress, UocAfOrderReceiverAddressBo.class));
        }
    }

    private void encapCommodityInfo(List<UocAfOrderItem> afOrderItemList, UocGetAfOrderDetailServiceRspBo rspBo, UocGetAfOrderDetailServiceReqBo reqBo) {
        ArrayList commodityInfo = new ArrayList();
        if (ObjectUtil.isNotEmpty(afOrderItemList)) {
            afOrderItemList.forEach(each -> {
                UocAfOrderCommodityItemBo commodityItemBo = new UocAfOrderCommodityItemBo();
                BeanUtils.copyProperties((Object)each, (Object)commodityItemBo);
                this.encapSaleOrderItemInfo((UocAfOrderItem)each, commodityItemBo, reqBo);
                this.encapShipOrderItemInfo((UocAfOrderItem)each, commodityItemBo);
                this.encapInspOrderItemInfo((UocAfOrderItem)each, commodityItemBo);
                this.translateCommodityInfo(commodityItemBo);
                commodityInfo.add(commodityItemBo);
            });
        }
        rspBo.setCommodityInfo(commodityInfo);
    }

    private void translateCommodityInfo(UocAfOrderCommodityItemBo commodityItemBo) {
        commodityItemBo.setShipOrderStateStr(this.getDic().get("SHIP_ORDER_STATE").get(commodityItemBo.getShipOrderState()));
        if (null != commodityItemBo.getSkuSource()) {
            commodityItemBo.setSkuSourceStr(this.getDic().get("UOC_SALE_ORDER_SOURCE").get(commodityItemBo.getSkuSource().toString()));
        }
    }

    private void encapInspOrderItemInfo(UocAfOrderItem item, UocAfOrderCommodityItemBo commodityItemBo) {
        List<UocInspOrderItem> inspOrderItemList = this.getInspOrderItemList(item);
        if (ObjectUtil.isNotEmpty(inspOrderItemList)) {
            UocInspOrderItem uocInspOrderItem = inspOrderItemList.get(0);
            BeanUtils.copyProperties((Object)uocInspOrderItem, (Object)commodityItemBo);
        }
    }

    private List<UocInspOrderItem> getInspOrderItemList(UocAfOrderItem reqBo) {
        UocInspOrderItemQryBo qryBo = new UocInspOrderItemQryBo();
        qryBo.setOrderId(reqBo.getOrderId());
        qryBo.setInspOrderItemId(reqBo.getInspItemId());
        return this.iUocInspOrderModel.getListInspOrderItem(qryBo).getUocInspOrderItemList();
    }

    private void encapShipOrderItemInfo(UocAfOrderItem item, UocAfOrderCommodityItemBo commodityItemBo) {
        List<UocShipOrderItem> shipOrderItemList = this.getShipOrderItemList(item);
        if (ObjectUtil.isNotEmpty(shipOrderItemList)) {
            UocShipOrderItem uocShipOrderItem = shipOrderItemList.get(0);
            BeanUtils.copyProperties((Object)uocShipOrderItem, (Object)commodityItemBo);
            this.encapShipOrderMainInfo(commodityItemBo, uocShipOrderItem);
        }
    }

    private void encapShipOrderMainInfo(UocAfOrderCommodityItemBo commodityItemBo, UocShipOrderItem uocShipOrderItem) {
        UocShipOrderDo shipOrderDo = this.getShipOrderDo(uocShipOrderItem);
        if (ObjectUtil.isNotNull((Object)shipOrderDo)) {
            BeanUtils.copyProperties((Object)shipOrderDo, (Object)commodityItemBo);
        }
    }

    private void encapSaleOrderItemInfo(UocAfOrderItem item, UocAfOrderCommodityItemBo commodityItemBo, UocGetAfOrderDetailServiceReqBo reqBo) {
        List<UocSaleOrderItem> saleOrderItemList = this.getSaleOrderItemList(item);
        if (ObjectUtil.isNotEmpty(saleOrderItemList)) {
            UocSaleOrderItem saleOrderItem = saleOrderItemList.get(0);
            BeanUtils.copyProperties((Object)saleOrderItem, (Object)commodityItemBo);
            this.encapStakeHolderInfo(commodityItemBo, saleOrderItem, reqBo);
        }
    }

    private void encapOrderItemInfo(UocAfOrderItem item, UocAfOrderCommodityItemBo commodityItemBo) {
        List<UocOrderItem> orderItemList = this.getOrderItemList(item);
        if (ObjectUtil.isNotEmpty(orderItemList)) {
            UocOrderItem uocOrderItem = orderItemList.get(0);
            BeanUtils.copyProperties((Object)uocOrderItem, (Object)commodityItemBo);
        }
    }

    private List<UocOrderItem> getOrderItemList(UocAfOrderItem reqBo) {
        UocOrderItemQryBo qryBo = new UocOrderItemQryBo();
        qryBo.setOrderId(reqBo.getOrderId());
        return this.iUocOrderModel.qryOrderItemList(qryBo);
    }

    private void encapStakeHolderInfo(UocAfOrderCommodityItemBo commodityItemBo, UocSaleOrderItem saleOrderItem, UocGetAfOrderDetailServiceReqBo reqBo) {
        List<UocSaleStakeholder> stakeHolderList = this.getStakeHolderList(saleOrderItem, reqBo, true);
        if (ObjectUtil.isNotEmpty(stakeHolderList)) {
            UocSaleStakeholder uocSaleStakeholder = stakeHolderList.get(0);
            BeanUtils.copyProperties((Object)uocSaleStakeholder, (Object)commodityItemBo);
        }
    }

    private List<UocSaleStakeholder> getStakeHolderList(UocSaleOrderItem item, UocGetAfOrderDetailServiceReqBo reqBo, Boolean isSaleItem) {
        UocSaleStakeholderQryBo qryBo = new UocSaleStakeholderQryBo();
        if (isSaleItem.booleanValue()) {
            qryBo.setOrderId(item.getOrderId());
        } else {
            qryBo.setOrderId(reqBo.getOrderId());
        }
        return this.iUocSaleOrderModel.qrySaleOrderStakeholder(qryBo);
    }

    private UocShipOrderDo getShipOrderDo(UocShipOrderItem reqBo) {
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderQryBo.setShipOrderId(reqBo.getShipOrderId());
        return this.iUocShipOrderModel.getShipOrderById(uocShipOrderQryBo);
    }

    private List<UocShipOrderItem> getShipOrderItemList(UocAfOrderItem reqBo) {
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderItemQryBo.setShipOrderItemId(reqBo.getShipItemId());
        return this.iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo).getShipOrderItemBoList();
    }

    private List<UocSaleOrderItem> getSaleOrderItemList(UocAfOrderItem reqBo) {
        UocSaleOrderItemQryBo qryBo = new UocSaleOrderItemQryBo();
        qryBo.setOrderId(reqBo.getOrderId());
        qryBo.setSaleOrderItemId(reqBo.getSaleItemId());
        return this.iUocSaleOrderModel.getSaleOrderItemList(qryBo);
    }

    private UocAfOrder getAfOrderMain(UocGetAfOrderDetailServiceReqBo reqBo) {
        UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
        uocAfOrderQryBo.setAfOrderId(reqBo.getAfOrderId());
        uocAfOrderQryBo.setOrderId(reqBo.getOrderId());
        return this.iUocAfOrderModel.getAfOrderById(uocAfOrderQryBo);
    }

    private List<UocAfOrderItem> getAfOrderItemList(UocGetAfOrderDetailServiceReqBo reqBo) {
        UocAfOrderItemQryBo uocAfOrderItemQryBo = new UocAfOrderItemQryBo();
        uocAfOrderItemQryBo.setAfOrderId(reqBo.getAfOrderId());
        uocAfOrderItemQryBo.setOrderId(reqBo.getOrderId());
        return this.iUocAfOrderModel.getAfOrderItemList(uocAfOrderItemQryBo);
    }

    private void validateParam(UocGetAfOrderDetailServiceReqBo reqBo) {
        if (ObjectUtil.isNull((Object)reqBo)) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getAfOrderId() == null) {
            throw new BaseBusinessException("100001", "\u552e\u540e\u670d\u52a1\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOrderId() == null) {
            throw new BaseBusinessException("100001", "\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private Map<String, Map<String, String>> getDic() {
        ArrayList<String> pCodes = new ArrayList<String>();
        pCodes.add("UOC_ORD_SERVICE_STATE");
        pCodes.add("UOC_ORD_SERVICE_TYPE");
        pCodes.add("UOC_SALE_ORDER_PAY_TYPE");
        pCodes.add("AFS_REASON");
        pCodes.add("UOC_SALE_ORDER_SOURCE");
        pCodes.add("SHIP_ORDER_STATE");
        return this.iUocSysDictionaryModel.getDictionaryMap(pCodes);
    }
}

