package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.UocAuditOrderDo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalLog;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.service.domainservice.bo.UocApproveCreateServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocApproveCreateServiceReqTaskBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocApproveCreateServiceRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocApproveCreateServiceImpl
 * 说明:
 * 时间:2022/3/10 16:26
 * 作者:田桂银
 */
@HTServiceImpl
public class UocApproveCreateServiceImpl implements UocApproveCreateService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;

    @Override
    public UocApproveCreateServiceRspBo createApprove(UocApproveCreateServiceReqBo reqBo) {
        validateArg(reqBo);
        UocApproveCreateServiceRspBo rspBo = UocRu.success(UocApproveCreateServiceRspBo.class);

        //保存流程数据
        UocOrderProcInst createSaleProcIns = new UocOrderProcInst();
        createSaleProcIns.setProcInstId(reqBo.getProcInstId());
        createSaleProcIns.setProcDefId(reqBo.getProcDefId());
        createSaleProcIns.setOrderId(reqBo.getOrderId());
        createSaleProcIns.setObjId(reqBo.getObjId());
        createSaleProcIns.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
        createSaleProcIns.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        iUocSaleOrderModel.createProInst(createSaleProcIns);


        //保存任务数据
        List<UocApproveCreateServiceReqTaskBo> taskBoList = reqBo.getTaskBoList();
        List<UocOrderTaskDeal> saveDealList = new ArrayList<>();
        List<UocOrderTaskInst> saveList = new ArrayList<>();
        for (UocApproveCreateServiceReqTaskBo reqTaskBo : taskBoList) {
            UocOrderTaskInst taskBo = new UocOrderTaskInst();
            taskBo.setId(IdUtil.nextId());
            taskBo.setOrderId(reqBo.getOrderId());
            taskBo.setTaskInstId(reqTaskBo.getTaskInstId());
            taskBo.setObjId(reqBo.getObjId());
            taskBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
            taskBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
            taskBo.setProcInstId(reqBo.getProcInstId());
            taskBo.setProcDefId(reqBo.getProcDefId());
            saveList.add(taskBo);


            String assignee = reqTaskBo.getAssignee();
            List<String> candidates = reqTaskBo.getCandidates();
            //处理人和候选人
            if (ObjectUtil.isNotEmpty(assignee)) {
                UocOrderTaskDeal deal = assembleTaskDealObj(reqBo, reqTaskBo);
                deal.setDealId(assignee);
                deal.setDealClass(UocDicConstant.TASK_DEAL_CLASS.ASSIGNEE);
                saveDealList.add(deal);
            } else if (ObjectUtil.isNotEmpty(candidates)) {
                for (String candidate : candidates) {
                    UocOrderTaskDeal deal = assembleTaskDealObj(reqBo, reqTaskBo);
                    deal.setDealId(candidate);
                    deal.setDealClass(UocDicConstant.TASK_DEAL_CLASS.CANDIDATE);
                    saveDealList.add(deal);
                }
            }

            if (ObjectUtil.isNotEmpty(saveDealList)) {
                iUocSaleOrderModel.saveOrderTaskDealList(saveDealList);
            }
            iUocSaleOrderModel.saveProcTaskInst(saveList);
        }


        long auditId = IdUtil.nextId();
        UocAuditOrderDo auditDo = UocRu.js(reqBo, UocAuditOrderDo.class);
        auditDo.setAuditOrderId(auditId);
        auditDo.setCreateOperId(reqBo.getUserId().toString());
        auditDo.setCreateOperName(reqBo.getName());
        auditDo.setOrderId(reqBo.getOrderId());
        auditDo.setAuditOrderStatus(UocStateConstants.AUDIT_ORDER_STATUS.WAIT_AUDIT);
        List<UocApprovalObj> objList = new ArrayList<>();
        auditDo.setApprovalObjs(objList);
        UocApprovalObj approvalObj = new UocApprovalObj();
        objList.add(approvalObj);
        approvalObj.setObjId(reqBo.getObjId().toString());
        approvalObj.setId(IdUtil.nextId());
        approvalObj.setAuditOrderId(auditDo.getAuditOrderId());
        approvalObj.setOrderId(reqBo.getOrderId());
        approvalObj.setObjType(reqBo.getObjType());
        approvalObj.setObjBusiType(reqBo.getObjBusiType());

        UocApprovalLog uocApprovalLog = new UocApprovalLog();
        uocApprovalLog.setAuditOrderId(auditId);
        uocApprovalLog.setId(IdUtil.nextId());
        uocApprovalLog.setOperid(reqBo.getUserId().toString());
        uocApprovalLog.setOperName(reqBo.getName());
        uocApprovalLog.setOperDept(reqBo.getOrgId().toString());
        uocApprovalLog.setCreateTime(new Date());
        uocApprovalLog.setObjNum(objList.size());
        uocApprovalLog.setObjType(reqBo.getObjBusiType());
        uocApprovalLog.setAuditResult(UocConstant.AUDIT_TYPE.CREATE);
        auditDo.setApprovalLog(uocApprovalLog);

        iUocAuditOrderModel.saveAudit(auditDo);

        rspBo.setAuditOrderId(auditId);
        return rspBo;
    }


    /**
     * 描述:对象创建
     *
     * @param reqBo, nextTaskInfo 入参
     * @return com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal
     * @author tgy
     * @date 2022/3/3 17:31
     */
    private UocOrderTaskDeal assembleTaskDealObj(UocApproveCreateServiceReqBo reqBo, UocApproveCreateServiceReqTaskBo nextTaskInfo) {
        UocOrderTaskDeal deal = new UocOrderTaskDeal();
        deal.setId(IdUtil.nextId());
        deal.setTaskInstId(nextTaskInfo.getTaskInstId());
        deal.setOrderId(reqBo.getOrderId());
        deal.setObjId(reqBo.getObjId());
        deal.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
        return deal;
    }

    private void validateArg(UocApproveCreateServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocApproveCreateServiceReqBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getUserId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[用户id]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[订单id]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getProcInstId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[流程实例id]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getObjId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[对象id，例如销售单id]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getTaskBoList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[任务实例数据]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getObjType())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[对象类型]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getObjBusiType())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[对象业务类型]不能为空");
        }

        for (UocApproveCreateServiceReqTaskBo uocApproveCreateServiceReqTaskBo : reqBo.getTaskBoList()) {
            validateTaskArg(uocApproveCreateServiceReqTaskBo);
        }

    }

    private void validateTaskArg(UocApproveCreateServiceReqTaskBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocApproveCreateServiceReqTaskBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getTaskInstId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[任务实例id]不能为空");
        }

    }
}


