package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.convert.Convert;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocTacheButtonQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.order.sub.UocTacheButtonBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocTacheButtonInfoBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocTacheButtonQryReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocTacheButtonQryRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

/**
 * 标题：UocTacheButtonQryServiceImpl
 * 说明：页签环节按钮查询
 * 时间：2022/4/21 15:01
 *
 * @author 文乐
 */
@HTServiceImpl
public class UocTacheButtonQryServiceImpl implements UocTacheButtonQryService {

    @Autowired
    private IUocOrderModel iUocOrderModel;

    public static final String DEFAULT = "DEFAULT";

    @Value("${button.url.prefix:http://39.96.39.0/lowCode/}")
    private String BUTTON_URL_PREFIX;

    @Override
    public UocTacheButtonQryRspBo qryTacheButton(UocTacheButtonQryReqBo reqBo) {
        validateArg(reqBo);
        UocTacheButtonQryRspBo rspBo = UocRu.success(UocTacheButtonQryRspBo.class);
        UocTacheButtonQryBo uocTacheButtonQryBo = new UocTacheButtonQryBo();
        uocTacheButtonQryBo.setTabId(Convert.toInt(reqBo.getTabId()));
        uocTacheButtonQryBo.setTacheCodes(reqBo.getTacheCodes());
        // 默认传一个ALL
        uocTacheButtonQryBo.getTacheCodes().add(DEFAULT);
        uocTacheButtonQryBo.setSubOrderStatusCodes(reqBo.getSubOrderStatusCodes());
        uocTacheButtonQryBo.setOrderStatusList(reqBo.getOrderStatusList());
        List<UocTacheButtonBo> uocTacheButtonBos = iUocOrderModel.qryTacheButton(uocTacheButtonQryBo);

        List<UocTacheButtonInfoBO> uocTacheButtonInfoBOS = UocRu.jsl(uocTacheButtonBos, UocTacheButtonInfoBO.class);
        List<String> formTacheCodeList = uocTacheButtonInfoBOS.stream().map(UocTacheButtonInfoBO::getSubOrderStatusCode).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(formTacheCodeList)) {
            UocOrderTaskInstQryBo uocOrderTaskInstQryBo = new UocOrderTaskInstQryBo();
            uocOrderTaskInstQryBo.setOrderIdList(reqBo.getOrderIdList());
            uocOrderTaskInstQryBo.setObjIdList(reqBo.getObjIdList());
            uocOrderTaskInstQryBo.setObjType(reqBo.getObjType());
            uocOrderTaskInstQryBo.setProcStateList(formTacheCodeList);
            uocOrderTaskInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
            uocOrderTaskInstQryBo.setOrderBy("create_time desc");
            List<UocOrderTaskInst> uocOrderTaskInsts = iUocOrderModel.qryOrderTaskInstList(uocOrderTaskInstQryBo);
            if (!CollectionUtils.isEmpty(uocOrderTaskInsts)) {
                ConcurrentMap<String, List<UocOrderTaskInst>> tacheCodeMap = uocOrderTaskInsts.stream().collect(Collectors.groupingByConcurrent(UocOrderTaskInst::getProcState));
                uocTacheButtonInfoBOS.forEach(uocTacheButtonInfoBO -> {
                    List<UocOrderTaskInst> formTaskList = tacheCodeMap.get(uocTacheButtonInfoBO.getSubOrderStatusCode());
                    if (!CollectionUtils.isEmpty(formTaskList)) {
                        if (StringUtils.isNotBlank(formTaskList.get(0).getFormUrl())) {
                            String url = BUTTON_URL_PREFIX + formTaskList.get(0).getFormUrl();
                            if (StringUtils.isNotBlank(uocTacheButtonInfoBO.getFormParam())) {
                                uocTacheButtonInfoBO.setUri(url + "?" + uocTacheButtonInfoBO.getFormParam());
                            } else {
                                uocTacheButtonInfoBO.setUri(url);
                            }
                        }
                    }
                });

            }
        }

        rspBo.setUocTacheButtonS(uocTacheButtonInfoBOS);

//        Map<String, List<UocTacheButtonBo>> tacheCodeMap = uocTacheButtonBos.stream().collect(Collectors.groupingBy(UocTacheButtonBo::getTacheCode));
//        Map<String, List<UocTacheButtonBo>> subTacheCodeMap = uocTacheButtonBos.stream()
//                .filter(uocTacheButton -> StringUtils.isNotBlank(uocTacheButton.getSubOrderStatusCode()))
//                .collect(Collectors.groupingBy(UocTacheButtonBo::getSubOrderStatusCode));
//
//        Map<String, List<UocButtonBo>> buttonMap = new HashMap<>(16);
//
//        tacheCodeMap.forEach((tacheCode, uocTacheButtonBoList) -> {
//            List<UocButtonBo> uocButtonBos = uocTacheButtonBoList.stream().map(uocTacheButtonBo -> {
//                UocButtonBo uocButtonBo = new UocButtonBo();
//                uocButtonBo.setMenuCode(uocTacheButtonBo.getMenuCode());
//                uocButtonBo.setMenuDesc(uocTacheButtonBo.getMenuDesc());
//                return uocButtonBo;
//            }).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(UocButtonBo::getMenuCode))), ArrayList::new));
//            buttonMap.put(tacheCode, uocButtonBos);
//        });
//
//        subTacheCodeMap.forEach((tacheCode, uocTacheButtonBoList) -> {
//            List<UocButtonBo> uocButtonBos = uocTacheButtonBoList.stream().map(uocTacheButtonBo -> {
//                UocButtonBo uocButtonBo = new UocButtonBo();
//                uocButtonBo.setMenuCode(uocTacheButtonBo.getMenuCode());
//                uocButtonBo.setMenuDesc(uocTacheButtonBo.getMenuDesc());
//                return uocButtonBo;
//            }).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(UocButtonBo::getMenuCode))), ArrayList::new));
//            buttonMap.put(tacheCode, uocButtonBos);
//        });

        return rspBo;
    }

    private void validateArg(UocTacheButtonQryReqBo reqBo) {
        if (StringUtils.isBlank(reqBo.getTabId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参tabId不能为空");
        }
//        if (CollectionUtils.isEmpty(reqBo.getTacheCodes())) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参tabId不能为空");
//        }
    }
}
