package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderItemQryBo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderItem;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderStakeholderQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderCancelReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderCancelRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题：类名称:UocAfterOrderCancelServiceImpl
 * 说明：描述一下类的作用TODO
 * 时间：2022/4/6 16:11
 * 作者 @author 尹栋梁
 */
@HTServiceImpl
public class UocAfterOrderCancelServiceImpl implements UocAfterOrderCancelService{
    @Autowired
    private IUocAfOrderModel afOrderModel;

    @Autowired
    private IUocInspOrderModel inspOrderModel;

    @Autowired
    private IUocSaleOrderModel saleOrderModel;
    @Autowired
    private IUocOrderModel orderModel;

    @Override
    public UocAfterOrderCancelRspBo cancelAfterOrder(UocAfterOrderCancelReqBo reqBo) {
        UocAfterOrderCancelRspBo rspBo = UocRu.success(UocAfterOrderCancelRspBo.class);
        //参数校验
        validateArg(reqBo);
        //查询售后单信息
        UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
        uocAfOrderQryBo.setOrderId(reqBo.getOrderId());
        uocAfOrderQryBo.setAfOrderId(reqBo.getAfOrderId());
        UocAfOrder uocAfOrder = afOrderModel.getAfOrderById(uocAfOrderQryBo);
        if (ObjectUtil.isEmpty(uocAfOrder)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "查询售后单信息为空");
        }
        Integer servType = uocAfOrder.getServType();
        //退货情况，需要更新 销售单，验收单明细 的在途数量
        if (UocConstant.AFTERORDER_SERVTYPE.RETURN.equals(servType)) {
            List<UocAfOrderItem> afOrderItemList = afOrderModel.getAfOrderItemList(UocRu.js(reqBo, UocAfOrderItemQryBo.class));
            if (CollectionUtil.isNotEmpty(afOrderItemList)) {
                for (UocAfOrderItem uocAfOrderItem : afOrderItemList) {
                    updateItemAndInspection(uocAfOrderItem,reqBo,rspBo);
                }
            }
        }
        UocOrderStakeholderQryBo uocOrderStakeholderQryBo = new UocOrderStakeholderQryBo();
        uocOrderStakeholderQryBo.setOrderId(reqBo.getOrderId());
        List<UocOrderStakeholderQryBo> uocOrderStakeholderQryBos = orderModel.qryStakeholderList(uocOrderStakeholderQryBo);
        String supId = uocOrderStakeholderQryBos.get(0).getSupId();

        rspBo.setSaleOrderId(uocAfOrder.getSaleOrderId());
        rspBo.setExtAfId(uocAfOrder.getExtAfId());
        rspBo.setSupId(supId);
        return rspBo;
    }

    private void updateItemAndInspection(UocAfOrderItem uocAfOrderItem, UocAfterOrderCancelReqBo reqBo, UocAfterOrderCancelRspBo rspBo) {
        Long inspItemId = uocAfOrderItem.getInspItemId();
        Long orderItemId = uocAfOrderItem.getSaleItemId();
        if (ObjectUtil.isNotEmpty(orderItemId)) {
            UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
            uocSaleOrderItem.setOrderId(uocAfOrderItem.getOrderId());
            uocSaleOrderItem.setSaleOrderItemId(orderItemId);
            uocSaleOrderItem.setReturnCount(uocAfOrderItem.getReturnCount());
            uocSaleOrderItem.setUpdateTime(new Date());
            uocSaleOrderItem.setUpdateOperId(ObjectUtil.isEmpty(reqBo.getUserId()) ? null : String.valueOf(reqBo.getUserId()));
            saleOrderModel.modifySaleOrderItemReturningCount(uocSaleOrderItem);
        }
        if (ObjectUtil.isNotEmpty(inspItemId)) {
            UocInspOrderItem uocInspOrderItem = new UocInspOrderItem();
            uocInspOrderItem.setOrderId(uocAfOrderItem.getOrderId());
            uocInspOrderItem.setInspOrderItemId(inspItemId);
            uocInspOrderItem.setReturnCount(uocAfOrderItem.getReturnCount());
            uocInspOrderItem.setUpdateTime(new Date());
            uocInspOrderItem.setUpdateOperId(ObjectUtil.isEmpty(reqBo.getUserId()) ? null : String.valueOf(reqBo.getUserId()));
            inspOrderModel.modifySaleOrderItemReturningCount(uocInspOrderItem);
            //出参es同步
            List<Long> inspOrderIdList = rspBo.getInspOrderIdList();
            UocInspOrderItemQryBo uocInspOrderItemQryBo = new UocInspOrderItemQryBo();
            UocInspOrderDo listInspOrderItem = inspOrderModel.getListInspOrderItem(uocInspOrderItemQryBo);
            inspOrderIdList.add(listInspOrderItem.getInspOrderId());
        }

    }

    private void validateArg(UocAfterOrderCancelReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocAfterOrderCancelReqBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[订单ID]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getAfOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[售后单ID]不能为空");
        }
    }
}
