package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocDMsgPoolQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderQueryIndexQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.domainservice.bo.UocArriveInfoBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocMsgCreateVoterReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocMsgCreateVoterRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * @Author lsl
 * @Description //TODO 电商订单消息处理，用于处理妥投、拒收状态修改接口实现
 * @Date 16:30 2022/4/12
 * @Param
 * @return
 */
@HTServiceImpl
@Slf4j
public class UocMsgCreateVoterServiceImpl implements UocMsgCreateVoterService {
    
    @Autowired
    private IUocOrderModel iUocOrderModel;
    
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    
    @Override
    public UocMsgCreateVoterRspBo createVoter(UocMsgCreateVoterReqBo reqBo) {
        UocMsgCreateVoterRspBo rspBo = new UocMsgCreateVoterRspBo();
        
        log.info("妥投拒收状态修改接口参数为：{}",reqBo.toString());
    
        rspBo = createCoreVoter(reqBo,rspBo);
    
        rspBo.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);
        return rspBo;
    }
    /*
     * @Author lsl
     * @Description //TODO
     * @Date 11:02 2022/4/15
     * @Param [reqBo]
     * @return com.tydic.dyc.oc.service.domainservice.bo.DycUocMsgCreateVoterRspBo
     */
    public UocMsgCreateVoterRspBo createCoreVoter(UocMsgCreateVoterReqBo reqBo, UocMsgCreateVoterRspBo rspBo){
        UocMsgCreateVoterRspBo rspBo1 = new UocMsgCreateVoterRspBo();
        try {
            rspBo1 = delieveredReject(reqBo);
            //处理完妥投消息后更新msgPool中的执行状态为已执行
            UocDMsgPoolQryBo qryBo = new UocDMsgPoolQryBo();
            qryBo.setMsgId(reqBo.getDycUocQryMsgBO().getMsgId());
            qryBo.setRunResult(1);//执行成功
            iUocOrderModel.updateMsgPoolById(qryBo);
            
            
        } catch (Exception e) {
            rspBo1 = new UocMsgCreateVoterRspBo();
            rspBo1.setRespCode(UocRspConstants.RSP_CODE_FAIL);
            rspBo1.setRespDesc(e.getMessage());
        }
        return rspBo1;
    }
    /*
     * @Author lsl
     * @Description //TODO 子超市订单妥投拒收业务服务方法
     * @Date 11:07 2022/4/15
     * @Param 
     * @return 
     */
    public UocMsgCreateVoterRspBo delieveredReject(UocMsgCreateVoterReqBo reqBo){
        UocMsgCreateVoterRspBo rspBo = new UocMsgCreateVoterRspBo();
        
        rspBo = delieveredCoreReject(reqBo);
        return rspBo;
    }
    /*
     * @Author lsl
     * @Description //TODO 子超市订单妥投拒收业务服务核心方法
     * @Date 11:10 2022/4/15
     * @Param [reqBo]
     * @return com.tydic.dyc.oc.service.domainservice.bo.DycUocMsgCreateVoterRspBo
     */
    public UocMsgCreateVoterRspBo delieveredCoreReject(UocMsgCreateVoterReqBo reqBo){
        //入参校验
        validateArg(reqBo);
        UocMsgCreateVoterRspBo rspBO = new UocMsgCreateVoterRspBo();
        //通过外部发货单ID查询内部订单和发货单的ID信息
        UocOrderQueryIndexQryBo queryIndexQryBo = new UocOrderQueryIndexQryBo();
        queryIndexQryBo.setOrderSystem("3");//发货单
        queryIndexQryBo.setOutObjId(reqBo.getDycUocQryMsgBO().getOutOrderId());//外部电商id
        List<UocOrderQueryIndex> queryIndexList = iUocOrderModel.qryOrderQueryIndexList(queryIndexQryBo);
        if(ObjectUtil.isEmpty(queryIndexList)){
            rspBO.setRespCode(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR);
            rspBO.setRespDesc("未查询到外部订单[" + reqBo.getDycUocQryMsgBO().getOutOrderId() + "]和系统编码["
                    + queryIndexQryBo.getOrderSystem() + "]的对应关系");
        }
        //查询销售订单并验证其状态是否是已发货(不验证状态)
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(reqBo.getDycUocQryMsgBO().getOrderId());
        uocSaleOrderDo = iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        if(uocSaleOrderDo == null ){
            rspBO.setRespCode(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR);
            rspBO.setRespDesc("未查询到外部订单[" + reqBo.getDycUocQryMsgBO().getOutOrderId() + "对应的销售订单信息");
        }
        Long saleVoucherId = uocSaleOrderDo.getSaleOrderId();//销售单id
        Long orderId = uocSaleOrderDo.getOrderId();//订单ID
        Long shipVoucherId = queryIndexQryBo.getObjId();//发货单单据id
        
        //查询当前进行妥投或拒收业务的发货单
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(orderId);
        uocShipOrderQryBo.setShipOrderId(shipVoucherId);
        List<UocShipOrderDo> shipOrderDoList =  iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
        if(ObjectUtil.isEmpty(shipOrderDoList)){
            rspBO.setRespCode(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR);
            rspBO.setRespDesc("电子超市订单妥投拒收业务服务失败，未查询到发货单信息!");
        }
        UocShipOrderDo uocShipOrderDo = shipOrderDoList.get(0);
    
        //更新到货数量
        executeArriveRegist(reqBo,queryIndexQryBo,uocShipOrderDo);
        
        //判断是否全部到货
        boolean isAllReceive = judgeIsAllReceive(orderId);
        
        rspBO.setIsAllReceive(isAllReceive);
        rspBO.setSaleVoucherId(saleVoucherId);
        rspBO.setShipVoucherId(uocShipOrderDo.getShipOrderId());
        rspBO.setOrderId(orderId);
        
    
        UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
        taskInstQryBo.setOrderId(reqBo.getDycUocQryMsgBO().getOrderId());
        taskInstQryBo.setObjId(uocShipOrderDo.getShipOrderId());
        taskInstQryBo.setFinishTag(0);
        taskInstQryBo.setObjType(4);
        //查询订单任务实例
        List<UocOrderTaskInst> taskInsts = iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
        if(ObjectUtil.isNotEmpty(taskInsts)){
            rspBO.setTaskInstId(taskInsts.get(0).getTaskInstId());
            rspBO.setStepId(taskInsts.get(0).getProcState());
        }
        
        return rspBO;
    }
    /*
     * @Author lsl
     * @Description //TODO 判断是否全部到货
     * @Date 15:49 2022/4/15
     * @Param [reqBo, queryIndexQryBo, uocShipOrderDo]
     * @return void
     */
    public boolean judgeIsAllReceive(Long orderId){
        boolean isAllReceive = true;
        UocSaleOrderItemQryBo saleOrderItemQryBo = new UocSaleOrderItemQryBo();
        saleOrderItemQryBo.setOrderId(orderId);
        
        List<UocSaleOrderItem> saleOrderItems = iUocSaleOrderModel.getSaleOrderItemList(saleOrderItemQryBo);
    
        if (saleOrderItems == null || saleOrderItems.isEmpty()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR, "电子超市订单妥投拒收业务服务失败:" +
                    "为查询到销售订单明细信息!");
        }
        //判断是否是全部到货逻辑
        BigDecimal totalPurchaseCount = new BigDecimal(0);
        BigDecimal totalArriveCount = new BigDecimal(0);
        for (UocSaleOrderItem saleOrderItem : saleOrderItems) {
            totalPurchaseCount = totalPurchaseCount.add(saleOrderItem.getPurchaseCount());
            //每个订单明细的到货数量
            BigDecimal arriveCount = saleOrderItem.getArriveCount().add(saleOrderItem.getRefuseCount());
            totalArriveCount = totalArriveCount.add(arriveCount);
        }
        if (!totalArriveCount.equals(totalPurchaseCount)) {
            isAllReceive = false;
        }
        log.info("------------------------是否是全部到货状态值：" + isAllReceive);
        return isAllReceive;
        
        
    }
    /*
     * @Author lsl
     * @Description //TODO 执行到货登记
     * @Date 11:31 2022/4/15
     * @Param
     * @return
     */
    public void executeArriveRegist(UocMsgCreateVoterReqBo reqBo, UocOrderQueryIndexQryBo queryIndexQryBo, UocShipOrderDo uocShipOrderDo){
        //查询发货明细，封装到货拒收情况BOList
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        List<UocArriveInfoBO> arriveInfoBOList = new ArrayList<>();
        uocShipOrderItemQryBo.setOrderId(uocShipOrderDo.getOrderId());
        uocShipOrderItemQryBo.setShipOrderId(uocShipOrderDo.getShipOrderId());
        UocShipOrderDo uocShipOrderDo1 = iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
    
        List<UocShipOrderItem> shipOrderItemBoList = uocShipOrderDo1.getShipOrderItemBoList();
        boolean notArrive = false;
        for(UocShipOrderItem shipOrderItem: shipOrderItemBoList){
            UocArriveInfoBO arriveInfoBO = new UocArriveInfoBO();//到货信息BO
                    
            if(reqBo.getDycUocQryMsgBO().getMsgState().equals(2)){
                //如果是拒收
                arriveInfoBO.setRejectCount(shipOrderItem.getSendCount());
            }else if(reqBo.getDycUocQryMsgBO().getMsgState().equals(1)){
                //如果是妥投
                arriveInfoBO.setArriveCount(shipOrderItem.getSendCount());
                if (shipOrderItem.getArriveCount() != null) {
                    if (shipOrderItem.getSendCount().compareTo(shipOrderItem.getArriveCount()) <= 0) {
                        notArrive = true;
                    }
                }
                
            }
            arriveInfoBOList.add(arriveInfoBO);
        }
    
        if (notArrive) {
            return;
        }
        //更新拒收数量和发货数量到货数量
        arriveRegist(uocShipOrderDo,arriveInfoBOList);
        //更新发货单的到货时间
        updateShipArriveTime(uocShipOrderDo.getOrderId(),uocShipOrderDo.getShipOrderId());
    
    }
    /*
     * @Author lsl
     * @Description //TODO 进行到货登记
     * @Date 14:25 2022/4/15
     * @Param [orderId, shipOrderId]
     * @return void
     */
    public void arriveRegist(UocShipOrderDo uocShipOrderDo,List<UocArriveInfoBO> arriveInfoBOList){
        //判断同一明细的到货数量+拒收数量必须小于等于发货数量
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setOrderId(uocShipOrderDo.getOrderId());
        uocShipOrderItemQryBo.setShipOrderId(uocShipOrderDo.getShipOrderId());
        UocShipOrderDo shipOrderItemDo = iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
        List<UocShipOrderItem>  ordShipItemList = shipOrderItemDo.getShipOrderItemBoList();
        for(UocShipOrderItem shipOrderItem :ordShipItemList){
            BigDecimal totalCount = new BigDecimal(0);
            totalCount = totalCount.add(shipOrderItem.getArriveCount()).add(shipOrderItem.getRefuseCount());
            if (totalCount.compareTo(shipOrderItem.getSendCount()) > 0) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR, "电商妥投进行到货登记发货明细【到货数量+拒收数量>发货数量】！");
            }
        }
        //更新拒收和到货数量
        for(UocArriveInfoBO bo: arriveInfoBOList){
            UocShipOrderDo shipArriveDo = new UocShipOrderDo();
            List<Long> shipOrderItemIdList = new ArrayList<>();
            List<UocShipOrderItem> shipOrderItemBoList = new ArrayList<>();
    
            shipArriveDo.setShipOrderItemIdList(shipOrderItemIdList);
            shipArriveDo.setShipOrderItemBoList(shipOrderItemBoList);
            
            shipOrderItemIdList.add(bo.getShipItemId());
            if(bo.getArriveCount() != null){//到货数量
                UocShipOrderItem uocShipOrderItem = new UocShipOrderItem();
                uocShipOrderItem.setArriveCount(bo.getArriveCount());
                shipOrderItemBoList.add(uocShipOrderItem);
    
            }
            if (bo.getRejectCount() != null) {//拒收数量
                UocShipOrderItem uocShipOrderItem = new UocShipOrderItem();
                uocShipOrderItem.setRefuseCount(bo.getRejectCount());
                shipOrderItemBoList.add(uocShipOrderItem);
            }
            
            //更新到货数量和拒收数量
            iUocShipOrderModel.modifyItemArriveCount(shipArriveDo);
            
            
            //更新uoc_sale_order_item
            UocShipOrderItemQryBo shipOrderItemQryBo1 = new UocShipOrderItemQryBo();
            shipOrderItemQryBo1.setShipOrderItemId(bo.getShipItemId());
            
            UocShipOrderDo shiItemDo = iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
            List<UocShipOrderItem> shipOrderItemBoList1 =  shiItemDo.getShipOrderItemBoList();
            
            Long saleOrderItemId = shipOrderItemBoList1.get(0).getSaleOrderItemId();
    
            UocSaleOrderDo saleOrderDo = new UocSaleOrderDo();
            saleOrderDo.setOrderId(uocShipOrderDo.getOrderId());
            List<UocSaleOrderItem> saleItemList = new ArrayList<>();
            saleOrderDo.setSaleOrderItems(saleItemList);
    
            if(bo.getArriveCount() != null){//到货数量
                UocSaleOrderItem saleOrderItem = new UocSaleOrderItem();
                saleOrderItem.setArriveCount(bo.getArriveCount());
                saleOrderItem.setSaleOrderItemId(saleOrderItemId);
                saleItemList.add(saleOrderItem);
        
            }
            if (bo.getRejectCount() != null) {//拒收数量
                UocSaleOrderItem saleOrderItem = new UocSaleOrderItem();
                saleOrderItem.setRefuseCount(bo.getRejectCount());
                saleOrderItem.setSaleOrderItemId(saleOrderItemId);
                saleItemList.add(saleOrderItem);
            }
            
            //更新uoc_sale_order_item
            iUocSaleOrderModel.updateSaleItemArriveAccount(saleOrderDo);
        }
        
        
    }
    /*
     * @Author lsl
     * @Description //TODO 更新发货单的到货时间
     * @Date 11:49 2022/4/15
     * @Param [orderId, shipOrderId]
     * @return void
     */
    public void updateShipArriveTime(Long orderId,Long shipOrderId){
        UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
        uocShipOrderDo.setOrderId(orderId);
        uocShipOrderDo.setShipOrderId(shipOrderId);
        uocShipOrderDo.setArriveTime(new Date());
        
        iUocShipOrderModel.modifyShipArrivtime(uocShipOrderDo);
    }
    /**
     * 入参校验
     *
     * @param reqBO 入参对象
     */
    private void validateArg(UocMsgCreateVoterReqBo reqBO) {
        if (reqBO == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "电子超市订单妥投拒收业务服务入参reqBO不能为空");
        }
        if (StringUtils.isBlank(reqBO.getDycUocQryMsgBO().getOutOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "电子超市订单妥投拒收业务服务入参属性【outOrderId】不能为空");
        }
        if (reqBO.getDycUocQryMsgBO().getSupNo() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "电子超市订单妥投拒收业务服务入参属性【supNo】不能为空");
        }
        if (reqBO.getDycUocQryMsgBO().getMsgState() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "电子超市订单妥投拒收业务服务入参属性【msgState】不能为空");
        }
    }
}
