package com.tydic.dyc.oc.service.order;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.es.UocEsSyncManager;
import com.tydic.dyc.oc.components.es.UocEsSyncManagerSaveDataReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderRelQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderRel;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.order.bo.UocOrderRelUpdateReqBo;
import com.tydic.dyc.oc.service.order.bo.UocOrderRelUpdateRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 标题：UocOrderRelUpdateServiceImpl
 * 说明：订单关联更新API
 * 时间：2022/4/1 14:57
 *
 * @author 文乐
 */
@HTServiceImpl
public class UocOrderRelUpdateServiceImpl implements UocOrderRelUpdateService {

    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;
    @Autowired
    private UocEsSyncManager uocEsSyncManager;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public UocOrderRelUpdateRspBo dealRelUpdate(UocOrderRelUpdateReqBo reqBo) {
        // 参数校验
        validateArg(reqBo);
        // 查询是否已存在
        UocOrderRelQryBo uocOrderRelQryBo = new UocOrderRelQryBo();
        uocOrderRelQryBo.setObjId(reqBo.getObjId());
        uocOrderRelQryBo.setObjType(reqBo.getObjType());
//        uocOrderRelQryBo.setOrderId(reqBo.getOrderId());
        uocOrderRelQryBo.setRelType(reqBo.getRelType());
        UocOrderRel qryRelInfo = iUocOrderModel.qryRelInfo(uocOrderRelQryBo);

        UocOrderRel uocOrderRel = new UocOrderRel();
        if ( null != qryRelInfo ) {
            // 更新
            uocOrderRel.setId(qryRelInfo.getId());
            uocOrderRel.setRelStatus(reqBo.getRelState());
            uocOrderRel.setRelId(reqBo.getRelId());
            iUocOrderModel.dealRelUpdate(uocOrderRel);
        } else {
            // 创建
            uocOrderRel = UocRu.js(reqBo, UocOrderRel.class);
            uocOrderRel.setRelStatus(reqBo.getRelState());
            uocOrderRel.setId(IdUtil.nextId());
            iUocOrderModel.createRelInfo(uocOrderRel);
        }
        uocOrderRel.setRelType(reqBo.getRelType());
        uocOrderRel.setObjId(reqBo.getObjId());
        uocOrderRel.setObjType(reqBo.getObjType());
        syncEs(uocOrderRel);
        return UocRu.success(UocOrderRelUpdateRspBo.class);
    }

    private void validateArg(UocOrderRelUpdateReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能不为空");
        }
        if (null == reqBo.getObjId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "ObjId不能为空");
        }
        if (null == reqBo.getObjType()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "ObjType不能为空");
        }
        if (null == reqBo.getRelState()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "relState不能为空");
        }
        if (null == reqBo.getRelType()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "relType不能为空");
        }
    }

    private Map<String, Map<String, String>> getDic() {
        List<String> pCodes = new ArrayList<>();
        pCodes.add(UocDicConstant.REL_TYPE.P_CODE);
        pCodes.add(UocDicConstant.REL_STATUS.P_CODE);
        return iUocSysDictionaryModel.getDictionaryMap(pCodes);
    }

    private void syncEs(UocOrderRel uocOrderRel) {
        UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = new UocEsSyncManagerSaveDataReqBo();
        uocEsSyncManagerSaveDataReqBo.setObjId(uocOrderRel.getObjId());
        JSONObject jsonObj = new JSONObject();
        jsonObj.put(UocConstant.ES_MAIN_OTHER.REL_TYPE, uocOrderRel.getRelType());
        jsonObj.put(UocConstant.ES_MAIN_OTHER.REL_STATUS, uocOrderRel.getRelStatus());
        jsonObj.put(UocConstant.ES_MAIN_OTHER.REL_INFO, uocOrderRel.getRelStatus() + "," + uocOrderRel.getRelType());
        jsonObj.put(UocConstant.ES_MAIN_OTHER.REL_ID, uocOrderRel.getRelId());
        Map<String, Map<String, String>> dic = getDic();
        Map<String, String> relTypeMap = dic.get(UocDicConstant.REL_TYPE.P_CODE);
        Map<String, String> relStatusMap = dic.get(UocDicConstant.REL_STATUS.P_CODE);
        jsonObj.put(UocConstant.ES_MAIN_OTHER.REL_STATUS_STR, relStatusMap.get(Convert.toStr(uocOrderRel.getRelStatus())));
        jsonObj.put(UocConstant.ES_MAIN_OTHER.REL_TYPE_STR, relTypeMap.get(Convert.toStr(uocOrderRel.getRelType())));
        uocEsSyncManagerSaveDataReqBo.setJsonObj(jsonObj);
        if (UocDicConstant.REL_TYPE.SERVICE_CHARGE.equals(uocOrderRel.getRelType())) {
            uocEsSyncManagerSaveDataReqBo.setIndexName(uocIndexConfig.getTransactionIndex());
        } else {
            uocEsSyncManagerSaveDataReqBo.setIndexName(uocIndexConfig.getInspOrderIndex());
        }
        uocEsSyncManager.updateData(uocEsSyncManagerSaveDataReqBo);
    }
}
