/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocDMsgPoolQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderQueryIndexQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.domainservice.UocMsgCreateVoterService;
import com.tydic.dyc.oc.service.domainservice.bo.UocArriveInfoBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocMsgCreateVoterReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocMsgCreateVoterRspBo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.domainservice.UocMsgCreateVoterService"})
public class UocMsgCreateVoterServiceImpl
implements UocMsgCreateVoterService {
    private static final Logger log = LoggerFactory.getLogger(UocMsgCreateVoterServiceImpl.class);
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;

    @PostMapping(value={"createVoter"})
    public UocMsgCreateVoterRspBo createVoter(@RequestBody UocMsgCreateVoterReqBo reqBo) {
        UocMsgCreateVoterRspBo rspBo = new UocMsgCreateVoterRspBo();
        log.info("\u59a5\u6295\u62d2\u6536\u72b6\u6001\u4fee\u6539\u63a5\u53e3\u53c2\u6570\u4e3a\uff1a{}", (Object)reqBo.toString());
        rspBo = this.createCoreVoter(reqBo, rspBo);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    public UocMsgCreateVoterRspBo createCoreVoter(UocMsgCreateVoterReqBo reqBo, UocMsgCreateVoterRspBo rspBo) {
        UocMsgCreateVoterRspBo rspBo1 = new UocMsgCreateVoterRspBo();
        try {
            rspBo1 = this.delieveredReject(reqBo);
            UocDMsgPoolQryBo qryBo = new UocDMsgPoolQryBo();
            qryBo.setMsgId(reqBo.getDycUocQryMsgBO().getMsgId());
            qryBo.setRunResult(1);
            this.iUocOrderModel.updateMsgPoolById(qryBo);
        }
        catch (Exception e) {
            rspBo1 = new UocMsgCreateVoterRspBo();
            rspBo1.setRespCode("8888");
            rspBo1.setRespDesc(e.getMessage());
        }
        return rspBo1;
    }

    public UocMsgCreateVoterRspBo delieveredReject(UocMsgCreateVoterReqBo reqBo) {
        UocMsgCreateVoterRspBo rspBo = new UocMsgCreateVoterRspBo();
        rspBo = this.delieveredCoreReject(reqBo);
        return rspBo;
    }

    public UocMsgCreateVoterRspBo delieveredCoreReject(UocMsgCreateVoterReqBo reqBo) {
        this.validateArg(reqBo);
        UocMsgCreateVoterRspBo rspBO = new UocMsgCreateVoterRspBo();
        UocOrderQueryIndexQryBo queryIndexQryBo = new UocOrderQueryIndexQryBo();
        queryIndexQryBo.setOrderSystem("3");
        queryIndexQryBo.setOutObjId(reqBo.getDycUocQryMsgBO().getOutOrderId());
        List<UocOrderQueryIndex> queryIndexList = this.iUocOrderModel.qryOrderQueryIndexList(queryIndexQryBo);
        if (ObjectUtil.isEmpty(queryIndexList)) {
            rspBO.setRespCode("101002");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5916\u90e8\u8ba2\u5355[" + reqBo.getDycUocQryMsgBO().getOutOrderId() + "]\u548c\u7cfb\u7edf\u7f16\u7801[" + queryIndexQryBo.getOrderSystem() + "]\u7684\u5bf9\u5e94\u5173\u7cfb");
        }
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(reqBo.getDycUocQryMsgBO().getOrderId());
        uocSaleOrderDo = this.iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        if (uocSaleOrderDo == null) {
            rspBO.setRespCode("101002");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5916\u90e8\u8ba2\u5355[" + reqBo.getDycUocQryMsgBO().getOutOrderId() + "\u5bf9\u5e94\u7684\u9500\u552e\u8ba2\u5355\u4fe1\u606f");
        }
        Long saleVoucherId = uocSaleOrderDo.getSaleOrderId();
        Long orderId = uocSaleOrderDo.getOrderId();
        Long shipVoucherId = queryIndexQryBo.getObjId();
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(orderId);
        uocShipOrderQryBo.setShipOrderId(shipVoucherId);
        List<UocShipOrderDo> shipOrderDoList = this.iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
        if (ObjectUtil.isEmpty(shipOrderDoList)) {
            rspBO.setRespCode("101002");
            rspBO.setRespDesc("\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u53d1\u8d27\u5355\u4fe1\u606f!");
        }
        UocShipOrderDo uocShipOrderDo = shipOrderDoList.get(0);
        this.executeArriveRegist(reqBo, queryIndexQryBo, uocShipOrderDo);
        boolean isAllReceive = this.judgeIsAllReceive(orderId);
        rspBO.setIsAllReceive(Boolean.valueOf(isAllReceive));
        rspBO.setSaleVoucherId(saleVoucherId);
        rspBO.setShipVoucherId(uocShipOrderDo.getShipOrderId());
        rspBO.setOrderId(orderId);
        UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
        taskInstQryBo.setOrderId(reqBo.getDycUocQryMsgBO().getOrderId());
        taskInstQryBo.setObjId(uocShipOrderDo.getShipOrderId());
        taskInstQryBo.setFinishTag(0);
        taskInstQryBo.setObjType(4);
        List<UocOrderTaskInst> taskInsts = this.iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
        if (ObjectUtil.isNotEmpty(taskInsts)) {
            rspBO.setTaskInstId(taskInsts.get(0).getTaskInstId());
            rspBO.setStepId(taskInsts.get(0).getProcState());
        }
        return rspBO;
    }

    public boolean judgeIsAllReceive(Long orderId) {
        boolean isAllReceive = true;
        UocSaleOrderItemQryBo saleOrderItemQryBo = new UocSaleOrderItemQryBo();
        saleOrderItemQryBo.setOrderId(orderId);
        List<UocSaleOrderItem> saleOrderItems = this.iUocSaleOrderModel.getSaleOrderItemList(saleOrderItemQryBo);
        if (saleOrderItems == null || saleOrderItems.isEmpty()) {
            throw new BaseBusinessException("101002", "\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u4e3a\u67e5\u8be2\u5230\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u4fe1\u606f!");
        }
        BigDecimal totalPurchaseCount = new BigDecimal(0);
        BigDecimal totalArriveCount = new BigDecimal(0);
        for (UocSaleOrderItem saleOrderItem : saleOrderItems) {
            totalPurchaseCount = totalPurchaseCount.add(saleOrderItem.getPurchaseCount());
            BigDecimal arriveCount = saleOrderItem.getArriveCount().add(saleOrderItem.getRefuseCount());
            totalArriveCount = totalArriveCount.add(arriveCount);
        }
        if (!totalArriveCount.equals(totalPurchaseCount)) {
            isAllReceive = false;
        }
        log.info("------------------------\u662f\u5426\u662f\u5168\u90e8\u5230\u8d27\u72b6\u6001\u503c\uff1a" + isAllReceive);
        return isAllReceive;
    }

    public void executeArriveRegist(UocMsgCreateVoterReqBo reqBo, UocOrderQueryIndexQryBo queryIndexQryBo, UocShipOrderDo uocShipOrderDo) {
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        ArrayList<UocArriveInfoBO> arriveInfoBOList = new ArrayList<UocArriveInfoBO>();
        uocShipOrderItemQryBo.setOrderId(uocShipOrderDo.getOrderId());
        uocShipOrderItemQryBo.setShipOrderId(uocShipOrderDo.getShipOrderId());
        UocShipOrderDo uocShipOrderDo1 = this.iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
        List<UocShipOrderItem> shipOrderItemBoList = uocShipOrderDo1.getShipOrderItemBoList();
        boolean notArrive = false;
        for (UocShipOrderItem shipOrderItem : shipOrderItemBoList) {
            UocArriveInfoBO arriveInfoBO = new UocArriveInfoBO();
            if (reqBo.getDycUocQryMsgBO().getMsgState().equals(2)) {
                arriveInfoBO.setRejectCount(shipOrderItem.getSendCount());
            } else if (reqBo.getDycUocQryMsgBO().getMsgState().equals(1)) {
                arriveInfoBO.setArriveCount(shipOrderItem.getSendCount());
                if (shipOrderItem.getArriveCount() != null && shipOrderItem.getSendCount().compareTo(shipOrderItem.getArriveCount()) <= 0) {
                    notArrive = true;
                }
            }
            arriveInfoBOList.add(arriveInfoBO);
        }
        if (notArrive) {
            return;
        }
        this.arriveRegist(uocShipOrderDo, arriveInfoBOList);
        this.updateShipArriveTime(uocShipOrderDo.getOrderId(), uocShipOrderDo.getShipOrderId());
    }

    public void arriveRegist(UocShipOrderDo uocShipOrderDo, List<UocArriveInfoBO> arriveInfoBOList) {
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setOrderId(uocShipOrderDo.getOrderId());
        uocShipOrderItemQryBo.setShipOrderId(uocShipOrderDo.getShipOrderId());
        UocShipOrderDo shipOrderItemDo = this.iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
        List<UocShipOrderItem> ordShipItemList = shipOrderItemDo.getShipOrderItemBoList();
        for (UocShipOrderItem shipOrderItem : ordShipItemList) {
            BigDecimal totalCount = new BigDecimal(0);
            if ((totalCount = totalCount.add(shipOrderItem.getArriveCount()).add(shipOrderItem.getRefuseCount())).compareTo(shipOrderItem.getSendCount()) <= 0) continue;
            throw new BaseBusinessException("101002", "\u7535\u5546\u59a5\u6295\u8fdb\u884c\u5230\u8d27\u767b\u8bb0\u53d1\u8d27\u660e\u7ec6\u3010\u5230\u8d27\u6570\u91cf+\u62d2\u6536\u6570\u91cf>\u53d1\u8d27\u6570\u91cf\u3011\uff01");
        }
        for (UocArriveInfoBO bo : arriveInfoBOList) {
            UocSaleOrderItem saleOrderItem;
            UocShipOrderItem uocShipOrderItem;
            UocShipOrderDo shipArriveDo = new UocShipOrderDo();
            ArrayList<Long> shipOrderItemIdList = new ArrayList<Long>();
            ArrayList<UocShipOrderItem> shipOrderItemBoList = new ArrayList<UocShipOrderItem>();
            shipArriveDo.setShipOrderItemIdList(shipOrderItemIdList);
            shipArriveDo.setShipOrderItemBoList(shipOrderItemBoList);
            shipOrderItemIdList.add(bo.getShipItemId());
            if (bo.getArriveCount() != null) {
                uocShipOrderItem = new UocShipOrderItem();
                uocShipOrderItem.setArriveCount(bo.getArriveCount());
                shipOrderItemBoList.add(uocShipOrderItem);
            }
            if (bo.getRejectCount() != null) {
                uocShipOrderItem = new UocShipOrderItem();
                uocShipOrderItem.setRefuseCount(bo.getRejectCount());
                shipOrderItemBoList.add(uocShipOrderItem);
            }
            this.iUocShipOrderModel.modifyItemArriveCount(shipArriveDo);
            UocShipOrderItemQryBo shipOrderItemQryBo1 = new UocShipOrderItemQryBo();
            shipOrderItemQryBo1.setShipOrderItemId(bo.getShipItemId());
            UocShipOrderDo shiItemDo = this.iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
            List<UocShipOrderItem> shipOrderItemBoList1 = shiItemDo.getShipOrderItemBoList();
            Long saleOrderItemId = shipOrderItemBoList1.get(0).getSaleOrderItemId();
            UocSaleOrderDo saleOrderDo = new UocSaleOrderDo();
            saleOrderDo.setOrderId(uocShipOrderDo.getOrderId());
            ArrayList<UocSaleOrderItem> saleItemList = new ArrayList<UocSaleOrderItem>();
            saleOrderDo.setSaleOrderItems(saleItemList);
            if (bo.getArriveCount() != null) {
                saleOrderItem = new UocSaleOrderItem();
                saleOrderItem.setArriveCount(bo.getArriveCount());
                saleOrderItem.setSaleOrderItemId(saleOrderItemId);
                saleItemList.add(saleOrderItem);
            }
            if (bo.getRejectCount() != null) {
                saleOrderItem = new UocSaleOrderItem();
                saleOrderItem.setRefuseCount(bo.getRejectCount());
                saleOrderItem.setSaleOrderItemId(saleOrderItemId);
                saleItemList.add(saleOrderItem);
            }
            this.iUocSaleOrderModel.updateSaleItemArriveAccount(saleOrderDo);
        }
    }

    public void updateShipArriveTime(Long orderId, Long shipOrderId) {
        UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
        uocShipOrderDo.setOrderId(orderId);
        uocShipOrderDo.setShipOrderId(shipOrderId);
        uocShipOrderDo.setArriveTime(new Date());
        this.iUocShipOrderModel.modifyShipArrivtime(uocShipOrderDo);
    }

    private void validateArg(UocMsgCreateVoterReqBo reqBO) {
        if (reqBO == null) {
            throw new BaseBusinessException("100001", "\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1\u5165\u53c2reqBO\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getDycUocQryMsgBO().getOutOrderId())) {
            throw new BaseBusinessException("100001", "\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u5c5e\u6027\u3010outOrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getDycUocQryMsgBO().getSupNo() == null) {
            throw new BaseBusinessException("100001", "\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u5c5e\u6027\u3010supNo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getDycUocQryMsgBO().getMsgState() == null) {
            throw new BaseBusinessException("100001", "\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u5c5e\u6027\u3010msgState\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

