/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrdInvoiceQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrdLogisticsRelaQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderAccessoryQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderItemQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderMapQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrdInvoice;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderItem;
import com.tydic.dyc.oc.model.order.sub.UocOrderMap;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderPayConfQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf;
import com.tydic.dyc.oc.service.domainservice.UocMsgSplitOrderService;
import com.tydic.dyc.oc.service.domainservice.bo.UocChildSaleOrderBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrdByOrdSplitBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocMsgSplitOrderReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocMsgSplitOrderRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocOrderSkuBO;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocMoneyUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.domainservice.UocMsgSplitOrderService"})
public class UocMsgSplitOrderServiceImpl
implements UocMsgSplitOrderService {
    private static final Logger log = LoggerFactory.getLogger(UocMsgSplitOrderServiceImpl.class);
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;

    @PostMapping(value={"splitOrder"})
    public UocMsgSplitOrderRspBo splitOrder(@RequestBody UocMsgSplitOrderReqBo reqBo) {
        UocSaleOrderDo uocSaleOrderDo = this.qrySale(reqBo);
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException("101002", "\u8ba2\u5355\u62c6\u5355\u901a\u77e5\u4e1a\u52a1\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u9500\u552e\u8ba2\u5355\u4fe1\u606f!");
        }
        int count = 0;
        for (UocChildSaleOrderBO childSaleOrderRspBO : reqBo.getExtOrderInfoBO().getChildSaleOrderList()) {
            UocCreateOrdByOrdSplitBO uocCreateOrdByOrdSplitBO = new UocCreateOrdByOrdSplitBO();
            uocCreateOrdByOrdSplitBO.setUocChildSaleOrderBO(childSaleOrderRspBO);
            uocCreateOrdByOrdSplitBO.setOrderId(uocSaleOrderDo.getOrderId());
            uocCreateOrdByOrdSplitBO.setSaleId(uocSaleOrderDo.getSaleOrderId());
            uocCreateOrdByOrdSplitBO.setCount(Integer.valueOf(count));
            this.splitCoreOrder(uocCreateOrdByOrdSplitBO);
        }
        return null;
    }

    public UocSaleOrderDo qrySale(UocMsgSplitOrderReqBo reqBo) {
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setOrderId(reqBo.getDycUocQryMsgBO().getOrderId());
        return this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
    }

    public void splitCoreOrder(UocCreateOrdByOrdSplitBO uocCreateOrdByOrdSplitBO) {
        Long newOrderId = IdUtil.nextId();
        this.createOrderByChildOrder(newOrderId, uocCreateOrdByOrdSplitBO);
    }

    public void createOrderByChildOrder(Long newOrderId, UocCreateOrdByOrdSplitBO uocCreateOrdByOrdSplitBO) {
        UocChildSaleOrderBO childSaleOrderRspBO = uocCreateOrdByOrdSplitBO.getUocChildSaleOrderBO();
        Long totalFee = 0L;
        Long baseFreight = null;
        Long freight = null;
        try {
            totalFee = UocMoneyUtil.bigDecimal2Long(childSaleOrderRspBO.getOrderPrice());
            baseFreight = UocMoneyUtil.bigDecimal2Long(childSaleOrderRspBO.getBaseFreight());
            if (baseFreight == null) {
                baseFreight = 0L;
            }
            if ((freight = UocMoneyUtil.bigDecimal2Long(childSaleOrderRspBO.getFreight())) == null) {
                freight = 0L;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u901a\u8fc7\u62c6\u5355\u521b\u5efa\u5b50\u8ba2\u5355\u65f6\u5f02\u5e38\uff1a\u8f6c\u6362\u8ba2\u5355\u8d39\u7528\u9519\u8bef!");
        }
        UocOrderDo uocOrderDo = new UocOrderDo();
        this.buildOrderAndItemParam(newOrderId, uocOrderDo, uocCreateOrdByOrdSplitBO);
        this.buildInvoiceParam(newOrderId, uocOrderDo, uocCreateOrdByOrdSplitBO.getOrderId());
        this.buildAccessort(newOrderId, uocOrderDo, uocCreateOrdByOrdSplitBO.getOrderId());
        this.buildLogisticsRelaParam(newOrderId, uocOrderDo, uocCreateOrdByOrdSplitBO.getOrderId());
        this.buildOrderMapExtParam(newOrderId, uocOrderDo, uocCreateOrdByOrdSplitBO.getOrderId());
        this.iUocOrderModel.createOrder(uocOrderDo);
        UocSaleOrderDo saleOrderQryDo = new UocSaleOrderDo();
        this.buildSaleAndItemParam(newOrderId, saleOrderQryDo, uocCreateOrdByOrdSplitBO);
        this.buildPayConfig(newOrderId, saleOrderQryDo, uocCreateOrdByOrdSplitBO.getOrderId());
        this.iUocSaleOrderModel.createSaleOrder(saleOrderQryDo);
    }

    public void buildOrderAndItemParam(Long newOrderId, UocOrderDo uocOrderDo, UocCreateOrdByOrdSplitBO uocCreateOrdByOrdSplitBO) {
        Long totalFee = 0L;
        try {
            totalFee = UocMoneyUtil.bigDecimal2Long(uocCreateOrdByOrdSplitBO.getUocChildSaleOrderBO().getOrderPrice());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u901a\u8fc7\u62c6\u5355\u521b\u5efa\u5b50\u8ba2\u5355\u65f6\u5f02\u5e38\uff1a\u8f6c\u6362\u8ba2\u5355\u8d39\u7528\u9519\u8bef!");
        }
        uocOrderDo.setOrderId(uocCreateOrdByOrdSplitBO.getOrderId());
        uocOrderDo = this.iUocOrderModel.qryOrderBy(uocOrderDo);
        uocOrderDo.setOrderId(newOrderId);
        uocOrderDo.setOrderNo(String.valueOf(newOrderId));
        uocOrderDo.setOrderState("XS_CJ_CJ");
        try {
            uocOrderDo.setTotalSaleFee(MoneyUtils.Long2BigDecimal((Long)totalFee));
            uocOrderDo.setTotalPurchaseFee(MoneyUtils.Long2BigDecimal((Long)totalFee));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u901a\u8fc7\u62c6\u5355\u521b\u5efa\u5b50\u8ba2\u5355\u65f6\u5f02\u5e38\uff1a\u8f6c\u6362\u8ba2\u5355\u8d39\u7528\u9519\u8bef!");
        }
        List exSkuList = uocCreateOrdByOrdSplitBO.getUocChildSaleOrderBO().getSku();
        UocOrderItemQryBo uocOrderItemQryBo = new UocOrderItemQryBo();
        uocOrderItemQryBo.setOrderId(uocCreateOrdByOrdSplitBO.getOrderId());
        List<UocOrderItem> orderItemList = this.iUocOrderModel.qryOrderItemList(uocOrderItemQryBo);
        for (UocOrderItem orderItem : orderItemList) {
            Long ordItemId = IdUtil.nextId();
            for (UocOrderSkuBO extSkuBo : exSkuList) {
                if (!orderItem.getExtSkuId().equals(extSkuBo.getSkuId())) continue;
                orderItem.setPurchaseCount(new BigDecimal(extSkuBo.getNum()));
            }
            orderItem.setOrderId(newOrderId);
            orderItem.setOrderItemId(ordItemId);
        }
        uocOrderDo.setOrderItems(orderItemList);
    }

    public void buildInvoiceParam(Long newOrderId, UocOrderDo uocOrderDo, Long orderId) {
        UocOrdInvoiceQryBo qryBo = new UocOrdInvoiceQryBo();
        qryBo.setOrderId(orderId);
        UocOrdInvoice uocOrdInvoice = this.iUocOrderModel.qryOrderInvoice(qryBo);
        if (null != uocOrdInvoice) {
            uocOrdInvoice.setId(IdUtil.nextId());
            uocOrdInvoice.setOrderId(newOrderId);
            uocOrderDo.setUocOrdInvoice(uocOrdInvoice);
        }
    }

    public void buildAccessort(Long newOrderId, UocOrderDo uocOrderDo, Long orderId) {
        UocOrderAccessoryQryBo accessoryQryBo = new UocOrderAccessoryQryBo();
        accessoryQryBo.setOrderId(orderId);
        List<UocOrderAccessory> accessoryList = this.iUocOrderModel.getOrderAccessoryList(accessoryQryBo);
        if (ObjectUtil.isNotEmpty(accessoryList)) {
            ArrayList<UocOrderAccessory> accessories = new ArrayList<UocOrderAccessory>();
            for (UocOrderAccessory accessory : accessoryList) {
                accessory.setOrderId(newOrderId);
                accessory.setId(IdUtil.nextId());
                accessory.setCreateTime(new Date());
                if (accessory.getObjType().equals(1)) {
                    accessory.setObjId(null);
                }
                accessories.add(accessory);
            }
            uocOrderDo.setAccessoryList(accessories);
        }
    }

    public void buildLogisticsRelaParam(Long newOrderId, UocOrderDo uocOrderDo, Long orderId) {
        UocOrdLogisticsRelaQryBo logisticsRelaQryBo = new UocOrdLogisticsRelaQryBo();
        logisticsRelaQryBo.setOrderId(orderId);
        UocOrdLogisticsRela uocOrdLogisticsRela = this.iUocOrderModel.qryOrderLogisticsRela(logisticsRelaQryBo);
        if (null != uocOrdLogisticsRela) {
            uocOrdLogisticsRela.setContactId(IdUtil.nextId());
            uocOrdLogisticsRela.setOrderId(newOrderId);
        }
        uocOrderDo.setReceiverAddress(uocOrdLogisticsRela);
    }

    public void buildOrderMapExtParam(Long newOrderId, UocOrderDo uocOrderDo, Long orderId) {
        UocOrderMapQryBo orderMapQryBo = new UocOrderMapQryBo();
        orderMapQryBo.setOrderId(orderId);
        List<UocOrderMap> uocOrderMaps = this.iUocOrderModel.qryOrderMapList(orderMapQryBo);
        if (ObjectUtil.isNotEmpty(uocOrderMaps)) {
            ArrayList<UocOrderMap> poList = new ArrayList<UocOrderMap>();
            for (UocOrderMap orderMap : uocOrderMaps) {
                orderMap.setId(IdUtil.nextId());
                orderMap.setOrderId(newOrderId);
                poList.add(orderMap);
            }
            uocOrderDo.setOrderExt(poList);
        }
    }

    public void buildSaleAndItemParam(Long newOrderId, UocSaleOrderDo saleOrderQryDo, UocCreateOrdByOrdSplitBO uocCreateOrdByOrdSplitBO) {
        UocChildSaleOrderBO childSaleOrderRspBO = uocCreateOrdByOrdSplitBO.getUocChildSaleOrderBO();
        Long totalFee = 0L;
        Long baseFreight = null;
        Long freight = null;
        try {
            totalFee = UocMoneyUtil.bigDecimal2Long(childSaleOrderRspBO.getOrderPrice());
            baseFreight = UocMoneyUtil.bigDecimal2Long(childSaleOrderRspBO.getBaseFreight());
            if (baseFreight == null) {
                baseFreight = 0L;
            }
            if ((freight = UocMoneyUtil.bigDecimal2Long(childSaleOrderRspBO.getFreight())) == null) {
                freight = 0L;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u901a\u8fc7\u62c6\u5355\u521b\u5efa\u5b50\u8ba2\u5355\u65f6\u5f02\u5e38\uff1a\u8f6c\u6362\u8ba2\u5355\u8d39\u7528\u9519\u8bef!");
        }
        UocSaleOrderQryBo uocSaleOrderBo = new UocSaleOrderQryBo();
        uocSaleOrderBo.setOrderId(uocCreateOrdByOrdSplitBO.getOrderId());
        saleOrderQryDo = this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderBo);
        saleOrderQryDo.setOrderId(newOrderId);
        saleOrderQryDo.setSaleOrderId(IdUtil.nextId());
        saleOrderQryDo.setSaleOrderNo("");
        try {
            saleOrderQryDo.setTotalSaleFee(MoneyUtils.Long2BigDecimal((Long)totalFee));
            saleOrderQryDo.setTotalPurchaseFee(MoneyUtils.Long2BigDecimal((Long)totalFee));
            saleOrderQryDo.setTotalTransFee(MoneyUtils.Long2BigDecimal((Long)baseFreight));
            saleOrderQryDo.setTotalTransFee(MoneyUtils.Long2BigDecimal((Long)(baseFreight + freight)));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u901a\u8fc7\u62c6\u5355\u521b\u5efa\u5b50\u8ba2\u5355\u65f6\u5f02\u5e38\uff1a\u8f6c\u6362\u8ba2\u5355\u8d39\u7528\u9519\u8bef!");
        }
        saleOrderQryDo.setSaleOrderState("XS_CJ_CJ");
        List exSkuList = childSaleOrderRspBO.getSku();
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(uocCreateOrdByOrdSplitBO.getOrderId());
        List<UocSaleOrderItem> saleItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        for (UocSaleOrderItem saleOrderItem : saleItemList) {
            Long saleOrderItemId = IdUtil.nextId();
            for (UocOrderSkuBO extSkuBo : exSkuList) {
                if (!saleOrderItem.getSkuExtSkuId().equals(extSkuBo.getSkuId())) continue;
                saleOrderItem.setPurchaseCount(new BigDecimal(extSkuBo.getNum()));
            }
            saleOrderItem.setOrderId(newOrderId);
            saleOrderItem.setSaleOrderItemId(saleOrderItemId);
        }
        saleOrderQryDo.setSaleOrderItems(saleItemList);
    }

    public void buildPayConfig(Long newOrderId, UocSaleOrderDo saleOrderQryDo, Long orderId) {
        UocSaleOrderPayConfQryBo payConfQryBo = new UocSaleOrderPayConfQryBo();
        payConfQryBo.setOrderId(orderId);
        List<UocSaleOrderPayConf> payConfList = this.iUocSaleOrderModel.getSaleOrderPayConfList(payConfQryBo);
        if (ObjectUtil.isEmpty(payConfList)) {
            return;
        }
        UocSaleOrderPayConf uocSaleOrderPayConf = payConfList.get(0);
        uocSaleOrderPayConf.setId(IdUtil.nextId());
        uocSaleOrderPayConf.setOrderId(newOrderId);
        if (ObjectUtil.isNotEmpty((Object)uocSaleOrderPayConf.getPrePayFee())) {
            BigDecimal preFee = saleOrderQryDo.getTotalSaleFee().divide(saleOrderQryDo.getTotalSaleFee(), 2, 0).multiply(uocSaleOrderPayConf.getPrePayFee()).setScale(2, 0);
            preFee = preFee.multiply(new BigDecimal(10000));
            uocSaleOrderPayConf.setPrePayFee(preFee);
        }
        saleOrderQryDo.getSaleOrderPayConfList().add(uocSaleOrderPayConf);
    }
}

