package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryShipOrderDetailsReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryShipOrderDetailsRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryShipOrderDetailsRspDetailBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryShipOrderDetailsRspDetailItemBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 标题:UocQryShipOrderDetailsServiceImpl
 * 说明:发货单详情查询
 * 时间:2022/3/14 14:50
 * 作者:罗有
 */

@HTServiceImpl
public class UocQryShipOrderDetailsServiceImpl implements UocQryShipOrderDetailsService {

    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    //    @Autowired
//    private IUocImplOrderModel iUocImplOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Override
    public UocQryShipOrderDetailsRspBo qryShipOrderDetails(UocQryShipOrderDetailsReqBo reqBo) {
        validateArg(reqBo);
        UocQryShipOrderDetailsRspBo uocQryShipOrderDetailsRspBo = UocRu.success(UocQryShipOrderDetailsRspBo.class);
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderQryBo.setShipOrderId(reqBo.getShipOrderId());
        UocShipOrderDo uocShipOrderDo = iUocShipOrderModel.getShipOrderById(uocShipOrderQryBo);
        Map<Long, UocSaleOrderItem> saleOrderItemMap = new HashMap<>();
        if (null != uocShipOrderDo) {
            UocQryShipOrderDetailsRspDetailBo uocQryShipOrderDetailsRspDetailBo = UocRu.js(uocShipOrderDo, UocQryShipOrderDetailsRspDetailBo.class);
            uocQryShipOrderDetailsRspBo.setShipOrderInfo(uocQryShipOrderDetailsRspDetailBo);
            UocSaleOrderDo uocSaleOrderDo = getSaleOrderDo(uocShipOrderDo);
            if (null != uocSaleOrderDo) {
                if (ObjectUtil.isNotEmpty(uocSaleOrderDo.getStakeholder())) {
                    BeanUtils.copyProperties(uocSaleOrderDo.getStakeholder(), uocQryShipOrderDetailsRspDetailBo);
                    uocQryShipOrderDetailsRspDetailBo.setSaleOrderNo(uocSaleOrderDo.getSaleOrderNo());
                }
                UocSaleOrderDo uocSaleOrderItem = getSaleOrderItemList(uocSaleOrderDo);
                saleOrderItemMap = uocSaleOrderItem.getSaleOrderItems().stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));
            }


            //查询执行单明细
//            UocImplOrderQryBo qryImplBo = new UocImplOrderQryBo();
//            qryImplBo.setImplOrderId(uocShipOrderDo.getImplOrderId());
//            qryImplBo.setOrderId(uocShipOrderDo.getOrderId());
//            UocImplOrderDo implOrderMain = iUocImplOrderModel.getImplOrderMain(qryImplBo);
//            uocQryShipOrderDetailsRspDetailBo.setImplOrderNo(implOrderMain.getImplOrderNo());

//            UocImplOrderItemQryBo qryImplItemBo = new UocImplOrderItemQryBo();
//            qryImplItemBo.setImplOrderId(uocShipOrderDo.getImplOrderId());
//            qryImplItemBo.setOrderId(uocShipOrderDo.getOrderId());
//            UocImplOrderDo listImplOrderItem = iUocImplOrderModel.getListImplOrderItem(qryImplItemBo);
//            List<UocImplOrderItem> uocImplOrderItemList = listImplOrderItem.getUocImplOrderItemList();
//            Map<Long, List<UocImplOrderItem>> implItemMap = uocImplOrderItemList.stream().collect(Collectors.groupingBy(UocImplOrderItem::getImplOrderItemId));


            //查询发货明细
            UocShipOrderItemQryBo qryItemListBo = UocRu.js(reqBo, UocShipOrderItemQryBo.class);
            UocShipOrderDo listShipOrderItem = iUocShipOrderModel.getListShipOrderItem(qryItemListBo);
            if (ObjectUtil.isNotEmpty(listShipOrderItem) && ObjectUtil.isNotEmpty(listShipOrderItem.getShipOrderItemBoList())) {
                List<UocShipOrderItem> shipOrderItemBoList = listShipOrderItem.getShipOrderItemBoList();
                uocQryShipOrderDetailsRspDetailBo.setShipOrderItemBoList(new ArrayList<>());
                for (UocShipOrderItem uocShipOrderItem : shipOrderItemBoList) {
                    UocQryShipOrderDetailsRspDetailItemBo rspItemBo = new UocQryShipOrderDetailsRspDetailItemBo();
                    if (ObjectUtil.isNotEmpty(saleOrderItemMap) && saleOrderItemMap.containsKey(uocShipOrderItem.getSaleOrderItemId())) {
                        UocSaleOrderItem uocSaleOrderItem = saleOrderItemMap.get(uocShipOrderItem.getSaleOrderItemId());
                        //若发货单状态为已到货时，可售后数量=本次发货数量-已退货数量-售后中数量
                        if (UocStateConstants.ShipOrder.FH_FH_YSH.equals(uocShipOrderDo.getShipOrderState())) {
                            if (uocShipOrderItem.getSendCount() != null && uocShipOrderItem.getReturnCount() != null && uocSaleOrderItem.getAfterServingCount() != null) {
                                BigDecimal afterCountEnable = uocShipOrderItem.getSendCount().subtract(uocShipOrderItem.getReturnCount()).subtract(uocSaleOrderItem.getAfterServingCount());
                                rspItemBo.setAvailableAfServCount(afterCountEnable);
                            }
                        }
                        //若发货单状态为已验收时，可售后数量=实际验收数量-已退货数量-售后中数量
                        if (UocStateConstants.ShipOrder.FH_FH_YS.equals(uocShipOrderDo.getShipOrderState())) {
                            if (uocShipOrderItem.getInspCount() != null && uocShipOrderItem.getReturnCount() != null && uocSaleOrderItem.getAfterServingCount() != null) {
                                BigDecimal afterCountEnable = uocShipOrderItem.getInspCount().subtract(uocShipOrderItem.getReturnCount()).subtract(uocSaleOrderItem.getAfterServingCount());
                                rspItemBo.setAvailableAfServCount(afterCountEnable);
                            }
                        }
                        BeanUtils.copyProperties(uocSaleOrderItem, rspItemBo);
                    }
//                    UocImplOrderItem uocImplOrderItem = implItemMap.get(uocShipOrderItem.getImplOrderItemId()).get(0);
//                    if (uocImplOrderItem != null) {
//                        rspItemBo = UocRu.js(uocImplOrderItem, UocQryShipOrderDetailsRspDetailItemBo.class);
//                        BeanUtils.copyProperties(uocShipOrderItem,rspItemBo);
//                    } else {
//                        rspItemBo = UocRu.js(uocShipOrderItem, UocQryShipOrderDetailsRspDetailItemBo.class);
//                    }
                    BeanUtils.copyProperties(uocShipOrderItem, rspItemBo);
                    uocQryShipOrderDetailsRspDetailBo.getShipOrderItemBoList().add(rspItemBo);
                }
            }


        }
        return uocQryShipOrderDetailsRspBo;
    }

    private void validateArg(UocQryShipOrderDetailsReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocQryShipOrderDetailsReqBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[订单ID]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getShipOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[发货单ID]不能为空");
        }


    }

    private UocSaleOrderDo getSaleOrderDo(UocShipOrderDo uocShipOrderDo) {
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setSaleOrderId(uocShipOrderDo.getSaleOrderId());
        uocSaleOrderQryBo.setOrderId(uocShipOrderDo.getOrderId());
        return iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
    }

    private UocSaleOrderDo getSaleOrderItemList(UocSaleOrderDo uocSaleOrderDo) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
        uocSaleOrderItemQryBo.setOrderId(uocSaleOrderDo.getOrderId());
        return iUocSaleOrderModel.qryListSaleOrderItem(uocSaleOrderItemQryBo);
    }
}
