package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.implorder.UocImplOrderDo;
import com.tydic.dyc.oc.model.implorder.sub.UocImplOrderItem;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspItemMap;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderMap;
import com.tydic.dyc.oc.model.insporder.sub.UocShipInspRel;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.domainservice.bo.UocArrvalAcceptanceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocArrvalAcceptanceRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateInspOrderReqShipBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateInspOrderReqShipItemBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 标题:UocArrvalAcceptanceServiceImpl
 * 说明:到货验收 实现
 * 时间:2022/2/22 17:26
 * 作者:罗有
 */

@Slf4j
@HTServiceImpl
public class UocArrvalAcceptanceServiceImpl implements UocArrvalAcceptanceService {

    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    /**
     * 全部验收完成
     */
    private static final String OP_FLAG_YES = "1";
    /**
     * 未全部验收完成
     */
    private static final String OP_FLAG_NO = "0";

    @Override
    public UocArrvalAcceptanceRspBo dealArrvalAcceptance(UocArrvalAcceptanceReqBo reqBo) {
        //参数校验
        validateArg(reqBo);
        // 1 查询发货单明细
        UocShipOrderDo uocShipOrderDo = getShipOrderItemList(reqBo);
        Map<Long, UocShipOrderItem> uocShipOrderItemMap = uocShipOrderDo.getShipOrderItemBoList().stream().collect(Collectors.toMap(UocShipOrderItem::getShipOrderItemId, o -> o));
        // 2 查询发货单明细关联的销售单明细
        List<UocSaleOrderItem> uocSaleOrderItemList = getUocSaleOrderItem(reqBo, uocShipOrderDo.getShipOrderItemBoList().stream().map(UocShipOrderItem::getSaleOrderItemId).distinct().collect(Collectors.toList()));
        Map<Long, UocSaleOrderItem> uocSaleOrderItemMap = uocSaleOrderItemList.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));
        //获取发货单可验收状态
        Map<Long, Boolean> shipOrderInspStateMap = checkShipOrderInspState(reqBo, uocShipOrderItemMap, uocSaleOrderItemMap);
        Date now = new Date();
        String operId = reqBo.getUserId().toString();
        //修改发货单信息
        modifyShipOrder(reqBo, now, operId, shipOrderInspStateMap);
        //修改销售单明细验收数量和超验数量
        iUocSaleOrderModel.modifyBatchItemInspCount(convertSaleOrderDo(reqBo, now, uocShipOrderItemMap, operId));
        // 更新销售单明细超验标识
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        iUocSaleOrderModel.modifyInspSuper(uocSaleOrderDo);
        // 更新销售单关闭尾差标识
        if(reqBo.getClosePennyDiff()!= null && reqBo.getClosePennyDiff()){
            UocSaleOrderDo uocSaleOrderDo1 = new UocSaleOrderDo();
            uocSaleOrderDo1.setOrderId(reqBo.getOrderId());
            uocSaleOrderDo1.setSaleOrderId(reqBo.getSaleOrderId());
            uocSaleOrderDo1.setClosePennyDiff(UocConstant.CLOSE_PENNY_DIFF.YES);
            uocSaleOrderDo1.setUpdateOperId(reqBo.getUserId().toString());
            uocSaleOrderDo1.setUpdateOperName(reqBo.getName());
            uocSaleOrderDo1.setUpdateTime(now);
            iUocSaleOrderModel.modifySaleOrderMain(uocSaleOrderDo1);
        }
        //创验收单
        UocInspOrderDo uocInspOrderDo = convertInspOrderDo(reqBo, now, uocShipOrderItemMap, operId);
        iUocInspOrderModel.createInspOrder(uocInspOrderDo);
        boolean inspFinish = judgeSaleOrderFinishFlag(reqBo);
        // 更新销售单状态
        if(inspFinish){
            modifySaleOrderState(reqBo);
        }
        UocArrvalAcceptanceRspBo uocArrvalAcceptanceRspBo = UocRu.success(UocArrvalAcceptanceRspBo.class);
        uocArrvalAcceptanceRspBo.setFinish(inspFinish);
        uocArrvalAcceptanceRspBo.setOpFlag(inspFinish ? OP_FLAG_YES : OP_FLAG_NO);
        uocArrvalAcceptanceRspBo.setInspOrderId(uocInspOrderDo.getInspOrderId());
        uocArrvalAcceptanceRspBo.setShipOrderInspStateMap(shipOrderInspStateMap);
        return uocArrvalAcceptanceRspBo;
    }
    /**
     * 更新销售单状态，如发货单存在拒收则销售单为部分验收，否则全部验收
     */
    private void modifySaleOrderState(UocArrvalAcceptanceReqBo reqBo) {
        List<UocShipOrderDo> uocShipOrderDoList = getUocShipOrderDoList(reqBo, UocStateConstants.ShipOrder.FH_FH_JS);
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo.setUpdateOperId(reqBo.getUserId().toString());
        if (!CollectionUtils.isEmpty(uocShipOrderDoList)) {
            uocSaleOrderDo.setSaleOrderState(UocStateConstants.SaleOrder.XS_YS_BFYS);
        } else {
            uocSaleOrderDo.setSaleOrderState(UocStateConstants.SaleOrder.XS_YS_YS);
        }
        iUocSaleOrderModel.updateSaleStatusAndProCode(uocSaleOrderDo);
    }
    /**
     * 查询发货单
     */
    private List<UocShipOrderDo> getUocShipOrderDoList(UocArrvalAcceptanceReqBo reqBo, String state) {
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        uocShipOrderQryBo.setShipOrderState(state);
        return iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
    }



    /**
     * 判断销售单是否验收完成
     */
    private Boolean judgeSaleOrderFinishFlag(UocArrvalAcceptanceReqBo reqBo){
        // 如果没有选择关闭尾差，需要先校验是否发货完成
        if(reqBo.getClosePennyDiff()==null || !reqBo.getClosePennyDiff() ){
            UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
            uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
            uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
            UocSaleOrderDo uocSaleOrderDo1 = iUocSaleOrderModel.getCollectCountImplOrderItem(uocSaleOrderItemQryBo);
            UocSaleOrderItem uocSaleOrderItem = uocSaleOrderDo1.getSaleOrderItems().get(0);
            if(uocSaleOrderItem.getPurchaseCount().compareTo(uocSaleOrderItem.getSendCount())!=0){
                return false;
            }
        }
        UocShipOrderQryBo uocShipOrderQryBo = new  UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        List<UocShipOrderDo> shipOrderDos = iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
        for (UocShipOrderDo uocShipOrderDo :shipOrderDos) {
            if(uocShipOrderDo.getFinishFlag().equals(UocConstant.SHIP_ORDER_FINISH_FLAG.NOT_FINISH)){
                return false;
            }
        }
        return true;
    }


    /**
     * 获取完成验收的发货单
     */
    private Map<Long, Boolean> checkShipOrderInspState(UocArrvalAcceptanceReqBo reqBo, Map<Long, UocShipOrderItem> uocShipOrderItemMap, Map<Long, UocSaleOrderItem> uocSaleOrderItemMap) {
        Map<Long, Boolean> shipOrderInspStateMap = new HashMap<>();
        // 遍历发货单
        reqBo.getShipOrderList().forEach(uocCreateInspOrderReqShipBo -> {
            // 先默认已验收完成
            shipOrderInspStateMap.put(uocCreateInspOrderReqShipBo.getShipOrderId(),true);
            // 遍历发货单明细
            uocCreateInspOrderReqShipBo.getShipItemList().forEach(uocCreateInspOrderReqShipItemBo -> {
                UocShipOrderItem uocShipOrderItem = uocShipOrderItemMap.get(uocCreateInspOrderReqShipItemBo.getShipItemId());
                UocSaleOrderItem uocSaleOrderItem = uocSaleOrderItemMap.get(uocShipOrderItem.getSaleOrderItemId());
                BigDecimal inspectionExcessPercent = getInspectionExcessPercent(uocSaleOrderItem.getInspectionExcessPercent());
                //总可验收数量 = 发货数量 + (可超验数量-已超验数量）
                BigDecimal canInspCount = uocShipOrderItem.getSendCount().add(uocSaleOrderItem.getPurchaseCount().multiply(inspectionExcessPercent).subtract(uocSaleOrderItem.getInspSuperCount()));
                // 验收数量 = 本次验收数量+已验收数量
                BigDecimal currentInspCount = uocCreateInspOrderReqShipItemBo.getInspCount().add(uocShipOrderItem.getInspCount());
                if (currentInspCount.compareTo(canInspCount) > 0) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARRIVA_ACCEPTANCE_ERROR, "剩余可验收数量不足，请刷新页面后重新填写验收数量");
                }
                // 发货单没有验收完成:没有选择验收完成同时只要又一个发货单明细没有验收完成则发货单没有验收完成
                if((reqBo.getInspFinish()==null || ! reqBo.getInspFinish()) && currentInspCount.compareTo(uocShipOrderItem.getSendCount())<0){
                    shipOrderInspStateMap.put(uocShipOrderItem.getShipOrderId(),false);
                }
                // 计算本次超验数量 = 验收数量-发货数量
                uocShipOrderItem.setInspSuperCount(BigDecimal.ZERO);
                BigDecimal currentInspSuperCount = currentInspCount.subtract(uocShipOrderItem.getSendCount());
                if(currentInspSuperCount.compareTo(BigDecimal.ZERO)>0){
                    uocShipOrderItem.setInspSuperCount(currentInspSuperCount);
                }
            });
        });
        return shipOrderInspStateMap;
    }


    /**
     * 获取发货单可验收状态
     * @return true完全验收 false未完全验收
     */
    private boolean isFinish(Map<Long, UocShipOrderItem> uocShipOrderItemMap, Map<Long, UocSaleOrderItem> uocSaleOrderItemMap, UocCreateInspOrderReqShipBo uocCreateInspOrderReqShipBo) {
        for (UocCreateInspOrderReqShipItemBo uocCreateInspOrderReqShipItemBo : uocCreateInspOrderReqShipBo.getShipItemList()) {
            UocShipOrderItem uocShipOrderItem = uocShipOrderItemMap.get(uocCreateInspOrderReqShipItemBo.getShipItemId());
            UocSaleOrderItem uocSaleOrderItem = uocSaleOrderItemMap.get(uocShipOrderItem.getSaleOrderItemId());
            BigDecimal inspectionExcessPercent = getInspectionExcessPercent(uocSaleOrderItem.getInspectionExcessPercent());
            //1.0版本不考虑退货 TODO
            //到货数量 + 可超验数量(采购数量*超验比例) = 本次验收数量 + 已验收数量 , 则验收完结
            //全部验收的数量 = 本次验收数量 + 已验收数量
            BigDecimal inspTotalCount = uocCreateInspOrderReqShipItemBo.getInspCount().add(uocShipOrderItem.getInspCount());
            //剩余可验收数量 = 发货数量 + 可超验数量(采购数量*超验比例)
            BigDecimal canInspCount = uocShipOrderItem.getSendCount().add(uocSaleOrderItem.getPurchaseCount().multiply(inspectionExcessPercent));
            log.info("可验收数量:{}", canInspCount);
            log.info("全部验收数量:{}", inspTotalCount);
            if (inspTotalCount.compareTo(canInspCount) > 0) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARRIVA_ACCEPTANCE_ERROR, "剩余可验收数量不足，请刷新页面后重新填写验收数量");
            }
            if (inspTotalCount.compareTo(canInspCount) < 0) {
                return false;
            }
        }
        return true;
    }

    private BigDecimal getInspectionExcessPercent(Integer supInspScale) {
        BigDecimal inspectionExcessPercent = BigDecimal.ZERO;
        if (null != supInspScale) {
            inspectionExcessPercent = new BigDecimal(supInspScale).divide(BigDecimal.valueOf(100), 2, RoundingMode.HALF_UP);
        }
        return inspectionExcessPercent;
    }

    /**
     * 组装验收数据
     *
     * @param reqBo               入参BO
     * @param now                 当前时间
     * @param uocShipOrderItemMap 发货单信息
     * @param operId              当前操作人
     * @return 验收单DO
     */
    private UocInspOrderDo convertInspOrderDo(UocArrvalAcceptanceReqBo reqBo, Date now, Map<Long, UocShipOrderItem> uocShipOrderItemMap, String operId) {
//        UocImplOrderDo uocImplOrderDo = getListImplOrderItem(reqBo, uocShipOrderItemMap);
//        Map<Long, UocImplOrderItem> uocImplOrderItemMap = uocImplOrderDo.getUocImplOrderItemList().stream().collect(Collectors.toMap(UocImplOrderItem::getImplOrderItemId, o -> o));
        UocInspOrderDo uocInspOrderDo = new UocInspOrderDo();
        uocInspOrderDo.setOrderId(reqBo.getOrderId());
        uocInspOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
//        uocInspOrderDo.setImplOrderId(reqBo.getImplOrderId());
        uocInspOrderDo.setInspOrderId(IdUtil.nextId());
        uocInspOrderDo.setRemark(reqBo.getRemark());
        uocInspOrderDo.setOtherRemark(reqBo.getOtherRemark());
        uocInspOrderDo.setInspOrderNo(getInspOrderNo(reqBo));
        uocInspOrderDo.setInspOrderState(UocStateConstants.InspOrder.YS_YS_YS);
        uocInspOrderDo.setInspOper(reqBo.getName());
        uocInspOrderDo.setCreateOperId(operId);
        uocInspOrderDo.setCreateTime(now);
        uocInspOrderDo.setInspOper(reqBo.getName());
        uocInspOrderDo.setInvoiceTag(UocConstant.INVOICE_TAG.NO);
        uocInspOrderDo.setInspOperPhone(reqBo.getCellphone());
        uocInspOrderDo.setTenantId(reqBo.getTenantId());
        uocInspOrderDo.setTotalPurchaseFee(BigDecimal.ZERO);
        uocInspOrderDo.setTotalSaleFee(BigDecimal.ZERO);
        List<UocShipInspRel> uocShipInspRelList = new ArrayList<>();
        List<UocInspOrderItem> uocInspOrderItemList = new ArrayList<>();
        reqBo.getShipOrderList().forEach(uocCreateInspOrderReqShipBo -> {
            UocShipInspRel uocShipInspRel = UocRu.js(uocInspOrderDo, UocShipInspRel.class);
            uocShipInspRel.setId(IdUtil.nextId());
            uocShipInspRel.setShipOrderId(uocCreateInspOrderReqShipBo.getShipOrderId());
            uocShipInspRel.setRemark(null);
            uocShipInspRelList.add(uocShipInspRel);
            uocCreateInspOrderReqShipBo.getShipItemList().forEach(uocCreateInspOrderReqShipItemBo -> {
                UocShipOrderItem uocShipOrderItem = uocShipOrderItemMap.get(uocCreateInspOrderReqShipItemBo.getShipItemId());
//                UocImplOrderItem uocImplOrderItem = uocImplOrderItemMap.get(uocShipOrderItem.getImplOrderItemId());
                UocInspOrderItem uocInspOrderItem = UocRu.js(uocInspOrderDo, UocInspOrderItem.class);
                uocInspOrderItem.setInspOrderItemId(IdUtil.nextId());
                uocInspOrderItem.setInspCount(uocCreateInspOrderReqShipItemBo.getInspCount());
//                uocInspOrderItem.setImplOrderItemId(uocImplOrderItem.getImplOrderItemId());
                uocInspOrderItem.setSaleOrderItemId(uocShipOrderItem.getSaleOrderItemId());
                uocInspOrderItem.setShipOrderItemId(uocCreateInspOrderReqShipItemBo.getShipItemId());
                uocInspOrderItem.setUnitName(uocShipOrderItem.getUnitName());
                uocInspOrderItem.setRemark(null);
//                uocInspOrderDo.setTotalSaleFee(uocInspOrderDo.getTotalSaleFee().add(uocImplOrderItem.getSalePrice().multiply(uocCreateInspOrderReqShipItemBo.getInspCount())));
//                uocInspOrderDo.setTotalPurchaseFee(uocInspOrderDo.getTotalPurchaseFee().add(uocImplOrderItem.getPurchasePrice().multiply(uocCreateInspOrderReqShipItemBo.getInspCount())));
                if (!CollectionUtils.isEmpty(uocCreateInspOrderReqShipItemBo.getItemExtParallelBoList())) {
                    List<UocInspItemMap> uocInspItemMapList = UocRu.jsl(uocCreateInspOrderReqShipItemBo.getItemExtParallelBoList(), UocInspItemMap.class);
                    uocInspItemMapList.forEach(uocInspItemMap -> {
                        uocInspItemMap.setInspOrderId(uocInspOrderDo.getInspOrderId());
                        uocInspItemMap.setOrderId(uocInspOrderDo.getOrderId());
                        uocInspItemMap.setSaleOrderId(uocInspOrderDo.getSaleOrderId());
//                        uocInspItemMap.setImplOrderId(uocImplOrderItem.getImplOrderId());
                        uocInspItemMap.setInspOrderItemId(uocInspOrderItem.getInspOrderItemId());
                        uocInspItemMap.setCreateOperId(operId);
                        uocInspItemMap.setCreateTime(now);
                        uocInspItemMap.setId(IdUtil.nextId());
                    });
                    uocInspOrderItem.setItemExtParallelBoList(uocInspItemMapList);
                }
                uocInspOrderItemList.add(uocInspOrderItem);
            });
        });
        uocInspOrderDo.setUocShipInspRelList(uocShipInspRelList);
        uocInspOrderDo.setUocInspOrderItemList(uocInspOrderItemList);
        if (!CollectionUtils.isEmpty(reqBo.getExtParallelBoList())) {
            List<UocInspOrderMap> uocInspOrderMapList = UocRu.jsl(reqBo.getExtParallelBoList(), UocInspOrderMap.class);
            uocInspOrderMapList.forEach(uocInspOrderMap -> {
                uocInspOrderMap.setInspOrderId(uocInspOrderDo.getInspOrderId());
                uocInspOrderMap.setSaleOrderId(reqBo.getSaleOrderId());
                uocInspOrderMap.setOrderId(reqBo.getOrderId());
//                uocInspOrderMap.setImplOrderId(reqBo.getImplOrderId());
                uocInspOrderMap.setCreateOperId(operId);
                uocInspOrderMap.setCreateTime(now);
                uocInspOrderMap.setId(IdUtil.nextId());
            });
            uocInspOrderDo.setExtParallelBoList(uocInspOrderMapList);
        }
        return uocInspOrderDo;
    }

    /**
     * 查询销售单明细
     */
    private List<UocSaleOrderItem> getUocSaleOrderItem(UocArrvalAcceptanceReqBo reqBo, List<Long> saleOrderItemIdList) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderItemIdList(saleOrderItemIdList);
        uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
        UocSaleOrderDo uocSaleOrderDo = iUocSaleOrderModel.qryListSaleOrderItem(uocSaleOrderItemQryBo);
        if (CollectionUtils.isEmpty(uocSaleOrderDo.getSaleOrderItems())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARRIVA_ACCEPTANCE_ERROR, "获取销售明细为空");
        }
        return uocSaleOrderDo.getSaleOrderItems();
    }

    /**
     * 变更发货单验收数量 和 状态
     */
    private void modifyShipOrder(UocArrvalAcceptanceReqBo reqBo, Date now, String operId, Map<Long, Boolean> shipOrderInspStateMap) {
        UocShipOrderDo uocShipOrderDo = convertShipOrderDo(reqBo, now, operId, shipOrderInspStateMap);
        if (!CollectionUtils.isEmpty(uocShipOrderDo.getShipOrderIdList())) {
            iUocShipOrderModel.modifyShipOrderMain(uocShipOrderDo);
        }
        iUocShipOrderModel.modifyShipOrderItemInspCount(uocShipOrderDo);
    }

    /**
     * 组装发货单数据
     */
    private UocShipOrderDo convertShipOrderDo(UocArrvalAcceptanceReqBo reqBo, Date now, String operId, Map<Long, Boolean> shipOrderInspStateMap) {
        List<Long> shipOrderIdList = new ArrayList<>();
        List<UocShipOrderItem> shipOrderItemList = new ArrayList<>();
        reqBo.getShipOrderList().forEach(uocCreateInspOrderReqShipBo -> {
            // 已验收完成的发货单
            if (shipOrderInspStateMap.get(uocCreateInspOrderReqShipBo.getShipOrderId())) {
                shipOrderIdList.add(uocCreateInspOrderReqShipBo.getShipOrderId());
            }
            uocCreateInspOrderReqShipBo.getShipItemList().forEach(uocCreateInspOrderReqShipItemBo -> {
                UocShipOrderItem uocShipOrderItem = new UocShipOrderItem();
                uocShipOrderItem.setShipOrderItemId(uocCreateInspOrderReqShipItemBo.getShipItemId());
                uocShipOrderItem.setInspCount(uocCreateInspOrderReqShipItemBo.getInspCount());
                uocShipOrderItem.setOrderId(reqBo.getOrderId());
                uocShipOrderItem.setSaleOrderId(reqBo.getSaleOrderId());
                shipOrderItemList.add(uocShipOrderItem);
            });
        });
        UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
        uocShipOrderDo.setOrderId(reqBo.getOrderId());
        uocShipOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocShipOrderDo.setUpdateTime(now);
        uocShipOrderDo.setUpdateOperId(operId);
        if (!CollectionUtils.isEmpty(shipOrderIdList)) {
            uocShipOrderDo.setShipOrderIdList(shipOrderIdList);
            uocShipOrderDo.setInspTime(now);
            uocShipOrderDo.setShipOrderState(UocStateConstants.ShipOrder.FH_FH_YS);
            uocShipOrderDo.setInspOperId(operId);
            uocShipOrderDo.setInspOperPhone(reqBo.getCellphone());
            uocShipOrderDo.setInspOperName(reqBo.getName());
            uocShipOrderDo.setFinishFlag(UocConstant.SHIP_ORDER_FINISH_FLAG.FINISH);
        }
        uocShipOrderDo.setShipOrderItemBoList(shipOrderItemList);
        return uocShipOrderDo;
    }

    /**
     * 获取发货单明细
     */
    private UocShipOrderDo getShipOrderItemList(UocArrvalAcceptanceReqBo reqBo) {
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        List<Long> shipOrderItemIdList = new ArrayList<>();
        List<Long> shipOrderIdList = new ArrayList<>();
        reqBo.getShipOrderList().forEach(uocCreateInspOrderReqShipBo -> {
            shipOrderIdList.add(uocCreateInspOrderReqShipBo.getShipOrderId());
            uocCreateInspOrderReqShipBo.getShipItemList().forEach(uocCreateInspOrderReqShipItemBo -> shipOrderItemIdList.add(uocCreateInspOrderReqShipItemBo.getShipItemId()));
        });
        uocShipOrderItemQryBo.setShipOrderItemIdList(shipOrderItemIdList);
        uocShipOrderItemQryBo.setShipOrderIdList(shipOrderIdList);
        UocShipOrderDo uocShipOrderDo = iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
        Integer idSize = shipOrderItemIdList.size();
        if (CollectionUtils.isEmpty(uocShipOrderDo.getShipOrderItemBoList()) || !idSize.equals(uocShipOrderDo.getShipOrderItemBoList().size())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARRIVA_ACCEPTANCE_ERROR, "勾选的发货明细与查询结果不一致，请重新选择验收的商品信息");
        }
        return uocShipOrderDo;
    }

    /**
     * 组装销售单明细参数
     */
    private UocSaleOrderDo convertSaleOrderDo(UocArrvalAcceptanceReqBo reqBo, Date now, Map<Long, UocShipOrderItem> uocShipOrderItemMap, String operId) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo.setUpdateOperId(operId);
        uocSaleOrderDo.setUpdateTime(now);
        Map<Long, UocSaleOrderItem> saleItemIdMap = new HashMap<>();
        reqBo.getShipOrderList().forEach(uocCreateInspOrderReqShipBo -> uocCreateInspOrderReqShipBo.getShipItemList().forEach(uocCreateInspOrderReqShipItemBo -> {
            UocShipOrderItem uocShipOrderItem = uocShipOrderItemMap.get(uocCreateInspOrderReqShipItemBo.getShipItemId());
            UocSaleOrderItem uocSaleOrderItem = saleItemIdMap.get(uocShipOrderItem.getSaleOrderItemId());
            if(null != uocSaleOrderItem) {
                uocSaleOrderItem.setAcceptanceCount(uocSaleOrderItem.getAcceptanceCount().add(uocCreateInspOrderReqShipItemBo.getInspCount()));
                uocSaleOrderItem.setInspSuperCount(uocSaleOrderItem.getInspSuperCount().add(uocShipOrderItem.getInspSuperCount()));
            }else {
                uocSaleOrderItem = new UocSaleOrderItem();
                uocSaleOrderItem.setSaleOrderItemId(uocShipOrderItem.getSaleOrderItemId());
                uocSaleOrderItem.setAcceptanceCount(uocCreateInspOrderReqShipItemBo.getInspCount());
                uocSaleOrderItem.setInspSuperCount(uocShipOrderItem.getInspSuperCount());
            }
            saleItemIdMap.put(uocSaleOrderItem.getSaleOrderItemId(), uocSaleOrderItem);
        }));
        uocSaleOrderDo.setSaleOrderItems(new ArrayList<>(saleItemIdMap.values()));
        return uocSaleOrderDo;
    }

    /**
     * 获取验收单编号
     */
    private String getInspOrderNo(UocArrvalAcceptanceReqBo reqBo){
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo = iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        if(null == uocSaleOrderDo){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR, "查询验收单为空");
        }
        UocInspOrderDo uocInspOrderDo = new UocInspOrderDo();
        uocInspOrderDo.setOrderSource(uocSaleOrderDo.getOrderSource());
        return iUocInspOrderModel.getInspOrderNo(uocInspOrderDo).getInspOrderNo();
    }

    private void validateArg(UocArrvalAcceptanceReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单ID不能为空");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参销售单ID不能为空");
        }
        if (null == reqBo.getInspFinish()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参验收完结不能为空");
        }
        if (null == reqBo.getClosePennyDiff()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参关闭尾差不能为空");
        }
        if (null == reqBo.getUserId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参用户ID为空");
        }
        if (CollectionUtils.isEmpty(reqBo.getShipOrderList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参发货单集合不能为空");
        }
        reqBo.getShipOrderList().forEach(uocCreateInspOrderReqShipBo -> {
            if (null == uocCreateInspOrderReqShipBo.getShipOrderId()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参发货单ID不能为空");
            }
            if (CollectionUtils.isEmpty(uocCreateInspOrderReqShipBo.getShipItemList())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参发货明细不能为空");
            }
            uocCreateInspOrderReqShipBo.getShipItemList().forEach(uocCreateInspOrderReqShipItemBo -> {
                if (null == uocCreateInspOrderReqShipItemBo.getInspCount()) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参验收数量不能为空");
                }
                if (null == uocCreateInspOrderReqShipItemBo.getShipItemId()) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参发货明细ID不能为空");
                }
            });
        });
    }
}
