package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.config.UocInitConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderProcInsUpdateStatusDomainServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderProcInsUpdateStatusDomainServiceRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题:UocCreateSaleProcInsUpdateStatusDomainServiceImpl
 * 说明:单据任务提交
 * 时间:2022/2/27 9:01
 * 作者:田桂银
 */
@HTServiceImpl
public class UocCreateOrderProcInsUpdateStatusDomainServiceImpl implements UocCreateOrderProcInsUpdateStatusDomainService {

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;

    @Autowired
    private UocInitConfig uocInitConfig;

    @Override
    public UocCreateOrderProcInsUpdateStatusDomainServiceRspBo createOrderProcIns(UocCreateOrderProcInsUpdateStatusDomainServiceReqBo reqBo) {
        validateArg(reqBo);

        //根据流程id查询流程是否存在，不存在创建
        if (ObjectUtil.isNotEmpty(reqBo.getProcInstId())) {
            UocOrderProcInst qryInst = new UocOrderProcInst();
            qryInst.setProcInstId(reqBo.getProcInstId());
            qryInst.setOrderId(reqBo.getOrderId());
            List<UocOrderProcInst> uocOrderProcInsts = iUocSaleOrderModel.qryProcInsList(qryInst);
            if (ObjectUtil.isEmpty(uocOrderProcInsts)) {
                UocOrderProcInst createSaleProcIns = new UocOrderProcInst();
                createSaleProcIns.setProcInstId(reqBo.getProcInstId());
                createSaleProcIns.setOrderId(reqBo.getOrderId());
                createSaleProcIns.setProcDefId(reqBo.getProcDefId());
                createSaleProcIns.setObjId(reqBo.getObjId());
                createSaleProcIns.setObjType(reqBo.getObjType());
                createSaleProcIns.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
                iUocSaleOrderModel.createProInst(createSaleProcIns);
            }

        }
        //传了旧任务id，置为已办
        String oldTaskInstId = reqBo.getOldTaskInstId();
        if (ObjectUtil.isNotEmpty(oldTaskInstId)) {
            //判断当前状态，是否为未办理
            UocOrderTaskInst qryInst = new UocOrderTaskInst();
            qryInst.setOrderId(reqBo.getOrderId());
            qryInst.setTaskInstId(oldTaskInstId);
            List<UocOrderTaskInst> uocOrderTaskInsts = iUocSaleOrderModel.qryTaskInstList(qryInst);
            //不存在，报错
            if (ObjectUtil.isEmpty(uocOrderTaskInsts)) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_SALE_TASK_COMMIT_ERROR, "任务实例id(" + oldTaskInstId + ")不存在");
            }
            //已办，报错
            if (UocDicConstant.PROC_TASK_FINISHED.FINISHED.equals(uocOrderTaskInsts.get(0).getFinishTag())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_SALE_TASK_COMMIT_ERROR, "任务实例id(" + oldTaskInstId + ")已完结");
            }

            List<UocOrderTaskInst> updateList = new ArrayList<>();
            UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
            updateList.add(uocOrderTaskInst);
            uocOrderTaskInst.setOrderId(reqBo.getOrderId());
            uocOrderTaskInst.setTaskInstId(oldTaskInstId);
            //设置为已办
            iUocSaleOrderModel.updateProcTaskInstToFinished(updateList);
            if (null != reqBo.getFinish() && reqBo.getFinish()) {
                String flag = UocConstant.FINISH_OTHER_TAG.FINISH;
                if (!StringUtils.isBlank(reqBo.getOpFlag())) {
                    flag += "-" + reqBo.getOpFlag();
                }
                String state = uocInitConfig.getStateByTachecode(uocOrderTaskInsts.get(0).getProcState() + flag, reqBo.getObjType());
                updateState(reqBo, state);
//                List<UocOrderTaskInst> saveList = new ArrayList<>();
//                UocOrderTaskInst taskBo = new UocOrderTaskInst();
//                taskBo.setId(IdUtil.nextId());
//                taskBo.setOrderId(reqBo.getOrderId());
//                taskBo.setTaskInstId(String.valueOf(IdUtil.nextId()));
//                taskBo.setObjId(reqBo.getObjId());
//                taskBo.setObjType(reqBo.getObjType());
//                taskBo.setProcState(uocOrderTaskInsts.get(0).getProcState() + UocConstant.FINISH_OTHER_TAG.FINISH);
//                taskBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.END_TASK);
//                saveList.add(taskBo);
//                iUocSaleOrderModel.saveProcTaskInst(saveList);
            } else {
                if (CollectionUtils.isEmpty(reqBo.getNextTaskInfos())) {
                    String state = uocInitConfig.getStateByTachecode(uocOrderTaskInsts.get(0).getProcState() + "-" + reqBo.getOpFlag(), reqBo.getObjType());
                    updateState(reqBo, state);
                }
            }
        }

        //保存新任务数据
        List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> nextTaskInfos = reqBo.getNextTaskInfos();
        if (ObjectUtil.isNotEmpty(nextTaskInfos)) {
            List<UocOrderTaskDeal> saveDealList = new ArrayList<>();
            List<UocOrderTaskInst> saveList = new ArrayList<>();
            for (UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo nextTaskInfo : nextTaskInfos) {
                UocOrderTaskInst taskBo = new UocOrderTaskInst();
                taskBo.setId(IdUtil.nextId());
                taskBo.setOrderId(reqBo.getOrderId());
                taskBo.setTaskInstId(nextTaskInfo.getTaskInstId());
                taskBo.setObjId(reqBo.getObjId());
                taskBo.setObjType(reqBo.getObjType());
                taskBo.setProcState(nextTaskInfo.getTacheCode());
                taskBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
                taskBo.setFormUrl(nextTaskInfo.getFormUrl());
                taskBo.setProcDefId(reqBo.getProcDefId());
                taskBo.setProcInstId(reqBo.getProcInstId());
                saveList.add(taskBo);

                String assignee = nextTaskInfo.getAssignee();
                List<String> candidates = nextTaskInfo.getCandidates();
                //处理人和候选人
                if (ObjectUtil.isNotEmpty(assignee)) {
                    UocOrderTaskDeal deal = assembleTaskDealObj(reqBo, nextTaskInfo);
                    deal.setDealId(assignee);
                    deal.setDealClass(UocDicConstant.TASK_DEAL_CLASS.ASSIGNEE);
                    saveDealList.add(deal);
                } else if (ObjectUtil.isNotEmpty(candidates)) {
                    for (String candidate : candidates) {
                        UocOrderTaskDeal deal = assembleTaskDealObj(reqBo, nextTaskInfo);
                        deal.setDealId(candidate);
                        deal.setDealClass(UocDicConstant.TASK_DEAL_CLASS.CANDIDATE);
                        saveDealList.add(deal);
                    }
                }

                String state = uocInitConfig.getStateByTachecode(nextTaskInfo.getTacheCode(), reqBo.getObjType());
                //环节，可能不变更状态，所以需要配置了状态才更新
                updateState(reqBo, state);
            }

            if (ObjectUtil.isNotEmpty(saveDealList)) {
                iUocSaleOrderModel.saveOrderTaskDealList(saveDealList);
            }
            iUocSaleOrderModel.saveProcTaskInst(saveList);
        }
        return UocRu.success(UocCreateOrderProcInsUpdateStatusDomainServiceRspBo.class);
    }

    private void updateState(UocCreateOrderProcInsUpdateStatusDomainServiceReqBo reqBo, String state) {
        //环节，可能不变更状态，所以需要配置了状态才更新
        if (ObjectUtil.isNotEmpty(state)) {
            if (UocDicConstant.OBJ_TYPE.SHIP.equals(reqBo.getObjType())) {
                //更新销售单状态和环节编码
                UocShipOrderDo updateShipDo = new UocShipOrderDo();
                updateShipDo.setUpdateOperId(reqBo.getUserId().toString());
                updateShipDo.setOrderId(reqBo.getOrderId());
                updateShipDo.setShipOrderId(reqBo.getObjId());
                updateShipDo.setShipOrderState(state);
                if(reqBo.getFinish()){
                    updateShipDo.setFinishFlag(UocConstant.SHIP_ORDER_FINISH_FLAG.FINISH);
                }
                iUocShipOrderModel.updateShipStatusAndProCode(updateShipDo);
            }
            if (UocDicConstant.OBJ_TYPE.SALE.equals(reqBo.getObjType())) {
                //更新销售单状态和环节编码
                UocSaleOrderDo updateSaleDo = new UocSaleOrderDo();
                updateSaleDo.setUpdateOperId(reqBo.getUserId().toString());
                updateSaleDo.setOrderId(reqBo.getOrderId());
                updateSaleDo.setSaleOrderId(reqBo.getObjId());
                updateSaleDo.setSaleOrderState(state);
                iUocSaleOrderModel.updateSaleStatusAndProCode(updateSaleDo);
            }
            if (UocDicConstant.OBJ_TYPE.CHNG.equals(reqBo.getObjType())) {
                //更新销售单状态和环节编码
                UocChngOrderDo updateChngDo = new UocChngOrderDo();
                updateChngDo.setUpdateOperId(reqBo.getUserId().toString());
                updateChngDo.setOrderId(reqBo.getOrderId());
                updateChngDo.setChngOrderId(reqBo.getObjId());
                updateChngDo.setChngOrderState(state);
                iUocChngOrderModel.updateShipStatusAndProCode(updateChngDo);
            }
        }
    }

    /**
     * 描述:对象创建
     *
     * @param reqBo, nextTaskInfo 入参
     * @return com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal
     * @author tgy
     * @date 2022/3/3 17:31
     */
    private UocOrderTaskDeal assembleTaskDealObj(UocCreateOrderProcInsUpdateStatusDomainServiceReqBo reqBo, UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo nextTaskInfo) {
        UocOrderTaskDeal deal = new UocOrderTaskDeal();
        deal.setId(IdUtil.nextId());
        deal.setTaskInstId(nextTaskInfo.getTaskInstId());
        deal.setOrderId(reqBo.getOrderId());
        deal.setObjId(reqBo.getObjId());
        deal.setObjType(reqBo.getObjType());
        return deal;
    }

    private void validateArg(UocCreateOrderProcInsUpdateStatusDomainServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocCreateSaleProcInsUpdateStatusDomainServiceReqBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getUserId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性【userId】不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性【订单id】不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getObjId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性【单据ID】不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getObjType())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性【单据类型】不能为空");
        }
        if (ObjectUtil.isNotEmpty(reqBo.getNextTaskInfos())) {
            for (UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo nextTaskInfo : reqBo.getNextTaskInfos()) {
                validateUocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo(nextTaskInfo);
            }
        }

    }

    private void validateUocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo(UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getTaskInstId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性【新任务实例id】不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getTacheCode())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性【环节编码，传值就会更新销售单环节编码】不能为空");
        }
    }
}


