package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocDMsgPoolQryBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryMsgReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryMsgRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/*
 * @Author lsl
 * @Description //TODO 消息查询服务，用于消息处理
 * @Date 15:36 2022/4/11
 * @Param 
 * @return 
 */
@HTServiceImpl
@Slf4j
public class UocQryMsgServiceImpl implements UocQryMsgService{
    
    /**
     * 消息失败消息最大重复处理次数
     */
    public static final Integer MAX_FAILURE_COUNT = 5;
    
    private final static Integer QRY_EXCEPT_VOTE_MSGS = 1;
    
    @Autowired
    private IUocOrderModel iUocOrderModel;
    
    @Autowired
    private Environment environment;
    
    @Override
    public BasePageRspBo<UocQryMsgRspBo> qryMsg(UocQryMsgReqBo reqBo) {
        BasePageRspBo<UocQryMsgRspBo> rspBo = new BasePageRspBo<>();
        //入参校验
        validataArg(reqBo);
        List<UocQryMsgRspBo> uocQryMsgRspBoList = new ArrayList<>();
        if(QRY_EXCEPT_VOTE_MSGS.equals(reqBo.getQryType())){
            UocDMsgPoolQryBo uocDMsgPoolQryBo = new UocDMsgPoolQryBo();
            uocDMsgPoolQryBo.setRunResultList(reqBo.getRunResult());
            uocDMsgPoolQryBo.setFailureCount(5);//消息处理失败次数
            List<UocDMsgPoolQryBo> uocDMsgPoolQryBoList = iUocOrderModel.getListByRunResultAndFailureCount(uocDMsgPoolQryBo);
            if(ObjectUtil.isNotEmpty(uocDMsgPoolQryBoList)){
                uocQryMsgRspBoList = uocDMsgPoolQryBoList.stream().map(e->{
                    UocQryMsgRspBo uocQryMsgRspBo = uocQryMsgRspBo = JSONObject.parseObject(JSON.toJSONString(e),UocQryMsgRspBo.class);
                    return uocQryMsgRspBo;
                }).collect(Collectors.toList());
            }
            rspBo.setRecordsTotal(uocDMsgPoolQryBoList.size());
            rspBo.setRows(uocQryMsgRspBoList);
        }else{
            //限制查询
            List<Integer> objTypeList = new ArrayList<>();
            objTypeList.add(3);//外部消息类型 发货单
/*            if (environment.getProperty("SUPPLIER_JD_ID").equals(String.valueOf(supNo))
                    || environment.getProperty("").equals(String.valueOf(supNo))) {
                objTypeList.add(1);//外部消息类型 京东、苏宁按销售单处理
            }*/
            UocDMsgPoolQryBo uocDMsgPoolQryBo = new UocDMsgPoolQryBo();
            uocDMsgPoolQryBo.setRunResultList(reqBo.getRunResult());
            uocDMsgPoolQryBo.setObjTypeList(objTypeList);
            List<UocDMsgPoolQryBo> uocDMsgPoolQryBoList = iUocOrderModel.getVoteMsgList(uocDMsgPoolQryBo);
            if(ObjectUtil.isNotEmpty(uocDMsgPoolQryBoList)){
                uocQryMsgRspBoList = uocDMsgPoolQryBoList.stream().map(e->{
                    UocQryMsgRspBo uocQryMsgRspBo = JSONObject.parseObject(JSON.toJSONString(e),UocQryMsgRspBo.class);
                    return uocQryMsgRspBo;
                }).collect(Collectors.toList());
            }
            rspBo.setRecordsTotal(uocDMsgPoolQryBoList.size());
            rspBo.setRows(uocQryMsgRspBoList);
        }
        return rspBo;
    }
    public void validataArg(UocQryMsgReqBo reqBo){
        if(ObjectUtil.isEmpty(reqBo)){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if(ObjectUtil.isEmpty(reqBo.getRunResult())){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性执行状态[runResult]不能为空");
        }
    }
}
