package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryOrderCreateResultServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryOrderCreateResultServiceRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryOrderCreateResultServiceRspProcessDataBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题:UocQryOrderCreateResultServiceImpl
 * 说明:
 * 时间:2022/2/27 14:59
 * 作者:田桂银
 */
@HTServiceImpl
public class UocQryOrderCreateResultServiceImpl implements UocQryOrderCreateResultService {

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Override
    public UocQryOrderCreateResultServiceRspBo qryOrderCreateResult(UocQryOrderCreateResultServiceReqBo reqBo) {
        validateArg(reqBo);
        UocQryOrderCreateResultServiceRspBo rspBo = UocRu.success(UocQryOrderCreateResultServiceRspBo.class);
        UocOrderDo qryOrderDo = new UocOrderDo();
        qryOrderDo.setOrderId(reqBo.getOrderId());
        UocOrderDo uocOrderDo = iUocOrderModel.qryOrderBy(qryOrderDo);
        if (ObjectUtil.isEmpty(uocOrderDo)) {
            return rspBo;
        }
        rspBo.setOrderId(reqBo.getOrderId());
        rspBo.setOrderNo(uocOrderDo.getOrderNo());
        rspBo.setTotalSaleFee(uocOrderDo.getTotalSaleFee());

        //是否处理成功
        boolean processResult = true;
        rspBo.setSuccessList(new ArrayList<>());
        rspBo.setFailedList(new ArrayList<>());
        UocSaleOrderDo qrySaleDo = UocRu.js(reqBo, UocSaleOrderDo.class);
        List<UocSaleOrderDo> uocSaleOrderDos = iUocSaleOrderModel.qrySaleOrderList(qrySaleDo);
        for (UocSaleOrderDo uocSaleOrderDo : uocSaleOrderDos) {
            //销售单不为空，代表该销售单处理完成了
            // 下单结果不为成功则失败
            if (!UocConstant.CREATED_RESULT.SUCCESS.equals(uocSaleOrderDo.getCreatedResult())) {
                processResult = false;
            }
            //如果销售单取消原因不为空，或者状态为取消状态，说明消费者处理失败了（取消订单）。
            UocQryOrderCreateResultServiceRspProcessDataBo resultDataBo = new UocQryOrderCreateResultServiceRspProcessDataBo();
            if (ObjectUtil.isNotEmpty(uocSaleOrderDo.getCancelReason()) || UocStateConstants.SaleOrder.XS_QX_QX.equals(uocSaleOrderDo.getSaleOrderState())) {
                resultDataBo.setMsg(uocSaleOrderDo.getCancelReason());
                rspBo.getFailedList().add(resultDataBo);
            } else {
                rspBo.getSuccessList().add(resultDataBo);
            }
            resultDataBo.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
            resultDataBo.setSaleOrderNo(uocSaleOrderDo.getSaleOrderNo());
            resultDataBo.setSupNo(uocSaleOrderDo.getStakeholder().getSupId());
            resultDataBo.setSupName(uocSaleOrderDo.getStakeholder().getSupName());
        }
        rspBo.setProcessResult(processResult);
        return rspBo;
    }

    private void validateArg(UocQryOrderCreateResultServiceReqBo reqBo) {

        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocQryOrderCreateResultServiceReqBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性【订单id】不能为空");
        }

    }
}


