package com.tydic.dyc.oc.service.domainservice;


import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocConfTabOrdStateQryBo;
import com.tydic.dyc.oc.model.order.sub.UocConfTabOrdState;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryTableConfiguredStateServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryTableConfiguredStateServiceRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocTableStateBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.*;

/**
 * 标题:UocQryTableConfiguredStateService
 * 说明:订单页签查询配置状态服务实现
 * 时间:2022/3/11 9:40
 * 作者:tkl
 */
@HTServiceImpl
public class UocQryTableConfiguredStateServiceImpl implements UocQryTableConfiguredStateService {

    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Override
    public UocQryTableConfiguredStateServiceRspBo queryTableConfigState(UocQryTableConfiguredStateServiceReqBo reqBo) {
        //入参校验
        validateArg(reqBo);
        UocQryTableConfiguredStateServiceRspBo rspBo = UocRu.success(UocQryTableConfiguredStateServiceRspBo.class);
        List<UocTableStateBo> tabStateList = new ArrayList<>();
        //查询页签状态配置信息
        UocConfTabOrdStateQryBo uocConfTabOrdStateQryBo = UocRu.js(reqBo, UocConfTabOrdStateQryBo.class);
        uocConfTabOrdStateQryBo.setOrderBy("sort");
        List<UocConfTabOrdState> uocConfTabOrdStates = iUocOrderModel.qryConfTabOrdStateList(uocConfTabOrdStateQryBo);
        if (ObjectUtil.isNotEmpty(uocConfTabOrdStates)) {
            //根据tabId分组状态
            Map<Integer, List<String>> tabStateMap = new HashMap<>();
            Map<Integer, List<String>> tabSubStateMap = new HashMap<>();
            Map<Integer, List<String>> tabStatusMap = new HashMap<>();
            uocConfTabOrdStates.forEach(each -> {
                if (ObjectUtil.isNotEmpty(each.getOrderStatusCode())) {
                    tabStateMap.put(each.getTabId(), Arrays.asList(StringUtils.split(each.getOrderStatusCode(), ",")));
                }
                if (ObjectUtil.isNotEmpty(each.getSubOrderStatusCode())) {
                    tabSubStateMap.put(each.getTabId(), Arrays.asList(StringUtils.split(each.getSubOrderStatusCode(), ",")));
                }
                if (ObjectUtil.isNotEmpty(each.getOrderStatus())) {
                    tabStatusMap.put(each.getTabId(), Arrays.asList(StringUtils.split(each.getOrderStatus(), ",")));
                }
            });
            tabStateList = UocRu.jsl(uocConfTabOrdStates,UocTableStateBo.class);
            for (UocTableStateBo bo : tabStateList) {
                if (ObjectUtil.isNotEmpty(tabStateMap) && tabStateMap.containsKey(bo.getTabId())) {
                    bo.setTabStateList(tabStateMap.get(bo.getTabId()));
                }
                if (ObjectUtil.isNotEmpty(tabSubStateMap) && tabSubStateMap.containsKey(bo.getTabId())) {
                    bo.setTabSubStateList(tabSubStateMap.get(bo.getTabId()));
                }
                if (ObjectUtil.isNotEmpty(tabStatusMap) && tabStatusMap.containsKey(bo.getTabId())) {
                    bo.setTabStatusList(tabStatusMap.get(bo.getTabId()));
                }
            }
        }
        rspBo.setTableStateBoList(tabStateList);
        return rspBo;
    }

    private void validateArg(UocQryTableConfiguredStateServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocQryTableConfiguredStateServiceReqBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getTabIdList()) && ObjectUtil.isEmpty(reqBo.getMenuCode())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[页签IdList]和[menuCode]不能同时为空");
        }
    }

}


