package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleShipOrderReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleShipOrderReqItemBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleShipOrderRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 标题:UocImplShipOrderServiceImpl
 * 说明:执行单发货 实现
 * 时间:2022/2/22 14:51
 * 作者:罗有
 */

@HTServiceImpl
public class UocSaleShipOrderServiceImpl implements UocSaleShipOrderService {

    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    //    @Autowired
//    private IUocImplOrderModel iUocImplOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    /**
     * 已发完货
     */
    private static final String OP_FLAG_YES = "1";
    /**
     * 未发完货
     */
    private static final String OP_FLAG_NO = "0";

    @Override
    public UocSaleShipOrderRspBo dealImplShipOrder(UocSaleShipOrderReqBo reqBo) {
        //参数校验
        validateArg(reqBo);
        Date now = new Date();
//        List<UocImplOrderItem> uocImplOrderItemList = getUocImplOrderItemList(reqBo);
        List<UocSaleOrderItem> uocSaleOrderItemList = getUocSaleOrderItemList(reqBo);
        UocSaleOrderDo uocSaleOrderDo = getUocSaleOrderDo(reqBo);
        UocShipOrderDo uocShipOrderDo = convertShipOrderDo(reqBo, now, uocSaleOrderItemList, uocSaleOrderDo);
        iUocShipOrderModel.createShipOrder(uocShipOrderDo);
        iUocSaleOrderModel.modifyBatchItemSendCount(convertSaleOrderDo(reqBo, now));
        UocSaleShipOrderRspBo uocImplShipOrderRspBo = UocRu.success(UocSaleShipOrderRspBo.class);
        if (UocStateConstants.SaleOrder.XS_FH_DFH.equals(uocSaleOrderDo.getSaleOrderState())) {
            modifySaleState(reqBo);
        }
        boolean finish = checkSaleOrderIsFinish(reqBo);
        uocImplShipOrderRspBo.setFinish(finish);
        uocImplShipOrderRspBo.setOpFlag(finish ? OP_FLAG_YES : OP_FLAG_NO);
        uocImplShipOrderRspBo.setShipOrderId(uocShipOrderDo.getShipOrderId());
        uocImplShipOrderRspBo.setShipOrderNo(uocShipOrderDo.getShipOrderNo());
        return uocImplShipOrderRspBo;
    }



    /**
     * 销售单状态变更
     */
    private void modifySaleState(UocSaleShipOrderReqBo reqBo) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo.setUpdateOperId(reqBo.getUserId().toString());
        uocSaleOrderDo.setSaleOrderState(UocStateConstants.SaleOrder.XS_FH_FHZ);
        iUocSaleOrderModel.updateSaleStatusAndProCode(uocSaleOrderDo);
    }

    private boolean checkSaleOrderIsFinish(UocSaleShipOrderReqBo reqBo) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocSaleOrderDo uocSaleOrderDo = iUocSaleOrderModel.getCollectCountImplOrderItem(uocSaleOrderItemQryBo);
        if (CollectionUtils.isEmpty(uocSaleOrderDo.getSaleOrderItems())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARRIVA_CONFIRM_REFUSE_ERROR, "查询数量汇总为空");
        }
        UocSaleOrderItem uocSaleOrderItem = uocSaleOrderDo.getSaleOrderItems().get(0);
        if (null == uocSaleOrderItem) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARRIVA_CONFIRM_REFUSE_ERROR, "查询数量汇总为空");
        }
        //采购数量 = 发货数量 + 退货数量 则发货完成
        if (uocSaleOrderItem.getPurchaseCount().compareTo(uocSaleOrderItem.getSendCount().add(uocSaleOrderItem.getReturnCount())) == 0) {
            return true;
        }
        return false;
    }


//    /**
//     * 组装执行单DO参数
//     *
//     * @param reqBo 入参
//     * @param now   当前时间
//     * @return 执行单DO
//     */
//    private UocImplOrderDo convertImplOrderDo(UocImplShipOrderReqBo reqBo, Date now) {
//        UocImplOrderDo uocImplOrderDo = new UocImplOrderDo();
//        uocImplOrderDo.setOrderId(reqBo.getOrderId());
//        uocImplOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
//        uocImplOrderDo.setUpdateOperId(reqBo.getUserId().toString());
//        uocImplOrderDo.setUpdateTime(now);
//        uocImplOrderDo.setUocImplOrderItemList(reqBo.getShipOrderItemBoList().stream().map(uocImplShipOrderReqItemBo -> {
//            UocImplOrderItem uocImplOrderItem = new UocImplOrderItem();
//            uocImplOrderItem.setImplOrderItemId(uocImplShipOrderReqItemBo.getImplOrderItemId());
//            uocImplOrderItem.setSendCount(uocImplShipOrderReqItemBo.getSendCount());
//            return uocImplOrderItem;
//        }).collect(Collectors.toList()));
//        return uocImplOrderDo;
//    }
    /**
     * 组装销售单DO参数
     *
     * @param reqBo 入参
     * @param now   当前时间
     * @return 执行单DO
     */
    private UocSaleOrderDo convertSaleOrderDo(UocSaleShipOrderReqBo reqBo, Date now) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo.setUpdateOperId(reqBo.getUserId().toString());
        uocSaleOrderDo.setUpdateTime(now);
        uocSaleOrderDo.setSaleOrderItems(reqBo.getShipOrderItemBoList().stream().map(uocImplShipOrderReqItemBo -> {
            UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
            uocSaleOrderItem.setSaleOrderItemId(uocImplShipOrderReqItemBo.getSaleOrderItemId());
            uocSaleOrderItem.setSendCount(uocImplShipOrderReqItemBo.getSendCount());
            return uocSaleOrderItem;
        }).collect(Collectors.toList()));
        return uocSaleOrderDo;
    }

    /**
     * 组装发货单DO参数
     *
     * @param reqBo                入参
     * @param now                  当前时间
     * @param uocImplOrderItemList
     * @param uocSaleOrderDo
     * @return 发货单DO
     */
    private UocShipOrderDo convertShipOrderDo(UocSaleShipOrderReqBo reqBo, Date now, List<UocSaleOrderItem> uocImplOrderItemList, UocSaleOrderDo uocSaleOrderDo) {
        Map<Long, UocSaleOrderItem> uocSaleOrderItemMap = uocImplOrderItemList.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));
        UocShipOrderDo uocShipOrderDo = UocRu.js(reqBo, UocShipOrderDo.class);
        uocShipOrderDo.setShipOrderState(UocStateConstants.ShipOrder.FH_FH_FH);
        uocShipOrderDo.setShipOperId(reqBo.getUserId().toString());
        uocShipOrderDo.setCreateOperId(reqBo.getUserId().toString());
        uocShipOrderDo.setCreateTime(now);
        uocShipOrderDo.setShipOrderId(IdUtil.nextId());
        uocShipOrderDo.setSupNo(uocImplOrderItemList.get(0).getSupplierId());
        uocShipOrderDo.setShipOrderNo(getShipOrderNo(reqBo, uocSaleOrderDo));
        if (!CollectionUtils.isEmpty(reqBo.getExtParallelBoList())) {
            uocShipOrderDo.getExtParallelBoList().forEach(uocShipOrderMap -> {
                uocShipOrderMap.setId(IdUtil.nextId());
                uocShipOrderMap.setOrderId(reqBo.getOrderId());
                uocShipOrderMap.setSaleOrderId(reqBo.getSaleOrderId());
                uocShipOrderMap.setShipOrderId(uocShipOrderDo.getShipOrderId());
//                uocShipOrderMap.setImplOrderId(reqBo.getImplOrderId());
                uocShipOrderMap.setCreateOperId(reqBo.getUserId().toString());
                uocShipOrderMap.setCreateTime(now);
            });

        }
        if (!CollectionUtils.isEmpty(reqBo.getOrderAccessoryBoList())) {
            List<UocOrderAccessory> uocOrderAccessoryList = UocRu.jsl(reqBo.getOrderAccessoryBoList(), UocOrderAccessory.class);
            uocOrderAccessoryList.forEach(uocOrderAccessory -> {
                uocOrderAccessory.setOrderId(reqBo.getOrderId());
                uocOrderAccessory.setCreateTime(now);
                uocOrderAccessory.setCreateOperId(reqBo.getUserId().toString());
                uocOrderAccessory.setId(IdUtil.nextId());
                uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
                uocOrderAccessory.setObjId(uocShipOrderDo.getShipOrderId());
            });
            uocShipOrderDo.setOrderAccessoryBoList(uocOrderAccessoryList);
        }
        uocShipOrderDo.getShipOrderItemBoList().forEach(uocShipOrderItem -> {
            UocSaleOrderItem uocSaleOrderItem = uocSaleOrderItemMap.get(uocShipOrderItem.getSaleOrderItemId());
            if (uocShipOrderItem.getSendCount().add(uocSaleOrderItem.getSendCount()).compareTo(uocSaleOrderItem.getPurchaseCount()) > 0) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR, "存在已发货完成的商品，请重新选择商品发货");
            }
            uocShipOrderItem.setShipOrderId(uocShipOrderDo.getShipOrderId());
            uocShipOrderItem.setOrderId(uocShipOrderDo.getOrderId());
            uocShipOrderItem.setSaleOrderId(uocShipOrderDo.getSaleOrderId());
//            uocShipOrderItem.setImplOrderId(uocShipOrderDo.getImplOrderId());
            uocShipOrderItem.setSaleOrderItemId(uocSaleOrderItem.getSaleOrderItemId());
            uocShipOrderItem.setUnitName(uocSaleOrderItem.getUnitName());
            uocShipOrderItem.setCreateOperId(reqBo.getUserId().toString());
            uocShipOrderItem.setCreateTime(now);
            uocShipOrderItem.setShipOrderItemId(IdUtil.nextId());
            if (!CollectionUtils.isEmpty(uocShipOrderItem.getItemExtParallelBoList())) {
                uocShipOrderItem.getItemExtParallelBoList().forEach(uocShipItemMap -> {
                    uocShipItemMap.setId(IdUtil.nextId());
                    uocShipItemMap.setOrderId(reqBo.getOrderId());
                    uocShipItemMap.setSaleOrderId(reqBo.getSaleOrderId());
//                    uocShipItemMap.setImplOrderId(uocShipOrderItem.getImplOrderId());
                    uocShipItemMap.setShipOrderItemId(uocShipOrderItem.getShipOrderItemId());
                    uocShipItemMap.setShipOrderId(uocShipOrderItem.getShipOrderId());
                    uocShipItemMap.setId(IdUtil.nextId());
                    uocShipItemMap.setCreateTime(now);
                    uocShipItemMap.setCreateOperId(reqBo.getUserId().toString());
                });
            }
        });
        return uocShipOrderDo;
    }


    /**
     * 查询销售单明细
     * @author wenle
     * @date 2022-04-02 14:11:19
     * @param reqBo 入参
     * @return java.util.List<com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem>
     */
    private List<UocSaleOrderItem> getUocSaleOrderItemList(UocSaleShipOrderReqBo reqBo) {
        List<Long> saleOrderItemIds = reqBo.getShipOrderItemBoList().stream().map(UocSaleShipOrderReqItemBo::getSaleOrderItemId).collect(Collectors.toList());
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderItemIdList(saleOrderItemIds);
        uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocSaleOrderDo uocSaleOrderDo  = iUocSaleOrderModel.getListSaleOrderItem(uocSaleOrderItemQryBo);
        List<UocSaleOrderItem> saleOrderItems = uocSaleOrderDo.getSaleOrderItems();
        if (CollectionUtils.isEmpty(saleOrderItems)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR, "获取销售单明细为空");
        }
        return saleOrderItems;
    }
//    private List<UocImplOrderItem> getUocImplOrderItemList(UocImplShipOrderReqBo reqBo) {
//        List<Long> implOrderItemIds = reqBo.getShipOrderItemBoList().stream().map(UocImplShipOrderReqItemBo::getImplOrderItemId).collect(Collectors.toList());
//        UocImplOrderItemQryBo uocImplOrderItemQryBo = new UocImplOrderItemQryBo();
//        uocImplOrderItemQryBo.setImplOrderItemIdList(implOrderItemIds);
//        uocImplOrderItemQryBo.setOrderId(reqBo.getOrderId());
//        uocImplOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
//        UocImplOrderDo uocImplOrderDo = iUocImplOrderModel.getListImplOrderItem(uocImplOrderItemQryBo);
//        List<UocImplOrderItem> uocImplOrderItemList = uocImplOrderDo.getUocImplOrderItemList();
//        if (CollectionUtils.isEmpty(uocImplOrderItemList)) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR, "获取执行单明细为空");
//        }
//        return uocImplOrderItemList;
//    }

    private String getShipOrderNo(UocSaleShipOrderReqBo reqBo, UocSaleOrderDo uocSaleOrderDo) {
        UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
        uocShipOrderDo.setOrderSource(uocSaleOrderDo.getOrderSource());
        uocShipOrderDo = iUocShipOrderModel.getShipOrderNo(uocShipOrderDo);
        return uocShipOrderDo.getShipOrderNo();
    }

    private UocSaleOrderDo getUocSaleOrderDo(UocSaleShipOrderReqBo reqBo) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo = iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR, "查询验收单为空");
        }
        return uocSaleOrderDo;
    }

    private void validateArg(UocSaleShipOrderReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象为空");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单ID为空");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参销售单ID为空");
        }
        if (null == reqBo.getShipCompanyNo()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参配送单号为空");
        }
        if (null == reqBo.getShipName()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参发货联系人为空");
        }
        if (null == reqBo.getShipPhone()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参联系人电话为空");
        }
        if (null == reqBo.getShipTime()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参发货日期为空");
        }
        if (null == reqBo.getEstimateArrivalTime()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参预计到货日期为空");
        }
        if (null == reqBo.getUserId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参用户ID为空");
        }
//        if (StringUtils.isBlank(reqBo.getTacheCode())) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参环节编码不能为空");
//        }

    }
}

