package com.tydic.dyc.oc.model.order.sub;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;


/**
 * @author 尹栋梁
 */
@Data
public class UocConfSupplier implements Serializable {
    private static final long serialVersionUID = 7696804512059506485L;
    /**
     * 供应商ID主键(必填项)
     */
    private Long confId;

    /**
     * 供应商ID主键(必填项)
     */
    private Long supNo;
    /**
     * 供应商名称
     */
    private String supName;
    /**
     * 供应商标识
     */
    private String supType;
    /**
     * 是否一次性发货
     * //            0 否
     * //            1 是
     */
    private Integer isOnceSendAll;
    /**
     * 订单超限额度
     */
    private Long orderQuota;
    /**
     * 订单超限额度 开始
     */
    private Long orderQuotaStart;
    /**
     * 订单超限额度 结束
     */
    private Long orderQuotaEnd;
    /**
     * 校验模式
     */
    private Integer checkFlag;
    /**
     * 接收消息类型
     */
    private String dealType;
    /**
     * 是否完结通知
     * //                        0 否
     * //                        1 是
     */
    private Integer completionFlag;
    /**
     * 业务类型编码
     */
    private String businessTypeCode;
    /**
     * 操作时间
     */
    private Date operatingTime;
    /**
     * 操作时间 开始
     */
    private Date operatingTimeStart;
    /**
     * 操作时间 结束
     */
    private Date operatingTimeEnd;
    /**
     * 操作人ID
     */
    private String operatorId;
    /**
     * 操作人名称
     */
    private String operatorName;
    /**
     * 订单限额额度
     */
    private Long orderLimit;
    /**
     * 订单限额状态：0：生效；1：失效
     */
    private Integer limitStatus;
    /**
     * 排序
     */
    private String orderBy;

    /**
     * 供应商编号列表
     */
    private List<Long> supplierNos;
}