package com.tydic.dyc.oc.service.cmporder;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.cmporder.IUocCmpOrderModel;
import com.tydic.dyc.oc.model.cmporder.UocCmpOrderDo;
import com.tydic.dyc.oc.model.cmporder.qrybo.UocCmpOrderItemQryBo;
import com.tydic.dyc.oc.model.cmporder.qrybo.UocCmpOrderQryBo;
import com.tydic.dyc.oc.model.cmporder.sub.UocCmpOrderItem;
import com.tydic.dyc.oc.service.cmporder.bo.UocGetCmpOrderDetailServiceReqBo;
import com.tydic.dyc.oc.service.cmporder.bo.UocGetCmpOrderDetailServiceRspDetailBo;
import com.tydic.dyc.oc.service.cmporder.bo.UocGetCmpOrderDetailServiceRspItemBo;
import com.tydic.dyc.oc.service.cmporder.bo.UocGetCmpOrderDetailServiceRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 标题：类名称:UocQryCmpOrderDetailServiceImpl
 * 说明：描述一下类的作用TODO
 * 时间：2022/3/29 14:16
 * 作者 @author 尹栋梁
 */
@HTServiceImpl
public class UocQryCmpOrderDetailServiceImpl implements UocGetCmpOrderDetailService{

    @Autowired
    private IUocCmpOrderModel uocCmpOrderModel;
    @Override
    public UocGetCmpOrderDetailServiceRspBo qryCmpOrderDetail(UocGetCmpOrderDetailServiceReqBo reqBo) {
        validateArg(reqBo);
        UocGetCmpOrderDetailServiceRspBo rspBo = UocRu.success(UocGetCmpOrderDetailServiceRspBo.class);
        UocCmpOrderQryBo uocCmpOrderQryBo = new UocCmpOrderQryBo();
        uocCmpOrderQryBo.setCmpOrderNo(reqBo.getCmpOrderNo());
        UocCmpOrderQryBo cmpOrderDetail = uocCmpOrderModel.qryCmpOrder(uocCmpOrderQryBo);
        if (ObjectUtil.isNotEmpty(cmpOrderDetail)) {
            UocGetCmpOrderDetailServiceRspDetailBo cmpOrderBo = UocRu.js(cmpOrderDetail, UocGetCmpOrderDetailServiceRspDetailBo.class);
            List<UocCmpOrderItemQryBo> uocCmpOrderItemList = cmpOrderDetail.getUocCmpOrderItemList();
            if (CollectionUtil.isNotEmpty(uocCmpOrderItemList)) {
                cmpOrderBo.setUocCmpOrderItemList(UocRu.jsl(uocCmpOrderItemList, UocGetCmpOrderDetailServiceRspItemBo.class));
            }
            rspBo.setCmpOrderDetailinfo(cmpOrderBo);
        }
        return rspBo;
    }

    private void validateArg(UocGetCmpOrderDetailServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocGetCmpOrderDetailServiceReqBo]不能为空");
        }
        if (reqBo.getCmpOrderNo() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[比价单编号]不能为空");
        }
    }
}
