package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderCheckAccountQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderCheckAccount;
import com.tydic.dyc.oc.service.domainservice.bo.UocOrderSyncCheckStatusReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocOrderSyncCheckStatusRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：UocOrderSyncCheckStatusServiceImpl
 * 说明：订单对账状态更新
 * 时间：2022/4/1 19:38
 *
 * @author 文乐
 */
@HTServiceImpl
public class UocOrderSyncCheckStatusServiceImpl implements UocOrderSyncCheckStatusService{

    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Override
    public UocOrderSyncCheckStatusRspBo dealSyncCheckStatus(UocOrderSyncCheckStatusReqBo reqBo) {
        validateArg(reqBo);
        // 查询是否存在
        UocOrderCheckAccountQryBo uocOrderCheckAccountQryBo = new UocOrderCheckAccountQryBo();
        uocOrderCheckAccountQryBo.setOrderId(reqBo.getOrderId());
        uocOrderCheckAccountQryBo.setObjId(reqBo.getObjId());
        uocOrderCheckAccountQryBo.setObjType(reqBo.getObjType());
        UocOrderCheckAccount uocOrderCheckAccount = iUocOrderModel.qryCheckInfo(uocOrderCheckAccountQryBo);

        if ( null != uocOrderCheckAccount ) {
            // 更新
            UocOrderCheckAccount update = new UocOrderCheckAccount();
            update.setId(uocOrderCheckAccount.getId());
            update.setCheckState(reqBo.getCheckState());
            iUocOrderModel.updateCheckInfo(update);
        } else {
            // 创建
            UocOrderCheckAccount insert = UocRu.js(reqBo, UocOrderCheckAccount.class);
            insert.setId(IdUtil.nextId());
            iUocOrderModel.createCheckInfo(insert);
        }

        return UocRu.success(UocOrderSyncCheckStatusRspBo.class);
    }

    private void validateArg(UocOrderSyncCheckStatusReqBo reqBo) {
        if (null == reqBo.getCheckState()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "checkState不能为空");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "orderId不能为空");
        }
        if (null == reqBo.getObjId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "objId不能为空");
        }
        if (null == reqBo.getObjType()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "objType不能为空");
        }
    }
}
