package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.es.UocEsSyncManager;
import com.tydic.dyc.oc.components.es.UocEsSyncManagerSaveDataReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.payorder.IUocPayOrderModel;
import com.tydic.dyc.oc.model.payorder.sub.UocOrderShouldPay;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.domainservice.bo.UocShouldPayCreateBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocShouldPayCreateReqBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocShouldPayCreateRspBO;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 标题：UocShouldPayCreateServiceImpl
 * 说明：订单应付单创建
 * 时间：2022/4/8 14:56
 * 作者： 周中贤
 */
@Slf4j
@HTServiceImpl
public class UocShouldPayCreateServiceImpl implements UocShouldPayCreateService {

    @Autowired
    private IUocPayOrderModel iUocPayOrderModel;
    @Autowired
    private UocIndexConfig uocIndexConfig;
    @Autowired
    private UocEsSyncManager uocEsSyncManager;

    /**
     * 订单应付单创建
     */
    @Override
    public UocShouldPayCreateRspBO create(UocShouldPayCreateReqBO reqBO) {
        if (reqBO == null || CollectionUtils.isEmpty(reqBO.getUocShouldPayCreateBoList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        //应付单入库
        for (UocShouldPayCreateBo item : reqBO.getUocShouldPayCreateBoList()) {
            UocOrderShouldPay uocOrderShouldPay = UocRu.js(item, UocOrderShouldPay.class);
            //生成订单应付单id
            uocOrderShouldPay.setShouldPayId(IdUtil.nextId());
            //创建时间
            uocOrderShouldPay.setCreateTime(new Date());
            //未支付状态
            uocOrderShouldPay.setIsPayCompleted(UocDicConstant.SHOULD_PAY_ORDER_PAY_STATE.NOT_PAY_COMPLETED);
            iUocPayOrderModel.createShouldPayOrder(uocOrderShouldPay);
        }
        //同步ES
        for (UocShouldPayCreateBo item : reqBO.getUocShouldPayCreateBoList()) {
            if (UocDicConstant.OBJ_TYPE.SALE.equals(reqBO.getObjectType())) {
                //单据类型为’销售单‘时，同步销售单ES
                //1、查询未支付状态的应付单
                UocOrderShouldPay uocOrderShouldPay = new UocOrderShouldPay();
                uocOrderShouldPay.setOrderId(item.getOrderId());
                uocOrderShouldPay.setObjectId(item.getObjectId());
                uocOrderShouldPay.setObjectType(UocDicConstant.OBJ_TYPE.SALE);
                uocOrderShouldPay.setIsPayCompleted(UocDicConstant.SHOULD_PAY_ORDER_PAY_STATE.NOT_PAY_COMPLETED);
                List<UocOrderShouldPay> listOrderShouldPay = iUocPayOrderModel.getListOrderShouldPay(uocOrderShouldPay);
                if (!CollectionUtils.isEmpty(listOrderShouldPay)) {
                    JSONArray jsonArray = new JSONArray();
                    for (UocOrderShouldPay shouldPayItem : listOrderShouldPay) {
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("fscShouldPayId", shouldPayItem.getFscShouldPayId());
                        jsonObject.put("shouldPayAmount", shouldPayItem.getShouldPayAmount());
                        jsonObject.put("paidAmount", shouldPayItem.getPaidAmount());
                        jsonObject.put("shouldPayType", item.getShouldPayType());
                        jsonArray.add(jsonObject);
                    }
                    //同步销售单ES
                    syncEs(item.getObjectId(), jsonArray);
                }
            }
        }

        return UocRu.success(UocShouldPayCreateRspBO.class);
    }

    /**
     * 同步ES
     */
    private void syncEs(Long objId, JSONArray jsonArray) {
        UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = new UocEsSyncManagerSaveDataReqBo();
        //objId
        uocEsSyncManagerSaveDataReqBo.setObjId(objId);
        //indexName
        uocEsSyncManagerSaveDataReqBo.setIndexName(uocIndexConfig.getSaleOrderIndex());
        JSONObject jsonObj = new JSONObject();
        //未支付状态应付订单列表
        jsonObj.put(UocConstant.ES_MAIN_OTHER.ORDER_SHOULD_PAY_LIST, jsonArray.toString());
        //jsonObj
        uocEsSyncManagerSaveDataReqBo.setJsonObj(jsonObj);
        log.info("应付单生成uocEsSyncManagerSaveDataReqBo为{}", JSONObject.toJSONString(uocEsSyncManagerSaveDataReqBo));
        uocEsSyncManager.updateData(uocEsSyncManagerSaveDataReqBo);
    }

}
