/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.es.UocEsSyncManager;
import com.tydic.dyc.oc.components.es.UocEsSyncManagerSaveDataReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.payorder.IUocPayOrderModel;
import com.tydic.dyc.oc.model.payorder.sub.UocOrderShouldPay;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderPayConfQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderMap;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.domainservice.UocCancelSaleOrderService;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelSaleOrderServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelSaleOrderServiceRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCancelSaleOrderBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.domainservice.UocCancelSaleOrderService"})
public class UocCancelSaleOrderServiceImpl
implements UocCancelSaleOrderService {
    private static final Logger log = LoggerFactory.getLogger(UocCancelSaleOrderServiceImpl.class);
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocPayOrderModel iUocPayOrderModel;
    @Autowired
    private UocIndexConfig uocIndexConfig;
    @Autowired
    private UocEsSyncManager uocEsSyncManager;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

    @PostMapping(value={"cancelSaleOrder"})
    public UocCancelSaleOrderServiceRspBo cancelSaleOrder(@RequestBody UocCancelSaleOrderServiceReqBo reqBo) {
        UocCancelSaleOrderServiceRspBo rspBo = new UocCancelSaleOrderServiceRspBo();
        ArrayList<UocCancelSaleOrderBo> uocCancelSaleOrderBoList = new ArrayList<UocCancelSaleOrderBo>();
        this.validateArg(reqBo);
        this.collectData(reqBo, uocCancelSaleOrderBoList);
        Date now = new Date();
        UocSaleOrderDo uocSaleOrderDo = UocRu.js(reqBo, UocSaleOrderDo.class);
        uocSaleOrderDo.setUpdateTime(now);
        uocSaleOrderDo.setUpdateOperId(reqBo.getUserId().toString());
        uocSaleOrderDo.setCancelTime(now);
        uocSaleOrderDo.setCancelReason(reqBo.getCancelReason());
        uocSaleOrderDo.setSaleOrderState("XS_QX_QX");
        this.iUocSaleOrderModel.modifySaleOrderMain(uocSaleOrderDo);
        if (ObjectUtil.isNotEmpty((Object)reqBo.getAccessoryAddBoList())) {
            this.iUocOrderModel.createOrderAccessory(this.convertSaleOrderAccessory(reqBo, now));
        }
        this.dealMap(reqBo, now);
        rspBo.setUocCancelSaleOrderBoList(uocCancelSaleOrderBoList);
        return rspBo;
    }

    private void collectData(UocCancelSaleOrderServiceReqBo reqBo, List<UocCancelSaleOrderBo> uocCancelSaleOrderBoList) {
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocSaleOrderDo uocSaleOrderDo = this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
        if (uocSaleOrderDo == null) {
            throw new BaseBusinessException("101016", "\u9500\u552e\u5355\u67e5\u8be2\u4e3a\u7a7a");
        }
        Long supId = Long.valueOf(uocSaleOrderDo.getStakeholder().getSupId());
        Long creditOrgId = Long.valueOf(uocSaleOrderDo.getStakeholder().getPurCompanyId());
        Long saleOrderId = uocSaleOrderDo.getSaleOrderId();
        String saleOrderNo = uocSaleOrderDo.getSaleOrderNo();
        List<UocSaleOrderPayConf> uocSaleOrderPayConfList = this.qrySaleOrderPayConf(reqBo);
        for (UocSaleOrderPayConf uocSaleOrderPayConf : uocSaleOrderPayConfList) {
            UocCancelSaleOrderBo uocCancelSaleOrderBo = new UocCancelSaleOrderBo();
            Integer payType = uocSaleOrderPayConf.getPayType();
            Integer userType = uocSaleOrderPayConf.getUserType();
            UocOrderShouldPay where = new UocOrderShouldPay();
            where.setOrderId(reqBo.getOrderId());
            where.setObjectId(reqBo.getSaleOrderId());
            where.setObjectType(UocDicConstant.OBJ_TYPE.SALE);
            List<UocOrderShouldPay> listOrderShouldPay = this.iUocPayOrderModel.getListOrderShouldPay(where);
            uocCancelSaleOrderBo.setSupId(supId);
            uocCancelSaleOrderBo.setCreditOrgId(creditOrgId);
            uocCancelSaleOrderBo.setSaleOrderId(saleOrderId);
            uocCancelSaleOrderBo.setSaleOrderNo(saleOrderNo);
            uocCancelSaleOrderBo.setShouldPayIds(listOrderShouldPay.stream().map(UocOrderShouldPay::getShouldPayId).collect(Collectors.toList()));
            uocCancelSaleOrderBo.setPayType(payType);
            uocCancelSaleOrderBo.setUserType(userType);
            if (UocDicConstant.USE_TYPE.PUR.equals(userType)) {
                uocCancelSaleOrderBo.setAmount(uocSaleOrderDo.getTotalSaleFee());
            } else {
                uocCancelSaleOrderBo.setAmount(uocSaleOrderDo.getTotalPurchaseFee());
            }
            uocCancelSaleOrderBoList.add(uocCancelSaleOrderBo);
            if (!UocDicConstant.PAY_TYPE.ADVANCE_PAYMENT_PRORATED.equals(payType) && !UocDicConstant.PAY_TYPE.PAY_BY_AGR_CONSTRAINT.equals(payType) || CollectionUtils.isEmpty(listOrderShouldPay)) continue;
            for (UocOrderShouldPay uocOrderShouldPay : listOrderShouldPay) {
                UocOrderShouldPay whereInner = new UocOrderShouldPay();
                whereInner.setShouldPayId(uocOrderShouldPay.getShouldPayId());
                UocOrderShouldPay set = new UocOrderShouldPay();
                set.setDelTag(UocDicConstant.DELETE_TAG.DELETED);
                this.iUocPayOrderModel.modifyOrderShouldPayMain(set, whereInner);
            }
        }
    }

    private List<UocSaleOrderPayConf> qrySaleOrderPayConf(UocCancelSaleOrderServiceReqBo reqBo) {
        UocSaleOrderPayConfQryBo uocSaleOrderPayConfQryBo = new UocSaleOrderPayConfQryBo();
        uocSaleOrderPayConfQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderPayConfQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        List<UocSaleOrderPayConf> saleOrderPayConfList = this.iUocSaleOrderModel.getSaleOrderPayConfList(uocSaleOrderPayConfQryBo);
        if (CollectionUtils.isEmpty(saleOrderPayConfList)) {
            throw new BaseBusinessException("101015", "\u9500\u552e\u5355\u652f\u4ed8\u914d\u7f6e\u67e5\u8be2\u4e3a\u7a7a");
        }
        return saleOrderPayConfList;
    }

    private List<UocOrderAccessory> convertSaleOrderAccessory(UocCancelSaleOrderServiceReqBo reqBo, Date now) {
        List<UocOrderAccessory> uocOrderAccessoryList = UocRu.jsl(reqBo.getAccessoryAddBoList(), UocOrderAccessory.class);
        uocOrderAccessoryList.forEach(each -> {
            each.setId(IdUtil.nextId());
            each.setObjId(reqBo.getSaleOrderId());
            each.setObjType(UocDicConstant.OBJ_TYPE.SALE);
            each.setOrderId(reqBo.getOrderId());
            each.setCreateTime(now);
            each.setCreateOperId(reqBo.getUserId().toString());
        });
        return uocOrderAccessoryList;
    }

    private void dealMap(UocCancelSaleOrderServiceReqBo reqBo, Date now) {
        if (!CollectionUtils.isEmpty((Collection)reqBo.getExtDeleteList())) {
            UocSaleOrderDo delSaleOrderDo = new UocSaleOrderDo();
            ArrayList<UocSaleOrderMap> extParallelBoList = new ArrayList<UocSaleOrderMap>();
            reqBo.getExtDeleteList().forEach(uocBaseExtParallelDeleteBo -> {
                UocSaleOrderMap uocSaleOrderMap = new UocSaleOrderMap();
                uocSaleOrderMap.setOrderId(reqBo.getOrderId());
                uocSaleOrderMap.setSaleOrderId(uocBaseExtParallelDeleteBo.getObjId());
                uocSaleOrderMap.setFieldCode(uocBaseExtParallelDeleteBo.getFieldCode());
                uocSaleOrderMap.setUpdateOperId(reqBo.getUserId().toString());
                uocSaleOrderMap.setUpdateTime(now);
                extParallelBoList.add(uocSaleOrderMap);
            });
            delSaleOrderDo.setSaleOrderMapList(extParallelBoList);
            this.iUocSaleOrderModel.updateInvalid(delSaleOrderDo);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getExtEditList())) {
            UocSaleOrderDo add = new UocSaleOrderDo();
            UocSaleOrderDo modify = new UocSaleOrderDo();
            ArrayList<UocSaleOrderMap> addList = new ArrayList<UocSaleOrderMap>();
            ArrayList<UocSaleOrderMap> modifyList = new ArrayList<UocSaleOrderMap>();
            reqBo.getExtEditList().forEach(uocBaseExtParallelEditBo -> {
                if (UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelEditBo.getOpFlag())) {
                    UocSaleOrderMap addShipOrderMap = new UocSaleOrderMap();
                    addShipOrderMap.setSaleOrderId(uocBaseExtParallelEditBo.getObjId());
                    addShipOrderMap.setFieldCode(uocBaseExtParallelEditBo.getFieldCode());
                    addShipOrderMap.setFieldName(uocBaseExtParallelEditBo.getFieldName());
                    addShipOrderMap.setFieldValue(uocBaseExtParallelEditBo.getFieldValue());
                    addShipOrderMap.setOrderId(reqBo.getOrderId());
                    addShipOrderMap.setId(IdUtil.nextId());
                    addShipOrderMap.setCreateOperId(reqBo.getUserId().toString());
                    addShipOrderMap.setCreateTime(now);
                    addList.add(addShipOrderMap);
                } else {
                    UocSaleOrderMap updateShipOrderMap = new UocSaleOrderMap();
                    updateShipOrderMap.setSaleOrderId(uocBaseExtParallelEditBo.getObjId());
                    updateShipOrderMap.setFieldCode(uocBaseExtParallelEditBo.getFieldCode());
                    updateShipOrderMap.setOrderId(reqBo.getOrderId());
                    updateShipOrderMap.setFieldValue(uocBaseExtParallelEditBo.getFieldValue());
                    updateShipOrderMap.setUpdateOperId(reqBo.getUserId().toString());
                    updateShipOrderMap.setUpdateTime(now);
                    modifyList.add(updateShipOrderMap);
                }
            });
            if (!CollectionUtils.isEmpty(addList)) {
                add.setSaleOrderMapList(addList);
                this.iUocSaleOrderModel.addSaleOrderMap(add);
            }
            if (!CollectionUtils.isEmpty(modifyList)) {
                modify.setSaleOrderMapList(modifyList);
                this.iUocSaleOrderModel.updateBatchValue(modify);
            }
        }
    }

    private void validateArg(UocCancelSaleOrderServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocCancelSaleOrderServiceReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSaleOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u9500\u552e\u5355id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8ba2\u5355id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getCancelReason())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u53d6\u6d88\u539f\u56e0]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getUserId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u7528\u6237ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getExtDeleteList())) {
            reqBo.getExtDeleteList().forEach(uocBaseExtParallelDeleteBo -> {
                if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                    throw new BaseBusinessException("100001", "\u8981\u5220\u9664\u7684\u6269\u5c55\u5c5e\u6027\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isBlank((CharSequence)uocBaseExtParallelDeleteBo.getFieldCode())) {
                    throw new BaseBusinessException("100001", "\u8981\u5220\u9664\u7684\u6269\u5c55\u5c5e\u6027\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                }
            });
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getExtEditList())) {
            reqBo.getExtEditList().forEach(uocBaseExtParallelDeleteBo -> {
                if (null == uocBaseExtParallelDeleteBo.getOpFlag()) {
                    throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u7f16\u8f91\u64cd\u4f5c\u65f6\uff0c\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelDeleteBo.getOpFlag()) && !UocConstant.MAP_OP_FLAG.UPDATE.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                    throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u7f16\u8f91\u64cd\u4f5c\u65f6\uff0c\u64cd\u4f5c\u7c7b\u578b\u4ec5\u652f\u6301\u65b0\u589e\u548c\u4fee\u6539");
                }
                if (UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                    if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                        throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtils.isBlank((CharSequence)uocBaseExtParallelDeleteBo.getFieldCode())) {
                        throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u5c5e\u6027\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                }
                if (UocConstant.MAP_OP_FLAG.UPDATE.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                    if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                        throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtils.isBlank((CharSequence)uocBaseExtParallelDeleteBo.getFieldCode())) {
                        throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u5c5e\u6027\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtils.isBlank((CharSequence)uocBaseExtParallelDeleteBo.getFieldValue())) {
                        throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u5c5e\u6027\u503c\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                }
            });
        }
    }

    private void syncEs(UocSaleOrderDo uocSaleOrderDo) {
        UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = new UocEsSyncManagerSaveDataReqBo();
        uocEsSyncManagerSaveDataReqBo.setObjId(uocSaleOrderDo.getSaleOrderId());
        uocEsSyncManagerSaveDataReqBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("updateTime", (Object)uocSaleOrderDo.getUpdateTime().getTime());
        jsonObj.put("cancelTime", (Object)uocSaleOrderDo.getCancelTime().getTime());
        jsonObj.put("updateOperId", (Object)uocSaleOrderDo.getUpdateOperId());
        jsonObj.put("cancelReason", (Object)uocSaleOrderDo.getCancelReason());
        jsonObj.put("saleOrderState", (Object)uocSaleOrderDo.getSaleOrderState());
        Map<String, String> saleOrdStateMap = this.getDic().get("UOC_SALE_ORDER_STATE");
        jsonObj.put("saleOrderStateStr", (Object)saleOrdStateMap.get(Convert.toStr((Object)uocSaleOrderDo.getSaleOrderState())));
        uocEsSyncManagerSaveDataReqBo.setJsonObj(jsonObj);
        log.info("uocEsSyncManagerSaveDataReqBo\u4e3a{}", (Object)JSONObject.toJSONString((Object)uocEsSyncManagerSaveDataReqBo));
        this.uocEsSyncManager.updateData(uocEsSyncManagerSaveDataReqBo);
    }

    private Map<String, Map<String, String>> getDic() {
        ArrayList<String> pCodes = new ArrayList<String>();
        pCodes.add("UOC_SALE_ORDER_STATE");
        return this.iUocSysDictionaryModel.getDictionaryMap(pCodes);
    }
}

