/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.insporder.sub.UocShipInspRel;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.service.domainservice.UocEcArrvalAcceptanceService;
import com.tydic.dyc.oc.service.domainservice.bo.UocEcArrvalAcceptanceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocEcArrvalAcceptanceRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.domainservice.UocEcArrvalAcceptanceService"})
public class UocEcArrvalAcceptanceServiceImpl
implements UocEcArrvalAcceptanceService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    private static final String OP_FLAG_YES = "1";

    @PostMapping(value={"dealEcArrvalAcceptance"})
    public UocEcArrvalAcceptanceRspBo dealEcArrvalAcceptance(@RequestBody UocEcArrvalAcceptanceReqBo reqBo) {
        this.validateArg(reqBo);
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocSaleOrderDo uocSaleOrderDo = this.iUocSaleOrderModel.getCollectCountImplOrderItem(uocSaleOrderItemQryBo);
        UocSaleOrderItem uocSaleOrderItem = uocSaleOrderDo.getSaleOrderItems().get(0);
        if (uocSaleOrderItem.getPurchaseCount().compareTo(uocSaleOrderItem.getArriveCount().add(uocSaleOrderItem.getRefuseCount())) != 0) {
            throw new BaseBusinessException("101004", "\u5b58\u5728\u4e0d\u80fd\u9a8c\u6536\u7684\u6570\u636e");
        }
        Date nowDate = new Date();
        UocInspOrderDo uocInspOrderDo = this.convertInspOrderDo(reqBo, nowDate);
        this.iUocInspOrderModel.createInspOrder(uocInspOrderDo);
        this.updateShipOrderInspInfo(reqBo, nowDate);
        this.updateShipOrderItemInspInfo(reqBo, nowDate);
        this.updateSaleOrderItemInspInfo(reqBo, nowDate);
        this.modifySaleOrderState(reqBo);
        UocEcArrvalAcceptanceRspBo uocEcArrvalAcceptanceRspBo = UocRu.success(UocEcArrvalAcceptanceRspBo.class);
        uocEcArrvalAcceptanceRspBo.setInspOrderId(uocInspOrderDo.getInspOrderId());
        return uocEcArrvalAcceptanceRspBo;
    }

    private void modifySaleOrderState(UocEcArrvalAcceptanceReqBo reqBo) {
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        List<UocShipOrderDo> shipOrderDos = this.iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setUpdateOperId(reqBo.getUserId() + "");
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo.setSaleOrderState("XS_YS_YS");
        shipOrderDos.forEach(uocShipOrderDo -> {
            if (!"FH_FH_YS".equals(uocShipOrderDo.getShipOrderState())) {
                uocSaleOrderDo.setSaleOrderState("XS_YS_BFYS");
            }
        });
        this.iUocSaleOrderModel.updateSaleStatusAndProCode(uocSaleOrderDo);
    }

    private void updateSaleOrderItemInspInfo(UocEcArrvalAcceptanceReqBo reqBo, Date nowDate) {
        UocSaleOrderDo uocSaleOrderDo1 = new UocSaleOrderDo();
        uocSaleOrderDo1.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo1.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo1.setUpdateTime(nowDate);
        uocSaleOrderDo1.setUpdateOperId(reqBo.getUserId().toString());
        this.iUocSaleOrderModel.modifySaleOrderItemInspCountEqualArrivalCount(uocSaleOrderDo1);
    }

    private void updateShipOrderItemInspInfo(UocEcArrvalAcceptanceReqBo reqBo, Date nowDate) {
        UocShipOrderDo uocShipOrderDo1 = new UocShipOrderDo();
        uocShipOrderDo1.setOrderId(reqBo.getOrderId());
        uocShipOrderDo1.setSaleOrderId(reqBo.getSaleOrderId());
        uocShipOrderDo1.setUpdateOperId(reqBo.getUserId().toString());
        uocShipOrderDo1.setUpdateTime(nowDate);
        this.iUocShipOrderModel.modifyShipOrderItemInspCountEqualArrivalCount(uocShipOrderDo1);
    }

    private void updateShipOrderInspInfo(UocEcArrvalAcceptanceReqBo reqBo, Date nowDate) {
        UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
        uocShipOrderDo.setOrderId(reqBo.getOrderId());
        uocShipOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocShipOrderDo.setUpdateOperId(reqBo.getUserId().toString());
        uocShipOrderDo.setUpdateTime(nowDate);
        uocShipOrderDo.setInspOperId(reqBo.getUserId().toString());
        uocShipOrderDo.setInspOperName(reqBo.getName());
        uocShipOrderDo.setInspTime(nowDate);
        uocShipOrderDo.setInspOperPhone(reqBo.getCellphone());
        this.iUocShipOrderModel.modifyShipOrderMain(uocShipOrderDo);
        UocShipOrderDo uocShipOrderDo1 = new UocShipOrderDo();
        uocShipOrderDo1.setOrderId(reqBo.getOrderId());
        uocShipOrderDo1.setSaleOrderId(reqBo.getSaleOrderId());
        this.iUocShipOrderModel.modifyShipOrderStatus(uocShipOrderDo1);
    }

    private UocInspOrderDo convertInspOrderDo(UocEcArrvalAcceptanceReqBo reqBo, Date nowDate) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo = this.iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException("101002", "\u67e5\u8be2\u9a8c\u6536\u5355\u4e3a\u7a7a");
        }
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        List<UocShipOrderDo> uocShipOrderDoList = this.iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocShipOrderDo uocShipOrderDo = this.iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
        UocInspOrderDo uocInspOrderDo = new UocInspOrderDo();
        uocInspOrderDo.setOrderId(reqBo.getOrderId());
        uocInspOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocInspOrderDo.setInspOrderId(IdUtil.nextId());
        uocInspOrderDo.setInspOrderNo(this.getInspOrderNo(uocSaleOrderDo));
        uocInspOrderDo.setInspOrderState("YS_YS_YS");
        uocInspOrderDo.setInspOper(reqBo.getName());
        uocInspOrderDo.setCreateOperId(reqBo.getUserId().toString());
        uocInspOrderDo.setCreateTime(nowDate);
        uocInspOrderDo.setInvoiceTag(UocConstant.INVOICE_TAG.NO);
        uocInspOrderDo.setInspOperPhone(reqBo.getCellphone());
        uocInspOrderDo.setTenantId(reqBo.getTenantId());
        uocInspOrderDo.setTotalPurchaseFee(uocSaleOrderDo.getTotalPurchaseFee());
        uocInspOrderDo.setTotalSaleFee(uocSaleOrderDo.getTotalSaleFee());
        ArrayList<UocShipInspRel> uocShipInspRelList = new ArrayList<UocShipInspRel>();
        uocShipOrderDoList.forEach(uocShipOrderDo1 -> {
            UocShipInspRel uocShipInspRel = UocRu.js(uocInspOrderDo, UocShipInspRel.class);
            uocShipInspRel.setId(IdUtil.nextId());
            uocShipInspRel.setShipOrderId(uocShipOrderDo1.getShipOrderId());
            uocShipInspRel.setRemark(null);
            uocShipInspRelList.add(uocShipInspRel);
        });
        ArrayList<UocInspOrderItem> uocInspOrderItemList = new ArrayList<UocInspOrderItem>();
        uocShipOrderDo.getShipOrderItemBoList().forEach(uocShipOrderItem -> {
            UocInspOrderItem uocInspOrderItem = UocRu.js(uocInspOrderDo, UocInspOrderItem.class);
            uocInspOrderItem.setInspOrderItemId(IdUtil.nextId());
            uocInspOrderItem.setInspCount(uocShipOrderItem.getArriveCount());
            uocInspOrderItem.setShipOrderItemId(uocShipOrderItem.getShipOrderItemId());
            uocInspOrderItem.setSaleOrderItemId(uocShipOrderItem.getSaleOrderItemId());
            uocInspOrderItem.setUnitName(uocShipOrderItem.getUnitName());
            uocInspOrderItem.setRemark(null);
            uocInspOrderItemList.add(uocInspOrderItem);
        });
        uocInspOrderDo.setUocShipInspRelList(uocShipInspRelList);
        uocInspOrderDo.setUocInspOrderItemList(uocInspOrderItemList);
        return uocInspOrderDo;
    }

    private String getInspOrderNo(UocSaleOrderDo uocSaleOrderDo) {
        UocInspOrderDo uocInspOrderDo = new UocInspOrderDo();
        uocInspOrderDo.setOrderSource(uocSaleOrderDo.getOrderSource());
        return this.iUocInspOrderModel.getInspOrderNo(uocInspOrderDo).getInspOrderNo();
    }

    private void validateArg(UocEcArrvalAcceptanceReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e3a\u7a7a");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u9500\u552e\u5355ID\u4e3a\u7a7a");
        }
    }
}

