/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.saleorder;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.config.UocInitConfig;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.saleorder.UocCreateSaleProcInsUpdateStatusDomainService;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.saleorder.UocCreateSaleProcInsUpdateStatusDomainService"})
public class UocCreateSaleProcInsUpdateStatusDomainServiceImpl
implements UocCreateSaleProcInsUpdateStatusDomainService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private UocInitConfig uocInitConfig;

    @PostMapping(value={"createSaleProcIns"})
    public UocCreateSaleProcInsUpdateStatusDomainServiceRspBo createSaleProcIns(@RequestBody UocCreateSaleProcInsUpdateStatusDomainServiceReqBo reqBo) {
        List nextTaskInfos;
        String oldTaskInstId;
        this.validateArg(reqBo);
        if (ObjectUtil.isNotEmpty((Object)reqBo.getProcInstId())) {
            UocOrderProcInst qryInst = new UocOrderProcInst();
            qryInst.setProcInstId(reqBo.getProcInstId());
            qryInst.setOrderId(reqBo.getOrderId());
            List<UocOrderProcInst> uocOrderProcInsts = this.iUocSaleOrderModel.qryProcInsList(qryInst);
            if (ObjectUtil.isEmpty(uocOrderProcInsts)) {
                UocOrderProcInst createSaleProcIns = new UocOrderProcInst();
                createSaleProcIns.setProcInstId(reqBo.getProcInstId());
                createSaleProcIns.setOrderId(reqBo.getOrderId());
                createSaleProcIns.setObjId(reqBo.getSaleOrderId());
                createSaleProcIns.setObjType(UocDicConstant.OBJ_TYPE.SALE);
                createSaleProcIns.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
                this.iUocSaleOrderModel.createProInst(createSaleProcIns);
            }
        }
        if (ObjectUtil.isNotEmpty((Object)(oldTaskInstId = reqBo.getOldTaskInstId()))) {
            UocOrderTaskInst qryInst = new UocOrderTaskInst();
            qryInst.setOrderId(reqBo.getOrderId());
            qryInst.setTaskInstId(oldTaskInstId);
            List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocSaleOrderModel.qryTaskInstList(qryInst);
            if (ObjectUtil.isEmpty(uocOrderTaskInsts)) {
                throw new BaseBusinessException("101005", "\u4efb\u52a1\u5b9e\u4f8bid(" + oldTaskInstId + ")\u4e0d\u5b58\u5728");
            }
            if (UocDicConstant.PROC_TASK_FINISHED.FINISHED.equals(uocOrderTaskInsts.get(0).getFinishTag())) {
                throw new BaseBusinessException("101005", "\u4efb\u52a1\u5b9e\u4f8bid(" + oldTaskInstId + ")\u5df2\u5b8c\u7ed3");
            }
            ArrayList<UocOrderTaskInst> updateList = new ArrayList<UocOrderTaskInst>();
            UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
            updateList.add(uocOrderTaskInst);
            uocOrderTaskInst.setOrderId(reqBo.getOrderId());
            uocOrderTaskInst.setTaskInstId(oldTaskInstId);
            this.iUocSaleOrderModel.updateProcTaskInstToFinished(updateList);
        }
        if (ObjectUtil.isNotEmpty((Object)(nextTaskInfos = reqBo.getNextTaskInfos()))) {
            ArrayList<UocOrderTaskDeal> saveDealList = new ArrayList<UocOrderTaskDeal>();
            ArrayList<UocOrderTaskInst> saveList = new ArrayList<UocOrderTaskInst>();
            for (UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo nextTaskInfo : nextTaskInfos) {
                String saleState;
                UocOrderTaskInst taskBo = new UocOrderTaskInst();
                taskBo.setId(IdUtil.nextId());
                taskBo.setOrderId(reqBo.getOrderId());
                taskBo.setTaskInstId(nextTaskInfo.getTaskInstId());
                taskBo.setObjId(reqBo.getSaleOrderId());
                taskBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
                taskBo.setProcState(nextTaskInfo.getTacheCode());
                taskBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
                saveList.add(taskBo);
                String assignee = nextTaskInfo.getAssignee();
                List candidates = nextTaskInfo.getCandidates();
                if (ObjectUtil.isNotEmpty((Object)assignee)) {
                    UocOrderTaskDeal deal = this.assembleTaskDealObj(reqBo, nextTaskInfo);
                    deal.setDealId(assignee);
                    deal.setDealClass("1");
                    saveDealList.add(deal);
                } else if (ObjectUtil.isNotEmpty((Object)candidates)) {
                    for (String candidate : candidates) {
                        UocOrderTaskDeal deal = this.assembleTaskDealObj(reqBo, nextTaskInfo);
                        deal.setDealId(candidate);
                        deal.setDealClass("2");
                        saveDealList.add(deal);
                    }
                }
                if (!ObjectUtil.isNotEmpty((Object)(saleState = this.uocInitConfig.getStateByTachecode(nextTaskInfo.getTacheCode(), UocDicConstant.OBJ_TYPE.SALE)))) continue;
                UocSaleOrderDo updateSaleDo = new UocSaleOrderDo();
                updateSaleDo.setUpdateOperId(reqBo.getUserId().toString());
                updateSaleDo.setOrderId(reqBo.getOrderId());
                updateSaleDo.setSaleOrderId(reqBo.getSaleOrderId());
                updateSaleDo.setSaleOrderState(saleState);
                this.iUocSaleOrderModel.updateSaleStatusAndProCode(updateSaleDo);
            }
            if (ObjectUtil.isNotEmpty(saveDealList)) {
                this.iUocSaleOrderModel.saveOrderTaskDealList(saveDealList);
            }
            this.iUocSaleOrderModel.saveProcTaskInst(saveList);
        }
        return UocRu.success(UocCreateSaleProcInsUpdateStatusDomainServiceRspBo.class);
    }

    private UocOrderTaskDeal assembleTaskDealObj(UocCreateSaleProcInsUpdateStatusDomainServiceReqBo reqBo, UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo nextTaskInfo) {
        UocOrderTaskDeal deal = new UocOrderTaskDeal();
        deal.setId(IdUtil.nextId());
        deal.setTaskInstId(nextTaskInfo.getTaskInstId());
        deal.setOrderId(reqBo.getOrderId());
        deal.setObjId(reqBo.getSaleOrderId());
        deal.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        return deal;
    }

    private void validateArg(UocCreateSaleProcInsUpdateStatusDomainServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocCreateSaleProcInsUpdateStatusDomainServiceReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getUserId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u3010userId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u3010\u8ba2\u5355id\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSaleOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u9500\u552e\u5355id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isNotEmpty((Object)reqBo.getNextTaskInfos())) {
            for (UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo nextTaskInfo : reqBo.getNextTaskInfos()) {
                this.validateUocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo(nextTaskInfo);
            }
        }
    }

    private void validateUocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo(UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getTaskInstId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u3010\u65b0\u4efb\u52a1\u5b9e\u4f8bid\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getTacheCode())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u3010\u73af\u8282\u7f16\u7801\uff0c\u4f20\u503c\u5c31\u4f1a\u66f4\u65b0\u9500\u552e\u5355\u73af\u8282\u7f16\u7801\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

