package com.tydic.dyc.oc.model.shiporder;

import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;

import java.util.List;

/**
 * 标题:IUocShipOrderModel
 * 说明:发货单
 * 时间:2022/2/23 14:01
 * 作者:罗有
 */

public interface IUocShipOrderModel {
	/**
	 * 发货单创建
	 * @param uocShipOrderDo
	 */
	void createShipOrder(UocShipOrderDo uocShipOrderDo);

	/**
	 * 记录到货确认信息
	 * @param uocShipOrderDo
	 */
	void arrivaConfirm(UocShipOrderDo uocShipOrderDo);

	/**
	 * 记录到货拒收信息
	 * @param uocShipOrderDo
	 */
	void arrivaRefuse(UocShipOrderDo uocShipOrderDo);

	/**
	 * 查询发货单明细
	 * @param uocShipOrderItemQryBo
	 * @return
	 */
	UocShipOrderDo   getListShipOrderItem(UocShipOrderItemQryBo uocShipOrderItemQryBo);

	/**
	 * 更新发货单主体信息
	 * @param uocShipOrderDo
	 */
	void modifyShipOrderMain(UocShipOrderDo uocShipOrderDo);

	/**
	 * 更新发货单明细验收数量
	 *
	 * @param uocShipOrderDo
	 */
	void modifyShipOrderItemInspCount(UocShipOrderDo uocShipOrderDo);

	/**
	 * 根据发货单ID查询发货单信息
	 *
	 * @return
	 */
	UocShipOrderDo getShipOrderById(UocShipOrderQryBo uocShipOrderQryBo);

	/**
	 * 发货单列表查询
	 */
	List<UocShipOrderDo> getListShipOrder(UocShipOrderQryBo uocShipOrderQryBo);

	/**
	 * 获取发货单编码
	 *
	 * @param uocShipOrderDo
	 * @return
	 */
	UocShipOrderDo getShipOrderNo(UocShipOrderDo uocShipOrderDo);

	/**
	 * 更新发货单明细异常变更在途数量
	 *
	 * @param uocShipOrderDo
	 */
	void modifyShipOrderItemChngingCount(UocShipOrderDo uocShipOrderDo);

	/**
	 * 更新发货单明细退货数量 依据异常变更在途数量修改
	 *
	 * @param uocShipOrderDo
	 */
	void modifyItemReturnCountConfirm(UocShipOrderDo uocShipOrderDo);

	/**
	 * 更新发货单明细异常变更在途数量为0，变更拒绝
	 *
	 * @param uocShipOrderDo
	 */
	void modifyItemChngCountRefuse(UocShipOrderDo uocShipOrderDo);

	/**
	 * 更新发货单状态和环节编码
	 *
	 * @param uocShipOrderDo
	 */
	void updateShipStatusAndProCode(UocShipOrderDo uocShipOrderDo);

	/**
	 * 增加扩展字段
	 *
	 * @param uocShipOrderDo
	 */
	void addShipOrderMap(UocShipOrderDo uocShipOrderDo);

	/**
	 * 批量更新扩展字段值
	 *
	 * @param uocShipOrderDo
	 */
	void updateBatchValue(UocShipOrderDo uocShipOrderDo);

	/**
	 * 删除扩展字段
	 *
	 * @param uocShipOrderDo
	 */
	void updateInvalid(UocShipOrderDo uocShipOrderDo);
	/**
	 * 更新发货单明细验收数量等于到货数量
	 *
	 * @param uocShipOrderDo
	 */
	void modifyShipOrderItemInspCountEqualArrivalCount(UocShipOrderDo uocShipOrderDo);


	/**
	 * 更新发货单明细到货数量 依据异常变更在途数量修改
	 *
	 * @param uocShipOrderDo
	 */
	void modifyItemArriveCountConfirm(UocShipOrderDo uocShipOrderDo);

	/**
	 * 更新发货单明细到货数量 依据异常变更在途数量修改
	 *
	 * @param uocShipOrderDo
	 */
	void modifyItemRefuseCountConfirm(UocShipOrderDo uocShipOrderDo);
    
    
    /*
     * @Author lsl
     * @Description //TODO 更新发货单到货时间
     * @Date 14:14 2022/4/15
     * @Param []
     * @return void
     */
    void modifyShipArrivtime(UocShipOrderDo uocShipOrderDo);
    
    void modifyItemArriveCount(UocShipOrderDo uocShipOrderDo);
	/**
	 * 修改发货单状态
	 */
	void modifyShipOrderStatus(UocShipOrderDo uocShipOrderDo);
}
