package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.domainservice.bo.UocOrdShipItemPrintRspBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocOrdShipPrintRspBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocShipOrderPrintReqBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocShipOrderPrintRspBO;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

/**
 * 标题：UocShipOrderPrintAbilityServiceImpl
 * 说明：打印发货单实现
 * 时间：2022/4/6 10:26
 *
 * @author 文乐
 */
@HTServiceImpl
public class UocShipOrderPrintAbilityServiceImpl implements UocShipOrderPrintAbilityService {

    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Override
    public UocShipOrderPrintRspBO printShipOrder(UocShipOrderPrintReqBO reqBO) {
        validateArg(reqBO);

        // 销售单信息及三方信息
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setOrderId(reqBO.getOrderId());
        UocSaleOrderDo uocSaleOrderDo = iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);

        // 发货信息
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(reqBO.getOrderId());
        uocShipOrderQryBo.setShipOrderId(reqBO.getShipOrderId());
        UocShipOrderDo uocShipOrderDo = iUocShipOrderModel.getShipOrderById(uocShipOrderQryBo);

        // 发货明细
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setShipOrderId(reqBO.getShipOrderId());
        UocShipOrderDo uocShipOrderItem = iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
        List<UocShipOrderItem> shipOrderItemBoList = uocShipOrderItem.getShipOrderItemBoList();

        // 销售单明细
        List<Long> saleOrderItemIds = shipOrderItemBoList.stream().map(UocShipOrderItem::getSaleOrderItemId).collect(Collectors.toList());
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderItemIdList(saleOrderItemIds);
        List<UocSaleOrderItem> saleOrderItemList = iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        Map<Long, UocSaleOrderItem> saleOrderItemMap = saleOrderItemList.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));

        // 发货单详情（主表信息）
        UocOrdShipPrintRspBO uocOrdShipPrintRspBO = new UocOrdShipPrintRspBO();
        uocOrdShipPrintRspBO.setSaleOrderNo(uocSaleOrderDo.getSaleOrderNo());
        uocOrdShipPrintRspBO.setSaleOrderNoExt(uocSaleOrderDo.getSaleOrderNoExt());
        uocOrdShipPrintRspBO.setSupName(uocSaleOrderDo.getStakeholder().getSupName());
        uocOrdShipPrintRspBO.setPurName(uocSaleOrderDo.getStakeholder().getPurName());
        uocOrdShipPrintRspBO.setShipCompanyNo(uocShipOrderDo.getShipCompanyNo());
        uocOrdShipPrintRspBO.setShipTime(uocShipOrderDo.getShipTime());
        uocOrdShipPrintRspBO.setShipName(uocShipOrderDo.getShipName());
        uocOrdShipPrintRspBO.setShipPhone(uocShipOrderDo.getShipPhone());

        // 发货明细Item信息（明细Item信息）
        AtomicInteger index = new AtomicInteger(1);
        List<UocOrdShipItemPrintRspBO> uocOrdShipItemPrintRspBOS = shipOrderItemBoList.stream().map(shipOrderItem -> {
            UocSaleOrderItem uocSaleOrderItem = saleOrderItemMap.get(shipOrderItem.getSaleOrderItemId());
            UocOrdShipItemPrintRspBO uocOrdShipItemPrintRspBO = new UocOrdShipItemPrintRspBO();
            uocOrdShipItemPrintRspBO.setIndex(index.getAndIncrement());
            uocOrdShipItemPrintRspBO.setSkuName(uocSaleOrderItem.getSkuName());
            uocOrdShipItemPrintRspBO.setSkuMaterialId(uocSaleOrderItem.getSkuMaterialId());
            uocOrdShipItemPrintRspBO.setSkuMaterialTypeName(uocSaleOrderItem.getSkuMaterialTypeName());
            uocOrdShipItemPrintRspBO.setSkuMaterialName(uocSaleOrderItem.getSkuMaterialName());
            uocOrdShipItemPrintRspBO.setSpec(uocSaleOrderItem.getSpec());
            uocOrdShipItemPrintRspBO.setModel(uocSaleOrderItem.getModel());
            uocOrdShipItemPrintRspBO.setPurchaseCount(uocSaleOrderItem.getPurchaseCount());
            uocOrdShipItemPrintRspBO.setUnitName(uocSaleOrderItem.getUnitName());
            uocOrdShipItemPrintRspBO.setSendCount(shipOrderItem.getSendCount());
            uocOrdShipItemPrintRspBO.setArriveCount(shipOrderItem.getArriveCount());
            uocOrdShipItemPrintRspBO.setEstimateArrivalTime(uocShipOrderDo.getEstimateArrivalTime());
            return uocOrdShipItemPrintRspBO;
        }).collect(Collectors.toList());

        UocShipOrderPrintRspBO uocShipOrderPrintRspBO = UocRu.success(UocShipOrderPrintRspBO.class);
        uocShipOrderPrintRspBO.setOrdShipPrint(uocOrdShipPrintRspBO);
        uocShipOrderPrintRspBO.setOrdShipItemPrintList(uocOrdShipItemPrintRspBOS);

        return uocShipOrderPrintRspBO;
    }

    private void validateArg(UocShipOrderPrintReqBO reqBO) {
        if (null == reqBO) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (null == reqBO.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "orderId不能为空");
        }
        if (null == reqBO.getShipOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "shipOrderId不能为空");
        }
    }
}
