package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.UocAfOrderDo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderItem;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderMap;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderObj;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryAddBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderCreateReqAddressBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderCreateReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderCreateReqItemBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderCreateRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 标题：类名称:UocAfterOrderCreateServiceImpl
 * 说明：描述一下类的作用TODO
 * 时间：2022/4/1 14:36
 * 作者 @author 尹栋梁
 */
@HTServiceImpl
public class UocAfterOrderCreateServiceImpl implements UocAfterOrderCreateService{
    @Autowired
    private IUocAfOrderModel afOrderModel;

    @Autowired
    private IUocShipOrderModel shipOrderModel;

    @Autowired
    private IUocSaleOrderModel saleOrderModel;

    @Autowired
    private IUocCommonModel iUocCommonModel;

    @Override
    public UocAfterOrderCreateRspBo createAfterOrder(UocAfterOrderCreateReqBo reqBo) {
        //参数校验
        validateArg(reqBo);
        UocAfterOrderCreateRspBo rspBo = UocRu.success(UocAfterOrderCreateRspBo.class);
        if (!StringUtils.isEmpty(reqBo.getName())) {
            reqBo.setUsername(reqBo.getName());
        }
        checkAfterCount(reqBo);
        //bo转售后订单do
        UocAfOrderDo createDo = convertOrderDo(reqBo);
        buildShipItem(reqBo, createDo);
        //售后服务单入库
        UocAfOrderDo uocAfOrderDo1 = afOrderModel.dealPebTheZoneAfterApplication(createDo,reqBo.getOrderSource());
        //明细修改在途数量
        updateAfingCount(reqBo,uocAfOrderDo1);
        // 保存外部订单id和内部订单关系
        UocOrderQueryIndex index = new UocOrderQueryIndex();
        index.setId(IdUtil.nextId());
        index.setOrderId(uocAfOrderDo1.getOrderId());
        index.setObjType(UocDicConstant.OBJ_TYPE.AFTER);
        index.setObjId(uocAfOrderDo1.getAfOrderId());
        index.setOutObjId(reqBo.getServiceId());
        iUocCommonModel.saveOrderQueryIndex(index);
        rspBo.setAfOrderId(uocAfOrderDo1.getAfOrderId());
        JSONObject saleOrderExtObj = new JSONObject();
        saleOrderExtObj.put(UocConstant.ES_MAIN_OTHER.AFTERORDERFLAG, UocConstant.SALEORDER_SYN_AFTERORDER.ING);
        rspBo.setSaleOrderExtObj(JSONObject.toJSONString(saleOrderExtObj));
        return rspBo;
    }
    private void updateAfingCount(UocAfterOrderCreateReqBo reqBo, UocAfOrderDo afOrderDo) {
        List<UocAfOrderItem> afOrderItemBoList = afOrderDo.getAfOrderItemBoList();
        for (UocAfOrderItem uocAfOrderItem : afOrderItemBoList) {
            Long orderItemId = uocAfOrderItem.getSaleItemId();
            Long shipItemId = uocAfOrderItem.getShipItemId();
            Long orderId = uocAfOrderItem.getOrderId();
            BigDecimal returnCount = uocAfOrderItem.getReturnCount();
            //修改发货单在途数量
            UocShipOrderItem uocShipOrderItem = new UocShipOrderItem();
            uocShipOrderItem.setOrderId(orderId);
            uocShipOrderItem.setShipOrderItemId(shipItemId);
            uocShipOrderItem.setAfterServingCount(returnCount);
            uocShipOrderItem.setUpdateTime(new Date());
            uocShipOrderItem.setUpdateOperId(Optional.ofNullable(reqBo.getUserId()).toString());
            shipOrderModel.modifyShipOrderItemAfterServingCount(uocShipOrderItem);
            //修改销售单在途数量
            UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
            uocSaleOrderItem.setOrderId(orderId);
            uocSaleOrderItem.setSaleOrderItemId(orderItemId);
            uocSaleOrderItem.setAfterServingCount(returnCount);
            uocSaleOrderItem.setUpdateTime(new Date());
            uocSaleOrderItem.setUpdateOperId(Optional.ofNullable(reqBo.getUserId()).toString());
            saleOrderModel.modifySaleOrderItemAfterServingCount(uocSaleOrderItem);


        }
    }

    private void checkAfterCount(UocAfterOrderCreateReqBo reqBo) {
        UocShipOrderItemQryBo uocShipOrderQryBo = new UocShipOrderItemQryBo();
        uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderQryBo.setShipOrderId(reqBo.getShipOrderId());
        UocShipOrderDo shipOrderById = shipOrderModel.getListShipOrderItem(uocShipOrderQryBo);
//        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
//        uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
//        uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
//        List<UocSaleOrderItem> saleOrderItemList = saleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
//        Map<Long, UocSaleOrderItem> saleOrderItemMap = saleOrderItemList.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));
        Map<Long, UocShipOrderItem> shipOrderItemMap = shipOrderById.getShipOrderItemBoList().stream().collect(Collectors.toMap(UocShipOrderItem::getShipOrderItemId, o -> o));
        List<UocAfterOrderCreateReqItemBo> shipItemList = reqBo.getShipItemList();
        for (UocAfterOrderCreateReqItemBo uocAfterOrderCreateReqItemBo : shipItemList) {
            UocShipOrderItem uocShipOrderItem = shipOrderItemMap.get(uocAfterOrderCreateReqItemBo.getShipOrderItemId());
//            UocSaleOrderItem uocSaleOrderItem = saleOrderItemMap.get(uocShipOrderItem.getSaleOrderItemId());

            //若发货单状态为已到货时，可售后数量=本次发货数量-已退货数量-售后中数量
            if (UocStateConstants.ShipOrder.FH_FH_YSH.equals(shipOrderById.getShipOrderState())) {
                BigDecimal afterCountEnable = uocShipOrderItem.getSendCount().subtract(uocShipOrderItem.getReturnCount()).subtract(uocShipOrderItem.getAfterServingCount());
                if (uocAfterOrderCreateReqItemBo.getReturnCount().compareTo(afterCountEnable) > 0) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性售后数量不能超过可售后数量");
                }
            }

            //若发货单状态为已验收时，可售后数量=实际验收数量-已退货数量-售后中数量
            if (UocStateConstants.ShipOrder.FH_FH_YS.equals(shipOrderById.getShipOrderState())) {
                BigDecimal afterCountEnable = uocShipOrderItem.getInspCount().subtract(uocShipOrderItem.getReturnCount()).subtract(uocShipOrderItem.getAfterServingCount());
                if (uocAfterOrderCreateReqItemBo.getReturnCount().compareTo(afterCountEnable) > 0) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性售后数量不能超过可售后数量");
                }
            }
        }
    }

    private void buildShipItem(UocAfterOrderCreateReqBo reqBo, UocAfOrderDo createDo) {
        List<UocAfOrderItem> uocAfOrderItems = new ArrayList<>();
        List<UocAfterOrderCreateReqItemBo> shipItemList = reqBo.getShipItemList();
        if (CollectionUtil.isNotEmpty(shipItemList)) {
            for (UocAfterOrderCreateReqItemBo uocAfterOrderCreateReqItemBo : shipItemList) {
                Long shipOrderItemId = uocAfterOrderCreateReqItemBo.getShipOrderItemId();
                UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
                uocShipOrderItemQryBo.setShipOrderItemId(shipOrderItemId);
                uocShipOrderItemQryBo.setShipOrderId(reqBo.getShipOrderId());
                UocShipOrderDo shipOrderItem = shipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
                if (ObjectUtil.isNotEmpty(shipOrderItem) && ObjectUtil.isNotEmpty(shipOrderItem.getShipOrderItemBoList())) {
                    UocAfOrderItem uocAfOrderItem = new UocAfOrderItem();
                    List<UocShipOrderItem> shipOrderItemBoList = shipOrderItem.getShipOrderItemBoList();
                    UocShipOrderItem uocShipOrderItem = shipOrderItemBoList.get(0);
                    BeanUtil.copyProperties(uocShipOrderItem, uocAfOrderItem);
                    Long saleOrderItemId = uocShipOrderItem.getSaleOrderItemId();
                    UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
                    uocSaleOrderItemQryBo.setSaleOrderItemId(saleOrderItemId);
                    List<UocSaleOrderItem> saleOrderItemList = saleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
                    UocSaleOrderItem uocSaleOrderItem = saleOrderItemList.get(0);
                    BeanUtil.copyProperties(uocSaleOrderItem, uocAfOrderItem);
                    uocAfOrderItem.setSaleItemId(uocShipOrderItem.getSaleOrderItemId());
                    uocAfOrderItem.setShipItemId(uocShipOrderItem.getShipOrderItemId());
                    uocAfOrderItem.setReturnCount(uocAfterOrderCreateReqItemBo.getReturnCount());
                    uocAfOrderItem.setRetPurchaseFee(uocSaleOrderItem.getPurchasePrice().multiply(uocAfterOrderCreateReqItemBo.getReturnCount()));
                    uocAfOrderItem.setRetSaleFee(uocSaleOrderItem.getSalePrice().multiply(uocAfterOrderCreateReqItemBo.getReturnCount()));
                    uocAfOrderItems.add(uocAfOrderItem);
                }
            }
        }
        if (UocConstant.AFTERORDER_SERVTYPE.RETURN.equals(reqBo.getServType())) {
            createDo.setRealReturnFee(uocAfOrderItems.stream().map(UocAfOrderItem::getRetSaleFee).reduce((x,y)->x.add(y)).get());
        }
        createDo.setAfOrderItemBoList(uocAfOrderItems);
        createDo.setRetTotalSaleFee(uocAfOrderItems.stream().map(UocAfOrderItem::getRetSaleFee).reduce((x,y)->x.add(y)).get());
        createDo.setRetTotalPurchaseFee(uocAfOrderItems.stream().map(UocAfOrderItem::getRetPurchaseFee).reduce((x,y)->x.add(y)).get());
    }


    private UocAfOrderDo convertOrderDo(UocAfterOrderCreateReqBo reqBo) {
        UocAfOrderDo uocAfOrderDo = UocRu.js(reqBo, UocAfOrderDo.class);
        UocAfOrderObj uocAfOrderObj = UocRu.js(reqBo, UocAfOrderObj.class);
        ArrayList<UocAfOrderObj> uocAfOrderObjs = new ArrayList<>();
        uocAfOrderObjs.add(uocAfOrderObj);
        uocAfOrderDo.setAfOrderObjList(uocAfOrderObjs);
        uocAfOrderDo.setExtAfId(reqBo.getServiceId());
        List<UocBaseExtParallelBo> extParallelBoList = reqBo.getExtParallelBoList();
        if (CollectionUtil.isNotEmpty(extParallelBoList)) {
            uocAfOrderDo.setExtParallelBoList(UocRu.jsl(extParallelBoList, UocAfOrderMap.class));
            BeanUtils.copyProperties(reqBo, uocAfOrderDo);
            uocAfOrderDo.setCreateTime(new Date());
            uocAfOrderDo.setCreateOperId(String.valueOf(reqBo.getUserId()));
        }
        List<UocAfterOrderCreateReqItemBo> shipItemList = reqBo.getShipItemList();
        if (CollectionUtil.isNotEmpty(shipItemList)) {
            uocAfOrderDo.setAfOrderItemBoList(UocRu.jsl(shipItemList, UocAfOrderItem.class));
            for (UocAfOrderItem uocAfOrderItem : uocAfOrderDo.getAfOrderItemBoList()) {
                BeanUtils.copyProperties(reqBo, uocAfOrderItem);
                uocAfOrderItem.setCreateTime(new Date());
                uocAfOrderItem.setCreateOperId(String.valueOf(reqBo.getUserId()));
            }
        }
        List<UocBaseOrderAccessoryAddBo> orderAccessoryBoList = reqBo.getOrderAccessoryBoList();
        if (CollectionUtil.isNotEmpty(orderAccessoryBoList)) {
            uocAfOrderDo.setOrderAccessoryBoList(UocRu.jsl(orderAccessoryBoList, UocOrderAccessory.class));
            for (UocOrderAccessory uocOrderAccessory : uocAfOrderDo.getOrderAccessoryBoList()) {
                BeanUtils.copyProperties(reqBo, uocOrderAccessory);
                uocOrderAccessory.setCreateTime(new Date());
                uocOrderAccessory.setAttachmentType(1);
                uocOrderAccessory.setCreateOperId(String.valueOf(reqBo.getUserId()));
            }
        }
        UocAfterOrderCreateReqAddressBo takeAddress = reqBo.getTakeAddress();
        UocAfterOrderCreateReqAddressBo returnAddress = reqBo.getReturnAddress();
        if (ObjectUtil.isNotEmpty(takeAddress)) {
            uocAfOrderDo.setTakeAddress(UocRu.js(takeAddress, UocOrdLogisticsRela.class));
            uocAfOrderDo.getTakeAddress().setCreateOperId(String.valueOf(reqBo.getUserId()));
        }
        if (ObjectUtil.isNotEmpty(returnAddress)) {
            uocAfOrderDo.setReturnAddress(UocRu.js(returnAddress, UocOrdLogisticsRela.class));
            uocAfOrderDo.getReturnAddress().setCreateOperId(String.valueOf(reqBo.getUserId()));
        }
        uocAfOrderDo.setSubContactName(reqBo.getName());
        uocAfOrderDo.setSubContactMobile(reqBo.getCellphone());
        uocAfOrderDo.setCreateTime(new Date());
        uocAfOrderDo.setCreateOperId(String.valueOf(reqBo.getUserId()));
        uocAfOrderDo.setSubmiteTime(new Date());
        uocAfOrderDo.setSubmitterOperId(String.valueOf(reqBo.getUserId()));
        uocAfOrderDo.setSubmitterOperName(reqBo.getUsername());
        uocAfOrderDo.setSubDeptId(String.valueOf(reqBo.getOrgId()));
        uocAfOrderDo.setSubDeptName(reqBo.getOrgName());
        uocAfOrderDo.setSubCompId(String.valueOf(reqBo.getCompanyId()));
        uocAfOrderDo.setSubCompName(reqBo.getCompanyName());

        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        UocSaleOrderDo saleOrderMain = saleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        uocAfOrderDo.setPayType(saleOrderMain.getPayType());
        uocAfOrderDo.setPayTypeStr(saleOrderMain.getPayTypeStr());
        return uocAfOrderDo;
    }

    private void validateArg(UocAfterOrderCreateReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocAfterOrderCreateReqBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getShipOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[发货单ID]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[订单ID]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getSaleOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[销售单ID]不能为空");
        }

        if (ObjectUtil.isEmpty(reqBo.getServType())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[服务类型]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getAfsReason())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[售后原因]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getPickwareType())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[取货服务类型]不能为空");
        }

        if (UocConstant.AFTERORDER_PICKWARETYPE.UPDOORPICK.equals(reqBo.getPickwareType())) {
            if (ObjectUtil.isEmpty(reqBo.getTakeAddress())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[取件地址]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getTakeAddress().getContactProvinceId())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人省份编号]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getTakeAddress().getContactProvinceName())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人省份名称]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getTakeAddress().getContactCityId())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人地市编号]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getTakeAddress().getContactCityName())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人地市名称]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getTakeAddress().getContactCountyId())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人区县编号]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getTakeAddress().getContactCountyName())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人区县名称]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getTakeAddress().getContactAddress())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[收货人地址]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getTakeAddress().getContactName())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人名称]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getTakeAddress().getContactEmail())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人邮件]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getTakeAddress().getContactMobile())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人手机]不能为空");
            }
        }

        if (UocConstant.AFTERORDER_SERVTYPE.CHANGE.equals(reqBo.getServType()) || UocConstant.AFTERORDER_SERVTYPE.FIX.equals(reqBo.getServType())) {
            if (ObjectUtil.isEmpty(reqBo.getReturnAddress())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[返件地址]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getReturnAddress().getContactProvinceId())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人省份编号]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getReturnAddress().getContactProvinceName())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人省份名称]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getReturnAddress().getContactCityId())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人地市编号]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getReturnAddress().getContactCityName())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人地市名称]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getReturnAddress().getContactCountyId())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人区县编号]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getReturnAddress().getContactCountyName())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人区县名称]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getReturnAddress().getContactAddress())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[收货人地址]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getReturnAddress().getContactName())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人名称]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getReturnAddress().getContactEmail())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人邮件]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getReturnAddress().getContactMobile())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人手机]不能为空");
            }
        }
        if (ObjectUtil.isEmpty(reqBo.getQuestionDesc())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[问题描述]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getShipItemList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[售后明细]不能为空");
        }
        for (UocAfterOrderCreateReqItemBo uocAfterOrderCreateReqItemBo : reqBo.getShipItemList()) {
            if (ObjectUtil.isEmpty(uocAfterOrderCreateReqItemBo.getShipOrderItemId())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[发货明细ID]不能为空");
            }
            if (ObjectUtil.isEmpty(uocAfterOrderCreateReqItemBo.getReturnCount())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[售后数量]不能为空");
            }
        }
        if (ObjectUtil.isEmpty(reqBo.getOrderAccessoryBoList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[附件]不能为空");
        }
    }
}
