package com.tydic.dyc.oc.components.es.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.dyc.oc.components.es.IUocEsSync;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryRspBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderObjQryBo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderProcInstQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskDealQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderAgreement;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocOrderAgreementQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderPayConfQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspPorcBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskDealBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 标题:UocEsSyncChng
 * 说明:变更单
 * 时间:2022/3/10 14:52
 * 作者:罗有
 */

@Slf4j
@Service
public class UocEsSyncChng implements IUocEsSync {

    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;

    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

    @Override
    public String indexName() {
        return uocIndexConfig.getChngOrderIndex();
    }

    @Override
    public IUocEsSyncQryRspBo qryData(IUocEsSyncQryReqBo reqBo) {
        IUocEsSyncQryRspBo iUocEsSyncQryRspBo = new IUocEsSyncQryRspBo();
        iUocEsSyncQryRspBo.setObjId(reqBo.getObjId());
        UocChngOrderDo chngOrder = getUocChngOrderDo(reqBo);
        if (null == chngOrder) {
            return iUocEsSyncQryRspBo;
        }
        Map<String, Map<String, String>> dicMap = getDic();
        List<UocChngOrderObj> chngOrderObjList = getChngOrderObjList(reqBo);
        UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
        if (!CollectionUtils.isEmpty(chngOrderObjList)) {
            chngOrder.setChngType(chngOrderObjList.get(0).getChngType());
            if (ObjectUtil.isNotEmpty(dicMap.get(UocStateConstants.ChngOrder.CHNG_TYPE.P_CODE)) && ObjectUtil.isNotNull(chngOrderObjList.get(0).getChngType())) {
                chngOrder.setChngTypeStr(dicMap.get(UocStateConstants.ChngOrder.CHNG_TYPE.P_CODE).get(chngOrderObjList.get(0).getChngType().toString()));
            }
            List<UocChngOrderObj> filterChngOrderObjs = chngOrderObjList.stream().filter(each -> ObjectUtil.isNotNull(each.getShipOrderId())).collect(Collectors.toList());
            if (ObjectUtil.isNotEmpty(filterChngOrderObjs)) {
                uocShipOrderDo = getUocShipOrderDo(filterChngOrderObjs);
                if (ObjectUtil.isNotNull(uocShipOrderDo)) {
                    chngOrder.setShipOrderNo(uocShipOrderDo.getShipOrderNo());
                    chngOrder.setShipOrderState(uocShipOrderDo.getShipOrderState());
                    chngOrder.setInspTime(uocShipOrderDo.getInspTime());
                    chngOrder.setInspOperName(uocShipOrderDo.getInspOperName());
                    if (ObjectUtil.isNotEmpty(dicMap.get(UocStateConstants.ShipOrder.P_CODE))) {
                        chngOrder.setShipOrderStateStr(dicMap.get(UocStateConstants.ShipOrder.P_CODE).get(uocShipOrderDo.getShipOrderState()));
                    }
                    //查询发货单明细
                    uocShipOrderDo.setShipOrderItemBoList(getShipOrderItem(uocShipOrderDo).getShipOrderItemBoList());
                }
            }
        }


        chngOrder.setUocChngOrderObjList(chngOrderObjList);
        Map<String, String> chngOrderState = new HashMap<>();
        if (ObjectUtil.equal(chngOrder.getBusiType(), UocConstant.BUSI_TYPE.SALE_ORDER_CANCEL)) {
            chngOrderState = dicMap.get(UocStateConstants.ChngOrder.SALE_ORDER_CANCEL.P_CODE);
        } else {
            chngOrderState = dicMap.get(UocStateConstants.ChngOrder.CHNG_ORDER_STATE.P_CODE);
        }
        log.info("dicMap:{}", JSON.toJSONString(dicMap));
        log.info(JSON.toJSONString(chngOrder));
        chngOrder.setChngOrderStateStr(chngOrderState.get(chngOrder.getChngOrderState()));
        JSONObject chngOrderJson = JSON.parseObject(JSON.toJSONString(chngOrder, SerializerFeature.WriteMapNullValue));
        if ( ObjectUtil.equal(chngOrder.getBusiType(), UocConstant.BUSI_TYPE.SALE_ORDER_CANCEL) ) {
            chngOrderJson.put(UocConstant.ES_MAIN_OTHER.CANCEL_APPLY_FLAG, true);
        } else {
            chngOrderJson.put(UocConstant.ES_MAIN_OTHER.CANCEL_APPLY_FLAG, false);
        }
        Map<Integer, UocChngOrderObj> chngTypeMaps = chngOrderObjList.stream().collect(Collectors.toMap(UocChngOrderObj::getChngType, o -> o));
        UocChngOrderObj uocChngOrderObj2 = chngTypeMaps.get(2);
        UocChngOrderObj uocChngOrderObj5 = chngTypeMaps.get(5);
        Optional.ofNullable(uocChngOrderObj2).ifPresent(x -> chngOrderJson.put(UocConstant.ES_MAIN_OTHER.ADJUST_PURCHASE_PRICE, uocChngOrderObj2.getChngFee()));
        Optional.ofNullable(uocChngOrderObj5).ifPresent(x -> chngOrderJson.put(UocConstant.ES_MAIN_OTHER.ADJUST_SALE_PRICE, uocChngOrderObj5.getChngFee()));
        if (!CollectionUtils.isEmpty(chngOrderObjList)) {
            UocSaleOrderDo saleOrder = getSaleOrder(chngOrderObjList.get(0));
            UocGetSaleOrderDetailServiceRspPorcBo busiProcInst = new UocGetSaleOrderDetailServiceRspPorcBo();
            UocGetSaleOrderDetailServiceRspPorcBo chngBusiProcInst = new UocGetSaleOrderDetailServiceRspPorcBo();
            UocGetSaleOrderDetailServiceRspPorcBo auditProcInst = new UocGetSaleOrderDetailServiceRspPorcBo();
            if (null != saleOrder) {
                Map<String, String> saleOrderState = dicMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE);
                saleOrder.setSaleOrderStateStr(saleOrderState.get(saleOrder.getSaleOrderState()));
                saleOrder.setPayType(saleOrderState.get(saleOrder.getSaleOrderState()));
                saleOrder.setModelSettleStr(null != saleOrder.getModelSettle() ?
                        dicMap.get(UocDicConstant.MODEL_SETTLE.P_CODE).get(saleOrder.getModelSettle() != null ? saleOrder.getModelSettle().toString() : saleOrder.getModelSettle()) : "");
                List<UocSaleOrderItem> uocSaleOrderItemList = getListSaleOrderItem(chngOrderObjList.get(0));
                if (ObjectUtil.isNotEmpty(uocSaleOrderItemList) && ObjectUtil.isNotEmpty(uocShipOrderDo.getShipOrderItemBoList())) {
                    Map<Long, UocSaleOrderItem> saleItemMap = uocSaleOrderItemList.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));
                    final BigDecimal[] saleFee = {BigDecimal.ZERO};
                    final BigDecimal[] purFee = {BigDecimal.ZERO};
                    uocShipOrderDo.getShipOrderItemBoList().forEach(each -> {
                        if (saleItemMap.containsKey(each.getSaleOrderItemId()) && each.getSendCount() != null) {
                            saleFee[0] = saleFee[0].add(saleItemMap.get(each.getSaleOrderItemId()).getSalePrice().multiply(each.getSendCount()));
                            purFee[0] = purFee[0].add(saleItemMap.get(each.getSaleOrderItemId()).getPurchasePrice().multiply(each.getSendCount()));
                        }
                    });
                    chngOrderJson.put(UocConstant.ES_MAIN_OTHER.SALE_FEE, saleFee[0]);
                    chngOrderJson.put(UocConstant.ES_MAIN_OTHER.PUR_FEE, purFee[0]);
                }

                saleOrder.setSaleOrderItems(uocSaleOrderItemList);
                List<UocSaleOrderPayConf> saleOrderPayConfList = getUocSaleOrderPayConf(saleOrder);
                if (!CollectionUtils.isEmpty(saleOrderPayConfList)) {
                    Map<String, String> payType = dicMap.get(UocDicConstant.PAY_TYPE.P_CODE);
                    saleOrder.setSaleOrderPayConfList(saleOrderPayConfList);
                    for (UocSaleOrderPayConf uocSaleOrderPayConf : saleOrderPayConfList) {
                        if (UocDicConstant.USE_TYPE.PUR.equals(uocSaleOrderPayConf.getUserType())) {
                            chngOrderJson.put(UocConstant.ES_MAIN_OTHER.PAY_TYPE, payType.get(uocSaleOrderPayConf.getPayType().toString()));
                        }
                    }
                }
                chngOrderJson.put(UocConstant.ES_MAIN_OTHER.ORDER_SOURCE, saleOrder.getOrderSource());
                chngOrderJson.put(UocConstant.ES_MAIN_OTHER.ORDER_SOURCE_STR, saleOrder.getOrderSourceStr());
                chngOrderJson.put(UocConstant.ES_MAIN_OTHER.UOC_SALE_ORDER_ITEM, JSON.parseArray(JSON.toJSONString(saleOrder.getSaleOrderItems())));
                if (ObjectUtil.isNotEmpty(saleOrder.getStakeholder())) {
                    chngOrderJson.put(UocConstant.ES_MAIN_OTHER.SUP_ID, saleOrder.getStakeholder().getSupId());
                    chngOrderJson.put(UocConstant.ES_MAIN_OTHER.SUP_NAME, saleOrder.getStakeholder().getSupName());
                    chngOrderJson.put(UocConstant.ES_MAIN_OTHER.PUR_ORG_ID, saleOrder.getStakeholder().getPurOrgId());
                    chngOrderJson.put(UocConstant.ES_MAIN_OTHER.PUR_ORG_NAME, saleOrder.getStakeholder().getPurOrgName());
                    chngOrderJson.put(UocConstant.ES_MAIN_OTHER.PRO_ID, saleOrder.getStakeholder().getProId());
                    chngOrderJson.put(UocConstant.ES_MAIN_OTHER.PUR_USER_ID, saleOrder.getStakeholder().getPurUserId());
                }
                //查询业务流程实例
                busiProcInst = getProcInst(saleOrder.getOrderId(),saleOrder.getSaleOrderId(),UocDicConstant.OBJ_TYPE.SALE, false);
                //查询变更单业务流程实例
                chngBusiProcInst = getProcInst(reqBo.getOrderId(),reqBo.getObjId(),UocDicConstant.OBJ_TYPE.CHNG, false);
                //查询审批流程实例
                auditProcInst = getProcInst(reqBo.getOrderId(),saleOrder.getSaleOrderId(),UocDicConstant.OBJ_TYPE.SALE, true);
                chngOrderJson.put(UocConstant.ES_MAIN_OTHER.SALE_ORDER_INFO, saleOrder);

                //协议信息
                //拉横协议信息
                if (UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(saleOrder.getOrderSource())) {
                    //查询协议信息
                    List<UocOrderAgreement> agreementOrderList = getAgreementOrderList(saleOrder);
                    //协议信息
                    if (ObjectUtil.isNotEmpty(agreementOrderList)) {
                        putAgreementInfo(agreementOrderList, chngOrderJson);
                    }
                }

                //判断贸易模式 合并单据 明细信息
                if (UocDicConstant.TRADE_MODE.TRADE_MODE.equals(saleOrder.getModelSettle())) {
                    List<UocChngOrderItemObj> uocChngOrderItemObjList = new ArrayList<>();
                    chngOrderObjList.forEach(x->{
                        if ( !CollectionUtils.isEmpty(x.getUocChngOrderItemObjList()) ) {
                            uocChngOrderItemObjList.addAll(x.getUocChngOrderItemObjList());
                        }
                    });
                    chngOrderObjList = chngOrderObjList.stream().sorted(new Comparator<UocChngOrderObj>() {
                        @Override
                        public int compare(UocChngOrderObj o1, UocChngOrderObj o2) {
                            return o1.getChngType().compareTo(o2.getChngType());
                        }
                    }).collect(Collectors.toList());
                    Map<Long, List<UocChngOrderItemObj>> saleItemMaps = uocChngOrderItemObjList.stream().collect(Collectors.groupingBy(UocChngOrderItemObj::getSaleOrderItemId));
                    for (UocChngOrderObj uocChngOrderObj : chngOrderObjList) {
                        if (UocConstant.BUSI_TYPE.ADJUST_PRICE.equals(uocChngOrderObj.getChngType())) {
                            List<UocChngOrderItemObj> chngOrderItemObjList = new ArrayList<>();
                            List<UocChngOrderItemObj> uocChngOrderItemObjList1 = uocChngOrderObj.getUocChngOrderItemObjList();
                            for (UocChngOrderItemObj uocChngOrderItemObj : uocChngOrderItemObjList1) {
                                List<UocChngOrderItemObj> uocChngOrderItemObjs = saleItemMaps.get(uocChngOrderItemObj.getSaleOrderItemId());
                                UocChngOrderItemObj uocChngOrderItemObj1 = uocChngOrderItemObjs.stream().filter(x -> UocConstant.BUSI_TYPE.STATE_FIVE.equals(x.getChngType())).collect(Collectors.toList()).get(0);
                                uocChngOrderItemObj.setChngFeeFive(uocChngOrderItemObj1.getChngFee());
                                chngOrderItemObjList.add(uocChngOrderItemObj);
                            }
                            List<UocChngOrderObj> uocChngOrderObjs = new ArrayList<>();
                            uocChngOrderObj.setUocChngOrderItemObjList(chngOrderItemObjList);
                            uocChngOrderObjs.add(uocChngOrderObj);
                            chngOrder.setUocChngOrderObjList(uocChngOrderObjs);
                            break;
                        }
                    }
                }
            }

            chngOrderJson.put(UocConstant.ES_MAIN_OTHER.SALE_ORDER_INFO, saleOrder);
            chngOrderJson.put(UocConstant.ES_MAIN_OTHER.BUSI_PROC_INST, ObjectUtil.isNotEmpty(busiProcInst.getProcInstId()) ? busiProcInst.getProcInstId() : "");
            chngOrderJson.put(UocConstant.ES_MAIN_OTHER.BUSI_TASK_INST, ObjectUtil.isNotEmpty(busiProcInst.getTaskList()) ? busiProcInst.getTaskList() : new ArrayList<>());

            chngOrderJson.put(UocConstant.ES_MAIN_OTHER.CHNG_BUSI_PROC_INST, ObjectUtil.isNotEmpty(chngBusiProcInst.getProcInstId()) ? chngBusiProcInst.getProcInstId() : "");
            chngOrderJson.put(UocConstant.ES_MAIN_OTHER.CHNG_BUSI_TASK_INST, ObjectUtil.isNotEmpty(chngBusiProcInst.getTaskList()) ? chngBusiProcInst.getTaskList() : new ArrayList<>());
            chngOrderJson.put(UocConstant.ES_MAIN_OTHER.AUDIT_TASK_INST, ObjectUtil.isNotEmpty(auditProcInst.getTaskList()) ? auditProcInst.getTaskList() : new ArrayList<>());
        }
        if (!CollectionUtils.isEmpty(chngOrder.getUocChngOrderMapList())) {
            chngOrder.getUocChngOrderMapList().forEach(uocChngOrderMap -> chngOrderJson.put(uocChngOrderMap.getFieldCode(), uocChngOrderMap.getFieldValue()));
        }

        iUocEsSyncQryRspBo.setJsonObj(chngOrderJson);
        return iUocEsSyncQryRspBo;
    }

    private UocChngOrderDo getUocChngOrderDo(IUocEsSyncQryReqBo reqBo) {
        UocChngOrderQryBo uocChngOrderQryBo = new UocChngOrderQryBo();
        uocChngOrderQryBo.setChngOrderId(reqBo.getObjId());
        uocChngOrderQryBo.setOrderId(reqBo.getOrderId());
        return iUocChngOrderModel.getChngOrder(uocChngOrderQryBo);
    }

    /**
     * 协议单列表查询
     *
     * @param saleOrder
     * @return java.util.List<com.tydic.dyc.oc.model.saleorder.sub.UocOrderAgreement></>
     */
    private List<UocOrderAgreement> getAgreementOrderList(UocSaleOrderDo saleOrder) {
        UocOrderAgreementQryBo uocOrderAgreementQryBo = new UocOrderAgreementQryBo();
        uocOrderAgreementQryBo.setOrderId(saleOrder.getOrderId());
        uocOrderAgreementQryBo.setId(saleOrder.getAgrDataId());
        return iUocSaleOrderModel.getAgreementOrderList(uocOrderAgreementQryBo);
    }

    /**
     * 拉横协议信息
     *
     * @param agreementOrderList
     * @param saleOrderObj
     */
    private void putAgreementInfo(List<UocOrderAgreement> agreementOrderList, JSONObject saleOrderObj) {
        UocOrderAgreement agreement = agreementOrderList.get(0);
        //协议模式
        saleOrderObj.put(UocConstant.ES_MAIN_OTHER.AGR_CODE, agreement.getAgreementCode());
        //平台协议编号
        saleOrderObj.put(UocConstant.ES_MAIN_OTHER.PLA_AGR_CODE, agreement.getPlaAgreementCode());
        //协议名称
        saleOrderObj.put(UocConstant.ES_MAIN_OTHER.AGR_NAME, agreement.getAgreementName());
    }

    private UocShipOrderDo getUocShipOrderDo(List<UocChngOrderObj> chngOrderObjList) {
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(chngOrderObjList.get(0).getOrderId());
        uocShipOrderQryBo.setShipOrderId(chngOrderObjList.get(0).getShipOrderId());
        UocShipOrderDo shipOrderDo = iUocShipOrderModel.getShipOrderById(uocShipOrderQryBo);
        return shipOrderDo;
    }

    private UocShipOrderDo getShipOrderItem(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setShipOrderId(uocShipOrderDo.getShipOrderId());
        uocShipOrderItemQryBo.setOrderId(uocShipOrderDo.getOrderId());
        return iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
    }

    private List<UocChngOrderObj> getChngOrderObjList(IUocEsSyncQryReqBo reqBo) {
        UocChngOrderObjQryBo uocChngOrderObjQryBo = new UocChngOrderObjQryBo();
        uocChngOrderObjQryBo.setOrderId(reqBo.getOrderId());
        uocChngOrderObjQryBo.setChngOrderId(reqBo.getObjId());
        return iUocChngOrderModel.getListChngOrderObj(uocChngOrderObjQryBo);
    }

    private UocSaleOrderDo getSaleOrder(UocChngOrderObj uocChngOrderObj) {
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setSaleOrderId(uocChngOrderObj.getSaleOrderId());
        uocSaleOrderQryBo.setOrderId(uocChngOrderObj.getOrderId());
        return iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
    }

    private List<UocSaleOrderItem> getListSaleOrderItem(UocChngOrderObj uocChngOrderObj) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderId(uocChngOrderObj.getSaleOrderId());
        uocSaleOrderItemQryBo.setOrderId(uocChngOrderObj.getOrderId());
        return iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
    }

    private Map<String, Map<String, String>> getDic() {
        List<String> pCodes = new ArrayList<>();
        pCodes.add(UocStateConstants.ShipOrder.P_CODE);
        pCodes.add(UocDicConstant.SALE_ORD_STATE.P_CODE);
        pCodes.add(UocDicConstant.PAY_TYPE.P_CODE);
        pCodes.add(UocStateConstants.ChngOrder.SALE_ORDER_CANCEL.P_CODE);
        pCodes.add(UocStateConstants.ChngOrder.CHNG_ORDER_STATE.P_CODE);
        pCodes.add(UocStateConstants.ChngOrder.CHNG_TYPE.P_CODE);
        pCodes.add(UocDicConstant.MODEL_SETTLE.P_CODE);
        return iUocSysDictionaryModel.getDictionaryMap(pCodes);
    }

    private List<UocSaleOrderPayConf> getUocSaleOrderPayConf(UocSaleOrderDo saleOrder) {
        UocSaleOrderPayConfQryBo uocSaleOrderPayConfQryBo = new UocSaleOrderPayConfQryBo();
        uocSaleOrderPayConfQryBo.setOrderId(saleOrder.getOrderId());
        uocSaleOrderPayConfQryBo.setSaleOrderId(saleOrder.getSaleOrderId());
        return iUocSaleOrderModel.getSaleOrderPayConfList(uocSaleOrderPayConfQryBo);
    }

    /**
     * 查询流程任务实例
     *
     * @param orderId
     * @param objId
     * @param objType
     * @param isAudit
     * @return UocGetSaleOrderDetailServiceRspPorcBo
     */
    private UocGetSaleOrderDetailServiceRspPorcBo getProcInst(Long orderId,Long objId,Integer objType, Boolean isAudit) {
        UocGetSaleOrderDetailServiceRspPorcBo procInst = new UocGetSaleOrderDetailServiceRspPorcBo();
        UocOrderProcInstQryBo procInstQryBo = new UocOrderProcInstQryBo();
        if (isAudit) {
            procInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
        } else {
            procInstQryBo.setObjId(objId);
            procInstQryBo.setObjType(objType);
        }
        procInstQryBo.setOrderId(orderId);
        procInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        List<UocOrderProcInst> uocOrderProcInsts = iUocOrderModel.qryOrderProcInstList(procInstQryBo);
        if (ObjectUtil.isNotEmpty(uocOrderProcInsts)) {
            procInst = UocRu.jsl(uocOrderProcInsts, UocGetSaleOrderDetailServiceRspPorcBo.class).get(0);
            UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
            taskInstQryBo.setObjId(procInst.getObjId());
            taskInstQryBo.setObjType(procInst.getObjType());
            List<Integer> finishTagList = new ArrayList<>();
            finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
            finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.END_TASK);
            taskInstQryBo.setFinishTagList(finishTagList);
            List<UocOrderTaskInst> uocOrderTaskInsts = iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
            List<UocGetSaleOrderDetailServiceRspTaskBo> taskBoList = new ArrayList<>();
            if (ObjectUtil.isNotEmpty(uocOrderTaskInsts)) {
                taskBoList = UocRu.jsl(uocOrderTaskInsts, UocGetSaleOrderDetailServiceRspTaskBo.class);
                taskBoList.forEach(each -> {
                    UocOrderTaskDealQryBo taskDealQryBo = new UocOrderTaskDealQryBo();
                    taskDealQryBo.setTaskInstId(each.getTaskInstId());
                    taskDealQryBo.setObjId(each.getObjId());
                    taskDealQryBo.setObjType(each.getObjType());
                    List<UocOrderTaskDeal> uocOrderTaskDeals = iUocOrderModel.qryOrderTaskDealList(taskDealQryBo);
                    each.setTaskDealBo(ObjectUtil.isNotEmpty(uocOrderTaskDeals) ? UocRu.jsl(uocOrderTaskDeals, UocGetSaleOrderDetailServiceRspTaskDealBo.class) : new ArrayList<>());
                });
            }
            procInst.setTaskList(taskBoList);
        }
        return procInst;
    }
}
