package com.tydic.dyc.oc.model.aforder.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocObjNoConstants;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.UocAfOrderDo;
import com.tydic.dyc.oc.model.aforder.qrybo.*;
import com.tydic.dyc.oc.model.aforder.sub.*;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.repository.*;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderSupplierConfirmReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderSupplierConfirmRspBo;
import com.tydic.dyc.oc.utils.IdUtil;

import com.tydic.dyc.oc.utils.UocRu;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Optional;

/**
 * 标题:UocAfOrderModelImpl
 * 说明:售后单
 * 时间:2022/3/8 18:10
 * 作者:罗有
 */

@Service
public class UocAfOrderModelImpl implements IUocAfOrderModel {
    @Autowired
    private UocAfOrderRepository uocAfOrderRepository;
    @Autowired
    private UocCommonRepository uocCommonRepository;
    @Autowired
    private UocSaleOrderRepository saleOrderRepository;
    @Autowired
    private UocShipOrderRepository shipOrderRepository;
    @Override
    public List<UocAfOrderItem> getAfOrderItemList(UocAfOrderItemQryBo uocAfOrderItemQryBo) {
        if (ObjectUtil.isNull(uocAfOrderItemQryBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocAfOrderRepository.getAfOrderItemList(uocAfOrderItemQryBo);
    }

    @Override
    public UocAfOrder getAfOrderById(UocAfOrderQryBo uocAfOrderQryBo) {
        if (ObjectUtil.isNull(uocAfOrderQryBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocAfOrderRepository.getAfOrderById(uocAfOrderQryBo);
    }

    @Override
    public List<UocAfOrder> getAfOrderList(UocAfOrderQryBo uocAfOrderQryBo) {
        if (ObjectUtil.isNull(uocAfOrderQryBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocAfOrderRepository.getAfOrderList(uocAfOrderQryBo);
    }

    @Override
    public List<UocAfOrderObj> getAfOrderObjList(UocAfOrderObjQryBo uocAfOrderObjQryBo) {
        if (ObjectUtil.isNull(uocAfOrderObjQryBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocAfOrderRepository.getAfOrderObjList(uocAfOrderObjQryBo);
    }

    @Override
    public List<UocAfOrderMap> getAfOrderMapList(UocAfOrderMapQryBo uocAfOrderMapQryBo) {
        if (ObjectUtil.isNull(uocAfOrderMapQryBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocAfOrderRepository.getAfOrderMapList(uocAfOrderMapQryBo);
    }

    @Override
    public List<UocAfOrderWaybill> getAfOrderWayBillList(UocAfOrderWaybillQryBo uocAfOrderWaybillQryBo) {
        if (ObjectUtil.isNull(uocAfOrderWaybillQryBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocAfOrderRepository.getAfOrderWayBillList(uocAfOrderWaybillQryBo);
    }

    @Override
    public UocAfOrderDo dealPebTheZoneAfterApplication(UocAfOrderDo afOrderDo,Integer orderSource) {
        if (ObjectUtil.isNull(afOrderDo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        afOrderDo.setAfOrderId(IdUtil.nextId());
        afOrderDo.setServState(UocDicConstant.SERVICE_STATE.SUMIT_APPLICATION);
        UocAfOrderDo afterOrderNo = getAfterOrderNo(new UocAfOrderDo(),orderSource);
        afOrderDo.setAfServCode(afterOrderNo.getAfServCode());
        List<UocAfOrderMap> extParallelBoList = afOrderDo.getExtParallelBoList();
        if (ObjectUtil.isNotEmpty(extParallelBoList)) {
            for (UocAfOrderMap uocAfOrderMap : extParallelBoList) {
                uocAfOrderMap.setAfOrderId(afOrderDo.getAfOrderId());
                uocAfOrderMap.setId(IdUtil.nextId());
            }
        }
        UocOrdLogisticsRela takeAddress = afOrderDo.getTakeAddress();
        if (ObjectUtil.isNotEmpty(takeAddress)) {
            takeAddress.setContactId(IdUtil.nextId());
            takeAddress.setOrderId(afOrderDo.getOrderId());
            takeAddress.setCreateTime(new Date());
            afOrderDo.setContactId(takeAddress.getContactId());
        }
        UocOrdLogisticsRela returnAddress = afOrderDo.getReturnAddress();
        if (ObjectUtil.isNotEmpty(returnAddress)) {
            returnAddress.setContactId(IdUtil.nextId());
            returnAddress.setOrderId(afOrderDo.getOrderId());
            returnAddress.setCreateTime(new Date());
            afOrderDo.setTpContactId(takeAddress.getContactId());
        }
        List<UocAfOrderObj> afOrderObjList = afOrderDo.getAfOrderObjList();
        if (ObjectUtil.isNotEmpty(afOrderObjList)) {
            for (UocAfOrderObj uocAfOrderObj : afOrderObjList) {
                uocAfOrderObj.setAfOrderId(afOrderDo.getAfOrderId());
                uocAfOrderObj.setId(IdUtil.nextId());
                uocAfOrderObj.setCreateTime(new Date());
                uocAfOrderObj.setOrderId(afOrderDo.getOrderId());
                uocAfOrderObj.setCreateOperId(afOrderDo.getCreateOperId());
            }
        }
        List<UocAfOrderItem> afOrderItemBoList = afOrderDo.getAfOrderItemBoList();
        if (ObjectUtil.isNotEmpty(afOrderItemBoList)) {
            for (UocAfOrderItem uocAfOrderItem : afOrderItemBoList) {
                uocAfOrderItem.setAfOrderId(afOrderDo.getAfOrderId());
                uocAfOrderItem.setAfOrderItemId(IdUtil.nextId());
            }
        }
        List<UocOrderAccessory> orderAccessoryBoList = afOrderDo.getOrderAccessoryBoList();
        if (ObjectUtil.isNotEmpty(orderAccessoryBoList)) {
            for (UocOrderAccessory uocOrderAccessory : orderAccessoryBoList) {
                uocOrderAccessory.setOrderId(afOrderDo.getOrderId());
                uocOrderAccessory.setObjId(afOrderDo.getAfOrderId());
                uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.AFTER);
                uocOrderAccessory.setCreateTime(new Date());
                uocOrderAccessory.setCreateOperId(afOrderDo.getCreateOperId());
                uocOrderAccessory.setId(IdUtil.nextId());
            }
        }
        return uocAfOrderRepository.saveAfterOder(afOrderDo);
    }

    @Override
    public UocAfOrderDo getAfterOrderNo(UocAfOrderDo afOrderDo,Integer orderSource) {
        if (null == afOrderDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        String orderNo = uocCommonRepository.getOrderNoSingle(UocObjNoConstants.ORDER_AS_NO+"_"+orderSource);
        afOrderDo.setAfServCode(orderNo);
        return afOrderDo;
    }

    @Override
    public List<UocAfItemMap> getAfOrderItemMapList(UocAfItemMapQryBo uocAfItemMapQryBo) {
        if (ObjectUtil.isNull(uocAfItemMapQryBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocAfOrderRepository.getAfOrderItemMapList(uocAfItemMapQryBo);
    }

    @Override
    public void updateBatchAfOrderMain(List<UocAfOrderDo> afOrderDos) {
        if (ObjectUtil.isNotEmpty(afOrderDos)) {
            uocAfOrderRepository.modifyBatchAfOrderRemark(afOrderDos);
        }
    }

    @Override
    public void modifyAfOrderExtOrderId(UocAfOrderDo afOrderDo) {
        if (ObjectUtil.isNotEmpty(afOrderDo)) {
            uocAfOrderRepository.modifyAfOrderExtOrderId(afOrderDo);
        }
    }

    @Override
    public void addWayBill(UocAfOrderWaybill uocAfOrderWaybill) {
        if (ObjectUtil.isNotEmpty(uocAfOrderWaybill)) {
            uocAfOrderWaybill.setId(IdUtil.nextId());
            uocAfOrderRepository.saveAfOrderWayBill(uocAfOrderWaybill);
        }
    }

    @Override
    public void modifyAfOrderState(UocAfOrderDo afOrderDo) {
        if (ObjectUtil.isNotEmpty(afOrderDo)) {
            uocAfOrderRepository.modifyAfOrderState(afOrderDo);
        }
    }

    @Override
    public void confirmAfOrderState(UocAfterOrderSupplierConfirmReqBo reqBo, Integer flag, UocAfterOrderSupplierConfirmRspBo rspBo) {
        if (ObjectUtil.isNotEmpty(reqBo)) {
            UocAfOrderDo afOrderDo = new UocAfOrderDo();
            afOrderDo.setOrderId(reqBo.getOrderId());
            afOrderDo.setAfOrderId(reqBo.getAfOrderId());
            UocAfOrderQryBo uocAfOrderQryBo = UocRu.js(afOrderDo, UocAfOrderQryBo.class);
            UocAfOrder afOrder = uocAfOrderRepository.getAfOrderById(uocAfOrderQryBo);
            UocAfOrderItemQryBo uocAfOrderItemQryBo = UocRu.js(afOrderDo, UocAfOrderItemQryBo.class);
            List<UocAfOrderItem> afOrderItemList = uocAfOrderRepository.getAfOrderItemList(uocAfOrderItemQryBo);
            if (flag == 0) {
                afOrderDo.setServState(UocDicConstant.SERVICE_STATE.APPROVAL_PASS);
                rspBo.setSaleOrderId(afOrder.getSaleOrderId());
            } else if (flag == 1) {
                updateAfteringCount(reqBo, afOrderItemList,afOrder,flag);
                afOrderDo.setServState(UocDicConstant.SERVICE_STATE.REMARK_COMPLATE);
                buildRspBo(rspBo, afOrder, afOrderItemList,flag);
            } else if (flag == 2) {
                updateAfteringCount(reqBo, afOrderItemList, afOrder, flag);
                afOrderDo.setServState(UocDicConstant.SERVICE_STATE.APPROVAL_NOT_PASS);
                buildRspBo(rspBo, afOrder, afOrderItemList, flag);
            }
            uocAfOrderRepository.modifyAfOrderState(afOrderDo);
        }
    }

    private void buildRspBo(UocAfterOrderSupplierConfirmRspBo rspBo, UocAfOrder afOrder, List<UocAfOrderItem> afOrderItemList, Integer flag) {
        UocAfOrderItem uocAfOrderItem = afOrderItemList.get(0);
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setOrderId(uocAfOrderItem.getOrderId());
        uocShipOrderItemQryBo.setShipOrderItemId(uocAfOrderItem.getShipItemId());
        List<UocShipOrderItem> shipOrderItem = shipOrderRepository.getShipOrderItem(uocShipOrderItemQryBo);
        rspBo.setSaleOrderId(afOrder.getSaleOrderId());
        rspBo.setShipOrderId(shipOrderItem.get(0).getShipOrderId());
    }

    private void updateAfteringCount(UocAfterOrderSupplierConfirmReqBo reqBo, List<UocAfOrderItem> afOrderItemList, UocAfOrder afOrder, Integer flag) {
        for (UocAfOrderItem uocAfOrderItem : afOrderItemList) {
            Long orderItemId = uocAfOrderItem.getSaleItemId();
            Long shipItemId = uocAfOrderItem.getShipItemId();
            Long orderId = uocAfOrderItem.getOrderId();
            BigDecimal returnCount = uocAfOrderItem.getReturnCount();
            //修改发货单在途数量
            UocShipOrderItem uocShipOrderItem = new UocShipOrderItem();
            uocShipOrderItem.setOrderId(orderId);
            uocShipOrderItem.setShipOrderItemId(shipItemId);
            uocShipOrderItem.setAfterServingCount(returnCount.negate());
            Integer servType = afOrder.getServType();
            if (UocDicConstant.SERVICE_TYPE.RETURN_GOODS.equals(servType) && flag==1) {
                uocShipOrderItem.setReturnCount(returnCount);
            }
            uocShipOrderItem.setUpdateTime(new Date());
            uocShipOrderItem.setUpdateOperId(Optional.ofNullable(reqBo.getUserId()).toString());
            shipOrderRepository.modifyShipOrderItemAfterServingCount(uocShipOrderItem);
            //修改销售单在途数量
            UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
            uocSaleOrderItem.setOrderId(orderId);
            uocSaleOrderItem.setSaleOrderItemId(orderItemId);
            uocSaleOrderItem.setAfterServingCount(returnCount.negate());
            if (UocDicConstant.SERVICE_TYPE.RETURN_GOODS.equals(servType) && flag==1) {
                uocSaleOrderItem.setReturnCount(returnCount);
            }
            uocSaleOrderItem.setUpdateTime(new Date());
            uocSaleOrderItem.setUpdateOperId(Optional.ofNullable(reqBo.getUserId()).toString());
            saleOrderRepository.modifySaleOrderItemAfterServingCount(uocSaleOrderItem);
        }
    }

}
