package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.UocAfOrderDo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderFinishConfirmReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderFinishConfirmRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题:UocAfterOrderFinishConfirmServiceImpl
 * 说明:售后完成确认
 * 时间:2022-05-13 13:54:43
 * 作者:luoyou
 */

@HTServiceImpl
public class UocAfterOrderFinishConfirmServiceImpl implements UocAfterOrderFinishConfirmService {
	@Autowired
	private IUocAfOrderModel afOrderModel;

	@Override
	public UocAfterOrderFinishConfirmRspBo finishConfirmAfterOrder(UocAfterOrderFinishConfirmReqBo reqBo) {
		val(reqBo);
		UocAfOrderDo uocAfOrderDo = new UocAfOrderDo();
		uocAfOrderDo.setAfOrderId(reqBo.getAfOrderId());
		uocAfOrderDo.setOrderId(reqBo.getOrderId());
		uocAfOrderDo.setServState(UocDicConstant.SERVICE_STATE.COMPLATE);
		afOrderModel.modifyAfOrderState(uocAfOrderDo);
		return UocRu.success(UocAfterOrderFinishConfirmRspBo.class);
	}

	private void val(UocAfterOrderFinishConfirmReqBo reqBo) {
		if (null == reqBo) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象为空");
		}
		if (null == reqBo.getOrderId()) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单ID为空");
		}
		if (null == reqBo.getAfOrderId()) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参售后单ID为空");
		}
	}
}
