package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.collection.CollectionUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderItemObjQryBo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderObjQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderMap;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 标题:UocChngOrderConfirmOrRefuseServiceImpl
 * 说明:数量变更确认/拒绝 实现
 * 时间:2022/3/9 20:42
 * 作者:罗有
 */

@HTServiceImpl
public class UocChngOrderConfirmOrRefuseServiceImpl implements UocChngOrderConfirmOrRefuseService {

	@Autowired
	private IUocChngOrderModel iUocChngOrderModel;
	@Autowired
	private IUocShipOrderModel iUocShipOrderModel;
	@Autowired
	private IUocSaleOrderModel iUocSaleOrderModel;


	private static final Integer OP_FLAG_CONFIRM = 1;

	private static final Integer OP_FLAG_REFUSE = 0;
	@Autowired
	private IUocCommonModel iUocCommonModel;


	@Override
	public UocChngOrderConfirmOrRefuseRspBo dealConfirmOrRefuse(UocChngOrderConfirmOrRefuseReqBo reqBo) {
		UocChngOrderConfirmOrRefuseRspBo rsp = UocRu.success(UocChngOrderConfirmOrRefuseRspBo.class);

		validateArg(reqBo);
		String operId = reqBo.getUserId().toString();
		Date now = new Date();
		List<UocChngOrderItemObj> uocChngOrderItemObjList = getListChngOrderItemObj(reqBo);
		for (UocChngOrderItemObj uocChngOrderItemObj : uocChngOrderItemObjList) {
			Integer chngType = uocChngOrderItemObj.getChngType();
			if (UocConstant.BUSI_TYPE.NUM.equals(chngType)) {
				//数量变更
				iUocChngOrderModel.modifyBatchChngOrderState(convertChngOrderDo(reqBo, now, operId));
				if (OP_FLAG_CONFIRM.equals(reqBo.getOpFlag())) {
					confirm(reqBo, operId, now, uocChngOrderItemObjList);
				}
				if (OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) {
					refuse(reqBo, operId, now, uocChngOrderItemObjList);
				}
			} else {
				//状态变更
				if (OP_FLAG_CONFIRM.equals(reqBo.getOpFlag())) {
					confirmStat(reqBo, operId, now, uocChngOrderItemObjList);
//					getShipTaskInsts(reqBo, rsp);
					getSaleOrderInfo(reqBo, rsp);
				}
				if (OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) {
					refuse(reqBo, operId, now, uocChngOrderItemObjList);
				}
			}
		}
		reqBo.getChngOrderList().forEach(uocChngOrderConfirmOrRefuseReqItemBo -> {
			// 提交任务
			UocCommonDo uocCommonDo = new UocCommonDo();
			List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskBos = new ArrayList<>();
			UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
			taskBo.setTaskId(uocChngOrderConfirmOrRefuseReqItemBo.getTaskId());
			taskBos.add(taskBo);
			uocCommonDo.setCompleteTaskInfos(taskBos);
			uocCommonDo.setUserId(11111l);
			uocCommonDo.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
			iUocCommonModel.dealTask(uocCommonDo);
		});
		dealMap(reqBo, now);
		return rsp;
	}

	private void getSaleOrderInfo(UocChngOrderConfirmOrRefuseReqBo reqBo, UocChngOrderConfirmOrRefuseRspBo rsp) {
		List<UocChngOrderConfirmOrRefuseSaleTaskInstBo> saleOrderTaskInstBoList = new ArrayList<>();
		List<Long> chngOrderIds = reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getChngOrderId).collect(Collectors.toList());
		UocChngOrderObjQryBo uocChngOrderObjQryBo = new UocChngOrderObjQryBo();
		uocChngOrderObjQryBo.setChngOrderIdList(chngOrderIds);
		List<UocChngOrderObj> listChngOrderObjWithOutItem = iUocChngOrderModel.getListChngOrderObjWithOutItem(uocChngOrderObjQryBo);
		if (CollectionUtil.isEmpty(listChngOrderObjWithOutItem)) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_CHNG_ORDER_CONFIRM_OR_REFUSE_ERROR, "查询变更对象为空");
		}
		for (UocChngOrderObj uocChngOrderObj : listChngOrderObjWithOutItem) {
			Long saleOrderId = uocChngOrderObj.getSaleOrderId();
			UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
			uocSaleOrderDo.setSaleOrderId(saleOrderId);
			uocSaleOrderDo.setOrderId(uocChngOrderObj.getOrderId());
			UocSaleOrderDo saleOrderMain = iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
			if (UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.equals(saleOrderMain.getOrderSource()) && UocConstant.BUSI_TYPE.STATE.equals(uocChngOrderObj.getChngType())) {
				// 妥投到拒收
				Boolean flag = null;
				UocOrderTaskInst uocSaleOrderTaskInst = new UocOrderTaskInst();
				uocSaleOrderTaskInst.setOrderId(uocChngOrderObj.getOrderId());
				uocSaleOrderTaskInst.setObjId(saleOrderId);
				uocSaleOrderTaskInst.setObjType(UocDicConstant.OBJ_TYPE.SALE);
				uocSaleOrderTaskInst.setFinishTag(0);
				List<UocOrderTaskInst> uocSaleOrderTaskInsts = iUocSaleOrderModel.qryTaskInstList(uocSaleOrderTaskInst);
				if (CollectionUtil.isEmpty(uocSaleOrderTaskInsts)) {
					return;
				}
				UocOrderTaskInst uocSaleOrderTaskInst1 = uocSaleOrderTaskInsts.get(0);
				if (UocDicConstant.STATE_CHNG.JUSHOU.equals(uocChngOrderObj.getOtherChngValue())) {
					UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
					uocShipOrderQryBo.setSaleOrderId(saleOrderId);
					uocShipOrderQryBo.setOrderId(uocChngOrderObj.getOrderId());
					List<UocShipOrderDo> listShipOrder = iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
					if (CollectionUtil.isEmpty(listShipOrder)) {
						throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "通过销售单查询发货单列表为空");
					}

					for (UocShipOrderDo uocShipOrderDo : listShipOrder) {
						UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
						uocOrderTaskInst.setOrderId(uocChngOrderObj.getOrderId());
						uocOrderTaskInst.setObjId(uocShipOrderDo.getShipOrderId());
						uocOrderTaskInst.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
						uocOrderTaskInst.setFinishTag(0);
						List<UocOrderTaskInst> uocOrderTaskInsts = iUocSaleOrderModel.qryTaskInstList(uocOrderTaskInst);
						if (CollectionUtil.isEmpty(uocOrderTaskInsts)) {
							return;
						}
						UocOrderTaskInst uocOrderTaskInst1 = uocOrderTaskInsts.get(0);
						String procState = uocOrderTaskInst1.getProcState();
						if (UocStateConstants.SaleOrder.XS_YS_YS.equals(procState)) {
							flag = true;
						} else {
							flag = false;
							break;
						}
					}
					Optional.ofNullable(flag).orElse(Boolean.FALSE);
					if (flag) {
						String taskId = uocSaleOrderTaskInst1.getTaskInstId();
						UocChngOrderConfirmOrRefuseSaleTaskInstBo saleTaskinfo = new UocChngOrderConfirmOrRefuseSaleTaskInstBo();
						saleTaskinfo.setTaskId(taskId);
						saleTaskinfo.setStepId(uocSaleOrderTaskInst1.getProcState());
						saleTaskinfo.setSaleOrderId(saleOrderId);
						saleTaskinfo.setOrderId(uocChngOrderObj.getOrderId());
						saleOrderTaskInstBoList.add(saleTaskinfo);
					}
				}
				// 拒收到妥投
				if (UocDicConstant.STATE_CHNG.TUOTOU.equals(uocChngOrderObj.getOtherChngValue())) {
					String procState = uocSaleOrderTaskInst1.getProcState();
					if (UocStateConstants.SaleOrder.XS_DH_JS.equals(procState)) {
						String taskId = uocSaleOrderTaskInst1.getTaskInstId();
						UocChngOrderConfirmOrRefuseSaleTaskInstBo saleTaskinfo = new UocChngOrderConfirmOrRefuseSaleTaskInstBo();
						saleTaskinfo.setTaskId(taskId);
						saleTaskinfo.setStepId(uocSaleOrderTaskInst1.getProcState());
						saleTaskinfo.setSaleOrderId(saleOrderId);
						saleTaskinfo.setOrderId(uocChngOrderObj.getOrderId());
						saleOrderTaskInstBoList.add(saleTaskinfo);
					}
				}
			}
		}
		rsp.setSaleOrderTaskInstList(saleOrderTaskInstBoList);
	}

	private void getShipTaskInsts(UocChngOrderConfirmOrRefuseReqBo reqBo, UocChngOrderConfirmOrRefuseRspBo rsp) {
		List<UocChngOrderConfirmOrRefuseShipTaskInstBo> shipTaskInstBoList = new ArrayList<>();
		List<Long> chngOrderIds = reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getChngOrderId).collect(Collectors.toList());
		UocChngOrderObjQryBo uocChngOrderObjQryBo = new UocChngOrderObjQryBo();
		uocChngOrderObjQryBo.setChngOrderIdList(chngOrderIds);
		List<UocChngOrderObj> listChngOrderObjWithOutItem = iUocChngOrderModel.getListChngOrderObjWithOutItem(uocChngOrderObjQryBo);

		listChngOrderObjWithOutItem.forEach(x->{
			UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
			uocOrderTaskInst.setOrderId(x.getOrderId());
			uocOrderTaskInst.setObjId(x.getShipOrderId());
			uocOrderTaskInst.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
			uocOrderTaskInst.setFinishTag(0);
			List<UocOrderTaskInst> uocOrderTaskInsts = iUocSaleOrderModel.qryTaskInstList(uocOrderTaskInst);
			if (CollectionUtil.isEmpty(uocOrderTaskInsts)) {
				throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "查询发货单任务信息为空");
			}
			UocOrderTaskInst uocOrderTaskInst1 = uocOrderTaskInsts.get(0);
			String taskInstId = uocOrderTaskInst1.getTaskInstId();
			String procState = uocOrderTaskInst1.getProcState();
			UocChngOrderConfirmOrRefuseShipTaskInstBo uocChngOrderConfirmOrRefuseShipTaskInstBo = new UocChngOrderConfirmOrRefuseShipTaskInstBo();
			uocChngOrderConfirmOrRefuseShipTaskInstBo.setShipOrderId(x.getShipOrderId());
			uocChngOrderConfirmOrRefuseShipTaskInstBo.setTaskId(taskInstId);
			uocChngOrderConfirmOrRefuseShipTaskInstBo.setStepId(procState);
			uocChngOrderConfirmOrRefuseShipTaskInstBo.setChngOrderId(x.getChngOrderId());
			uocChngOrderConfirmOrRefuseShipTaskInstBo.setOrderId(x.getOrderId());
			shipTaskInstBoList.add(uocChngOrderConfirmOrRefuseShipTaskInstBo);
		});
		rsp.setShipTaskInstList(shipTaskInstBoList);
	}

	private void confirmStat(UocChngOrderConfirmOrRefuseReqBo reqBo, String operId, Date now, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
		Map<String, List<UocChngOrderItemObj>> chngOrderItemMaps = uocChngOrderItemObjList.stream().collect(Collectors.groupingBy(UocChngOrderItemObj::getOtherChngValue));
		List<UocChngOrderItemObj> uocChngOrderItemObjsJS = chngOrderItemMaps.get(UocDicConstant.STATE_CHNG.JUSHOU);
		List<UocChngOrderItemObj> uocChngOrderItemObjsTT = chngOrderItemMaps.get(UocDicConstant.STATE_CHNG.TUOTOU);
		if (CollectionUtil.isNotEmpty(uocChngOrderItemObjsJS)) {
			UocShipOrderDo uocShipOrderDo = convertShipOrderDo(reqBo, now, operId, uocChngOrderItemObjsJS);
			UocSaleOrderDo uocSaleOrderDo = convertSaleOrderDo(reqBo, now, operId, uocChngOrderItemObjsJS);
			iUocSaleOrderModel.modifyItemRefuseCountConfirm(uocSaleOrderDo);
			iUocShipOrderModel.modifyItemRefuseCountConfirm(uocShipOrderDo);
		}
		if (CollectionUtil.isNotEmpty(uocChngOrderItemObjsTT)) {
			UocShipOrderDo uocShipOrderDo = convertShipOrderDo(reqBo, now, operId, uocChngOrderItemObjsTT);
			UocSaleOrderDo uocSaleOrderDo = convertSaleOrderDo(reqBo, now, operId, uocChngOrderItemObjsTT);
			iUocSaleOrderModel.modifyItemArriveCountConfirm(uocSaleOrderDo);
			iUocShipOrderModel.modifyItemArriveCountConfirm(uocShipOrderDo);

		}
	}

	private void refuse(UocChngOrderConfirmOrRefuseReqBo reqBo, String operId, Date now, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
		iUocShipOrderModel.modifyItemChngCountRefuse(convertShipOrderDo(reqBo, now, operId, uocChngOrderItemObjList));
		iUocSaleOrderModel.modifyBatchItemChngCountRefuse(convertSaleOrderDo(reqBo, now, operId, uocChngOrderItemObjList));
	}

	private void confirm(UocChngOrderConfirmOrRefuseReqBo reqBo, String operId, Date now, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
		iUocShipOrderModel.modifyItemReturnCountConfirm(convertShipOrderDo(reqBo, now, operId, uocChngOrderItemObjList));
		iUocSaleOrderModel.modifyBatchItemReturnCountConfirm(convertSaleOrderDo(reqBo, now, operId, uocChngOrderItemObjList));
	}


	/**
	 * 查询执行单信息
	 */
	private UocSaleOrderDo convertSaleOrderDo(UocChngOrderConfirmOrRefuseReqBo reqBo, Date now, String operId, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
		UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
		uocSaleOrderDo.setUpdateOperId(operId);
		uocSaleOrderDo.setUpdateTime(now);
		uocSaleOrderDo.setOrderIdList(reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getOrderId).collect(Collectors.toList()));
		uocSaleOrderDo.setSaleOrderItemsIdList(uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getSaleOrderItemId).collect(Collectors.toList()));
		return uocSaleOrderDo;
	}

	/**
	 * 查询发货单信息信息
	 */
	private UocShipOrderDo convertShipOrderDo(UocChngOrderConfirmOrRefuseReqBo reqBo, Date now, String operId, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
		List<Long> orderIdList = reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getOrderId).collect(Collectors.toList());
		UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
		uocShipOrderDo.setShipOrderItemIdList(uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getShipOrderItemId).collect(Collectors.toList()));
		uocShipOrderDo.setOrderIdList(orderIdList);
		uocShipOrderDo.setUpdateTime(now);
		uocShipOrderDo.setUpdateOperId(operId);
		return uocShipOrderDo;
	}

	/**
	 * 组装变更单信息
	 */
	private List<UocChngOrderDo> convertChngOrderDo(UocChngOrderConfirmOrRefuseReqBo reqBo, Date now, String operId) {
		String state = getState(reqBo);
		return reqBo.getChngOrderList().stream().map(uocChngOrderConfirmOrRefuseReqItemBo -> {
			UocChngOrderDo uocChngOrderDo = new UocChngOrderDo();
			uocChngOrderDo.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
			uocChngOrderDo.setChngOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId());
			uocChngOrderDo.setChngOrderState(state);
			uocChngOrderDo.setUpdateTime(now);
			uocChngOrderDo.setUpdateOperId(operId);
			uocChngOrderDo.setUpdateOperName(reqBo.getName());
			uocChngOrderDo.setRejectReason(reqBo.getRejectRemark());
			return uocChngOrderDo;
		}).collect(Collectors.toList());
	}

	/**
	 * 获取对应状态
	 */
	private String getState(UocChngOrderConfirmOrRefuseReqBo reqBo) {
		if (OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) {
			return UocStateConstants.ChngOrder.NUM.CHNG_CHNG_JJ;
		}
		return UocStateConstants.ChngOrder.NUM.CHNG_CHNG_QR;
	}

	/**
	 * 查询变更对象明细信息
	 */
	private List<UocChngOrderItemObj> getListChngOrderItemObj(UocChngOrderConfirmOrRefuseReqBo reqBo){
		List<Long> orderIdList = reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getOrderId).collect(Collectors.toList());
		UocChngOrderItemObjQryBo uocChngOrderItemObjQryBo = new UocChngOrderItemObjQryBo();
		uocChngOrderItemObjQryBo.setChngOrderIdList(reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getChngOrderId).collect(Collectors.toList()));
		uocChngOrderItemObjQryBo.setOrderIdList(orderIdList);
		List<UocChngOrderItemObj> uocChngOrderItemObjList = iUocChngOrderModel.getListChngOrderItemObj(uocChngOrderItemObjQryBo);
		if (CollectionUtils.isEmpty(uocChngOrderItemObjList)) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_CHNG_ORDER_CONFIRM_OR_REFUSE_ERROR, "查询变更明细对象为空");
		}
		return uocChngOrderItemObjList;
	}


	/**
	 * 扩展属性处理
	 */
	private void dealMap(UocChngOrderConfirmOrRefuseReqBo reqBo, Date now) {
		List<UocChngOrderConfirmOrRefuseReqItemBo> chngOrderList = reqBo.getChngOrderList();
		chngOrderList.forEach(uocChngOrderConfirmOrRefuseReqItemBo -> {
			if (!CollectionUtils.isEmpty(uocChngOrderConfirmOrRefuseReqItemBo.getExtDeleteList())) {
				UocChngOrderDo delChngOrderDo = new UocChngOrderDo();
				List<UocChngOrderMap> extParallelBoList = new ArrayList<>();
				uocChngOrderConfirmOrRefuseReqItemBo.getExtDeleteList().forEach(uocBaseExtParallelDeleteBo -> {
					UocChngOrderMap uocChngOrderMap = new UocChngOrderMap();
					uocChngOrderMap.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
					uocChngOrderMap.setChngOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId());
					uocChngOrderMap.setFieldCode(uocBaseExtParallelDeleteBo.getFieldCode());
					uocChngOrderMap.setUpdateOperId(reqBo.getUserId().toString());
					uocChngOrderMap.setUpdateTime(now);
					extParallelBoList.add(uocChngOrderMap);
				});
				delChngOrderDo.setUocChngOrderMapList(extParallelBoList);
				iUocChngOrderModel.updateInvalid(delChngOrderDo);
			}
			if (!CollectionUtils.isEmpty(uocChngOrderConfirmOrRefuseReqItemBo.getExtEditList())) {
				UocChngOrderDo add = new UocChngOrderDo();
				UocChngOrderDo modify = new UocChngOrderDo();
				List<UocChngOrderMap> addList = new ArrayList<>();
				List<UocChngOrderMap> modifyList = new ArrayList<>();
				uocChngOrderConfirmOrRefuseReqItemBo.getExtEditList().forEach(uocBaseExtParallelEditBo -> {
					if (UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelEditBo.getOpFlag())) {
						UocChngOrderMap addShipOrderMap = new UocChngOrderMap();
						addShipOrderMap.setChngOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId());
						addShipOrderMap.setFieldCode(uocBaseExtParallelEditBo.getFieldCode());
						addShipOrderMap.setFieldName(uocBaseExtParallelEditBo.getFieldName());
						addShipOrderMap.setFieldValue(uocBaseExtParallelEditBo.getFieldValue());
						addShipOrderMap.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
						addShipOrderMap.setId(IdUtil.nextId());
						addShipOrderMap.setCreateOperId(reqBo.getUserId().toString());
						addShipOrderMap.setCreateTime(now);
						addList.add(addShipOrderMap);
					} else {
						UocChngOrderMap updateShipOrderMap = new UocChngOrderMap();
						updateShipOrderMap.setChngOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId());
						updateShipOrderMap.setFieldCode(uocBaseExtParallelEditBo.getFieldCode());
						updateShipOrderMap.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
						updateShipOrderMap.setFieldValue(uocBaseExtParallelEditBo.getFieldValue());
						updateShipOrderMap.setUpdateOperId(reqBo.getUserId().toString());
						updateShipOrderMap.setUpdateTime(now);
						modifyList.add(updateShipOrderMap);
					}
				});
				if (!CollectionUtils.isEmpty(addList)) {
					add.setUocChngOrderMapList(addList);
					iUocChngOrderModel.addChngOrderMap(add);
				}
				if (!CollectionUtils.isEmpty(modifyList)) {
					modify.setUocChngOrderMapList(modifyList);
					iUocChngOrderModel.updateBatchValue(modify);
				}
			}
			UocChngOrderDo uocChngOrderDo = new UocChngOrderDo();
			uocChngOrderDo.setChngOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId());
			uocChngOrderDo.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
			uocChngOrderDo.setChngOrderState(OP_FLAG_CONFIRM.equals(reqBo.getOpFlag())?UocStateConstants.ChngOrder.NUM.CHNG_CHNG_QR:UocStateConstants.ChngOrder.NUM.CHNG_CHNG_JJ);
			uocChngOrderDo.setUpdateTime(now);
			uocChngOrderDo.setUpdateOperId(reqBo.getUserId().toString());
			iUocChngOrderModel.updateChngOrderMain(uocChngOrderDo);
		});
	}

	private void validateArg(UocChngOrderConfirmOrRefuseReqBo reqBo) {
		if (null == reqBo) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象为空");
		}
		if (!OP_FLAG_CONFIRM.equals(reqBo.getOpFlag()) && !OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参操作只支持确认或拒绝为空");
		}
		if (CollectionUtils.isEmpty(reqBo.getChngOrderList())) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参变更信息列表不能为空");
		}
		reqBo.getChngOrderList().forEach(uocChngOrderConfirmOrRefuseReqItemBo -> {
			if (null == uocChngOrderConfirmOrRefuseReqItemBo.getOrderId()) {
				throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参变更信息的订单ID不能为空");
			}
			if (null == uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId()) {
				throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参变更信息的变更单ID不能为空");
			}
		});
		if (null == reqBo.getUserId()) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参用户ID不能为空");
		}
		List<UocChngOrderConfirmOrRefuseReqItemBo> chngOrderList = reqBo.getChngOrderList();
		chngOrderList.forEach(uocChngOrderConfirmOrRefuseReqItemBo -> {

			if (!CollectionUtils.isEmpty(uocChngOrderConfirmOrRefuseReqItemBo.getExtDeleteList())) {
				uocChngOrderConfirmOrRefuseReqItemBo.getExtDeleteList().forEach(uocBaseExtParallelDeleteBo -> {
					if (null == uocBaseExtParallelDeleteBo.getObjId()) {
						throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "要删除的扩展属性对象ID不能为空");
					}
					if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldCode())) {
						throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "要删除的扩展属性编码不能为空");
					}
				});
			}
			if (!CollectionUtils.isEmpty(uocChngOrderConfirmOrRefuseReqItemBo.getExtEditList())) {
				uocChngOrderConfirmOrRefuseReqItemBo.getExtEditList().forEach(uocBaseExtParallelDeleteBo -> {
					if (null == uocBaseExtParallelDeleteBo.getOpFlag()) {
						throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做编辑操作时，操作类型不能为空");
					}
					if (!UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelDeleteBo.getOpFlag()) && !UocConstant.MAP_OP_FLAG.UPDATE.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
						throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做编辑操作时，操作类型仅支持新增和修改");
					}
					if (UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
						if (null == uocBaseExtParallelDeleteBo.getObjId()) {
							throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做新增操作时，对象ID不能为空");
						}
						if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldCode())) {
							throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做新增操作时，属性编码不能为空");
						}
					}
					if (UocConstant.MAP_OP_FLAG.UPDATE.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
						if (null == uocBaseExtParallelDeleteBo.getObjId()) {
							throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做修改操作时，对象ID不能为空");
						}
						if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldCode())) {
							throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做修改操作时，属性编码不能为空");
						}
						if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldValue())) {
							throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做修改操作时，属性值不能为空");
						}
					}
				});
			}
		});
	}

}
