package com.tydic.dyc.oc.service.order;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocConfAudit;
import com.tydic.dyc.oc.service.order.bo.UocUpdateAuditConfReqBo;
import com.tydic.dyc.oc.service.order.bo.UocUpdateAuditConfRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题:UocUpdateAuditConfServiceImpl
 * 说明:审批配置更新
 * 时间:2022-05-20 10:16:33
 * 作者:luoyou
 */

@HTServiceImpl
public class UocUpdateAuditConfServiceImpl implements UocUpdateAuditConfService {
	@Autowired
	private IUocOrderModel iUocOrderModel;
	public static final Long ZORE = 0L;

	@Override
	public UocUpdateAuditConfRspBo updateAuditConf(UocUpdateAuditConfReqBo reqBo) {
		val(reqBo);
		iUocOrderModel.updateAuditConf(convertDo(reqBo));
		return UocRu.success(UocUpdateAuditConfRspBo.class);
	}

	private UocConfAudit convertDo(UocUpdateAuditConfReqBo reqBo) {
		UocConfAudit uocConfAudit = UocRu.js(reqBo, UocConfAudit.class);
		uocConfAudit.setOrgId(reqBo.getOrgIdWeb());
		uocConfAudit.setOrgName(reqBo.getOrgNameWeb());
		uocConfAudit.setOrgType(reqBo.getOrgTypeWeb());
		return uocConfAudit;
	}

	private void val(UocUpdateAuditConfReqBo reqBo) {
		if (null == reqBo) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
		}
		if (null == reqBo.getId()) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参ID不能为空");
		}
		if (StringUtils.isBlank(reqBo.getConfCode())) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参配置编码不能为空");
		}
		if (StringUtils.isBlank(reqBo.getConfName())) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参配置名称不能为空");
		}
		if (StringUtils.isBlank(reqBo.getOrgNameWeb())) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参配置名称不能为空");
		}
		if (null == reqBo.getOrgIdWeb()) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参配置名称不能为空");
		}
		if (!ZORE.equals(reqBo.getOrgIdWeb())) {
			if (StringUtils.isBlank(reqBo.getOrgTypeWeb())) {
				throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参例外机构类型不能为空");
			}
			if (StringUtils.isBlank(reqBo.getOrgTypeName())) {
				throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参例外机构类型翻译不能为空");
			}
		}
		if (null == reqBo.getAuditFlag()) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单是否审批不能为空");
		}
		if (UocConstant.CONF_AUDIT_FLAG.YES.equals(reqBo.getAuditFlag()) && null == reqBo.getAuditType()) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参需要审批时审批方式不能为空");
		}
	}
}
