/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.components.event.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.event.EventConsumer;
import com.tydic.dyc.oc.components.event.IUocEsSyncQryEventReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocDicConstant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EventConsumerSyncSaleTransaction
implements EventConsumer {
    private static final Logger log = LoggerFactory.getLogger(EventConsumerSyncSaleTransaction.class);
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public List<IUocEsSyncQryEventReqBo> parseMap(Map<String, Object> map) {
        Object saleOrderListObj;
        log.info("event-EventConsumerSyncSaleTransaction->{}", (Object)JSON.toJSONString(map));
        ArrayList<IUocEsSyncQryEventReqBo> retList = new ArrayList<IUocEsSyncQryEventReqBo>();
        Long orderId = Long.valueOf((String)map.get("orderId"));
        JSONObject supSignInfo = (JSONObject)map.get("jsonObj");
        if (ObjectUtil.isNotEmpty((Object)orderId) && ObjectUtil.isNotEmpty((Object)(saleOrderListObj = map.get("saleOrderList")))) {
            JSONArray saleOrderList = JSON.parseArray((String)JSON.toJSONString((Object)saleOrderListObj));
            ArrayList<IUocEsSyncQryReqBo> saleList = new ArrayList<IUocEsSyncQryReqBo>();
            if (ObjectUtil.isNotEmpty((Object)saleOrderList)) {
                for (int i = 0; i < saleOrderList.size(); ++i) {
                    JSONObject arrayJson = saleOrderList.getJSONObject(i);
                    Long saleOrderId = arrayJson.getLong("saleOrderId");
                    Long supId = arrayJson.getLong("supId");
                    if (saleOrderId == null) continue;
                    IUocEsSyncQryReqBo syncQryReqBo = new IUocEsSyncQryReqBo();
                    syncQryReqBo.setOrderId(orderId);
                    syncQryReqBo.setObjId(saleOrderId);
                    syncQryReqBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
                    syncQryReqBo.setJsonObj(supSignInfo.getJSONObject(supId.toString()));
                    saleList.add(syncQryReqBo);
                }
            }
            if (ObjectUtil.isNotEmpty(saleList)) {
                IUocEsSyncQryEventReqBo eventReqBo = new IUocEsSyncQryEventReqBo();
                eventReqBo.setIndexName(this.uocIndexConfig.getTransactionIndex());
                eventReqBo.setDataList(saleList);
                retList.add(eventReqBo);
            }
        }
        return retList;
    }

    @Override
    public String getEvent() {
        return "UOC_SALE_TRANSACTION_SYNC";
    }
}

